C=======================================================================
C
C     Program PLOTTAB (Version 2022-1)
C     ================================
C
C     OWNED, MAINTAINED AND DISTRIBUTED BY
C     ------------------------------------
C     THE NUCLEAR DATA SECTION
C     INTERNATIONAL ATOMIC ENERGY AGENCY
C     P.O. BOX 100
C     A-1400, VIENNA, AUSTRIA
C     EUROPE
C
C     ORIGINALLY WRITTEN BY
C     ------------------------------------
C     Dermott E. Cullen
C
C     PRESENT CONTACT INFORMATION
C     ---------------------------
C     Dermott E. Cullen
C     1466 Hudson Way
C     Livermore, CA 94550
C     U.S.A.
C     Telephone  925-321-4177
C     E. Mail    RedCullen1@Comcast.net
C     Website    http://home.comcast.net/~redcullen1
C
C=======================================================================
c     HISTORY
C     -------
C     VERSION 87-1 (JANUARY, 1987) *Original WINDOWS Version
C     VERSION 87-2 (MAY, 1987)     *SOFTWARE UPPER AND LOWER CASE
C                                   CHARACTERS
C                                  *SOFTWARE SPECIAL SYMBOLS TO IDENTIFY
C                                   SETS OF DISCRETE POINTS.
C                                  *SOFTWARE LINE TYPES TO IDENTIFY
C                                   CURVES.
C     VERSION 87-3 (NOVEMBER, 1987)*IMPROVED GROUPING OF DATA ON PLOTS
C                                   (NOTE, CHANGE IN DEFINITION OF
C                                   INPUT VARIABLES).
C                                  *ALL INPUT READ AS CHARACTERS AND
C                                   INTERNALLY CONVERTED TO FLOATING
C                                   OR FIXED POINT AS NEEDED.
C                                  *IMPROVED LINE TYPES TO DESCRIBE
C                                   CURVES.
C                                  *IMPROVED SCALING.
C     VERSION 88-1 (JULY, 1988)    *SIMPLER INTERFACE TO ALLOW PROGRAM
C                                   TO BE USED ON VIRTUALLY ANY PLOTTER
C                                  *OPTION..TURN OFF INTERPOLATION FROM
C                                   LINEAR-LINEAR TO PLANE OF PLOT.
C                                  *OPTION..INTERNALLY DEFINE FILENAMES
C                                   (SEE SUBROUTINE FILEIO FOR DETAILS).
C                                  *ALLOW RE-DEFINITION OF GLOBAL
C                                   PARAMETERS DURING RUN (ALLOW
C                                   IMPROVED GROUPING OF DATA ON PLOTS)
C                                  *IMPROVED COMPUTER COMPATIBILITY.
C     VERSION 88-2 (OCTOBER 1988)  *UPDATED BASED ON USER COMMENTS.
C                                  *UPDATED TO USE NEW PROGRAM CONVERT
C                                   KEYWORDS.
C                                  *TREAT CHARACTER ARRAYS AS EITHER
C                                   - CHARACTER (FORTRAN-77 CONVENTION)
C                                   - INTEGER (FORTRAN-H CONVENTION)
C     VERSION 89-1 (MAY 1989)      *UPDATED BASED ON USER COMMENTS.
C                                  *ONE SIDED X AND Y LIMITS
C                                  *10,000 POINTS FOR CURVES AND
C                                    2,000 DISCRETE POINTS
C                                  *3 CHARACTER FONTS
C                                  *LINEAR OR LOG X AND Y INTERPOLATION
C                                  *OPTIONAL ROUNDING OF PLOT LIMITS
C                                  *OPTIONAL LEGEND BOX ON PLOT
C     VERSION 89-1 (JULY 1989)     *UPDATED BASED ON USER COMMENTS.
C                                  *UP TO 20000 POINTS FOR CURVES
C                                  *IMPROVED LEGEND BOX POSITIONING.
C                                  *ADDITIONAL GRIDS COMBINING TICK
C                                   MARKS WITH SOLID OR DASHED GRID.
C                                  *ONE SIDED X AND Y ROUNDING
C                                  *THICK CURVES, ETC., BUT NOT THICK
C                                   CHARACTERS.
C     VERSION 90-1 (MAY 1991)      *UPDATED BASED ON USER COMMENTS.
C                                  *ADDED NEW GRID TYPES
C                                  *UP TO 10000 DISCRETE POINTS
C     VERSION 92-1 (MARCH 1992)    *UPDATED BASED ON USER COMMENTS.
C                                  *ADDED THICK MASTER CURVE OPTION
C                                  *ADDED MANY NEW FEATURES
C                                  *CORRECTED MANY OLD PROBLEMS
C     VERSION 92-2 (APRIL 1992)    *VARIABLE CHARACTER SIZE INPUT OPTION
C                                  *ALLOW COMPLETE FLEXIBILITY TO CHANGE
C                                   PAGE LAYOUT ANY NUMBER OF TIMES
C                                   DURING A SINGLE RUN.
C                                  *UPDATED BASED ON USER COMMENTS.
C     VERSION 93-1 (MARCH 1993)    *UPDATED GRAPHICS INTERFACE FOR LAHEY
C                                   IBM-PC FORTRAN COMPILER FOR ON
C                                   SCREEN GRAPHICS (SEE, DESCRIPTION
C                                   OF GRAPHICS INTERFACE BELOW).
C                                  *INCREASED MAXIMUM NUMBER OF POINTS
C                                   FOR CURVES FROM 20000 TO 200000.
C     VERSION 94-1 (JANUARY 1994)  *ADDED OPTION - SHOW POINTS OF CURVES
C                                   (SEE, BELOW DESCRIPTION OF INPUT
C                                   PARAMETERS).
C                                  *ADDED INTERACTIVE INTERFACE USING
C                                   MOUSE.
C     VERSION 96-1 (SEPTEMBER 1996)*GENERAL UPDATE BASED ON USER
C                                   COMMENTS
C     VERSION 97-1 (SEPTEMBER 1997)*GENERAL UPDATE BASED ON USER
C                                   COMMENTS
C     VERSION 98-1 (MAY 1998)      *GENERAL UPDATE BASED ON USER
C                                   COMMENTS
C     VERSION 2000-1 (MAY 2000)    *GENERAL UPDATE BASED ON USER
C                                   COMMENTS
C     VERSION 2002-1 (Nov. 2002)   *GENERAL UPDATE BASED ON USER
C                                   COMMENTS
C     VERSION 2004-1 (April 2004)  *REAL*8 VERSION
C                                  *ADDED INCLUDE FOR COMMON
C                                  *IMPROVED POSTSCRIPT FILES
C     VERSION 2005-1 (Dec. 2005)   *READY FOR 2005 DISTRIBUTION
C     VERSION 2011-1 (Mar. 2011)   *Many Updates
C     VERSION 2013-1 (Nov. 2013)   *32 and 64 bit Compatible.
C                                  *Limit discrete data
C                                   *Data MUST be positive
C                                   *ERRORS cannot exceed 90% of Data
C                                  *Replaced Old Routines for character
C                                   translation by Current IN9 and OUT9
C                                   for ALL Floating Point Translation.
C                                  *Removed arbitrary positioned titles.
C                                   This can now be accomplished easier
C                                   by editing finished plots.
C     VERSION 2014-1 (Apr. 2014)   *Accomodate ALL interactive options.
C                                  *Allow negative discrete data.
C                                   *ERRORS CAN exceed Data
C                                  *Added X and Y Err Bar interactive
C                                   input option.
C                                  *Prevent legend box from being too
C                                   LARGE < 50% of X and Y plot range.
C     VERSION 2015-1 (Jan. 2015)   *Major re-write to update.
C                                  *Replaced ALL 3 way IF statements.
C                                  *Turned off line thickness option
C                                   (temporarily)
C                                   Including MASTER curve thickness.
C     VERSION 2016-1 (Feb. 2016)   *Minor Updates.
C                                  *Same COLOR for curve and points.
C     VERSION 2019-1 (Dec. 2019)   *Compiler using *.OBJ
C     VERSION 2022-1 (May  2022)   *Added more % ratios.
C                                  *Updated for FORTRAN 2018.
C     VERSION 2025-1 (Sept.2025)   *Allow Repested CURVES or POINTS =
C                                  (After showing data use negstive
C                                   count for next plot.)
C
C     PURPOSE
C     ==================================================================
C     THIS PROGRAM IS DESIGNED TO PLOT ANY COMBINATION OF CONTINUOUS
C     CURVES AND/OR DISCRETE POINTS (WITH ASSOCIATED ERROR BARS) USING
C     USER SUPPLIED TITLES AND X AND Y AXIS LABELS AND UNITS.
C
C     IN ADDITION IF CURVES ARE PLOTTED THE FIRST CURVE MAY BE USED AS
C     A STANDARD AND NOT ONLY THE DATA, BUT ALSO THE RATIO OF THE DATA
C     TO THE STANDARD WILL BE PLOTTED.
C
C     USING THIS METHOD THE PROGRAM HAS NO IDEA OF WHAT DATA IS BEING
C     PLOTTED AND YET BY SUPPLYING TITLES, X AND Y AXIS LABELS AND
C     UNITS THE USER CAN PRODUCE ANY NUMBER OF PLOTS WITH EACH PLOT
C     CONTAINING ALMOST ANY COMBINATION OF CURVES AND POINTS WITH EACH
C     PLOT PROPERLY IDENTIFIED.
C
C     GRAPHICS INTERFACE
C     ==================================================================
C     THIS PROGRAM USES A SIMPLE CALCOMP LIKE GRAPHICS INTERFACE WHICH
C     REQUIRES ONLY 4 SUBROUTINES...EACH SUBROUTINE IS DESCRIBED IN
C     DETAIL BELOW. ALL CHARACTERS AND SYMBOLS ARE DRAWN USING TABLES
C     OF PEN STROKES (SUPPLIED WITH THIS PROGRAM). USING THIS METHOD
C     THE PROGRAM SHOULD BE SIMPLE TO INTERFACE TO VIRTUALLY ANY PLOTTER
C     OR GRAPHICS TERMINAL AND THE APPEARANCE AND LAYOUT OF THE PLOTS
C     SHOULD BE INDEPENDENT OF WHICH PLOTTER IS USED.
C
C     ON WHAT COMPUTERS WILL THE PROGRAM RUN
C     ==================================================================
C     THIS PROGRAM WILL RUN ON ALMOST ANY COMPUTER. PERSONAL COMPUTERS
C     ALLOW ON-SCREEN GRAPHICS AND INTERACTION WITH THE PLOTS, AS WELL
C     AS HARDCOPY PLOTS IN POSTSCRIPT FORMAT. CONTRAL COMPUTERS CAN ALSO
C     BE USED WITHOUT INTERACTION TO PRODUCE HARDCOPY PLOTS POSTSCRIPT
C     FORMAT.
C
C     2015 PLOTTER DIMENSIONS
C     ==================================================================
C     PLOTTER DIMENSIONS ARE IN INCHES - NOT CM, MM, OR CUBITS.
C     THIS IS DONE FOR HISTORICAL REASONS AND HOPEFULLY THIS WILL
C     NOT INCONVENIENCE ANYONE - IN PRACTICE I HAVE USED EXACTLY THE
C     SAME DIMENSION = X = 0 to 12.5 and Y = 0 to 10 FOR DECADES
C     TO PRODUCE BOTH ON-SCREEN AND HARDCOPY POSTSCRIPT PLOTS.
C
c     I STRONGLY SUGGEST THAT YOU NOT CHANGE THESE DIMENSIONS UNLESS
C     YOU MUST = BASED ON THE PLOT SIZE YOU OBTAIN WHEN YOU FIRST RUN
C     THIS CODE.
C
C     OPTIONAL FILE NAMES
C     ==================================================================
C     THIS PROGRAM CONTAINS A SUBROUTINE FILEIO WHICH MAY BE USED TO
C     OPTIONALLY DEFINE STANDARD FILE NAMES TO EACH I/O FILE. SEE THIS
C     SUBROUTINE FOR DETAILS ON HOW TO MODIFY THIS PROGRAM TO EITHER
C     (1) ASSUME ALL FILE NAMES ARE DEFINED FROM OUTSIDE THE PROGRAM
C     (E.G. USING JOB CONTROL LANGUAGE) OR (2) DEFINE ALL FILE NAMES
C     INTERNALLY USING SUBROUTINE FILEIO.
C
C     METHOD
C     ==================================================================
C     STARTING FROM FILES OF,
C     (1) OPTIONS = TO CONTROL SELECTION AND PLOTTING OF DATA.
C     (2) CURVES  = IDENTIFIED BY A TITLE AND (X,Y) COORDINATES.
C     (3) POINTS  = IDENTIFIED BY A TITLE AND (X,+DX,-DX,Y,+DY,-DY)
C                   COORDINATES.
C
C     THIS PROGRAM IS DESIGNED TO CREATE PLOTS OF THE USER SELECTED DATA
C
C     FORMAT OF INPUT OPTIONS, CURVES AND DISCRETE POINTS
C     ==================================================================
C     THE FORMAT OF ALL FIXED AND FLOATING POINT DATA USED BY THIS
C     PROGRAM ARE ALL IN FIELDS 11 COLUMNS WIDE (E.G. I11 OR E11.4)
C     WHICH WAS SELECTED TO BE COMPATIBLE WITH THE ENDF/B (EVALUATED
C     NUCLEAR DATA FILE/VERSION B), ENDL (LIVERMORE EVALUATED NUCLEAR
C     DATA LIBRARY) AND EXFOR (EXPERIMENTAL NUCLEAR DATA LIBRARY)
C     FORMATS. DATA IN THE ENDF/B, ENDL OR EXFOR FORMAT CAN EASILY BE
C     TRANSLATED INTO THE FORMATS READ BY THIS PROGRAM.
C
C     DATA UNITS AND IDENTIFICATION
C     ==================================================================
C     BY INPUT PARAMETERS THE USER CAN SPECIFY THE UNITS OF THE DATA
C     FOR THE X AND Y AXIS OF THE PLOTS (E.G., EV, KEV, MEV, BARNS,
C     CM**2,....) AND THE PHYSICAL IDENTIFICATION OF THE DATA TO APPEAR
C     AT THE TOP OF THE PLOT (E.G., 26-FE-56 (N,2N) CROSS SECTION,
C     HELIUM ELECTRON IONIZATION CROSS SECTIONS,....). AS SUCH THE DATA
C     TO BE PLOTTED MAY BE IN ANY UNITS THAT THE USER FINDS CONVENIENT
C     (E.G., EXFOR DATA IN KEV VS. MILLI-BARNS NEED NOT BE CONVERTED TO
C     EV AND BARNS UNLESS THE USER FINDS IT CONVENIENT TO DO SO).
C
C     IF THE USERS WISHES TO USE THIS PROGRAM TO COMPARE DIFFERENT SETS
C     OF DATA (E.G., COMPARE AN EVALUATION TO A NUMBER OF EXPERIMENTAL
C     MEASUREMENTS OR COMPARE A NUMBER OF DIFFERENT EVALUATION) ALL OF
C     THE DATA TO BE COMPARED MUST BE IN THE SAME UNITS.
C
C     BLANK VERSUS ZERO
C     ==================================================================
C     THIS PROGRAM WILL READ ALL DATA AS CHARACTERS AND INTERNALLY
C     CONVERT THEM TO NUMERICAL VALUES AS NEEDED. AS SUCH THIS PROGRAM
C     CAN DISTINGUISH BETWEEN BLANK AND ZERO INPUT. THIS CAPABILITY
C     IS IMPORTANT TO ALLOW THE PROGRAM TO DISTINGUISH BETWEEN WHEN
C     YOU ARE TRYING TO TELL THE PROGRAM NOTHING VERSUS ZERO, E.G.,
C     THE DIFFERENCE BETWEEN SPECIFYING A LOWER X LIMIT OF ZERO OR
C     NO LOWER LIMIT (IN WHICH CASE THE LIMIT WILL BE DEFINED BY THE
C     X RANGE OF THE DATA).
C
C     INPUT OPTIONS
C     ==================================================================
C     I/O UNIT 2 CONTAINS CONTROL INFORMATION OF 3 TYPES (NOTE, UNIT
C     3 IS RESERVED FOR COMPUTER TERMINAL INTERACTION),
C
C     PLOTTER PARAMETERS
C     ------------------------------------------------------------------
C     PARAMETERS WHICH DEFINE THE PHYSICAL X AND Y DIMENSIONS OF A
C     FRAME AND THE NUMBER OF PLOTS TO APPEAR ON EACH FRAME (A FRAME
C     MAY BE SUBDIVIDED INTO ANY NUMBER OF PLOTS IN THE X AND Y
C     DIRECTION).
C
C     PLOTTER PARAMETERS ARE READ AS THE FIRST LINE OF INPUT AND CAN
C     BE USED TO APPLY TO ALL SUBSEQUENT PLOTS OR CAN BE READ AGAIN
C     TO CHANGE THE LAYOUT OF A FRAME AND/OR THE GLOBAL PARAMETERS
C     WHICH FOLLOW (SEE, HOW TO RE-DEFINE THE PLOTTER AND GLOBAL
C     PARAMETERS, BELOW).
C
C     GLOBAL PARAMETERS
C     ------------------------------------------------------------------
C     PARAMETERS WHICH APPLY TO ALL PLOTS, INCLUDING,
C     (1) WHETHER OR NOT TO PLOT CURVES AND HOW TO GROUP THEM.
C     (2) WHETHER OR NOT TO PLOT POINTS AND HOW TO GROUP THEM.
C     (3) WHETHER OR NOT TO PLOT AN OUTER BORDER ON EACH PLOT.
C     (4) TYPE OF GRID (TICK MARKS, FULL GRID OR DASHED GRID).
C     (5) WHETHER ONLY DATA SHOULD BE PLOTTED OR DATA AND RATIO OF ALL
C         DATA TO FIRST CURVE.
C     (6) THE WIDTH OF PLOTTED LINES (APPLIES TO ALL LINES EXCEPT THE
C         GRID).
C     (7) X AND Y AXIS LABELS AND UNITS.
C
C     THERE ARE 3 LINES OF GLOBAL PARAMETERS AND THESE PARAMETERS WILL
C     APPLY TO ALL SUBSEQUENT PLOTS UNTIL THE END OF THE RUN OR THE
C     USER CHOOSES TO RECYCLE BACK TO THE PLOTTER PARAMETER AND GLOBAL
C     PARAMETERS (SEE, HOW TO RE-DEFINE THE PLOTTER AND GLOBAL
C     PARAMETERS, BELOW).
C
C     PLOT PARAMETERS
C     ------------------------------------------------------------------
C     PARAMETERS WHICH ONLY APPLY TO ONE PLOT, INCLUDING,
C     (1) A 2 LINE TITLE TO BE CENTERED AND APPEAR AT TOP OF PLOT.
C     (2) A REQUESTED X RANGE (IF ANY).
C     (3) WHETHER OR NOT X ERROR BARS SHOULD BE PLOTTED FOR POINTS.
C     (4) X SCALING AND INTERPOLATION (AUTOMATIC, LINEAR OR LOG)
C     (5) WHETHER OR NOT TO ROUND X LIMITS OUTWARD SO THAT DATA DOES
C         EXTEND ALL THE WAY TO THE BORDER OF THE PLOT.
C     (6) A REQUESTED Y RANGE (IF ANY).
C     (7) WHETHER OR NOT Y ERROR BARS SHOULD BE PLOTTED FOR POINTS.
C     (8) Y SCALING AND INTERPOLATION (AUTOMATIC, LINEAR OR LOG)
C     (9) WHETHER OR NOT TO ROUND Y LIMITS OUTWARD SO THAT DATA DOES
C         EXTEND ALL THE WAY TO THE BORDER OF THE PLOT.
C
C     FOR EACH PLOT THERE ARE 3 LINES OF PLOT PARAMETERS.
C
C     PLOTTING IS CONTROLLED BY PLOT PARAMETERS, NOT THE CURVE OR POINT
C     DATA. EACH SET OF PLOT PARAMETERS WILL PRODUCE ONE PLOT. PLOTTING
C     ENDS WHEN ALL SETS OF PLOT PARAMETERS HAVE BEEN READ OR WHEN THERE
C     IS NO MORE DATA TO PLOT.
C
C     RE-DEFINING THE PLOTTER AND GLOBAL PARAMETERS
C     ==================================================================
C     IF THE FIRST LINE OF THE TITLE INCLUDED WITH THE PLOT PARAMETERS
C     (DESCRIBED ABOVE) IS BLANK THE PROGRAM WILL RE-CYCLE BACK TO
C     THE POINT OF READING THE PLOTTER PARAMETERS, FOLLOWED BY THE
C     GLOBAL PARAMETERS, FOLLOWED BY PLOT PARAMETERS FOR ANY NUMBER
C     OF PLOTS. THIS METHOD MAY BE USED ANY NUMBER OF TIMES DURING
C     EXECUTION IN ORDER TO CHANGE THE FRAME LAYOUT AND/OR GLOBAL
C     PARAMETERS.
C
C     CURVES
C     ==================================================================
C     I/O UNIT 10 CONTAINS INFORMATION DESCRIBING THE CURVES TO BE
C     PLOTTED (IF ANY), INCLUDING,
C     (1) A ONE LINE TITLE TO IDENTIFY EACH CURVE.
C     (2) TABULATED (X,Y) PAIRS, ONE PAIR PER LINE, TERMINATED BY
C         A BLANK (NOT 0.0) LINE.
C
C     THE SEQUENCE OF CURVE TITLE FOLLOWED BY A TABLE OF VALUES AND
C     TERMINATED BY BLANK MAY BE REPEATED ANY NUMBER OF TIMES TO CREATE
C     A SERIES OF CURVES. INPUT PARAMETERS MAY BE USED TO PLOT EACH
C     CURVE SEPARATELY OR TO GROUP CURVES ON ONE OR MORE PLOTS.
C
C     IF REQUESTED, THE PROGRAM WILL USE THIS DATA TO DRAW CONTINUOUS
C     CURVES CONNECTING THE TABULATED VALUES. EACH CURVE (UP TO 30 MAY
C     APPEAR ON EACH PLOT) WILL BE IDENTIFIED BY ITS TITLE IN A LEGEND
C     BOX WITHIN THE PLOTTING AREA. FOR EACH PLOT THE TOTAL NUMBER OF
C     DATA POINTS USED TO DEFINE THE CURVE MAY BE UP 200000 (IF THIS IS
C     EXCEEDED ONLY THE FIRST 200000 POINTS WILL BE USED).
C
C     POINTS
C     ==================================================================
C     I/O UNIT 11 CONTAINS INFORMATION DESCRIBING THE POINTS TO BE
C     PLOTTED (IF ANY), INCLUDING,
C     (1) A ONE LINE TITLE TO IDENTIFY EACH SET OF POINTS.
C     (2) TABULATED (X,+DX,-DX,Y,+DY,-DY) SEXTUPLETS, ONE SEXTUPLET PER
C         LINE, TERMINATED BY A BLANK (NOT 0.0) LINE.
C
C     THE SEQUENCE OF POINT TITLE FOLLOWED BY A TABLE OF POINTS AND
C     TERMINATED BY BLANK MAY BE REPEATED ANY NUMBER OF TIMES TO CREATE
C     A SERIES OF SETS OF POINTS. INPUT PARAMETERS MAY BE USED TO PLOT
C     THE SETS OF POINTS SEPARATELY OR TO GROUP SETS OF POINTS ON ONE
C     OR MORE PLOTS.
C
C     IF REQUESTED, THE PROGRAM WILL USE THIS DATA TO DRAW A SET OF
C     DISCRETE POINTS AND ASSOCIATED ERROR BARS (IF REQUESTED). EACH
C     SET OF POINTS (UP TO 30 SETS MAY APPEAR ON EACH PLOT) WILL BE
C     IDENTIFIED BY ITS TITLE IN A LEGEND BOX WITHIN THE PLOTTING AREA.
C     FOR EACH PLOT THE TOTAL NUMBER OF DISCRETE DATA POINTS MAY BE UP
C     TO 100000 (IF THIS NUMBER IS EXCEEDED ONLY THE FIRST 100000 POINTS
C     WILL BE USED).
C
C     COMBINED CURVES AND POINTS
C     ==================================================================
C     A COMBINATION OF UP TO 30 CURVES AND SETS OF DISCRETE POINTS MAY
C     APPEAR ON EACH PLOT (E.G., IF THERE ARE 10 CURVES THERE CANNOT BE
C     MORE THAN 20 SETS OF DISCRETE POINTS).
C
C     WARNING...THE PROGRAM WILL ALLOW THE USER TO SPECIFY UP TO 30
C     CURVES AND 30 SETS OF DISCRETE POINTS, BUT WILL NOT READ MORE THAN
C     A COMBINATION OF UP TO 30 CURVES AND DISCRETE POINTS FOR ANY ONE
C     PLOT. IF THE USER EXCEEDS THIS LIMIT IT MAY CAUSE THE DATA THAT
C     APPEARS ON EACH PLOT TO GET OUT OF SYNC WITH THE PLOT PARAMETERS
C     AND APPEAR ON THE WRONG PLOT.
C
C     OPERATION
C     ==================================================================
C     THE PROGRAM WILL,
C     (1) READ PLOTTER PARAMETERS
C     (2) READ ALL GLOBAL PARAMETERS
C     (3) READ ALL THE FIRST TITLE LINE (PLOT PARAMETERS). IF THE LINE
C         IS COMPLETELY BLANK THE PROGRAM WILL GO TO (1) - ABOVE, TO
C         RE-DEFINE THE PLOTTER AND GLOBAL PARAMETERS. IF THE LINE IS
C         NOT COMPLETELY BLANK IT WILL PROCEED TO (4) BELOW.
C     (4) READ THE SECOND TITLE LINE AND TWO PLOT PARAMETER LINES.
C     (5) READ ALL REQUESTED CURVE AND/OR POINT DATA (BASED ON CURRENT
C         GLOBAL PARAMETERS).
C     (6) DETERMINE THE MINIMUM AND MAXIMUM X AND Y VALUES.
C     (7) DECIDE WHETHER FOR X AND Y AXIS TO USE LINEAR OR LOG SCALING.
C         LOG SCALING IS USED UNLESS,
C         (A) USER INPUT SPECIFIES LINEAR
C         (B) THE MINIMUM IS NOT POSITIVE
C         (C) THE MAXIMUM IS LESS THAN 10 TIMES THE MINIMUM
C     (8) IF LINEAR SCALING IS USED FOR THE X AND/OR Y AXIS THE DATA
C         WILL BE SCALED TO OBTAIN AXIS ANNOTATION IN NORMAL FORM TO 3
C         DIGITS ACCURACY (I.E., IF THE X UNITS ARE EV AND THE MAXIMUM
C         X VALUE IS 0.00350 THE AXIS ANNOTATION WILL BE SCALED TO
C         3.50 AND THE UNITS MODIFIED TO (10**-3 EV))
C     (9) PRODUCE A PLOT CONTAINING THE USER SUPPLIED TITLES, X AND Y
C         AXIS LABEL AND UNITS IDENTIFYING EACH CURVE AND SET OF POINTS.
C         THE PLOT WILL ALWAYS CONTAIN THE DATA (CURVES AND/OR DISCRETE
C         POINTS). IF PLOTTING CURVES THE USER MAY OPTIONALLY SPECIFY BY
C         INPUT THAT THE FIRST CURVE IS TO BE USED AS A STANDARD AND THE
C         RATIO OF ALL OTHER DATA (CURVES AND/OR POINTS) TO THE STANDARD
C         SHOULD ALSO APPEAR ON THE PLOT (DATA = TOP 2/3 OF PLOT, RATIO=
C         BOTTOM 1/3 OF PLOT).
C
C     THE CYCLE OF STEPS (3)-(9) IS REPEATED UNTIL ALL SETS OF PLOT
C     PARAMETERS HAS BEEN READ.
C
C     USING THIS METHOD THE PROGRAM HAS NO IDEA OF WHAT DATA IS BEING
C     PLOTTED AND YET BY SUPPLYING TITLES, X AND Y AXIS LABELS AND
C     UNITS THE USER CAN PRODUCE A SERIES OF PLOTS OF ALMOST COMBINATION
C     OF CURVES AND POINTS WITH EACH PLOT PROPERLY IDENTIFIED.
C
C     X ORDER OF DATA
C     ==================================================================
C     IF ALL DATA IS TO APPEAR ON THE PLOTS (I.E., THE USER DOES NOT
C     SPECIFY AN X RANGE..SEE DESCRIPTION OF INPUT OPTIONS) THE DATA FOR
C     EACH CURVE OR SET OF DISCRETE POINTS MAY BE IN ANY X ORDER, E.G.,
C     THE POINTS FOR A CURVE MAY BE ASCENDING OR DESCENDING ORDER OR MAY
C     EVEN REVERSE IN X.
C
C     IF YOU WISH TO SPECIFY X RANGES OR HAVE RATIOS ON A PLOT THE DATA
C     FOR EACH CURVE OR SET OF DISCRETE POINTS MUST BE IN ASCENDING
C     OR DESCENDING (DISCONTINUITY ALLOWED) X ORDER. FAILURE TO CONFORM
C     TO THIS RULE CAN RESULT IN UNPREDICTABLE RESULTS.
C
C     INTERPOLATION OF CURVES
C     ==================================================================
C     IN ORDER TO DEFINE A CONTINUOUS CURVE BETWEEN TABULATED POINTS
C     THIS PROGRAM MUST KNOW HOW TO INTERPOLATE BETWEEN POINTS. BY
C     INPUT THE USER MAY SPECIFY EITHER THE DEFAULT OPTION OF LINEAR X
C     VERSUS LINEAR Y INTERPOLATION OR ALTERNATIVELY LOG X AND/OR LOG
C     Y INTERPOLATION. IN ALL CASES, REGARDLESS OF THE INTERPOLATION
C     SPECIFIED, THE PROGRAM WILL ALWAYS INTERPOLATE THE DATA TO THE
C     PLANE OF THE PLOT (LINEAR OR LOG X AND Y PLANE) IN ORDER TO
C     PRESENT THE TRUE VARIATION OF THE DATA BETWEEN TABULATED POINTS,
C     BASED ON THE USER SPECIFIED INTERPOLATION LAW.
C
C     IF THE USER WISHES THE CURVES TO MERELY BE STRAIGHT LINES BETWEEN
C     TABULATED POINTS IN THE PLANE OF THE PLOT THE INTERPOLATION LAW
C     NEED ONLY CORRESPOND TO THE PLANE OF THE PLOT (LINEAR OR LOG X
C     AND Y PLANE), WHICH CAN BE SPECIFIED BY INPUT.
C
C     TABULATED POINTS SHOULD BE TABULATED AT A SUFFICIENT NUMBER OF X
C     VALUES TO INSURE THAT THE DIFFERENCE BETWEEN THE SPECIFIED
C     INTERPOLATION AND THE 'TRUE' VARIATION OF A CURVE BETWEEN
C     TABULATED VALUES IS RELATIVELY SMALL.
C
C     FOR SOME APPLICATIONS THIS CAN BE VERY IMPORTANT, E.G., CONSIDER
C     THE CASE WHEN WE HAVE THE SIMPLE FUNCTION Y=1/X. TRY COMPARING
C     THE RESULTS OBTAINED AT X=500.0 FOR,
C     (1) THE EXACT VALUE.....Y=1/500.=0.002
C     (2) THE RESULT OBTAINED BY ONLY TABULATING THE FUNCTION AT X=1.0
C         (Y=1.0) AND X=1000.0 (Y=0.001) AND LINEARLY INTERPOLATING
C         BETWEEN THESE 2 VALUES.....Y=ABOUT 0.5
C     (3) THE RESULTS OBTAINED BY TABULATING THE FUNCTION AT X=1.0 UP
C         TO X=1000.0 USING STEPS IN X OF 1.0.....Y=0.002
C
C     IN (2) WHERE AN INSUFFICIENT NUMBER OF POINTS WERE USED THE
C     PREDICTED Y IS A FACTOR OF 250 TOO HIGH. IF THIS TABULATED DATA
C     IS EVER USED IN AN INTEGRAL THE INTEGRAL OF THE DATA IN (2) IS
C     ABOUT 500. WHEREAS THE EXACT INTEGRAL IS ABOUT 6.9 (THE CASE (2)
C     INTEGRAL IS OVER 70 TIMES TOO HIGH).
C
C     THE ABOVE EXAMPLE IS NATURALLY AN EXTREME EXAMPLE, BUT HOPEFULLY
C     IT ILLUSTRATES THE PROBLEMS WHICH CAN OCCUR WHEN TRYING TO PRODUCE
C     ACCURATE CURVES FROM TABULATED VALUES.
C
C     IF YOU HAVE A FUNCTION WHICH YOU WISH TO TABULATE AND YOU ARE NOT
C     SURE HOW MANY TABULATED VALUES TO USE AND WHERE TO LOCATE THEM
C     CONTACT THE AUTHOR FOR A COPY OF PROGRAM LINTAB, WHICH IS DESIGNED
C     TO START FROM ANY USER SUPPLIED FUNCTION AND TO CREATE A TABLE OF
C     LINEARLY INTERPOLABLE POINTS TO WITHIN ANY USER DESIRED ACCURACY.
C
C     NOTE, IF IN THE ABOVE EXAMPLE THE FUNCTION Y=1/X WERE TABULATED
C     AT ONLY X=1.0 AND X=1000.0 THE CORRECT INTERPOLATED VALUES AND
C     INTEGRALS WOULD BE OBTAINED IF LOG-LOG INTERPOLATION WERE ASSUMED.
C     IN THIS CASE INPUT PARAMETERS CAN BE USED TO (1) FORCE THE PLOT
C     TO BE INTO THE LOG-LOG PLANE, (2) SPECIFY LOG X VERSUS LOG Y
C     INTERPOLATION AND THE RESULTING PLOT WILL ACCURATELY REPRESENT
C     THE VARIATION OF THE CURVE BETWEEN TABULATED VALUES.
C
C     LAYOUT OF A FRAME
C     ==================================================================
C     EACH FRAME MAY CONTAIN ANY NUMBER OF PLOTS - AS CONTROLLED BY
C     THE PLOTTER PARAMETERS (THE FIRST LINE OF INPUT) AND WHETHER OR
C     NOT YOU ARE IN THE COMPOSITION MODE. EACH PLOT WILL BE ANNOTATED
C     BY A 2 LINE TITLE AT THE TOP OF THE PLOT, X AND Y AXIS LABELS
C     TO DEFINE THE PHYSICAL SIGNIFICANCE AND DIMENSIONS OF EACH AXIS
C     AND A LEGEND BOX WITH THE PLOT TO IDENTIFY EACH CURVE AND SET OF
C     PLOTS AND IF PLOTTING RATIOS, THE MAXIMUM DIFFERENCE AND WHERE
C     (IN TERMS OF X) THIS DIFFERENCE OCCURRED.
C
C     LEGEND BOX
C     ------------------------------------------------------------------
C     FOR SIMPLE PLOTS WHICH ONLY INVOLVE A SINGLE CURVE OR A SINGLE
C     SET OF POINTS THE LEGEND BOX IS USUALLY REDUNDANT, SINCE IN
C     THIS CASE THE 2 LINE TITLE IS SUFFICIENT TO IDENTIFY THE DATA
C     BEING PLOTTED - FOR SOME APPLICATIONS YOU MAY WISH NOT TO
C     USE A LEGEND BOX AND TO IDENTIFY EACH CURVE AND/OR SET OF
C     SEPARATELY. FOR WHATEVER REASON IF YOU CHOOSE NOT TO HAVE THE
C     LEGEND BOX PLOTTED, YOU CAN SPECIFY THIS AS AN INPUT OPTION
C     TO THE CODE.
C
C     VERTICAL VS. HORIZONTAL PLOTS
C     =============================
C     IF YOUR PLOTTING AREA IS NOT SQUARE YOU MAY WISH TO RE-ORIENT
C     THE PLOTS BY SWITCHING THE X AND Y AXI. FOR EXAMPLE, IF YOUR
C     PLOTTING AREA IS 13.5 BY 10 INCHES (X BY Y), NORMALLY YOU WILL
C     OBTAIN A PLOT WHICH IS UPRIGHT WHEN THE X AXIS IS HORIZONTAL.
C     IF YOU WISH TO OBTAIN A PLOT WHICH IS UPRIGHT WHEN THE Y AXIS
C     IS HORIZONTAL THIS MAY BE DONE BY SETTING THE UPPER X LIMIT OF
C     THE PLOTTING AREA TO ITS NEGATIVE.
C
C     FOR EXAMPLE, FOR 13.5 BY 10.0 INCH PLOTS WITH THE X AXIS
C     HORIZONTAL, COLUMNS 1-44 OF THE FIRST INPUT LINE SHOULD BE,
C
C      0.0       13.5      0.0     10.0
C
C     IN CONTRAST FOR 13.5 BY 10.0 INCH PLOTS WITH THE Y AXIS HORIZONTAL
C     COLUMNS 1-44 OF THE FIRST INPUT LINE SHOULD BE,
C
C      0.0      -13.5      0.0     10.0
C
C     NOTE, THESE 2 CASES DIFFER ONLY IN THE SIGN OF 13.5.
C
C     THAT IS ALL YOU NEED DO - THE NEGATIVE UPPER X LIMIT WILL SERVE
C     AS A SIGNAL TO THE PROGRAM TO ROTATE THE PLOT THROUGH 90 DEGREES.
C
C     NOTE - THE PRESENT CONVENTION DIFFERS FROM THE CONVENTION USED
C     IN EARLIER VERSIONS OF THIS CODE - IN EARLIER VERSIONS IT WAS
C     NECESSARY TO NOT ONLY CHANGE THE SIGN OF THE UPPER X DIMENSION,
C     BUT ALSO TO SWITCH THE X AND Y DIMENSIONS OF THE PLOT - THIS WAS
C     CUMBERSOME AND IS NO LONGER REQUIRED.
C
C     I/O UNITS
C     ==================================================================
C     UNIT  DESCRIPTION
C     ==================================================================
C       2   INPUT OPTIONS (NOTE, UNIT 3 IS RESERVED FOR KEYBOARD
C           INTERACTION ON A COMPUTER TERMINAL OR PERSONAL COMPUTER).
C       5   KEYBOARD INTERACTION (USUALLY JUST TO INDICATE WHEN TO
C           PROCEED TO THE NEXT PLOT).
C       3   OUTPUT REPORT
C      10   TITLES AND SETS OF POINTS FOR EACH CURVE.
C      11   TITLES AND SETS OF DISCRETE POINTS.
C      12   SOFTWARE CHARACTER TABLE
C      14   SOFTWARE SYMBOL AND LINE TYPE TABLE
C
C     OPTIONAL STANDARD FILE NAMES (SEE SUBROUTINE FILEIO)
C     ==================================================================
C     UNIT  FILE NAME
C     ==================================================================
C           STANDARD
C     ==================================================================
C       2   PLOTTAB.INP
C       3   PLOTTAB.LST
C      10   PLOTTAB.CUR
C      11   PLOTTAB.PNT
C      12   PLOT.CHR
C      14   PLOT.SYM
C
C     INPUT PARAMETERS (ON I/O UNIT 2)
C     ==================================================================
C     DESCRIPTION OF PLOTTER AND FRAME LAYOUT
C     ------------------------------------------------------------------
C     LINE  COLUMNS  FORMAT  DESCRIPTION
C     ------------------------------------------------------------------
C     CARD  COLUMNS  FORMAT  DESCRIPTION
C     ----  -------  ------  -----------
C       1     1-11    E11.4  LOWER X LIMIT OF PLOTTER
C            12-22    E11.4  UPPER X LIMIT OF PLOTTER
C            23-33    E11.4  LOWER Y LIMIT OF PLOTTER
C            34-44    E11.4  UPPER Y LIMIT OF PLOTTER
C            45-55     I11   NUMBER OF PLOTS PER FRAME IN X DIRECTION
C            56-66     I11   NUMBER OF PLOTS PER FRAME IN Y DIRECTION
C            67-70     F4.2  CHARACTER SIZE MULTIPLIER.
C                            =0 OR 1    = STANDARD CHARACTER SIZE.
C                            =OTHERWISE = SCALE CHARACTER SIZE BY THIS
C                                         FACTOR.
C                            IF GREATER THAN 2 IT IS SET = 2
C                            IF LESS THAN 1/2 IT IS SET = 1/2
C
C     EXAMPLE DEFINITION OF PLOTTER
C     -----------------------------
C     2015 - WARNING - THE FOLLOWING DESCRIPTION IS OUT-OF-DATE.
C     TODAY THE DIMENSIONS OF THE PLOTTER ARE IN INCHES.
C
C     THE FIRST INPUT LINE DEFINES THE DIMENSIONS OF THE PLOTTER BEING
C     USED IN ANY UNITS (INCHES, CENTIMETERS, MILLIMETERS, ANYTHING)
C     WHICH APPLY TO THE PLOTTER. IN ADDITION THE FIRST LINE DEFINES
C     HOW MANY PLOTS SHOULD APPEAR ON EACH FRAME. THE PLOTTING AREA
C     DEFINED ON THE FIRST INPUT LINE MAY BE SUBDIVIDED INTO ANY NUMBER
C     OF PLOTS IN THE X AND Y DIRECTION. FOR EXAMPLE, TO PRODUCE A
C     SERIES OF FRAMES EACH CONTAINING 3 PLOTS IN THE X DIRECTION AND
C     2 PLOTS IN THE Y DIRECTION (6 PLOTS PER FRAME) COLUMN 45-55 OF
C     THE FIRST INPUT LINE SHOULD BE 3 AND COLUMNS 56-66 SHOULD BE 2.
C
C     IF THE LOCAL PLOTTER USES DIMENSIONS OF INCHES IN ORDER TO OBTAIN
C     10 X 10 INCH FRAMES WITH 3 X 2 PLOTS PER FRAME THE FIRST INPUT
C     LINE SHOULD BE,
C
C       0.0       10.0      0.0     10.0              3          2   0
C
C     IF THE LOCAL PLOTTER USES DIMENSION OF MILLIMETERS THE SAME
C     PHYSICAL SIZE PLOT MAY BE OBTAINED IF THE FIRST INPUT LINE IS,
C
C       0.0      254.0      0.0    254.0              3          2   0
C
C     FOR THE SAME PHYSICAL SIZE AND PLOT LAYOUT AS INDICATED ON THE
C     ABOVE LINE, IF YOU WOULD LIKE THE CHARACTERS TO BE 1.5 TIMES THEIR
C     STANDARD SIZE, YOU NEED MERELY DEFINE COLUMNS 67-70 TO BE 1.5,
C     AS INDICATED BELOW.
C
C       0.0      254.0      0.0    254.0              3          2 1.5
C
C     FOR SIMPLICITY THE FOLLOWING EXAMPLE INPUTS WILL NOT DISCUSS THE
C     PHYSICAL DIMENSIONS OF THE PLOTTER AND THE FIRST INPUT LINE WILL
C     IN ALL CASES INDICATE 10 X 10 INCH PLOTS WITH ONLY 1 PLOT PER
C     FRAME.
C
C     THIS FIRST INPUT CARD IS ALWAYS READ AS THE FIRST LINE OF INPUT
C     PARAMETERS. IT IS POSSIBLE TO RE-CYCLE BACK TO THIS POINT IN
C     THE INPUT TO RE-DEFINE THE LAYOUT OF EACH FRAME AND/OR THE
C     GLOBAL PARAMETERS WHICH FOLLOW (AS DESCRIBED ABOVE).
C
C     GLOBAL PARAMETERS
C     ------------------------------------------------------------------
C     LINE  COLUMNS  FORMAT  DESCRIPTION
C     ------------------------------------------------------------------
C       2     1-11    I11    NUMBER OF CURVES ON EACH PLOT.
C                            = 0        - NO CURVES. IGNORE CURVE FILE.
C                            =+1 TO +30 - FOR EACH PLOT READ 1 TO 30
C                                         CURVES AND PLOT. AFTER PLOT
C                                         READ 1 TO 30 AGAIN AND PLOT.
C                                         CONTINUE READING AND PLOTTING
C                                         UNTIL EITHER ALL CURVE DATA
C                                         OR INPUT PARAMETERS HAVE BEEN
C                                         READ.
C                            =-1 TO -30 - READ 1 TO 30 CURVES ONLY ONCE
C                                         AND SAVE IN CORE TO ALLOW ANY
C                                         NUMBER OF PLOTS OF THE SAME
C                                         DATA (E.G., OVER DIFFERENT X
C                                         RANGES). CONTINUE PLOTTING
C                                         UNTIL ALL INPUT PARAMETERS
C                                         HAVE BEEN READ. AFTER READING
C                                         THE INITIAL DATA FOR 1 TO 30
C                                         CURVES DO NOT READ ANY MORE
C                                         CURVE DATA.
C                            = OTHER    - TREAT AS INPUT ERROR AND DO
C                                         NOT PLOT ANY CURVE DATA.
C            12-22    I11    NUMBER OF SETS OF POINTS ON EACH PLOT.
C                            = 0        - NO POINTS. IGNORE POINTS FILE.
C                            =+1 TO +30 - FOR EACH PLOT READ 1 TO 30
C                                         SETS AND PLOT. AFTER PLOT
C                                         READ 1 TO 30 AGAIN AND PLOT.
C                                         CONTINUE READING AND PLOTTING
C                                         UNTIL EITHER ALL SETS OF DATA
C                                         OR INPUT PARAMETERS HAVE BEEN
C                                         READ.
C                            =-1 TO -30 - READ 1 TO 30 SETS ONLY ONCE
C                                         AND SAVE IN CORE TO ALLOW ANY
C                                         NUMBER OF PLOTS OF THE SAME
C                                         DATA (E.G., OVER DIFFERENT X
C                                         RANGES). CONTINUE PLOTTING
C                                         UNTIL ALL INPUT PARAMETERS
C                                         HAVE BEEN READ. AFTER READING
C                                         THE INITIAL DATA FOR 1 TO 30
C                                         SETS DO NOT READ ANY MORE
C                                         SETS OF DATA.
C                            = OTHER    - TREAT AS INPUT ERROR AND DO
C                                         NOT PLOT ANY POINT DATA.
C            23-33    I11    SHOULD BORDER BE DRAWN AROUND PLOTS.
C                            = 0 - NO
C                            = 1 - YES
C            34-44    I11    TYPE OF GRID ON PLOTS
C                            (NOTE, DEFINITION CHANGED IN VERSION 90-1)
C                            = 0 - TICK MARKS ON BORDER OF PLOT.
C                            = 1 - DASHED COARSE INTERVALS.
C                            = 2 - SOLID COARSE INTERVALS.
C                            = 3 - DASHED COARSE AND FINE INTERVALS.
C                            = 4 - SOLID COARSE/DASHED FINE INTERVALS.
C                            = 5 - SOLID COARSE AND FINE INTERVALS.
C            45-55    I11    SHOULD RATIO OF ALL DATA TO FIRST CURVE BE
C                            PLOTTED.
C                            = 0 - NO
C                            = 1 - YES (GENERAL RATIO RANGE)
C                            = 2 - YES (10000 % MAXIMUM DIFFERENCES)
C                            = 3 - YES ( 1000 % MAXIMUM DIFFERENCES)
C                            = 4 - YES (  100 % MAXIMUM DIFFERENCES)
C                            = 5 - YES (   10 % MAXIMUM DIFFERENCES)
C                            = 6 - YES (    1 % MAXIMUM DIFFERENCES)
C                            = 7 - YES (  0.1 % MAXIMUM DIFFERENCES)
C            56-66    I11    LINE THICKNESS
C                            = 0       - NORMAL
C                            = 1 TO 5  - ALL LINES EXCEPT GRID
C                            =-1 TO -5 - ONLY CURVES AND POINTS
C                                        (NO THICK CHARACTERS)
C            67-70     I4    MASTER CURVE INDEX (THIS CURVE WILL BE
C                            PLOTTED AS A THICK (THICKNESS=3), SOLID
C                            CURVE). ZERO INDICATES NO MASTER CURVE.
C                            (THICKNESS Temprarily turned off).
C       3     1-40   40A1    X LABEL LABEL, E.G. INCIDENT ENERGY
C            41-72   32A1    X LABEL UNITS, E.G. EV
C                            (NOTE, ON THE PLOT THE PROGRAM WILL PLOT
C                            PARENTHESIS AROUND THE UNITS, AS SUCH THE
C                            UNITS AS INPUT NEED NOT INCLUDE A SET OF
C                            ENCLOSING PARENTHESIS).
C       4     1-40   40A1    Y LABEL LABEL, E.G. CROSS SECTION
C            41-72   32A1    Y LABEL UNITS, E.G. BARNS
C                            (NOTE, ON THE PLOT THE PROGRAM WILL PLOT
C                            PARENTHESIS AROUND THE UNITS, AS SUCH THE
C                            UNITS AS INPUT NEED NOT INCLUDE A SET OF
C                            ENCLOSING PARENTHESIS).
C
C     THE ABOVE 3 LINES ARE LINES 2 - 4  OF INPUT AND IF THE USER
C     WISHES TO USE THE SAME GLOBAL PARAMETERS FOR ALL PLOTS THESE 3
C     LINES WILL ONLY BE READ ONCE (NOT FOR EACH PLOT).
C
C     IF THE USER WISHES TO CHANGE THE GLOBAL PARAMETERS IN THE MIDDLE
C     OF A RUN THE FIRST LINE OF THE PLOT PARAMETERS, DESCRIBED BELOW,
C     SHOULD BE BLANK (AS DESCRIBED ABOVE).
C
C     NOTE, ONLY A COMBINATION OF UP TO 30 CURVES AND SETS OF POINTS
C     MAY BE READ AND PLOTTED ON THE SAME PLOT. THE USER MAY REQUEST
C     MORE THAN THIS NUMBER BUT THE PROGRAM WILL ONLY READ AND PLOT UP
C     TO 30 (E.G., IF IT FIRST READS 17 CURVES IT WILL ONLY READ UP TO
C     13 SETS OF POINTS).
C
C     PLOT PARAMETERS
C     ------------------------------------------------------------------
C     LINE  COLUMNS  FORMAT  DESCRIPTION
C     ------------------------------------------------------------------
C       5     1-72    72A1   FIRST LINE OF TITLE (FOR TOP OF PLOT)
C                            IF THIS LINE IS BLANK THE PROGRAM WILL
C                            ASSUME THAT THE 4 LINES FOLLOWING THIS ONE
C                            ARE A RE-DEFINITION OF THE PLOTTER AND
C                            GLOBAL PARAMETERS (DESCRIBED ABOVE).
C       6     1-72    72A1   SECOND LINE OF TITLE (FOR TOP OF PLOT)
C       7     1-11    E11.4  MINIMUM X LIMIT OF PLOT (BLANK INDICATES NO
C                            LIMIT = USE MINIMUM X VALUE OF DATA).
C            12-22    E11.4  MAXIMUM X LIMIT OF PLOT (BLANK INDICATES NO
C                            LIMIT = USE MAXIMUM X VALUE OF DATA).
C            23-33     I11   SHOULD X ERROR BARS BE PLOTTED.
C                            = 0 - NO
C                            = 1 - YES
C            34-44     I11   X AXIS SCALING
C                            = 0 - AUTOMATIC
C                            = 1 - LINEAR SCALING AND INTERPOLATION
C                            = 2 - LOG SCALING AND LINEAR INTERPOLATION
C                            =-1 - LINEAR SCALING AND INTERPOLATION
C                                  (IDENTICAL TO +1)
C                            =-2 - LOG SCALING AND INTERPOLATION
C            45-55     I11   SHOULD X LIMITS BE ROUNDED OUTWARD TO AVOID
C                            TOUCHING EDGE OF PLOT
C                            = 0 - YES
C                            = 1 - NO
C                            = 2 - ONLY ROUND BOTTOM
C                            = 3 - ONLY ROUND TOP
C            56-66     I11   OMIT LEGEND BOX FROM PLOT
C                            = 0 - NO - LEGEND BOX WILL APPEAR ON PLOT
C                            = 1 - YES - NO LEGEND BOX ON PLOT
C       8     1-11    E11.4  MINIMUM Y LIMIT OF PLOT (BLANK INDICATES NO
C                            LIMIT = USE MINIMUM Y VALUE OF DATA).
C            12-22    E11.4  MAXIMUM Y LIMIT OF PLOT (BLANK INDICATES NO
C                            LIMIT = USE MAXIMUM Y VALUE OF DATA).
C            23-33     I11   SHOULD Y ERROR BARS BE PLOTTED.
C                            = 0 - NO
C                            = 1 - YES
C            34-44     I11   Y AXIS SCALING
C                            = 0 - AUTOMATIC
C                            = 1 - LINEAR SCALING AND INTERPOLATION
C                            = 2 - LOG SCALING AND LINEAR INTERPOLATION
C                            =-1 - LINEAR SCALING AND INTERPOLATION
C                                  (IDENTICAL TO +1)
C                            =-2 - LOG SCALING AND INTERPOLATION
C            45-55     I11   SHOULD Y LIMITS BE ROUNDED OUTWARD TO AVOID
C                            TOUCHING EDGE OF PLOT
C                            = 0 - YES
C                            = 1 - NO
C                            = 2 - ONLY ROUND BOTTOM
C                            = 3 - ONLY ROUND TOP
C            56-66     I11   SHOW DATA POINTS
C                            = 0 - NO
C                            = 1 - YES
C
C     WARNING - DO NOT USE THE SHOW DATA POINTS OPTIONS IF YOU HAVE MANY
C     POINTS ON A PLOT, E.G., MORE THAN A FEW HUNDRED. THIS OPTION WILL
C     WORK WITH ANY NUMBER OF POINTS, BUT IF THERE ARE TOO MANY POINTS
C     YOU MAY NOT BE ABLE TO SEE CURVES BETWEEN POINTS. THE PROPER WAY
C     TO USE THIS OPTION IS TO RESTRICT THE X, Y RANGE OF THE PLOT TO
C     INSURE THAT NOT TOO MANY POINTS WILL APPEAR ON THE PLOT.
C
C     NOTE, INPUT LINES 7 AND 8 ARE ALMOST IDENTICAL EXCEPT THAT LINE 7
C     APPLIES TO THE X AXIS AND LINE 8 TO THE Y AXIS.
C
C     NOTE, ONE SIDED LIMITS MAY BE SPECIFIED FOR X AND/OR Y, E.G.,
C     FOR X LIMITS BETWEEN 5.0 AND THE UPPER X LIMIT OF THE DATA
C     MERELY SPECIFY THE MINIMUM X LIMIT TO BE 5.0 AND LEAVE THE
C     MAXIMUM LIMIT BLANK (NOT 0.0). SIMILARLY FOR X BETWEEN THE
C     LOWER X LIMIT OF THE DATA AND 12.0 MERELY LEAVE THE MINIMUM
C     LIMIT BLANK (NOT 0.0) AND SPECIFY THE MAXIMUM X LIMIT TO BE
C     12.0. THE Y LIMITS CAN BE TREATED IN A SIMILAR MANNER.
C
C     NOTE, THE X AND Y SCALING CONTROL BOTH THE PLANE IN WHICH THE
C     PLOT IS PRESENTED (LINEAR OR LOG X AND Y SCALING) AND HOW THE
C     DATA IS INTERPOLATED INTO THIS PLANE.
C
C     THE ABOVE 4 LINES ARE READ FOR EACH PLOT. PROGRAM EXECUTION
C     TERMINATES AT THE END OF INPUT.
C
C     NOTE, REGARDLESS OF WHETHER OR NOT THE POINTS INCLUDE UNCERTAINTY
C     (+DX,-DX,+DY,-DY) COLUMNS 23-33 OF LINES 7 AND 8 CONTROL WHETHER
C     OR NOT THE X AND Y UNCERTAINTY IS CONSIDERED IN SCALING THE PLOT
C     AND WHETHER OR NOT ERROR BARS WILL APPEAR ON THE PLOT.
C
C     GROUPING DATA ON PLOTS
C     ==================================================================
C     BY USING INPUT OPTIONS THE USER HAS CONTROL OVER HOW MANY SETS OF
C     CURVES AND/OR POINTS WILL APPEAR ON EACH PLOT. ON THE GLOBAL INPUT
C     LINE COLUMNS 1-11 CONTROL HOW CURVES SHOULD APPEAR ON EACH PLOT
C     AND COLUMNS 12-22 CONTROL HOW POINTS SHOULD APPEAR ON EACH PLOT.
C     THESE OPTIONS CONTROL HOW MANY SETS (IF ANY) OF A GIVEN TYPE OF
C     DATA (CURVES OR POINTS) WILL BE READ OR KEPT IN CORE FOR THE NEXT
C     PLOT. THE AVAILABLE OPTIONS ARE,
C
C     (LESS THAN -30 OR MORE THAN +30)
C     ------------------------------------------------------------------
C     IS TREATED AS AS AN ERROR, NO DATA IS READ (I.E., IT IS TREATED
C     AS 0, AS DESCRIBED BELOW).
C
C     (0)
C     ------------------------------------------------------------------
C         DATA IS NOT TO BE READ OR APPEAR ON PLOT. WHEN YOU WISH TO
C         PLOT ONE TYPE OF DATA (CURVES OR POINTS) THIS OPTION SHOULD
C         BE SPECIFIED FOR THE OTHER TYPE OF DATA. YOU CANNOT SPECIFY
C         THIS OPTION FOR BOTH TYPES OF DATA. IF YOU DO THE PROGRAM WILL
C         SIMPLY TELL YOU THAT YOU ARE NOT REQUESTING ANY PLOTS AND
C         TERMINATE. E.G., IF YOU WISH TO ONLY PLOT CURVES SPECIFY THIS
C         OPTION FOR POINTS (COLUMNS 12-22 = 0).
C
C     (+1 TO +30)
C     ------------------------------------------------------------------
C         FOR THE NEXT PLOT READ 1 TO 30 SETS OF DATA (POINTS OR CURVES)
C         AND USE THEM ONLY FOR THE NEXT PLOT. THIS OPTION MAY BE USED
C         WHEN YOU WISH TO CREATE A SERIES OF PLOTS EACH CONTAINING 1 TO
C         30 SETS OF A TYPE OF DATA (POINTS OR CURVES) PLUS ANY NUMBER
C         (0 TO 30) OF SETS OF THE OTHER TYPE OF DATA. NOTE, THE SETS OF
C         DATA WILL ONLY APPEAR ON ONE PLOT, SO THAT YOU CANNOT FIRST
C         SPECIFY THE ENTIRE X RANGE FOR ONE PLOT AND THEN SPECIFY A
C         MINIMUM AND MAXIMUM RANGE FOR A SECOND PLOT. E.G., IF YOU WISH
C         TO CREATE A SERIES OF PLOTS EACH CONTAINING 5 CURVES SPECIFY
C         THIS OPTION FOR CURVES (COLUMNS 1-11 = 5).
C
C     (-1 TO -30)
C     ------------------------------------------------------------------
C         READ 1 TO 30 SETS OF DATA (POINTS OR CURVES) AND USE THEM ON
C         ALL PLOTS. AFTER THE INITIAL READ NO MORE DATA (POINTS OR
C         CURVES) WILL BE READ. THIS OPTION MAY BE USED IF YOU WISH TO
C         CREATE A SERIES OF PLOTS EACH CONTAINING ALL OR THE FIRST 1 TO
C         30 SETS OF DATA OF A GIVEN TYPE (POINTS OR CURVES). NOTE,
C         IN THIS CASE YOU MAY FIRST PLOT THE ENTIRE X RANGE AND THEN
C         SPECIFY MINIMUM AND MAXIMUM RANGES FOR ANY NUMBER OF FOLLOWING
C         PLOTS. E.G., IF YOU WISH TO A CREATE A SERIES OF PLOTS EACH
C         CONTAINING 15 CURVES AND EACH INVOLVING A DIFFERENT X RANGES
C         SPECIFY THIS OPTION FOR CURVES (COLUMNS 1-11 =-15).
C
C     IF YOU WISH TO CREATE A SERIES OF PLOTS CONTAINING A DIFFERENT
C     NUMBER OF CURVES AND OR POINTS YOU MAY RE-DEFINE THE GLOBAL
C     PARAMETERS, AS DESCRIBED ABOVE, IN THE MIDDLE OF A RUN TO PLOT
C     ALMOST ANY COMBINATION OF CURVES AND/OR POINTS ON A SERIES OF
C     PLOTS.
C
C     IN ORDER TO CREATE OTHER COMBINATIONS OF CURVES AND PLOTS IT IS
C     USUALLY EASIER TO EDIT YOUR CURVE AND POINT FILES TO CONTAIN THE
C     THE DATA TO APPEAR ON THE PLOTS THAN TO INCLUDE MORE INPUT OPTIONS
C     IN THIS PROGRAM. E.G., IF YOU HAVE A SERIES OF CURVES AND YOU WISH
C     TO PLOT EACH SEPARATELY, BUT YOU WOULD LIKE A SERIES OF PLOTS OF
C     DIFFERENT X RANGES FOR EACH CURVE, CREATE A NUMBER OF CURVE FILES
C     EACH CONTAINING ONLY ONE CURVE AND RUN EACH FILE SEPARATELY WITH
C     COLUMNS 1-11 = -1.
C
C     FOR VERSION 88-1 AND LATER VERSIONS THE ABOVE SERIES OF PLOTS MAY
C     BE CREATED BY RE-DEFINING THE GLOBAL PARAMETERS IN THE MIDDLE OF
C     A RUN. FOR EACH OF THE SERIES OF CURVES USE GLOBAL PARAMETERS
C     WITH COLUMNS 1-11 = -1, TO FORCE THE NEXT CURVE TO BE READ AND
C     KEPT IN CORE TO ALLOW A NUMBER OF DIFFERENT X RANGES TO BY PLOTTED
C     SEPERATELY. WHEN ALL RANGES HAVE BEEN PLOTTED INSERT A BLANK LINE
C     IN THE INPUT, FOLLOWED BY 3 LINES RE-DEFINING GLOBAL PARAMETERS
C     WITH COLUMNS 1-11 = -1 TO FORCE THE NEXT CURVE TO BE READ AND
C     KEPT IN CORE WHILE DIFFERENT X RANGES ARE PLOTTED. THIS CYCLE OF
C     RE-DEFINING GLOBAL PARAMETERS FOLLOWED BY A SERIES OF PLOTS MAY
C     BE REPEATED ANY NUMBER OF TIMES DURING A RUN.
C
C     COMPOSITION MODE
C     ==================================================================
C     IT IS POSSIBLE TO USE THIS CODE TO COMPOSE FRAMES WITH ANY NUMBER
C     OF PLOTS APPEARING ANYWHERE ON EACH FRAME. THIS COMPOSITION MODE
C     SHOULD ONLY TO USED TO POSITION ONE PLOT AT A TIME ON THE FRAME
C     AND THEN RE-CYCLE BACK TO THE PLOTTER PARAMETERS (AS DESCRIBED
C     ABOVE) TO POSITION THE NEXT PLOT ON THE SAME FRAME. THIS MODE IS
C     TURNED ON BY SPECIFYING A -1 FOR THE NUMBER OF PLOTS IN THE X
C     DIRECTION ON THE PLOTTER PARAMETER LINE. THIS -1 MERELY INDICATES
C     TO THE PROGRAM NOT TO ADVANCE TO THE NEXT PLOTTING AREA OR FRAME
C     AT THE END OF THE CURRENT PLOT. THE USER CAN THEN USE THE X AND
C     Y DIMENSIONS OF THE PLOTTER TO SPECIFY WHERE THIS PLOT SHOULD
C     APPEAR ON THE FRAME, E.G., FOR A PLOT LOCATED BETWEEN X = 3.0
C     AND 7.0 AND Y = 2.0 AND 8.0, MERELY SPECIFY THESE X AND Y LIMITS
C     AS THE LIMIT OF THE PLOTTER ON THE PLOTTER PARAMETER LINE.
C
C     IN THIS MODE YOU HAVE COMPLETE FREEDOM TO COMPOSE FRAMES, BUT
C     YOU HAVE THE RESPONSIBILITY TO EXACTLY DEFINE WHERE YOU WANT
C     EACH PLOT POSITIONED. COMPOSITION CAN USUALLY BE DONE QUITE
C     QUICKLY USING A COMPUTER TERMINAL SCREEN. ONCE THE INPUT
C     CORRECTLY DEFINES THE COMPOSED FRAME YOU CAN THEN USE THIS
C     INPUT TO PRODUCE A HARD COPY PLOT.
C
C     AGAIN, WARNING...THIS MODE SHOULD ONLY TO USED TO POSITION ONE
C     PLOT AT A TIME ONTO A FRAME AND YOU SHOULD THEN USE THE PROPER
C     SEQUENCE OF INPUT TO RE-CYCLE BACK TO RE-DEFINE THE PLOTTER
C     AND GLOBAL PARAMETERS...FAILURE TO HEED THIS WARNING MAY PRODUCE
C     UNPREDICTABLE RESULTS.
C
C     IN ORDER TO STAY IN THE COMPOSITION MODE FOR A SERIES OF PLOTS
C     THE USER SHOULD CONTINUE TO SPECIFY -1 FOR THE NUMBER OF PLOTS
C     IN THE X DIRECTION (DO NOT ADVANCE AFTER PLOT). FOR THE LAST PLOT
C     OF A COMPOSED FRAME SPECIFY 1 FOR THE NUMBER OF PLOTS IN THE X
C     DIRECTION (LEAVE COMPOSITION MODE AND ADVANCE AFTER PLOT).
C     REMEMBER, TO LEAVE THE COMPOSITION MODE AND ADVANCE TO THE NEXT
C     FRAME THE LAST PLOT ON A FRAME MUST SPECIFY +1 FOR THE NUMBER OF
C     PLOTS IN THE X DIRECTION - IF YOU CREATE A NUMBER OF PLOTS ON A
C     FRAME AND THEN FINISH EXECUTING WITHOUT ADVANCING TO THE NEXT
C     FRAME, DEPENDING ON THE PLOTTING SYSTEM THAT YOU USE, YOU MAY
C     NOT GET ANY OUTPUT PLOTTING, I.E., YOU DIDN'T FINISH THE PLOT.
C
C     ONE SPECIAL CONVENTION HAS BEEN INTRODUCED FOR USE WITH THE
C     COMPOSITION MODE - THE MOST USEFUL PURPOSE OF THIS MODE IS TO
C     ALLOW A FULL SIZED PLOT OF THE FULL X AND Y RANGE AND THEN TO
C     INSERT ONTO THIS FRAME ONE OR MORE EXPANDED VIEWS OF SPECIFIC
C     X AND Y RANGES - IN ORDER TO ALLOW THIS TO BE DONE THE PROGRAM
C     MUST KEEP THE SAME CURVES AND/OR POINTS IN CORE AS YOU MOVE
C     FROM ONE PLOT OF THE COMPOSITION TO THE NEXT - NORMALLY WHEN
C     THE PROGRAM READS THE GLOBAL PARAMETERS IT IS TOLD HOW MANY
C     CURVES AND/OR POINTS TO READ FOR THE NEXT PLOT - WHEN IN
C     COMPOSITION MODE FOR THE FIRST PLOT OF A FRAME THIS IS WHAT
C     THE CODE WILL DO - BUT IF YOU USE A MINUS COUNT FOR THE
C     NUMBER OF CURVES AND/OR SETS OF POINTS (SEE, DESCRIPTION OF
C     INPUT PARAMETERS ABOVE) YOU ARE TELLING THE CODE TO READ
C     AND KEEP THIS DATA IN CORE - IF SUCCESSIVE PLOTS FOR THE
C     SAME COMPOSITION FRAME ALSO SPECIFY A MINUS COUNT THE CODE
C     WILL NOT READ AND SAVE MORE DATA - IT WILL ASSUME THAT
C     WHAT YOU MEAN IS USE THE DATA ALREADY IN CORE, I.E., THE
C     DATA WHICH APPEARED ON THE LAST PLOT.
C
C     PLOTTING RATIOS
C     ==================================================================
C     WHICHEVER DATA IS REQUESTED (CURVES AND/OR POINTS) WILL ALWAYS BE
C     PLOTTED. WHEN PLOTTING CURVES THE USER HAS THE OPTION TO USE THE
C     FIRST CURVE AS A STANDARD AND TO PLOT NOT ONLY THE DATA (UPPER 2/3
C     OF PLOT), BUT ALSO THE RATIO OF ALL CURVES AND/OR DATA POINTS TO
C     THE STANDARD (LOWER 1/3 OF PLOT). THIS OPTION IS EXTREMELY HANDY
C     WHEN YOU WOULD LIKE TO QUANTITATIVELY DEFINE THE AGREEMENT BETWEEN
C     CURVES AND/OR POINTS (E.G., IT IS EASY TO SEE FROM THE PLOT THAT
C     2 CURVES DIFFER BY 15 PER-CENT).
C
C     IF YOU WISH TO CHANGE THE STANDARD TO WHICH ALL OTHER DATA IS TO
C     BE COMPARED SIMPLY MOVE THE DATA THAT YOU WISH TO BE USED AS A
C     STANDARD TO THE BEGINNING OF THE CURVE FILE TO BE THE FIRST CURVE.
C
C     ALL OF THE FOLLOWING EXAMPLE INPUTS ASSUME A STANDARD 13.5 BY 10
C     SIZE FOR THE PLOTTER AND 1 BY 1 (FULL SIZE) PLOTS PER FRAME, AS
C     DEFINED BY THE BELOW INPUT, AND WILL NOT BE DISCUSSED FOR EACH
C     EXAMPLE INPUT.
C
C     EXAMPLE NO. 1 UNIT 2 INPUT
C     ------------------------------------------------------------------
C     IF WE HAVE EVALUATED DATA FOR 27-CO-59 (N,2N) FROM 3 DIFFERENT
C     EVALUATED DATA LIBRARIES (ASSUME ENDF/B-V, ENDL AND JENDL-2) AND
C     EXPERIMENTAL DATA FROM A NUMBER OF MEASUREMENTS WE CAN PUT THE
C     EVALUATED DATA ON THE CURVE FILE AS 3 SEPARATE CURVES IDENTIFYING
C     EACH BY LIBRARY NAME AND THE EXPERIMENTAL DATA ON THE POINT FILE
C     IDENTIFYING EACH BY FIRST AUTHOR AND YEAR.
C
C     TO CREATE SEPARATE PLOTS OF EACH EVALUATION, EACH PLOT CONTAINING
C     ONE EVALUATION AND ALL EXPERIMENTAL DATA WE CAN SPECIFY 1 CURVE
C     (READ AND PLOT 1 CURVE PER PLOT) AND -30 SETS OF POINTS (READ ONCE
C     AND INCLUDE ON ALL PLOTS). THE FOLLOWING INPUT WILL CREATE 3 FULL
C     SIZED PLOTS WITH TICKS MARKS ON THE BORDER, NO RATIOS AND LINE
C     THICKNESS 0. X AND Y ERRORS FOR EXPERIMENTAL DATA (IF ANY) WILL BE
C     PLOTTED ON THE FIRST 2 PLOTS BUT WILL NOT APPEAR ON THE 3-RD PLOT.
C     NOTE, IN THIS EXAMPLE THE BELOW INPUT IS USED TO IDENTIFY THE
C     TARGET (27-CO-59) AND REACTION (N,2N) (FOR CONTRAST SEE EXAMPLE
C     INPUT NO. 3).
C
C             0.0       13.5        0.0       10.0          1          1
C               1        -30          0          0          0          0
C     INCIDENT ENERGY                         EV
C     CROSS SECTION                           BARNS
C     27-CO-59                                                 (N,2N)
C     CROSS SECTIONS
C                                     1          0          0
C                                     1          0          0
C     27-CO-59                                                 (N,2N)
C     CROSS SECTIONS
C                                     1          0          0
C                                     1          0          0
C     27-CO-59                                                 (N,2N)
C     CROSS SECTIONS
C                                     0          0          0
C                                     0          0          0
C
C     NOTE, TO OBTAIN A PLOT OF EACH EVALUATION SEPARATELY WITHOUT
C     EXPERIMENTAL DATA ONE CAN CHANGE COLUMNS 12-22 OF THE 2-ND INPUT
C     LINE FROM -30 TO 0 AND USE THE ABOVE INPUT.
C
C     EXAMPLE NO. 2 UNIT 2 INPUT
C     ------------------------------------------------------------------
C     ASSUMING WE HAVE ALL OF THE DATA DESCRIBED IN EXAMPLE NO. 1 AND
C     WE WOULD LIKE TO CREATE PLOTS CONTAINING ALL EVALUATED AND
C     EXPERIMENTAL DATA AND THE RATIO OF ALL EVALUATED AND EXPERIMENTAL
C     DATA TO THE FIRST EVALUATION. TO DO THIS SPECIFY -30 FOR BOTH
C     CURVES AND POINTS (READ ONCE AND INCLUDE ON ALL PLOTS). IF WE
C     WOULD LIKE TO OBTAIN 2 PLOTS, ONE FOR THE ENTIRE ENERGY RANGE AND
C     A SECOND FROM 10 TO 20 MEV (ASSUMING DATA IS GIVEN IN EV) THE
C     FOLLOWING INPUT CARDS WILL CREATE 2 FULL SIZED PLOTS WITH A
C     DASHED GRID, RATIOS AND LINE THICKNESS 3. X AND Y ERRORS (IF ANY)
C     WILL BE INCLUDED ON BOTH PLOTS. THE PLANE OF THE PLOT (LINEAR OR
C     LOG IN X OR Y) WILL BE AUTOMATICALLY SELECTED FOR THE FIRST PLOT.
C     THE SECOND PLOT WILL BE LOG IN X AND LINEAR Y WITH THE LOWER Y
C     LIMIT OF ZERO. THE Y LIMITS WILL NOT BE ROUNDED OUTWARD, SO THE
C     LOWER Y LIMIT OF THE PLOT WILL BE EXACTLY ZERO.
C
C             0.0       13.5        0.0       10.0          1          1
C             -30        -30          0          2          1          3
C     INCIDENT ENERGY                         EV
C     CROSS SECTION                           BARNS
C     27-CO-59                                                 (N,2N)
C     CROSS SECTIONS
C                                     1          0          0
C                                     1          0          0
C     27-CO-59                                                 (N,2N)
C     CROSS SECTIONS
C      1.00000+07 2.00000+07          1          2          0
C      0.0                            1          1          1
C
C     NOTE, TO OBTAIN PLOTS OF ALL EVALUATIONS TOGETHER WITHOUT
C     EXPERIMENTAL DATA ONE CAN CHANGE COLUMNS 12-22 OF THE 2-ND INPUT
C     LINE FROM -30 TO 0 AND USE THE ABOVE INPUT.
C
C     NOTE, IF YOU WOULD LIKE THE EXPERIMENTAL DATA TO ONLY APPEAR ON
C     THE FIRST PLOT CHANGE COLUMNS 12-22 OF THE FIRST INPUT LINE FROM
C     -30 TO 30 (ASSUMING THERE ARE 30 OR FEWER SETS OF EXPERIMENTAL
C     DATA). SIMILARLY TO HAVE THE FIRST 6 EXPERIMENTAL REFERENCES
C     APPEAR ON THE FIRST PLOT AND THE NEXT 6 ON THE SECOND PLOT CHANGE
C     COLUMNS 12-22 OF THE FIRST INPUT LINE FROM -30 TO 6.
C
C     EXAMPLE NO. 3 UNIT 2 INPUT
C     ------------------------------------------------------------------
C     IF WE HAVE THE ENDF/B-V 27-CO-59 (N,N'), (N,2N) AND (N,3N) DATA
C     WE CAN PUT THE DATA ON THE CURVE FILE AND IDENTIFY EACH BY THE
C     REACTION (AS OPPOSED TO LIBRARY NAME AS IN EXAMPLE NO. 1). TO
C     PLOT ALL 3 REACTIONS AND THE RATIO OF ALL REACTIONS TO THE (N,N')
C     OVER THE ENTIRE ENERGY RANGE AND THEN OVER 10 TO 20 MEV THE
C     FOLLOWING INPUT MAY BE USED. NOTE, IN THIS EXAMPLE THE BELOW
C     INPUT IS USED TO IDENTIFY THE TARGET AND LIBRARY NAME (AS OPPOSED
C     TO THE REACTION AS IN EXAMPLE NO. 1).
C
C             0.0       13.5        0.0       10.0          1          1
C              -3          0          0          0          1          3
C     INCIDENT ENERGY                         EV
C     CROSS SECTION                           BARNS
C     27-CO-59                                              ENDF/B-V
C     CROSS SECTIONS
C                                     0          0          0
C                                     0          0          0
C     27-CO-59                                              ENDF/B-V
C     CROSS SECTIONS
C      1.00000+ 7 2.00000+ 7          0          0          0
C                                     0          0          0
C
C     NOTE, TO OBTAIN PLOTS ONLY COMPARING (N,N') AND (N,2N) (I.E.,
C     IGNORE (N,3N)) ONE CAN CHANGE COLUMNS 1-11 OF THE FIRST INPUT
C     LINE FROM -3 TO -2 AND USE THE ABOVE INPUT.
C
C     EXAMPLE NO. 4 UNIT 2 INPUT
C     ------------------------------------------------------------------
C     IF WE HAVE PHOTON INTERACTION DATA FOR THE ENTIRE PERIODIC TABLE
C     WITH 5 CURVES FOR EACH ELEMENT (TOTAL, COHERENT, INCOHERENT,
C     PHOTOELECTRIC AND PAIR PRODUCTION) WE CAN PUT THE DATA ON THE
C     CURVE FILE IN ELEMENT ORDER (I.E., HYDROGEN FIRST) AND IDENTIFY
C     EACH CURVE BY REACTION. TO OBTAIN A SERIES OF PLOTS 1 FOR EACH
C     ELEMENT THE FOLLOWING INPUT MAY BE USED.
C
C             0.0       13.5        0.0       10.0          1          1
C               5          0          0          0          1          0
C     INCIDENT ENERGY                         MEV
C     CROSS SECTION                           BARNS
C     HYDROGEN                                              ENDL
C     PHOTON INTERACTION CROSS SECTIONS
C                                     0          0          0
C                                     0          0          0
C     HELIUM                                                ENDL
C     PHOTON INTERACTION CROSS SECTIONS
C                                     0          0          0
C                                     0          0          0
C     LITHIUM                                               ENDL
C     PHOTON INTERACTION CROSS SECTIONS
C                                     0          0          0
C                                     0          0          0
C                    .                .          .          .
C                    .                .          .          .
C                    .                .          .          .
C     (3 LINES FOR EACH ELEMENT TO THE END OF THE PERIODIC TABLE)
C
C     EXAMPLE NO. 5 UNIT 2 INPUT
C     ------------------------------------------------------------------
C     ASSUMING WE HAVE ALL OF THE DATA DESCRIBED IN EXAMPLE NO. 3, BUT
C     WE ONLY HAVE EXPERIMENTAL DATA FOR (N,3N) AND WE WOULD LIKE TO
C     PLOT (N,N') AND (N,2N) SEPARATELY WITHOUT EXPERIMENTAL DATA AND
C     THEN WE WOULD LIKE TO PLOT (N,3N) COMPARED TO EXPERIMENTAL DATA
C     OVER THE ENTIRE ENERGY RANGE FOLLOWED BY A PLOT OF 10 TO 20 MEV
C     WE MAY USE THE FOLLOWING INPUT TO RE-DEFINE THE GLOBAL PARAMETERS
C     AFTER THE FIRST TWO PLOTS TO OBTAIN THE DESIRED PLOTS.
C
C             0.0       13.5        0.0       10.0          1          1
C               1          0          0          0          1          0
C     INCIDENT ENERGY                         EV
C     CROSS SECTION                           BARNS
C     27-CO-59                                              ENDF/B-V
C     CROSS SECTIONS
C                                     1          0          0
C                                     1          0          0
C     27-CO-59                                              ENDF/B-V
C     CROSS SECTIONS
C                                     1          0          0
C                                     1          0          0
C     (IF THIS LINE IS BLANK NEXT 4 LINES = PLOTTER/GLOBAL PARAMETERS)
C             0.0       13.5        0.0       10.0          1          1
C              -1        -30          0          0          1          0
C     INCIDENT ENERGY                         EV
C     CROSS SECTION                           BARNS
C     27-CO-59                                              ENDF/B-V
C     CROSS SECTIONS
C                                     1          0          0
C                                     1          0          0
C     27-CO-59                                              ENDF/B-V
C     CROSS SECTIONS
C      1.00000+ 7 2.00000+ 7          1          0          0
C                                     1          0          0
C
C     CURVE DATA (ON I/O UNIT 10)
C     ==================================================================
C     LINE  COLUMNS  FORMAT  DESCRIPTION
C     ------------------------------------------------------------------
C       1     1-26    26A1   TITLE FOR CURVE
C     2-N     1-11   E11.4   X VALUE
C            12-22   E11.4   Y VALUE
C
C     EACH CURVE IS TERMINATED BY BLANK (NOT 0.0). THE SEQUENCE OF
C     TITLE FOLLOWED BY TABULATED POINTS MAY BE REPEATED ANY NUMBER OF
C     TIMES. THE CURVE FILE MAY CONTAIN DATA FOR ANY NUMBER OF CURVES
C     AND ANY NUMBER OF DATA POINTS. EACH PLOT MAY CONTAIN UP TO 200000
C     POINTS (IF MORE ARE PRESENT ONLY THE FIRST 200000 WILL BE USED).
C
C     EXAMPLE  UNIT 10 INPUT
C     ------------------------------------------------------------------
C     IF UNIT 10 CONTAINS THE 27-CO-59 (N,2N) EVALUATIONS FROM ENDF/B-IV
C     JENDL-II AND ENDL84 THE DATA COULD LOOK LIKE,
C
C     ENDF/B-IV                                        27-CO-59 (N,2N)
C      1.10000+ 7 0.00000+ 0
C      1.20000+ 7 1.20000- 3
C          .          .
C          .          .
C      2.00000+ 7 3.00000- 2
C                                (NOTE, BLANK CARD TERMINATES CURVE).
C     JENDL-II                                         27-CO-59 (N,2N)
C      1.07000+ 7 0.00000+ 0
C      1.16000+ 7 1.13000- 3
C          .          .
C          .          .
C      2.00000+ 7 2.80000- 2
C                                (NOTE, BLANK CARD TERMINATES CURVE).
C     ENDL84                                          27-CO-59 (N,2N)
C      1.12000+ 7 0.00000+ 0
C      1.22000+ 7 1.27000- 3
C          .          .
C          .          .
C      2.00000+ 7 2.90000- 2
C                                (NOTE, BLANK CARD TERMINATES CURVE).
C
C     NOTE, FOR IDENTIFICATION ON EACH PLOT THE PROGRAM WILL ONLY READ
C     AND USE THE FIRST 40 CHARACTERS OF THE TITLE. THE USER MAY USE
C     THE REMAINDER OF THE TITLE LINE TO FURTHER PHYSICALLY IDENTIFY
C     THE DATA (AS IN THE ABOVE EXAMPLE WHERE THE DATA IS FURTHER
C     IDENTIFIED AS 27-CO-59 (N,2N)).
C
C     NOTE, THE ABOVE DATA IS FOR ILLUSTRATION PURPOSES ONLY AND DOES
C     NOT CORRESPOND TO THE ACTUAL DATA FROM THESE EVALUATED LIBRARIES.
C
C     POINT DATA (ON I/O UNIT 11)
C     ==================================================================
C     LINE  COLUMNS  FORMAT  DESCRIPTION
C     ------------------------------------------------------------------
C       1     1-26    26A1   TITLE FOR CURVE
C     2-N     1-11   E11.4   X VALUE
C            12-22   E11.4   POSITIVE X UNCERTAINTY
C            23-33   E11.4   NEGATIVE X UNCERTAINTY
C            34-44   E11.4   Y VALUE
C            45-55   E11.4   POSITIVE Y UNCERTAINTY
C            55-66   E11.4   NEGATIVE Y UNCERTAINTY
C
C     EACH SET OF POINTS IS TERMINATED BY BLANK (NOT 0.0). THE SEQUENCE
C     TITLE FOLLOWED BY TABULATED POINTS MAY BE REPEATED ANY NUMBER OF
C     TIMES. THE POINT FILE MAY CONTAIN DATA FOR ANY NUMBER OF SETS
C     AND ANY NUMBER OF DATA POINTS. EACH PLOT MAY CONTAIN UP TO 100000
C     POINTS (IF MORE ARE PRESENT ONLY THE FIRST 100000 WILL BE USED).
C
C     UNCERTAINTIES
C     ------------------------------------------------------------------
C     UNCERTAINTIES MUST BE IN THE SAME UNITS AS THE DATA (E.G., EV OR
C     BARNS). THE UNCERTAINTIES WILL BE INTERPRETED TO DEFINE THE ERROR
C     BARS RELATIVE TO THE DATA POINT. THE ERROR BARS FOR A POINT WILL
C     EXTEND FROM THE POINT MINUS THE NEGATIVE ERROR TO THE POINT PLUS
C     THE POSITIVE ERROR (E.G., 10 BARNS +/- 2 BARNS DEFINES AN ERROR
C     BAR FROM 8 TO 12 BARNS). NEVER TRY TO USE THE UNCERTAINTIES TO
C     DIRECTLY DEFINE THE ERROR BARS (E.G., IN THE ABOVE EXAMPLE YOU
C     CANNOT DEFINE THE UNCERTAINTIES AS 8 AND 12 BARNS). NEVER SPECIFY
C     ERRORS IN PER-CENT (E.G., 10 BARNS +/- 5 PER-CENT WILL BE TREATED
C     AS 10 BARNS +/- 5 BARNS, SINCE THE PROGRAM KNOWS NOTHING ABOUT THE
C     REAL UNITS OF THE DATA).
C
C     THE UNCERTAINTIES CAN BE SYMMETRIC OR NON-SYMMETRIC AND CAN BE
C     GIVEN OR SIMPLY LEFT BLANK (NO UNCERTAINTY GIVEN). NOTE, FOR A
C     SYMMETRIC UNCERTAINTY YOU MUST ENTER BOTH A POSITIVE AND NEGATIVE
C     UNCERTAINTIES.
C
C     IT DOES NOT MATTER WHETHER YOU DEFINE THE UNCERTAINTIES TO BE
C     POSITIVE OR NEGATIVE ON UNIT 11 (YOU CAN USE ANY CONVENTION THAT
C     YOU LIKE). INTERNALLY THE PROGRAM WILL DEFINE ALL UNCERTAINTIES TO
C     BE POSITIVE NUMBERS AND USE THE UNCERTAINTIES TO DEFINE A POSITIVE
C     ERROR BAR (EXTENDING FROM THE POINT TO THE POINT PLUS THE POSITIVE
C     ERROR) AND A NEGATIVE ERROR BAR (EXTENDING FROM THE POINT TO THE
C     POINT MINUS THE NEGATIVE ERROR).
C
C     EXAMPLE  UNIT 11 INPUT
C     ------------------------------------------------------------------
C     IF UNIT 11 CONTAINS THE EXPERIMENTAL MEASURED DATA 27-CO-59 (N,2N)
C     THE DATA COULD LOOK LIKE,
C
C     L.R.VEESER, ET AL. (77)                        27-CO-59 (N,2N)
C      1.10000+ 7 1.10000+ 6 1.10000+ 6 1.10000- 4 2.30000- 4 1.10000- 4
C      1.20000+ 7                       1.20000- 3
C          .          .
C          .          .
C      2.00000+ 7 2.20000+ 6 2.20000+ 6 3.00000- 2
C                                (NOTE, BLANK CARD TERMINATES DATA SET).
C     S.OKAMURA (67)                                27-CO-59 (N,2N)
C      1.07000+ 7 1.07000+ 6 1.07000+ 6 1.30000- 4 3.40000- 4 1.10000- 4
C      1.16000+ 7                       1.40000- 3
C          .          .
C          .          .
C      2.00000+ 7 2.20000+ 6 2.20000+ 6 3.10000- 2
C                                (NOTE, BLANK CARD TERMINATES DATA SET).
C     A.PAULSEN, ET AL (65)                          27-CO-59 (N,2N)
C      1.13000+ 7 1.13000+ 6 1.13000+ 6 1.80000- 4 3.40000- 4 1.10000- 4
C      1.37000+ 7                       2.80000- 3
C          .          .
C          .          .
C      2.00000+ 7 2.20000+ 6 2.20000+ 6 3.30000- 2
C                                (NOTE, BLANK CARD TERMINATES DATA SET).
C          .          .
C          .          .
C     (NOTE, ANY NUMBER OF REFERENCES MAY FOLLOW)
C
C     NOTE, FOR IDENTIFICATION ON EACH PLOT THE PROGRAM WILL ONLY READ
C     AND USE THE FIRST 40 CHARACTERS OF THE TITLE. THE USER MAY USE
C     THE REMAINDER OF THE TITLE LINE TO FURTHER PHYSICALLY IDENTIFY
C     THE DATA (AS IN THE ABOVE EXAMPLE WHERE THE DATA IS FURTHER
C     IDENTIFIED AS 27-CO-59 (N,2N)).
C
C     NOTE, THE ABOVE DATA IS FOR ILLUSTRATION PURPOSES ONLY AND DOES
C     NOT CORRESPOND TO THE ACTUAL DATA FROM THESE REFERENCES.
C
C     REPORTING ERRORS
C     ==================================================================
C     IN ORDER TO IMPROVE THIS CODE AND MAKE FUTURE VERSIONS MORE
C     COMPATIBLE FOR USE ON AS MANY DIFFERENT TYPES OF COMPUTERS AS
C     POSSIBLE PLEASE REPORT ALL COMPILER DIAGNOSTICS AND/OR OPERATING
C     PROBLEMS TO THE AUTHOR AT THE ABOVE ADDRESS.
C
C     PLEASE REMEMBER IF YOU SIMPLY REPORT 'I'VE GOT A PROBLEM' AND DO
C     NOT ADEQUATELY DESCRIBE EXACTLY HOW YOU WERE USING THE PROGRAM
C     IT WILL BE IMPOSSIBLE FOR THE AUTHOR TO HELP YOU. WHEN A PROBLEM
C     ARISES PLEASE WRITE TO THE AUTHOR, DESCRIBE THE PROBLEM IN AS MUCH
C     DETAIL AS POSSIBLE, IDENTIFY THE VERSION OF THE PROGRAM THAT YOU
C     ARE USING (E.G. VERSION 90-1) AND SEND THE FOLLOWING INFORMATION
C     ON MAGNETIC TAPE TO THE AUTHOR,
C
C     (1) A COPY OF THE FORTRAN PROGRAM YOU ARE USING
C     (2) A COPY OF COMPILER DIAGNOSTICS (IF ANY)
C     (3) A COPY OF YOUR JCL AND INPUT OPTIONS (UNIT 2)
C     (4) A COPY OF YOUR CURVE DATA (UNIT 10)
C     (5) A COPY OF YOUR POINT DATA (UNIT 11)
C     (6) A COPY OF SOFTWARE CHARACTER TABLE (UNIT 12)
C     (7) A COPY OF SOFTWARE SYMBOL AND LINE TYPE TABLE (UNIT 14)
C     (8) A COPY OF THE OUTPUT REPORT FROM THE PROGRAM (UNIT 6)
C     (9) A COPY OF THE PLOTS FROM THE PROGRAM
C
C     WITHOUT ALL OF THIS INFORMATION IT IS IMPOSSIBLE TO EXACTLY
C     SIMULATE THE PROBLEM THAT YOU RAN AND TO DETERMINE THE SOURCE
C     OF YOUR PROBLEM.
C
C***** PLOTTER/GRAPHICS TERMINAL INTERFACE *****************************
C
C      PLOTTING
C      --------
C      THIS PROGRAM USES A SIMPLE CALCOMP LIKE INTERFACE INVOLVING
C      ONLY 7 SUBROUTINES,
C
C      STARPLOT              - INITIALIZE PLOTTER
C      NEXTPLOT              - END OF A PLOT - CLEAR SCREEN FOR NEXT
C      ENDPLOTS              - END OF PLOTTING
C
C      PLOT(X,Y,IPEN)        - DRAW OR MOVE FROM LAST LOCATION TO (X,Y),
C                              END OF CURRENT PLOT OR END OF PLOTTING.
C               IPEN         =   2 - DRAW
C                            =   3 - MOVE
C
C      PEN(IPEN)             - SELECT COLOR.
C          IPEN              = COLOR = 1 TO N (N = ANY POSITIVE INTEGER)
C
C      BOXCOLOR(X,Y,IFILL,IBORDER) - FILL A RECTANGLE WITH COLOR
C               X,Y                = DEFINES THE CORNERS OF THE BOX
C                   IFILL          = COLOR TO FILL BOX WITH
C                         IBORDER  = COLOR OF THE BORDER OF THE BOX
C
C     IN ORDER TO INTERFACE THIS PROGRAM FOR USE ON ANY PLOTTER WHICH
C     DOES NOT USE THE ABOVE CONVENTIONS IT IS MERELY NECESSARY FOR THE
C     THE USER TO WRITE 7 SUBROUTINES WITH THE NAMES AND ARGUMENTS
C     DESCRIBED ABOVE AND TO THEN CALL THE LOCAL EQUIVALENT ROUTINES.
C
C     INTERACTION
C     -----------
C     THIS PROGRAM USES 2 SUBROUTINES TO CONTROL INTERACTION,
C
C     INTERACT(MYACTION)           - INDICATE WHETHER OR NOT PROGRAM
C                                    IS IN ITS INTERACTIVE MODE
C              MYACTION            = 0 - NO INTERACTION
C                                  = 1 - INTERACTION
C                                    (MYACTION IS RETURNED BY INTERACT)
C     MOUSEY(IWAY,X,Y,IWAY1,IWAY2) - READ MOUSE AND/OR KEYBOARD
C            IWAY                  = 0      - NO INPUT
C                                  = 1 TO 3 - MOUSE INPUT
C                                  = 4      - KEYBOARD INPUT
C                 X,Y              = COORDINATES FOR MOUSE INPUT
C                     IWAY1        = LOWEST VALUE OF IWAY ALLOWED
C                           IWAY2  = HIGHEST VALUE OF IWAY ALLOWED
C
C     FOR NON-INTERACTIVE INPUT YOUR GRAPHIC INTERFACE SHOULD CONTAIN
C     ROUTINES INTERACT AND MOUSEY. WHEN CALLED INTERACT SHOULD RETURN
C     MYACTION = 0. MOUSEY CAN THEN BE A DUMMY THAT SIMPLY RETURNS.
C
C     AVAILABLE PLOTTER INTERFACES
C     ------------------------------------------------------------------
C     THIS PROGRAM HAS AVAILABLE PLOTTER INTERFACES TO OPERATE AS
C     FOLLOWS,
C     (1) MAINFRAME - HARDCOPY PLOTS IN BLACK AND WHITE.
C     (2) MAINFRAME - SCREEN PLOTS IN 7 COLORS ON IBM GRAPHICS TERMINAL.
C     (3) IBM-PC    - HARDCOPY PLOTS IN 6 COLORS ON A HEWLETT-PACKARD
C                     7475A PLOTTER.
C     (4) IBM-PC    - SCREEN PLOTS IN 16 COLORS - REQUIRES LAHEY
C                     FORTRAN COMPILER.
C     (5) SUN       - HARDCOPY PLOTS IN BLACK AND WHITE.
C     (6) SUN       - SCREEN PLOTS IN BLACK AND WHITE.
C     (7) SUN       - X-WINDOWS SCREEN PLOTS IN 256 COLORS.
C
C     CONTACT THE AUTHOR TO OBTAIN COPIES OF ANY OF THE ABOVE PLOTTER
C     INTERFACES.
C
C     COLOR PLOTS
C     ------------------------------------------------------------------
C     TO SELECT PLOTTING COLORS SUBROUTINE PEN (DESCRIBED ABOVE) IS USED
C     TO SELECT ONE OF THE AVAILABLE COLORS. WHEN RUNNING ON A MAINFRAME
C     USING AN IBM GRAPHICS TERMINAL OR ON AN IBM-PC USING A HEWLETT-
C     PACKARD PLOTTER THE GRAPHICS INTERFACE (DESCRIBED ABOVE) WILL
C     PRODUCE COLOR PLOTS.
C
C     BLACK AND WHITE PLOTS
C     ------------------------------------------------------------------
C     WHEN PRODUCING BLACK AND WHITE HARDCOPY ON A MAINFRAME THE USER
C     SHOULD ADD A DUMMY SUBROUTINE PEN TO THE END OF THE PROGRAM TO
C     IGNORE ATTEMPTS TO CHANGE COLOR. ADD THE FOLLOWING SUBROUTINE,
C
C     SUBROUTINE PEN(IPEN)
C     RETURN
C     END
C
C     SIMILARLY FOR BOXCOLOR,
C
C     SUBROUTINE BOXCOLOR(X,Y,IFILL,IBORDER)
C     RETURN
C     END
C
C     CHARACTER SET
C     ------------------------------------------------------------------
C     THIS PROGRAM USES COMPUTER AND PLOTTER DEVICE INDEPENDENT SOFTWARE
C     CHARACTERS. THIS PROGRAM COMES WITH A FILE THAT DEFINES THE PEN
C     STROKES REQUIRED TO DRAW ALL CHARACTERS ON AN IBM KEYBOARD (UPPER
C     AND LOWER CASE CHARACTERS, NUMBERS, ETC.) PLUS AN ALTERNATE SET OF
C     ALL UPPER AND LOWER CASE GREEK CHARACTERS AND ADDITIONAL SPECIAL
C     SYMBOLS.
C
C     THE SOFTWARE CHARACTER TABLE CONTAINS X AND Y AND PEN POSITIONS TO
C     DRAW EACH CHARACTER. IF YOU WISH TO DRAW ANY ADDITIONAL CHARACTERS
C     OR TO MODIFY THE FONT OF THE EXISTING CHARACTERS YOU NEED ONLY
C     MODIFY THIS TABLE.
C
C     CONTROL CHARACTERS
C     ------------------------------------------------------------------
C     IN THE SOFTWARE CHARACTER TABLE ALL CHARACTERS TO BE PLOTTED WILL
C     HAVE PEN POSITION = 2 (DRAW) OR = 3 (MOVE). IN ADDITION THE TABLE
C     CURRENTLY CONTAINS 4 CONTROL CHARACTERS,
C
C     PEN POSITION = 0
C     ----------------
C     SHIFT THE NEXT PRINTED CHARACTER BY X AND Y. 3 CONTROL CHARACTERS
C     ARE PRESENTLY INCLUDED IN THE SOFTWARE CHARACTER TABLE TO ALLOW
C     SHIFTING.
C
C     {   = SHIFT UP (FOR SUPERSCRIPTS..............X= 0.0, Y= 0.5)
C     }   = SHIFT DOWN (FOR SUBSCRIPTS..............X= 0.0, Y=-0.5)
C     \   = SHIFT LEFT 1 CHARACTER (FOR BACKSPACE...X=-1.0, Y= 0.0)
C
C     PEN POSITION =-1
C     ----------------
C     SELECT THE NEXT PRINTED CHARACTER FROM THE ALTERNATE CHARACTER
C     SET. AT PRESENT THIS CONTROL CHARACTER IS,
C
C     ]   = SWITCH TO ALTERNATE CHARACTER SET
C
C     THESE 4 CONTROL CHARACTERS ARE ONLY DEFINED BY THE VALUE OF THE
C     PEN POSITION IN THE SOFTWARE CHARACTER TABLE (I.E., THEY ARE NOT
C     HARD WIRED INTO THIS PROGRAM). AS SUCH BY MODIFYING THE SOFTWARE
C     CHARACTER TABLE THE USER HAS THE OPTION OF DEFINING ANY CONTROL
C     CHARACTERS TO MEET SPECIFIC NEEDS.
C
C     THESE CHARACTERS MAY BE USED IN CHARACTER STRINGS TO PRODUCE
C     SPECIAL EFFECTS. FOR EXAMPLE, TO PLOT SUBSCRIPT 5, B, SUPERSCRIPT
C     10 USE THE STRING,
C
C     }5B{1{0
C
C     TO PLOT B, SUBSCRIPT 5 AND SUPERSCRIPT 10 WITH THE 5 DIRECTLY
C     BELOW THE 1 OF THE 10 WE CAN USE THE BACKSPACE CHARACTER TO
C     POSITION THE 1 DIRECTLY ABOVE THE 5 USING THE STRING,
C
C     B}5\{1{0
C
C     TO PLOT UPPER CASE GREEK GAMMA FOLLOWED BY THE WORD TOTAL (I.E.,
C     RESONANCE TOTAL WIDTH) USE THE STRING.
C
C     ]G TOTAL
C
C     NOTE, WHEN THESE CONTROL CHARACTERS ARE USED THEY ONLY EFFECT THE
C     NEXT 1 PRINTED CHARACTER (SEE, ABOVE EXAMPLE OF PLOTTING SUPER-
C     SCRIPT 10 WHERE THE SHIFT UP CONTROL CHARACTER WAS USED BEFORE THE
C     1 AND THEN AGAIN BEFORE THE 0 AND THE BACKSPACE AND SHIFT UP
C     CONTROL CHARACTERS WERE USED IN COMBINATION).
C
C     IF THESE 4 CONTROL CHARACTERS ARE NOT AVAILABLE ON YOUR COMPUTER
C     YOU CAN MODIFY THE SOFTWARE CHARACTER TABLE TO USE ANY OTHER 4
C     CHARACTERS THAT YOU DO NOT NORMALLY USE IN CHARACTER STRINGS (FOR
C     DETAILS SEE THE SOFTWARE CHARACTER TABLE).
C
C     STANDARD/ALTERNATE CHARACTER SETS
C     ------------------------------------------------------------------
C     THE SOFTWARE CHARACTER TABLE CONTAINS 2 SETS OF CHARACTERS WHICH
C     ARE A STANDARD SET (ALL CHARACTERS ON AN IBM KEYBOARD) AND AN
C     ALTERNATE SET (UPPER AND LOWER CASE GREEK CHARACTERS AND SPECIAL
C     CHARACTERS). TO DRAW A CHARACTER FROM THE ALTERNATE CHARACTER SET
C     PUT A RIGHT BRACKET CHARACTER (]) BEFORE A CHARACTER (SEE THE
C     ABOVE EXAMPLE AND THE SOFTWARE CHARACTER TABLE FOR DETAILS). THIS
C     CONTROL CHARACTER WILL ONLY EFFECT THE NEXT 1 PLOTTED CHARACTER.
C
C     SUB AND SUPER SCRIPTS
C     ------------------------------------------------------------------
C     TO DRAW SUBSCRIPT PRECEDE A CHARACTER BY }. TO DRAW SUPERSCRIPT
C     PRECEDE A CHARACTER BY { (SEE THE ABOVE EXAMPLE AND THE SOFTWARE
C     CHARACTER TABLE FOR DETAILS). THESE CONTROL CHARACTER WILL ONLY
C     EFFECT THE NEXT 1 PLOTTED CHARACTER.
C
C     BACKSPACING
C     ------------------------------------------------------------------
C     TO BACKSPACE ONE CHARACTER PRECEDE A CHARACTER BY \ (SEE, THE
C     ABOVE EXAMPLE AND THE SOFTWARE CHARACTER TABLE FOR DETAILS). THIS
C     CONTROL CHARACTER WILL PERFORM A TRUE BACKSPACE AND WILL EFFECT
C     ALL FOLLOWING CHARACTERS IN THE SAME CHARACTER STRING.
C
C     PLOT DIMENSIONS
C     ---------------
C     ARE DEFINED BY USER INPUT. INTERNALLY THE PROGRAM WILL CREATE A
C     PLOT IN APPROXIMATELY A4 OR 8-1/2 BY 11 INCH FORMAT. DURING
C     OUTPUT THE PLOT IS TRANSFORMED TO THE UNITS (INCHES, CENTIMETERS,
C     MILLIMETERS, WHATEVER) OF THE PLOTTER BEING USED AND OUTPUT.
C
C     DEFINING THE DIMENSIONS OF YOUR PLOTTER
C     ---------------------------------------
C     WHEN IMPLEMENTING THIS CODE FOR USE ON ANY PLOTTER THE FIRST THING
C     TO DO IS DETERMINE THE PHYSICAL SIZE OF THE PLOT TO SPECIFY ON
C     THE FIRST INPUT LINE. ONCE YOU HAVE DETERMINED THE APPROPRIATE
C     X AND Y DIMENSIONS YOU WILL NEVER HAVE TO CHANGE THEM AGAIN.
C
C     TO DEFINE THE APPROPRIATE DIMENSIONS YOU CAN USE THE FIRST PLOT
C     GENERATED BY THIS CODE. THE FIRST PLOT IS A SIMPLE PLOT MERELY
C     TO IDENTIFY THE CODE AND VERSION, E.G., 90-1. USE THE INPUT
C     PARAMETERS TO TURN ON THE BORDER FOR PLOTS (SEE, DESCRIPTION
C     OF INPUT PARAMETERS ABOVE) - THE BORDER DEFINES THE EXTREME
C     X AND Y LIMITS OF THE PLOTTING AREA. BY CHANGING THE X AND Y
C     PHYSICAL LIMITS THAT YOU SPECIFY ON THE FIRST INPUT LINE YOU
C     WILL BE ABLE TO RAPIDLY POSITION THE PLOT AND DEFINE ITS SIZE
C     FOR YOUR PLOTTER.
C
C     REMEMBER THE BORDER DEFINES THE EXTREME X AND Y LIMITS OF THE
C     PLOT - THERE IS A PLOTTING AREA WHICH IS SURROUNDED BY TITLE
C     INFORMATION AT TOP, BOTTOM AND LEFT OF THE PLOT - THEREFORE
C     YOU MUST TURN ON THE BORDER FOR THE FIRST PLOT AND INSURE
C     THAT THE ENTIRE BORDER APPEARS ON YOUR PLOTTING SURFACE -
C     FAILURE TO FOLLOW THESE INSTRUCTIONS MAY CAUSE YOU TO LOSE
C     A PORTION OF SOME PLOTS, I.E., THEY MAY NOT BE WITHIN THE
C     PHYSICAL LIMITS OF YOUR PLOTTING SURFACE.
C
C***** PLOTTER/GRAPHICS TERMINAL INTERFACE *****************************
C
C     ACKNOWLEDGEMENTS
C     ==================================================================
C     THE AUTHORS ACKNOWLEDGES THE CONTRIBUTION OF JIM SMITH, NUCLEAR
C     DATA SECTION, IAEA, VIENNA, FOR SUGGESTING MANY OF THE OPTIONS
C     WHICH ARE NOW INCORPORATED IN THIS CODE AS WELL AS FOR TESTING
C     THE CODE EXTENSIVELY DURING ITS DEVELOPMENT PHASE.
C
C     THE AUTHOR ACKNOWLEDGES THE CONTRIBUTION OF DAVE RESLER, LAWRENCE
C     LIVERMORE NATIONAL LABORATORY FOR PROVIDING THE GRAPHICS INTERFACE
C     WHICH ALLOWS THIS PROGRAM TO BE USED ON A SUN TERMINAL
C
C=======================================================================
      INCLUDE 'implicit.h'
      INTEGER*4 OUTP
      CHARACTER*1 XLABEL,YLABEL,BLANK,PARENL,PARENR,FIELD,TITLES,TITLEC,
     1 TITLEP,FIELDX,FIELD4,FIELD11(11,4)
      CHARACTER*4 PLANES,PLANEI,GRIDTP,RATIOS,KBORD,RATTYP
      CHARACTER*8 ANSWER,NO,YES,TOP,BOTTOM
      COMMON/UNITS/INP,OUTP,ITAPE1,ITAPE2
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/PLTTOP/TINCHP(2)
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/MULTHT/HTMULT
      COMMON/XYLABC/XLABEL(72),YLABEL(72)
      COMMON/STITLE/TITLES(72,2)
      COMMON/CTITLE/TITLEC(40,30)
      COMMON/PTITLE/TITLEP(40,30)
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/ERRBAR/IXBAR,IYBAR
      COMMON/XYREAL/XREAL(2),YREAL(2)
      COMMON/WAYS/IWAY(2)
      COMMON/PLOTN/NUMPLT
      COMMON/GRIDDY/IMFINE(2)
      COMMON/THICKY/THICK,ITHICK,NTHICK(3)
      COMMON/THINME/IMTHIN
      COMMON/GROUPY/ICURVE,IPOINT
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/FIELDS/FIELD(66)
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
      COMMON/VANCED/ISMALX,ISMALY,NSMALX,NSMALY,ICOMP
      COMMON/EDGE/XYEDGE(2,2)
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/ERRBIG/BIGERR,BIGX
      COMMON/TERPIT/INTERD,INTERR
      COMMON/RATLIM/RATMAX,RATMIN
      COMMON/LEGOFF/NOLEGS
      COMMON/REMAST/MASTER
      COMMON/SHOWPT/MYSHOW
      COMMON/ACTORS/MYACTION
      COMMON/STARTX/XSTART(2),ISTARTX(2),LSTART(2),IWAYD(2),
     1 KNTERD,KNTERR
      INCLUDE 'plottab.h'
      DIMENSION PLANES(3,2),ANSWER(3),GRIDTP(5,6),PLANEI(6,4),
     1 RATTYP(3,8),RATAB(2,10),PARENR(1),PARENL(1),
     2 NUGRID(6),FIELDX(11),FIELD4(4),XYPLST(2,2)
      EQUIVALENCE (FIELDX(8),FIELD4(1))
      DATA FIELDX/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA BLANK/' '/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA PLANES/
     1 ' (Li','near',')   ',
     2 ' (Lo','g)  ','    '/
      DATA ANSWER/'YES     ','YES     ','YES     '/
      DATA NO/' NO     '/
      DATA YES/' YES    '/
      DATA TOP/' Top    '/
      DATA BOTTOM/' Bottom '/
      DATA GRIDTP/
     1 'Tick',' Mar','ks  ','    ','    ',
     2 'Full',' Gri','d (C','oars','e)  ',
     2 'Dash','ed G','rid ','(Coa','rse)',
     3 'Full',' Gri','d (F','ine)','    ',
     4 'Dash','Ed G','rid ','(Fin','e)  ',
     5 'Full','/Das','hed ','    ','    '/
      DATA PLANEI/
     1 'Line','ar  ','    ','    ','    ','    ',
     2 'Log ','    ','    ','    ','    ','    ',
     3 'Line','ar (','0 Ba','se) ','    ','    ',
     4 'Log ','(No ','Inte','rpol','atio','n)  '/
      DATA RATAB/
     1 0.0000,    0.000,
     2 0.0100,  100.000,
     3 0.1000,   10.000,
     4 0.5000,    2.000,        ! 100%
     5 0.9000,    1.100,        ! 10%
     6 0.9500,    1.050,        !  5%
     7 0.9800,    1.020,        !  2%
     8 0.9900,    1.010,        !  1%
     9 0.9990,    1.001,        ! 0.1%
     A 0.0000,    0.000/        ! 0.0
      DATA RATTYP/
     1 '(Gen','eral',')   ',
     2 '(100','00 %','Max)',
     3 '(100','0 % ','Max)',
     4 '(100',' % M','ax) ',
     5 '(10 ','% Ma','x)  ',
     6 '(1 %',' MxX',')   ',
     7 '(0.1',' % M','ax) ',
     8 '    ','    ','    '/
C-----PERMUTATION FROM OLD TO NEW GRID TYPE DEFINITIONS.
      DATA NUGRID/0,2,1,4,5,3/
      DATA IMTHRU/0/
C
C     DEFINE ALL I/O UNITS AND OPTIONALLY DEFINE FILE NAMES.
C
      CALL FILEIO
C-----READ SOFTWARE CHARACTER DEFINITIONS.
      CALL SYMIN
C-----READ SOFTWARE SYMBOLS AND LINE TYPES.
      CALL REFIN
C-----INITIALIZE NUMBER OF PLOTS GENERATED.
      NUMPLT=0
C-----DEFINE OUTER EDGE OF PLOTTING AREA.
      XYEDGE(1,1)=0.0
      XYEDGE(2,1)=13.5
      XYEDGE(1,2)=0.0
      XYEDGE(2,2)=10.24
C-----INITIALIZE END OF DATA FLAGS.
      ICEND=0
      IPEND=0
C-----INITIALIZE CURVE AND SETS OF POINTS COUNTS
      NUMCUR=0
      NUMSET=0
C
C     THE PROGRAM WILL CYCLE BACK TO THIS POINT TO RE-DEFINE
C     GLOBAL PARAMETERS IF THE FIRST LINE OF THE PLOT PARAMETERS
C     IS COMPLETELY BLANK.
C
C-----IDENTIFY PROGRAM.
   10 WRITE(OUTP,530)
C
C     READ ALL INPUT PARAMETERS AS CHARACTERS AND CONVERT TO INTEGERS
C     AND INSURE ALL PARAMETERS ARE LEGAL VALUES.
C
C-----READ DESCRIPTION OF PLOTTER AND FRAME LAYOUT.
      READ(INP,510,END=490,ERR=490) FIELD,FIELD4
      CALL IN9(XYPLOT(1,1),FIELD)
      CALL IN9(XYPLOT(2,1),FIELD(12))
      CALL IN9(XYPLOT(1,2),FIELD(23))
      CALL IN9(XYPLOT(2,2),FIELD(34))
      CALL INTGER(NSMALX,FIELD(45))
      CALL INTGER(NSMALY,FIELD(56))
      CALL IN9(HTMULT,FIELDX)
C
C     RESTRICT CHARACTER SIZE RANGE
C
      IF(HTMULT.LE.0.0)  HTMULT=1.0
c----- 214/4/29 - Restricted 1/2 to 2 (same as ACTION) - was 1/4 to 4
      IF(HTMULT.LT.0.5) HTMULT=0.5
      IF(HTMULT.GT.2.0) HTMULT=2.0
C
C     DEFINE WHETHER OR NOT IN COMPOSITION MODE (IN COMPOSITION MODE
C     THERE WILL NOT BE ADVANCE TO THE NEXT FRAME OR PLOTTING AREA
C     AT THE END OF THE CURRENT PLOT).
C
      ICOMP=0
      IF(NSMALX.LT.0) ICOMP=1
      NSMALX=IABS(NSMALX)
C
C     DETERMINE WHETHER OR NOT TO FLIP X AND Y AXIS.
C
      IFLIP=0
      IF(XYPLOT(2,1).LT.0.0) IFLIP=1
      XYPLOT(2,1)=DABS(XYPLOT(2,1))
C
C     CHECK PLOTTER LAYOUT.
C
      DO 20 I=1,2
      DO    J=1,2
      IF(XYPLOT(I,J).EQ.0.0) XYPLOT(I,J)=XYEDGE(I,J)
      ENDDO
   20 CONTINUE
      IF(NSMALX.LT.1) NSMALX=1
      IF(NSMALY.LT.1) NSMALY=1
      CALL OUT9(XYPLOT(1,1),FIELD11(1,1))
      CALL OUT9(XYPLOT(2,1),FIELD11(1,2))
      CALL OUT9(XYPLOT(1,2),FIELD11(1,3))
      CALL OUT9(XYPLOT(2,2),FIELD11(1,4))
      WRITE(OUTP,540) FIELD11,NSMALX,NSMALY,HTMULT
C
C     DECIDE TO START A NEW PAGE - DO NOT START A NEW PAGE,
C     1) IF IN COMPOSITION MODE.
C     2) IF PAGE LAYOUT IS THE SAME AS PREVIOUSLY.
C
      IF(IMTHRU.EQ.0) GO TO 30
      IF(ICOMP.NE.0) GO TO 30
      IF(XYPLOT(1,1).EQ.XYPLST(1,1).AND.
     1   XYPLOT(2,1).EQ.XYPLST(2,1).AND.
     2   XYPLOT(1,2).EQ.XYPLST(1,2).AND.
     3   XYPLOT(2,2).EQ.XYPLST(2,2).AND.
     4   NSMALX.EQ.KSMALX.AND.NSMALY.EQ.KSMALY) GO TO 40
C-----START A NEW PAGE.
      IMTHRU=0
C-----ADVANCE TO NEXT PAGE IF ANYTHING IS PLOTTED ON CURRENT PAGE.
      IF(ISMALX.NE.1.OR.ISMALY.NE.1) CALL NEXTPLOT
C
C     SAVE PLOT LAYOUT PARAMETERS.
C
   30 XYPLST(1,1)=XYPLOT(1,1)
      XYPLST(2,1)=XYPLOT(2,1)
      XYPLST(1,2)=XYPLOT(1,2)
      XYPLST(2,2)=XYPLOT(2,2)
      KSMALX=NSMALX
      KSMALY=NSMALY
C
C     IF X AND Y AXIS ARE FLIPPED EXCHANGE X AND Y DIMENSIONS.
C
   40 IF(IFLIP.LE.0) GO TO 50
      DD=XYPLOT(1,1)
      XYPLOT(1,1)=XYPLOT(1,2)
      XYPLOT(1,2)=DD
      DD=XYPLOT(2,1)
      XYPLOT(2,1)=XYPLOT(2,2)
      XYPLOT(2,2)=DD
C
C     READ RUN PARAMETERS.
C
   50 READ(INP,510,END=490,ERR=490) FIELD,FIELD4
      CALL INTGER(ICURVE,FIELD(1))
      CALL INTGER(IPOINT,FIELD(12))
      CALL INTGER(NBORD,FIELD(23))
      CALL INTGER(MYGRID,FIELD(34))
      CALL INTGER(MPLOT,FIELD(45))
      CALL INTGER(NTHICK(2),FIELD(56))
      CALL INTGER(MASTER,FIELDX)
      IF(MASTER.LT.0) MASTER=0
c-----2025/10/05 - After END limit data to last values
      if(ICEND.ne.0.and.NUMCUR.gt.IABS(ICURVE)) NUMCUR = IABS(ICURVE)
      if(IPEND.ne.0.and.NUMSET.gt.IABS(IPOINT)) NUMSET = IABS(IPOINT)
C-----INSURE ALL PARAMETERS ARE IN LEGAL RANGE.
      IF(IABS(ICURVE).LE.30) GO TO 60
      IF(ICURVE.GT.0) ICURVE=30
      IF(ICURVE.LT.0) ICURVE=-30
   60 IF(IABS(IPOINT).LE.30) GO TO 70
      IF(IPOINT.GT.0) IPOINT=30
      IF(IPOINT.LT.0) IPOINT=-30
   70 IF(NBORD.NE.0) NBORD=1
      KBORD=NO
      IF(NBORD.EQ.1) KBORD=YES
      IF(MYGRID.LT.0.OR.MYGRID.GT.5) MYGRID=0
C-----PERMUTATION FROM NEW TO OLD GRID TYPES.
      MYGRID=NUGRID(MYGRID+1)
C-----IF CURVES NOT BEING PLOTTED CANNOT PLOT RATIOS.
      IF(ICURVE.EQ.0) MPLOT=0
C-----DEFINE ALLOWABLE RATIO RANGE.
      MRATIO=8
      IF(MPLOT.EQ.0) GO TO 80
      IF(MPLOT.GE.1.AND.MPLOT.LE.9) MRATIO=MPLOT
      RATMIN=RATAB(1,MRATIO)
      RATMAX=RATAB(2,MRATIO)
      MPLOT=1
      RATIOS=YES
      GO TO 90
   80 RATIOS=NO
   90 IMTHIN=0
      IF(NTHICK(2).GE.0) GO TO 100
      IMTHIN=1
      NTHICK(2)=-NTHICK(2)
  100 IF(NTHICK(2).GT.5) NTHICK(2)=5
      NTHICK(1)=0
      NTHICK(3)=2*NTHICK(2)
      ITHICK=NTHICK(2)
C-----DEFINE LINE THICKNESS.
      THICK=0.002
C-----PRINT INTERPRETATION OF PARAMETERS.
      ICURVP=IABS(ICURVE)
      IPOINP=IABS(IPOINT)
      IF(ICURVE.EQ.0) WRITE(OUTP,640)
      IF(ICURVE.GT.0) WRITE(OUTP,650) ICURVE
      IF(ICURVE.LT.0) WRITE(OUTP,660) ICURVP
      IF(IPOINT.EQ.0) WRITE(OUTP,670)
      IF(IPOINT.GT.0) WRITE(OUTP,680) IPOINT
      IF(IPOINT.LT.0) WRITE(OUTP,690) IPOINP
      WRITE(OUTP,700) KBORD,(GRIDTP(I,MYGRID+1),I=1,5),
     1 RATIOS,(RATTYP(I,MRATIO),I=1,3),NTHICK(2)
C
C     IF MASTER CURVE SELECTED IDENTIFY IT.
C
      IF(MASTER.GT.0) WRITE(OUTP,550) MASTER
C-----DEFINE COARSE AND FINE GRIDS.
      IMFINE(1)=0
      IMFINE(2)=0
      IF(MYGRID.LE.2) IMFINE(1)=MYGRID
      IF(MYGRID.EQ.3) IMFINE(1)=1
      IF(MYGRID.GT.3) IMFINE(1)=2
      IF(MYGRID.GT.2) IMFINE(2)=1
      IF(MYGRID.EQ.5) IMFINE(2)=2
C-----TERMINATE IF NEITHER CURVES NOR POINTS REQUESTED.
      IF(ICURVE.EQ.0.AND.IPOINT.EQ.0) GO TO 500
C-----2025/10/01 - Terminte if either repeats and none other remains
      if(ICURVE.lt.0.and.IPEND.ne.0) go to 490
      if(IPOINT.lt.0.and.ICEND.ne.0) go to 490
C-----2025/10/01 - Terminte if either repeats and none other remains
C-----USE MPLOT TO DEFINE NUMBER OF SUB-PLOTS (1=ONLY DATA,2=DATA+RATIO)
      MPLOT=MPLOT+1
      MMPLOT=MPLOT
C
C     READ AND LIST X AND Y AXIS LABELS.
C
      READ(INP,520,END=490,ERR=490) XLABEL,YLABEL
C-----LEFT ADJUST AND DEFINE LENGTH OF X AXIS LABELS AND UNITS.
      CALL LEFTY(XLABEL,IXLAB(1),NXLAB(1),40)
      CALL LEFTY(XLABEL(41),IXLAB(2),NXLAB(2),32)
      IF(IXLAB(2).GT.0) GO TO 110
C-----NO UNITS.
      IXLAB(2)=IXLAB(1)
      NXLAB(2)=NXLAB(1)
      II=IXLAB(1)
      GO TO 120
C-----CONCATENATE LABEL (UNITS).
  110 II=IXLAB(1)
      CALL CONCAT(XLABEL,II,BLANK,1)
      CALL CONCAT(XLABEL,II,PARENL,1)
      CALL CONCAT(XLABEL,II,XLABEL(41),IXLAB(2))
      CALL CONCAT(XLABEL,II,PARENR,1)
      IXLAB(2)=II
      NXLAB(2)=NXLAB(1)+NXLAB(2)+3
  120 WRITE(OUTP,620) (XLABEL(I),I=1,II)
C-----LEFT ADJUST AND DEFINE LENGTH OF Y AXIS LABELS AND UNITS.
      CALL LEFTY(YLABEL,IYLAB(1),NYLAB(1),40)
      CALL LEFTY(YLABEL(41),IYLAB(2),NYLAB(2),32)
      IF(IYLAB(2).GT.0) GO TO 130
C-----NO UNITS.
      IYLAB(2)=IYLAB(1)
      NYLAB(2)=NYLAB(1)
      II=IYLAB(1)
      GO TO 140
C-----CONCATENATE LABEL (UNITS).
  130 II=IYLAB(1)
      CALL CONCAT(YLABEL,II,BLANK,1)
      CALL CONCAT(YLABEL,II,PARENL,1)
      CALL CONCAT(YLABEL,II,YLABEL(41),IYLAB(2))
      CALL CONCAT(YLABEL,II,PARENR,1)
      IYLAB(2)=II
      NYLAB(2)=NYLAB(1)+NYLAB(2)+3
  140 WRITE(OUTP,630) (YLABEL(I),I=1,II)
C-----INITIALIZE PLOTTER.
      CALL SETUP(IMTHRU)
C
C     START EACH PLOT.
C
C-----READ FIRST TITLE LINE AND CHECK FOR BLANK LINE (RE-DEFINE GLOBAL
C-----PARAMETERS).
  150 READ(INP,520,ERR=490,END=490) (TITLES(K,1),K=1,72)
      DO 160 K=1,72
      IF(TITLES(K,1).NE.BLANK) GO TO 170
  160 CONTINUE
C-----LINE IS BLANK. BRANCH BACK TO RE-DEFINE GLOBAL PARAMETERS.
      GO TO 10
C-----READ SECOND TITLE LINE AND PRINT BOTH TITLE LINES.
  170 READ(INP,520,ERR=490,END=490) (TITLES(K,2),K=1,72)
      WRITE(OUTP,720) TITLES
C-----LEFT ADJUST TITLES.
      CALL LEFTY(TITLES(1,1),ITITS(1),NTITS(1),72)
      CALL LEFTY(TITLES(1,2),ITITS(2),NTITS(2),72)
C
C     READ ALL PARAMETERS AS CHARACTERS AND CONVERT TO FLOATING OR FIXED
C     POINT. READ X RANGE (IF ANY), WHEATHER OR NOT X AND Y ERROR BARS
C     WILL BE PLOTTED AND PLANE OF THE PLOT (LINEAR OR LOG).
C
C     X DIMENSION.
C
      READ(INP,510,END=490,ERR=490) FIELD
C-----DEFINE WHETHER OR NOT X RANGE IS REQUESTED.
      DO 180 I=1,11
      IF(FIELD(I).NE.BLANK) GO TO 190
  180 CONTINUE
      XRANGE(1)=0.0
      KWANT(1,1)=0
      GO TO 200
  190 KWANT(1,1)=1
      CALL IN9(XRANGE(1),FIELD(1))
  200 DO 210 I=12,22
      IF(FIELD(I).NE.BLANK) GO TO 220
  210 CONTINUE
      XRANGE(2)=0.0
      KWANT(2,1)=0
      GO TO 230
  220 KWANT(2,1)=1
      CALL IN9(XRANGE(2),FIELD(12))
C-----IF NECESSARY REVERSE X RANGE TO ASCENDING ORDER.
  230 IF(KWANT(1,1).LE.0.OR.KWANT(2,1).LE.0) GO TO 240
      IF(XRANGE(1).LE.XRANGE(2)) GO TO 240
      XRD=XRANGE(1)
      XRANGE(1)=XRANGE(2)
      XRANGE(2)=XRD
      KWD=KWANT(1,1)
      KWANT(1,1)=KWANT(2,1)
      KWANT(2,1)=KWD
  240 CALL INTGER(IXBAR,FIELD(23))
      CALL INTGER(IWANT(1),FIELD(34))
      CALL INTGER(NROUND(1),FIELD(45))
      CALL INTGER(NOLEGS,FIELD(56))
      IF(KWANT(1,1).NE.0.OR.KWANT(2,1).NE.0) GO TO 250
      WRITE(OUTP,750)
      GO TO 260
  250 CALL OUT9(XRANGE(1),FIELD11(1,1))
      CALL OUT9(XRANGE(2),FIELD11(1,2))
      WRITE(OUTP,730) ((FIELD11(kk,I),kk=1,11),I=1,2)
  260 IF(IXBAR.NE.0) IXBAR=1
      ANSWER(1)=YES
      IF(IXBAR.EQ.0) ANSWER(1)=NO
      IF(IWANT(1).LT.-2) IWANT(1)=0
      IF(IWANT(1).GE.0.AND.IWANT(1).NE.1) IWANT(1)=2
      IW1=IWANT(1)
      IF(IWANT(1).EQ.-1) IW1=3
      IF(IWANT(1).EQ.-2) IW1=4
      IF(NROUND(1).LE.0.OR.NROUND(1).GT.3) NROUND(1)=0
      ANSWER(2)=YES
      IF(NROUND(1).EQ.1) ANSWER(2)=NO
      IF(NROUND(1).EQ.2) ANSWER(2)=BOTTOM
      IF(NROUND(1).EQ.3) ANSWER(2)=TOP
      IF(NOLEGS.NE.0) NOLEGS=1
      ANSWER(3)=YES
      IF(NOLEGS.NE.0) ANSWER(3)=NO
      WRITE(OUTP,780) ANSWER(1),(PLANEI(I,IW1),I=1,6),ANSWER(2),
     1 ANSWER(3)
C
C     Y DIMENSION.
C
      READ(INP,510,END=490,ERR=490) FIELD
C-----DEFINE WHETHER OR NOT Y RANGE IS REQUESTED.
      DO 270 I=1,11
      IF(FIELD(I).NE.BLANK) GO TO 280
  270 CONTINUE
      YRANGE(1)=0.0
      KWANT(1,2)=0
      GO TO 290
  280 KWANT(1,2)=1
      CALL IN9(YRANGE(1),FIELD(1))
  290 DO 300 I=12,22
      IF(FIELD(I).NE.BLANK) GO TO 310
  300 CONTINUE
      YRANGE(2)=0.0
      KWANT(2,2)=0
      GO TO 320
  310 KWANT(2,2)=1
      CALL IN9(YRANGE(2),FIELD(12))
C-----IF NECESSARY REVERSE Y RANGE TO ASCENDING ORDER.
  320 IF(KWANT(1,2).LE.0.OR.KWANT(2,2).LE.0) GO TO 330
      IF(YRANGE(1).LE.YRANGE(2)) GO TO 330
      YRD=YRANGE(1)
      YRANGE(1)=YRANGE(2)
      YRANGE(2)=YRD
      KWD=KWANT(1,2)
      KWANT(1,2)=KWANT(2,2)
      KWANT(2,2)=KWD
  330 CALL INTGER(IYBAR,FIELD(23))
      CALL INTGER(IWANT(2),FIELD(34))
      CALL INTGER(NROUND(2),FIELD(45))
      CALL INTGER(MYSHOW,FIELD(56))
      IF(MYSHOW.NE.0) MYSHOW=1
      IF(KWANT(1,2).NE.0.OR.KWANT(2,2).NE.0) GO TO 340
      WRITE(OUTP,760)
      GO TO 350
  340 CALL OUT9(YRANGE(1),FIELD11(1,1))
      CALL OUT9(YRANGE(2),FIELD11(1,2))
      WRITE(OUTP,740) ((FIELD11(kk,I),kk=1,11),I=1,2)
  350 IF(IYBAR.NE.0) IYBAR=1
      ANSWER(1)=YES
      IF(IYBAR.EQ.0) ANSWER(1)=NO
      IF(IWANT(2).LT.-2) IWANT(2)=0
      IF(IWANT(2).GE.0.AND.IWANT(2).NE.1) IWANT(2)=2
      IW2=IWANT(2)
      IF(IWANT(2).EQ.-1) IW2=3
      IF(IWANT(2).EQ.-2) IW2=4
C-----DEFINE INTERPOLATION LAW IF RATIOS ARE CALCULATED.
      INTERD=1
      IF(IWANT(1).EQ.-2) INTERD=3
      IF(IWANT(2).EQ.-2) INTERD=INTERD+1
      INTERR=1
      IF(INTERD.GE.3) INTERR=3
      IF(NROUND(2).LE.0.OR.NROUND(2).GT.3) NROUND(2)=0
      ANSWER(2)=YES
      IF(NROUND(2).EQ.1) ANSWER(2)=NO
      IF(NROUND(2).EQ.2) ANSWER(2)=BOTTOM
      IF(NROUND(2).EQ.3) ANSWER(2)=TOP
      ANSWER(3)=NO
      IF(MYSHOW.NE.0) ANSWER(3)=YES
      WRITE(OUTP,790) ANSWER(1),(PLANEI(I,IW2),I=1,6),ANSWER(2),
     1 ANSWER(3)
C
C     SET COUNTERS AND FLAGS AT END OF DATA FILES.
C
C-----CANNOT READ ANY MORE DATA IF END OF DATA HAS BEEN REACHED.
      IF(ICURVE.GT.0.AND.ICEND.ne.0) ICURVE=0
      IF(IPOINT.GT.0.AND.IPEND.ne.0) IPOINT=0
C-----IF MORE DATA WILL BE READ INITIALIZE CURVE AND SETS OF POINTS
C-----COUNTS.
      IF(ICURVE.GE.0) NUMCUR=0
      IF(IPOINT.GE.0) NUMSET=0
C
C     ALL INPUT PARAMETERS READ. READ ALL CURVES AND/OR POINTS.
C
C-----IF NOT YET END OF DATA READ DATA TABLE FOR CURVE.
      IF(ICEND.EQ.0) CALL GETCUR(ICEND)
C-----IF NOT YET END OF DATA READ DATA TABLE FOR CONTINUOUS POINTS.
      IF(IPEND.EQ.0) CALL GETPNT(IPEND)
C-----TREMINATE IF NO DATA TO PLOT.
      IF(NUMCUR.LE.0.AND.NUMSET.LE.0) GO TO 490
C-----INITIALIZE NUMBER OF SUB-PLOTS.
      MPLOT=MMPLOT
C-----DO NOT PLOT RATIO IF NO CURVES OR ONLY 1 CURVE.
      IF(NUMCUR.EQ.0) GO TO 360
      IF(NUMCUR.NE.1.OR.NUMSET.NE.0) GO TO 370
C-----DEFINE ONLY 1 SUB-PLOT (NO RATIOS).
  360 MPLOT=1
      YSINCH(1,1)=YFINCH(1)
      YSINCH(2,1)=YFINCH(2)
C-----INDICATE FIRST PLOT OF THIS DATA
  370 KSTART=0
C
C     ALL CURVES AND/OR POINTS READ. SCALE DATA AND IF REQUESTED
C     CREATE RATIOS.
C
C-----INITIALIZE BIGGEST DIFFERENCE.
  380 BIGERR=0.0
      BIGX=0.0
C-----DEFINE X AND Y LIMITS OF PLOT.
      CALL SCALXY(IPASS)
C-----SAVE STARTING X LIMITS (FOR INTERACTIVE SHOW ALL)
      IF(KSTART.NE.0) GO TO 390
      XSTART(1)=XLIM(1)
      XSTART(2)=XLIM(2)
C-----NO PLOT IF NO DATA IN REQUESTED X RANGE.
  390 IF(IPASS.EQ.0) GO TO 480
C
C     LOOP OVER DATA AND RATIO (IF ANY) PLOTS.
C
      DO 460 NPLOT=1,MPLOT
C-----DEFINE Y LOCATION OF PLOT ON PAGE.
      YINCHP(1)=YSINCH(1,NPLOT)
      YINCHP(2)=YSINCH(2,NPLOT)
C-----DEFINE X AND Y LIMIT FOR DATA OR RATIO.
      IF(NPLOT.LE.1) GO TO 400
      XLIM(1)=XLIMR(1)
      XLIM(2)=XLIMR(2)
      YLIM(1)=YLIMR(1)
      YLIM(2)=YLIMR(2)
  400 CALL YROUND
C-----ROUND X AND POSITION LEGEND BOX FOR DATA PLOT.
      IF(NPLOT.NE.1) GO TO 410
      CALL XROUND
C-----SAVE DATA X, Y LIN/LOG SCALE
      IWAYD(1)=IWAY(1)
      IWAYD(2)=IWAY(2)
C-----SET INTERPOLATION FLAGS.
      IF(IWAY(1).EQ.IABS(LSTART(1))) IWANT(1)=LSTART(1)
      IF(IWAY(2).EQ.IABS(LSTART(2))) IWANT(2)=LSTART(2)
C-----SAVE ORIGINAL X LIMITS FOR RATIO.
      XLIMR(1)=XLIM(1)
      XLIMR(2)=XLIM(2)
C-----SAVE ORIGINAL X/Y LIN/LOG SCALING
      IF(KSTART.NE.0) GO TO 410
      KSTART=1
      ISTARTX(1)=IWAY(1)
      ISTARTX(2)=IWAY(2)
      LSTART (1)=IWANT(1)
      LSTART (2)=IWANT(2)
      KNTERD=INTERD
      KNTERR=INTERR
C-----SELECT AXIS UNITS.
  410 CALL UNITED
C-----ONLY DESCRIBE DATA (NOT RATIO)
      IF(NPLOT.NE.1) GO TO 450
C-----DESCRIBE RANGE AND SCALING OF PLOT.
      IP=IWAY(1)
      CALL OUT9(XREAL(1),FIELD11(1,1))
      CALL OUT9(XREAL(2),FIELD11(1,2))
      WRITE(OUTP,600) ((FIELD11(kk,I),kk=1,11),I=1,2),
     1 (PLANES(I,IP),I=1,3)
      IP=IWAY(2)
      CALL OUT9(YREAL(1),FIELD11(1,1))
      CALL OUT9(YREAL(2),FIELD11(1,2))
      WRITE(OUTP,610) ((FIELD11(kk,I),kk=1,11),I=1,2),
     1 (PLANES(I,IP),I=1,3)
C-----PRINT TITLES FOR CURVES AND/OR SETS OF POINTS WHICH WILL APPEAR
C-----ON NEXT PLOT.
      IF(NUMCUR.LE.0) GO TO 430
      WRITE(OUTP,560)
      KK=0
      DO 420 K=1,NUMCUR
      IF(IMONC(K).LE.0) GO TO 420
      KK=KK+1
      WRITE(OUTP,570) KK,IMONC(K),(TITLEC(J,K),J=1,40)
  420 CONTINUE
  430 IF(NUMSET.LE.0) GO TO 450
      WRITE(OUTP,580)
      KK=0
      DO 440 K=1,NUMSET
      IF(IMONP(K).LE.0) GO TO 440
      KK=KK+1
      WRITE(OUTP,570) KK,IMONP(K),(TITLEP(J,K),J=1,40)
  440 CONTINUE
C-----PLOT BORDER AND ALL AXIS LABELS.
  450 CALL BORDER
C-----SAVE y RANGE OF DATA (FIRST) PLOT AREA.
      IF(NPLOT.EQ.1) THEN
      TINCHP(1) = YINCHP(1)
      TINCHP(2) = YINCHP(2)
      ENDIF
C-----PLOT X AND Y AXIS GRID
      CALL GRID
C-----PLOT CONTINUOUS CURVE (IF ANY).
      CALL PLTCUR
C-----PLOT DISCRETE POINTS (IF ANY).
      CALL PLTPT
  460 CONTINUE
C
C     IF IN INTERACTIVE MODE CHECK FOR MOUSE OR KEYBOARD INPUT
C
      IF(MYACTION.LE.0) GO TO 470
      CALL ACTION(IMACTIVE)
C-----EITHER NEXT INPUT REQUST OR INTERACTIVE REQUEST.
      IF(IMACTIVE.LE.0) GO TO 470
C-----END OF PLOT. ADVANCE TO NEXT PLOTTING AREA.
      CALL NXTPLT
      GO TO 380
C-----END OF PLOT. ADVANCE TO NEXT PLOTTING AREA.
  470 CALL NXTPLT
      GO TO 150
C-----NO DATA IN REQUESTED X RANGE.
  480 WRITE(OUTP,770)
C-----CONTINUE UNTIL NO MORE DATA.
      GO TO 150
C-----END OF RUN.
  490 WRITE(OUTP,590) NUMPLT
      CALL ENDIT
C
C     NEITHER CURVE NOR DISCRETE POINTS REQUESTED.
C
  500 WRITE(OUTP,710)
      CALL ENDIT
  510 FORMAT(66A1,4A1)
  520 FORMAT(72A1)
  530 FORMAT(1X,72('=')/
     1 ' Plot Tabulated Data (PLOTTAB Version 2025-1)'/1X,72('='))
  540 FORMAT(' Description of Plotter and Frame Layout'/1X,72('-')/
     1       ' X Dimensions (X-Min to X-Max).....',11A1,
     2 ' to ',11A1,' Inches'/
     3       ' Y Dimensions (Y-Min TO Y-Max).....',11A1,
     4 ' to ',11A1,' Inches'/
     5       ' Plots per Frame (X by Y)..........',I12,' by ',I12/
     6       ' Character Size Multiplier.........',F12.3/
     7 1X,72('='))
  550 FORMAT(
     5       ' Master Curve (Thick and Solid)....',I12/
     6 1X,72('='))
  560 FORMAT(1X,72('-')/' Continuous Curves'/1X,72('.')/
     1 ' Index Points Description'/1X,72('.'))
  570 FORMAT(I6,I7,1X,40A1)
  580 FORMAT(1X,72('-')/' Discrete Points'/1X,72('.')/
     1 ' Index Points Description'/1X,72('.'))
  590 FORMAT(1X,72('-')/' End of Run  ',I6,' Plots Generated')
  600 FORMAT(1X,72('-')/
     1       ' X Limits (Plane)..................',11A1,' to ',11A1,3A4)
  610 FORMAT(' Y Limits (Plane)..................',11A1,' to ',11A1,3A4)
  620 FORMAT(1X,72('-')/' X Axis Label and Units............',1X,80A1)
  630 FORMAT(           ' Y Axis Label and Units............',1X,80A1)
  640 FORMAT(' Curves per Plot................... NONE')
  650 FORMAT(' Read and Plot (for Each Plot).....',I5,' Curves')
  660 FORMAT(' Read Once. Allow Multiple Plots...',I5,' Curves')
  670 FORMAT(' Sets of Points per Plot........... NONE')
  680 FORMAT(' Read and Plot (for Each Plot).....',I5,' Sets of Points')
  690 FORMAT(' Read Once. Allow Multiple Plots...',I5,' Sets of Points')
  700 FORMAT(' Should Border be Plotted..........',A4/
     1       ' Type of Grid......................',5A4/
     2       ' Should Ratios be Plotted..........',A4,1X,3A4/
     3       ' Line Thickness....................',I4)
  710 FORMAT(1X,72('-')/' Neither Curve NOR Discrete Points Requested'/
     1 ' Check Your Input Parameters'/
     2 ' Executiob Terminated')
  720 FORMAT(1X,72('-')/' Plot Title'/1X,72('.')/1X,72A1/1X,72A1/
     1 1X,72('-'))
  730 FORMAT(           ' Requested X Range.................',
     1 11A1,' to ',11A1)
  740 FORMAT(1X,72('-')/' Requested Y Range.................',
     1 11A1,' to ',11A1)
  750 FORMAT(           ' Requested X Range.................',
     1 ' Plot All Points')
  760 FORMAT(1X,72('-')/' Requested Y Range.................',
     1 ' Plot All Points')
  770 FORMAT(' No Data in Requested X Range')
  780 FORMAT(' Plot X Error Bars.................',A4/
     1       ' X Plane on Plots (if Possible)....',6A4/
     2       ' Round X Limits....................',A8/
     3       ' Legend Box on Plot................',A4)
  790 FORMAT(' Plot Y Error Bars.................',A4/
     1       ' Y Plane on Plots (if Possible)....',6A4/
     2       ' Round Y Limits....................',A8/
     3       ' Show Data Points..................',A4)
      END
      SUBROUTINE GETCUR(ICEND)
C=================================================================
C
C     READ NEXT TABLE OF DATA FOR CONTINUOUS CURVE.
C
C=================================================================
      INCLUDE 'implicit.h'
      INTEGER*4 OUTP
      CHARACTER*1 TITLEC,FIELD,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE1,ITAPE2
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/CTITLE/TITLEC(40,30)
      COMMON/GROUPY/ICURVE,IPOINT
      COMMON/FIELDS/FIELD(66)
      INCLUDE 'plottab.h'
      DATA BLANK/' '/
c-----2025/9/28 - last NUMCUR
      DATA LSTCURVE/0/
C-----INITIALIZE NUMBER OF CURVES.
      NUMCUR=0
C-----IF END OF FILE READ SET EXTERNAL END OF FILE FLAG AND RETURN.
      IF(ICEND.ne.0) RETURN
      if(ICURVE.lt.0) then     ! repeat curves
      if(LSTCURVE.le.0) RETURN ! no curves loaded
      ICURVE   = -ICURVE
      if(LSTCURVE.lt.ICURVE) ICURVE = LSTCURVE
      NUMCUR   =  ICURVE
      LSTCURVE =  ICURVE
      RETURN
      endif
C-----IF MAXIMUM NUMBER OF DISCRETE POINTS CANNOT PLOT CURVES.
      IF(NUMSET.GE.30) RETURN
C-----DEFINE NUMBER OF SETS OF CURVES TO READ.
      INMAX=IABS(ICURVE)
      KMAX=INMAX
C-----CANNOT HAVE MORE 30 SETS OF POINTS PLUS CURVES.
      IF((KMAX+NUMSET).GT.30) KMAX=30-NUMSET
C-----SET UP LOOP OVER CURVES.
      NREAD=0
      DO 80 NUMCUR=1,KMAX
C-----READ LINE TO IDENTIFY CURVE
      READ(ITAPE1,110,END=90,ERR=90) (TITLEC(I,NUMCUR),I=1,40)
C-----DEFINE LENGTH OF TITLE.
      CALL LEFTY(TITLEC(1,NUMCUR),ITITC(NUMCUR),NTITC(NUMCUR),40)
C-----DEFINE LOWER POINT INDEX. IF NO ROOM LEFT IGNORE CURVE.
      NIN=NREAD+1
      IF(NIN.GT.MAXCUR) GO TO 90
      LIMCUR(1,NUMCUR)=NIN
C-----INITIALIZE FLAG FOR ORDER CHECK.
      KORDER=0
C-----READ POINTS UNTIL BLANK X FIELD FOUND.
      DO 50 N=NIN,MAXCUR
C-----READ AS CHARACTERS AND CONVERT TO FLOATING POINT.
      READ(ITAPE1,110,END=100,ERR=100) (FIELD(I),I=1,22)
C-----TERMINATE ON BLANK X FIELD.
      DO 10 I=1,11
      IF(FIELD(I).NE.BLANK) GO TO 20
   10 CONTINUE
      GO TO 60
   20 CALL IN9(XCURVE(N),FIELD)
      CALL IN9(YCURVE(N),FIELD(12))
C-----IGNORE POINTS UNTIL A CHANGE IS FOUND.
      IF(N.EQ.NIN) GO TO 50
      IF(XCURVE(N).eq.XCURVE(N-1)) go to 50
      IF(XCURVE(N).gt.XCURVE(N-1)) go to 30
      IF(KORDER.lt.0) go to 50
      IF(KORDER.gt.0) go to 40
      KORDER=-1
      GO TO 50
   30 IF(KORDER.lt.0) go to 40
      IF(KORDER.gt.0) go to 50
      KORDER=1
      GO TO 50
   40 KORDER=0
   50 CONTINUE
C-----TOO MANY POINTS. ONLY USE FIRST 1000000 AND TREAT AS END OF DATA.
      N=MAXCUR+1
      GO TO 100
C-----NORMAL END OF CURVE.
   60 N=N-1
      NREAD=N
      LIMCUR(2,NUMCUR)=NREAD
C-----IF DATA IS IN DESCENDING ORDER CHANGE IT TO ASCENDING ORDER.
      IF(KORDER.GE.0) GO TO 80
      KDUM=NREAD
      LDUM=NIN+(NREAD-NIN-1)/2
      DO 70 KD=NIN,LDUM
      XD=XCURVE(KD)
      YD=YCURVE(KD)
      XCURVE(KD)=XCURVE(KDUM)
      YCURVE(KD)=YCURVE(KDUM)
      XCURVE(KDUM)=XD
      YCURVE(KDUM)=YD
      KDUM=KDUM-1
   70 CONTINUE
   80 CONTINUE
c-----------------------------------------------------------------------
C-----NORMAL END OF READ.
c-----------------------------------------------------------------------
      NUMCUR=KMAX
C-----PRINT WARNING IF REQUESTED NUMBER OF CURVES NOT READ.
      IF(KMAX.NE.INMAX) WRITE(OUTP,120) INMAX,KMAX
      go to 105
C-----END OF CURVES WHILE READING CURVE I.D.
   90 NUMCUR  = NUMCUR-1
      ICEND=1
      go to 105
C-----END OF CURVES WHILE READING DATA POINTS.
  100 ICEND=1
      N=N-1
      LIMCUR(2,NUMCUR)=N
      IF(LIMCUR(2,NUMCUR).LE.LIMCUR(1,NUMCUR)) NUMCUR=NUMCUR-1
c-----------------------------------------------------------------------
c     2025/9/28 - always same NUMCUR
c-----------------------------------------------------------------------
  105 LSTCURVE = NUMCUR
      RETURN
  110 FORMAT(72A1)
  120 FORMAT(1X,72('-')/' WARNING...Requested',I3,' Curves.'/
     1                  '           Read Only',I3,' Curves.'/1X,72('-'))
      END
      SUBROUTINE GETPNT(IPEND)
C=================================================================
C
C     READ NEXT TABLE OF DATA FOR DISCRETE POINTS.
C
C=================================================================
      INCLUDE 'implicit.h'
      INTEGER*4 OUTP
      CHARACTER*1 TITLEP,FIELD,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE1,ITAPE2
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/PTITLE/TITLEP(40,30)
      COMMON/GROUPY/ICURVE,IPOINT
      COMMON/FIELDS/FIELD(66)
      INCLUDE 'plottab.h'
      DATA BLANK/' '/
      DATA LSTSET/0/
C-----INITIALIZE NUMBER OF SETS OF POINTS.
      NUMSET=0
C-----IF END OF FILE READ SET EXTERNAL END OF FILE FLAG AND RETURN.
      IF(IPEND.ne.0) RETURN
      if(IPOINT.lt.0) then    ! repeat setrs
      if(LSTSET.le.0) RETURN  ! no sets loaded
      IPOINT  = -IPOINT
      if(LSTSET.le.IPOINT) IPOINT = LSTSET
      NUMSET  = IPOINT
      LSTSET  = IPOINT
      RETURN
      endif
C-----IF MAXIMUM NUMBER OF CURVES CANNOT PLOT DISCRETE POINTS.
      IF(NUMCUR.GE.30) RETURN
C-----DEFINE NUMBER OF SETS OF POINTS TO READ.
      INMAX=IABS(IPOINT)
      KMAX=INMAX
C-----CANNOT HAVE MORE THAN 30 SETS OF POINTS PLUS CURVES.
      IF((KMAX+NUMCUR).GT.30) KMAX=30-NUMCUR
C-----SET UP LOOP OVER POINTS.
      NREAD=0
      DO 50 NUMSET=1,KMAX
C-----READ LINE TO IDENTIFY POINTS
      READ(ITAPE2,80,END=60,ERR=60) (TITLEP(I,NUMSET),I=1,40)
C-----DEFINE LENGTH OF TITLE.
      CALL LEFTY(TITLEP(1,NUMSET),ITITP(NUMSET),NTITP(NUMSET),40)
C-----DEFINE LOWER POINT INDEX. IF NO ROOM LEFT IGNORE POINTS.
      NIN=NREAD+1
      IF(NIN.GT.MAXPT) GO TO 60
      LIMPT(1,NUMSET)=NIN
C-----READ POINTS UNTIL BLANK X FIELD FOUND.
      DO 30 N=NIN,MAXPT
C-----READ AS CHARACTERS AND CONVERT TO FLOATING POINT.
      READ(ITAPE2,80,END=70,ERR=70) FIELD
C-----TERMINATE ON BLANK X FIELD.
      DO 10 I=1,11
      IF(FIELD(I).NE.BLANK) GO TO 20
   10 CONTINUE
      GO TO 40
   20 CALL IN9(XPT(N),FIELD)
      CALL IN9(DXPTP(N),FIELD(12))
      CALL IN9(DXPTM(N),FIELD(23))
      CALL IN9(YPT(N),FIELD(34))
      CALL IN9(DYPTP(N),FIELD(45))
      CALL IN9(DYPTM(N),FIELD(56))
C-----INSURE ERRORS ARE NOT NEGATIVE.
      DXPTM(N)=DABS(DXPTM(N))
      DXPTP(N)=DABS(DXPTP(N))
      DYPTM(N)=DABS(DYPTM(N))
      DYPTP(N)=DABS(DYPTP(N))
c-----2014/4/23 - Allow negative discrete data = previously ignor Y < 0
c-----2014/4/23 - ERROR CAN exceed data = previously < 90% of data
   30 CONTINUE
C-----TOO MANY POINTS. ONLY USE FIRST 1002000 AND TREAT AS END OF DATA.
      N=MAXPT+1
      GO TO 70
C-----NORMAL END OF POINTS.
   40 N=N-1
      NREAD=N
      LIMPT(2,NUMSET)=NREAD
   50 CONTINUE
C-----NORMAL END OF READ.
      NUMSET=KMAX
C-----PRINT WARNING IF REQUESTED NUMBER OF SETS NOT READ.
      IF(KMAX.NE.INMAX) WRITE(OUTP,90) INMAX,KMAX
      GO TO 75
C-----END OF POINTS WHILE READING POINT I.D.
   60 NUMSET=NUMSET-1
      IPEND=1
      GO TO 75
C-----END OF POINTS WHILE READING DATA POINTS.
   70 IPEND=1
      GO TO 75
      LIMPT(2,NUMSET)=N
      IF(LIMPT(2,NUMSET).LT.LIMPT(1,NUMSET)) NUMSET=NUMSET-1
c-----------------------------------------------------------------------
c     COMMON RETURN
c-----------------------------------------------------------------------
   75 LSTSET = NUMSET
      RETURN
   80 FORMAT(72A1)
   90 FORMAT(1X,72('-')/' WARNING...Requested',I3,' Sets.'/
     1                  '           Read Only',I3,' Sets.'/1X,72('-'))
      END
      SUBROUTINE SETUP(IMTHRU)
C=================================================================
C
C     DEFINE ALL PLOTTER PARAMETERS AND INITIALIZE PLOTTER.
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 VERSES
      CHARACTER*40 VERSE40
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
      COMMON/LOGTAB/TABLOG(10)
      COMMON/VANCED/ISMALX,ISMALY,NSMALX,NSMALY,ICOMP
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
      COMMON/THICKY/THICK,ITHICK,NTHICK(3)
      COMMON/EDGE/XYEDGE(2,2)
      COMMON/XYOFF/XOFF,YOFF,XSCALE,YSCALE,XSIZEP,YSIZEP
      COMMON/SIZEHT/HTSIZE
      COMMON/MULTHT/HTMULT
      COMMON/ACTORS/MYACTION
      DIMENSION VERSES(40,14),VERSE40(14),NVERSE(14),BOXZX(2),BOXZY(2)
      EQUIVALENCE (VERSE40(1),VERSES(1,1))
C-----DEFINE IDENTIFICATION FOR PROGRAM AND VERSION BY,
C-----(1) KVERSE - NUMBER OF LINES IN I.D.
C-----(2) NVERSE - NUMBER OF CHARACTERS IN EACH LINE OF I.D.
C-----(3) VERSES - CHARACTERS FOR I.D.
      DATA KVERSE/14/
      DATA NVERSE/15,16, 2,17,29,17,15,19, 6,18,31,31, 1,28/
c       1234567890123456789012345678901234567890
      DATA VERSE40/
     1 'Program PLOTTAB                         ',     ! 15
     2 '(Version 2025-1)                        ',     ! 16
     3 'by                                      ',     !  2
     4 'Dermott E. Cullen                       ',     ! 17
     5 '(Present Contact Information)           ',     ! 29
     6 'Dermott E. Cullen                       ',     ! 17
     7 '1466 Hudson Way                         ',     ! 15
     8 'Livermore, CA 94550                     ',     ! 19
     9 'U.S.A.                                  ',     !  6
     A 'Tele: 925-321-4177                      ',     ! 18
     1 'E. Mail: redcullen1@comcast.net         ',     ! 31
     2 'Web:redcullen1.net/HOMEPAGE.NEW         ',     ! 31
     3 '                                        ',     !  1
     4 'Press Any MOUSE Key to Start            '/     ! 28
c       1234567890123456789012345678901234567890
C-----ONLY ALLOW PLOTTER TO BE INITIALIZED ONCE.
      DATA IPASS/0/
C-----DEFINE HEIGHT AND WIDTH OF CHARACTERS FOR PROGRAM I.D.
      DATA HTV/0.28/
C-----COUNT TIMES THROUGH THIS ROUTINE TO INITIALIZE PLOTTER AND
C-----PLOT PROGRAM I.D. ONLY ONCE.
      IPASS=IPASS+1
C
C     INITIALIZE PLOTTER - ONLY ONCE.
C
      IF(IPASS.NE.1) GO TO 10
      CALL STARPLOT
      CALL INTERACT(MYACTION)
C-----IF IN INTERACTIVE MODE LEAVE ROOM AT TOP FOR OPTIONS.
   10 IF(MYACTION.LE.0) GO TO 20
C-----DEFINE OPTION BOXES AND CHANGE Y PLOT DIMENSION TO LEAVE
C-----ROOM FOR OPTIONS AT TOP OF PLOT.
      CALL SETMOUSE
C-----DEFINE SCALING FACTORS.
   20 DX=XYPLOT(2,1)-XYPLOT(1,1)
      DY=XYPLOT(2,2)-XYPLOT(1,2)
      XSIZEP=DX/FLOAT(NSMALX)
      IF(IFLIP.NE.0) XSIZEP=-XSIZEP
      YSIZEP=DY/FLOAT(NSMALY)
      XSCALE=XSIZEP/XYEDGE(2,1)
      YSCALE=YSIZEP/XYEDGE(2,2)
C-----FOR NEW PAGE INITIALIZE SUBPLOT INDICES.
      IF(IMTHRU.NE.0) GO TO 50
      IF(IPASS.GT.1) GO TO 30
C-----FIRST TIME THROUGH SET UP FOR LAST SUBPLOT FOR PROGRAM I.D.
      ISMALX=NSMALX
      ISMALY=NSMALY
      XOFF=XYPLOT(1,1)
      IF(IFLIP.NE.0) XOFF=XYPLOT(2,1)
      YOFF=XYPLOT(1,2)
      GO TO 40
C-----AFTER FIRST TIME THROUGH SET UP FOR FIRST SUBPLOT.
   30 ISMALX=1
      ISMALY=1
      XOFF=XYPLOT(1,1)
      IF(IFLIP.NE.0) XOFF=XYPLOT(2,1)
      YOFF=XYPLOT(2,2)-YSIZEP
   40 IMTHRU=1
C-----DEFINE CHARACTER HEIGHT AND BOX SIZE (FOR POINTS).
   50 HT=0.10*HTMULT
      BOX=0.10*HTMULT
C-----DEFINE STANDARD HEIGHT FOR LINE THICKNESS SELECTION.
      HTSIZE=HT
      XINCHP(1)=XYEDGE(1,1)+11.0*HT
      XINCHP(2)=XYEDGE(2,1)-5.0*HT
      YFINCH(1)=XYEDGE(1,2)+6.0*HT
      YFINCH(2)=XYEDGE(2,2)-5.5*HT
C-----DEFINE SUB-PLOT AREA (ONLY DATA OR DATA+RATIOS)
      IF(MPLOT.EQ.1) GO TO 60
C-----DATA AND RATIOS.
      DYINCH=YFINCH(2)-YFINCH(1)
      YSINCH(2,1)=YFINCH(2)
      YSINCH(1,1)=YFINCH(2)-2.0*DYINCH/3.0
      YSINCH(2,2)=YSINCH(1,1)
      YSINCH(1,2)=YFINCH(1)
      GO TO 70
C-----ONLY DATA.
   60 YSINCH(1,1)=YFINCH(1)
      YSINCH(2,1)=YFINCH(2)
C-----DEFINE ALL BOX AND CHARACTER HEIGHTS AND WIDTHS (ALL SCALED TO
C-----BOX AND HT DEFINED ABOVE).
   70 WT=HT
      BOX2=BOX/2.0
      HT34=3.0*HT/4.0
      WTH=WT/2.0
      WT38=3.0*WT/8.0
C-----CONSTRUCT ONE DECADE OF TABLE OF LOGS (FOR AXIS LABELS).
      DO 80 I=1,10
      XL=I
      TABLOG(I)=DLOG10(XL)
   80 CONTINUE
C
C     IDENTIFY PROGRAM AND INSTALLATION ONLY THE FIRST TIME THIS
C     ROUTINE IS CALLED.
C
      IF(IPASS.NE.1) RETURN
C
C     FIRST TIME THROUGH - PLOT ID.
C
      CALL PEN(2)
C-----IF REQUESTED DRAW BORDER AROUND PLOT.
      IF(NBORD.LE.0) GO TO 90
      ITHICK=NTHICK(3)
      CALL PLOT1(XYEDGE(1,1),XYEDGE(1,2),3)
      CALL PLOT1(XYEDGE(1,1),XYEDGE(2,2),2)
      CALL PLOT1(XYEDGE(2,1),XYEDGE(2,2),2)
      CALL PLOT1(XYEDGE(2,1),XYEDGE(1,2),2)
      CALL PLOT1(XYEDGE(1,1),XYEDGE(1,2),2)
      ITHICK=NTHICK(2)
   90 Y=0.5*(XYEDGE(1,2)+XYEDGE(2,2)+HTV*FLOAT(KVERSE)+
     1 0.75*HTV*FLOAT(KVERSE-1))
      XMID=0.5*(XYEDGE(1,1)+XYEDGE(2,1))
C-----OUTLINE ID.
      LL=NVERSE(1)
      DO 100 L=1,KVERSE
      IF(NVERSE(L).GT.LL) LL=NVERSE(L)
  100 CONTINUE
      XLL=LL
      BOXZX(1)=XMID-HTV*(0.5*XLL+2.0)
      BOXZX(2)=XMID+HTV*(0.5*XLL+3.0)
      BOXZY(1)=Y-(1.75*FLOAT(KVERSE-1)+2.0)*HTV
      BOXZY(2)=Y+3.0*HTV
      CALL COLORBOX(BOXZX(1),BOXZY(1),0,2)
C-----PLOT ID.
      CALL PEN(2)
      DO 110 L=1,KVERSE
      X=XMID-0.5*FLOAT(NVERSE(L))*HTV
      CALL SYMBL1(X,Y,HTV,VERSES(1,L),0.0D+0,NVERSE(L))
      Y=Y-1.75*HTV
  110 CONTINUE
C
C     ADVANCE TO NEXT PLOTTING AREA (INSURE COMPOSIION FLAG IS OFF AND
C     THEN RESTORE).
C
      KCOMP=ICOMP
      ICOMP=0
      CALL NXTPLT
      ICOMP=KCOMP
      RETURN
      END
      SUBROUTINE NXTPLT
C=================================================================
C
C     ADVANCE TO NEXT PLOTTING AREA. THERE CAN BE ANY NUMBER OF PLOTS
C     IN X AND/OR Y DIRECTION.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/PLOTN/NUMPLT
      COMMON/XYOFF/XOFF,YOFF,XSCALE,YSCALE,XSIZEP,YSIZEP
      COMMON/VANCED/ISMALX,ISMALY,NSMALX,NSMALY,ICOMP
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
C-----INCREMENT PLOT COUNT.
      NUMPLT=NUMPLT+1
C-----NOTHING TO DO IF COMPOSING A FRAME.
      IF(ICOMP.NE.0) RETURN
C-----IF FRAME IS FULL ADVANCE TO NEXT FRAME.
      IF(ISMALX.LT.NSMALX.OR.ISMALY.LT.NSMALY) GO TO 10
      CALL NEXTPLOT
C-----INCREMENT INDEX IN X DIRECTION. RESET X POSITION WHEN X DIRECTION
C-----IS FULL.
   10 ISMALX=ISMALX+1
      XOFF=XOFF+XSIZEP
      IF(ISMALX.LE.NSMALX) GO TO 20
C-----X DIRECTION IS FULL. RESET X INDEX AND POSITION. INCREMENT INDEX
C-----IN Y DIRECTION. WHEN Y DIRECTION IS FULL FRAME IS COMPLETE.
      ISMALX=1
      XOFF=XYPLOT(1,1)
      IF(IFLIP.NE.0) XOFF=XYPLOT(2,1)
      ISMALY=ISMALY+1
      YOFF=YOFF-YSIZEP
      IF(ISMALY.LE.NSMALY) GO TO 20
      ISMALY=1
      YOFF=XYPLOT(2,2)-YSIZEP
C-----DEFINE SUB-PLOT AREAS (ONLY DATA OR DATA+RATIOS)
   20 IF(MPLOT.EQ.1) GO TO 30
C-----DATA AND RATIOS.
      DYFINCH=YFINCH(2)-YFINCH(1)
      YSINCH(2,1)=YFINCH(2)
      YSINCH(1,1)=YFINCH(2)-2.0*DYFINCH/3.0
      YSINCH(2,2)=YSINCH(1,1)
      YSINCH(1,2)=YFINCH(1)
      GO TO 40
C-----ONLY DATA.
   30 YSINCH(1,1)=YFINCH(1)
      YSINCH(2,1)=YFINCH(2)
   40 RETURN
      END
      SUBROUTINE BOXSIZ
C=================================================================
C
C     DEFINE SIZE AND POSITION OF LEGEND BOX.
C
C     RIGHT3 = X POSITION OF START OF LEGEND BOX
C     RIGHT4 = X POSITION OF END OF LEGEND BOX
C     RIGHT5 = X POSITION OF REFERENCE TITLE
C     RIGHT6 = X POSITION OF START DASH TO IDENTIFY REFERENCE
C     RIGHT7 = X POSITION OF START OF BOX TO IDENTIFY REFERENCE
C     RIGHT8 = X POSITION OF END OF BOX TO IDENTIFY REFERENCE
C     RIGHT9 = X POSITION OF END DASH TO IDENTIFY REFERENCE
C
C     2014/5/2 - Some interactive input options can change
C                the size of the Legend Box - to account for
C                a loop hs been added to insure the Legend
C                box is within the plotting area.
C
C=================================================================
      INCLUDE 'implicit.h'
      INCLUDE 'plottab.h'
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
      COMMON/SPOTS/TOP2,TOP3,BOT1,BOT2,BOT3,XLEFT1,XLEFT2,RIGHT3,
     1 RIGHT4,RIGHT5,RIGHT6,RIGHT7,RIGHT8,RIGHT9
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/NEEDED/YNEEDS(3)
      COMMON/TITMAX/MAXTIT
C
C     Loop to insure Legend is on PLOT area
C
      XSHIFT = 0.0d+0
      YSHIFT = 0.0d+0
      DO 30 LOOP=1,2
C-----SELECT MAXIMUM LEGEND BOX WIDTH FOR COMBINATIONS OF CURVES,
C-----POINTS AND RATIO DIFFERENCE MESSAGE.
      OFF1=0.0
      OFF2=0.0
      OFF3=0.0
      OFFT=FLOAT(MAXTIT+2)*WT
      IF(JMONC.GT.0) OFF1=6.0*WT+OFFT
      IF(JMONP.GT.0) OFF2=WT+BOX+OFFT
      IF(MPLOT.GT.1) OFF3=20.0*WT
      IF(OFF2.GT.OFF1) OFF1=OFF2
      IF(OFF3.GT.OFF1) OFF1=OFF3
C-----DEFINE MAXIMUM AND MININUM LIMITS OF BOX.
      RIGHT4=BOXMAX
      RIGHT3=RIGHT4-OFF1
C-----IF CURVES DEFINE POSITION OF START AND END OF DASH TO IDENTIFY
C-----CURVES.
      IF(JMONC.LE.0) GO TO 10
C-----START AND END OF DASH TO IDENTIFY CURVES.
      RIGHT6=RIGHT3+WT
      RIGHT9=RIGHT3+6.0*WT
C-----START AND END OF SYMBOL TO IDENTIFY SET OF POINTS.
      RIGHT8=RIGHT9
      RIGHT7=RIGHT8-BOX
C-----START OF REFERENCE.
      RIGHT5=RIGHT9+WT
      GO TO 20
C-----DEFINE START AND END OF SYMBOL TO IDENTIFY SET OF POINTS.
   10 RIGHT7=RIGHT3+WT
      RIGHT8=RIGHT7+BOX
C-----DEFINE START OF REFERENCE.
      RIGHT5=RIGHT8+WT
   20 BOXMIN=RIGHT3
C-----DEFINE BOTTOM OF LEGEND BOX AND POSITION TO START CURVE, SETS
C-----OF POINTS AND RATIO MESSAGES.
      YNEED=BOYMAX
      YNEEDS(1)=YNEED-1.75*HT
      YNEED=YNEED-1.75*FLOAT(JMONC)*HT
      YNEEDS(2)=YNEED-1.75*HT
      YNEED=YNEED-1.75*FLOAT(JMONP)*HT
      YNEEDS(3)=YNEED-1.75*HT
C-----DEFINE POSITION OF THE BOTTOM OF THE LEGEND BOX.
      BOYMIN=YNEED-HT
C-----IF RATIO PLOTTED LEAVE ROOM IN LEGEND BOX FOR MESSAGE.
      IF(MPLOT.GT.1.AND.NUMCUR.GT.1) BOYMIN=BOYMIN-5.25*HT
      DXBOX = BOXMAX - BOXMIN
      DYBOX = BOYMAX - BOYMIN
c
c     Insure Legend is on plot area.
c
      if(LOOP.eq.2) go to 30
c-----X min
      if(BOXMIN.lt.XINCHP(1)) then
      XSHIFT = XINCHP(1) - BOXMIN
      BOXMIN = XINCHP(1)
      BOXMAX = BOXMAX + XSHIFT
      endif
c-----X max
      if(BOXMAX.gt.XINCHP(2)) then
      XSHIFT = XINCHP(2) - BOXMAX
      BOXMAX = XINCHP(2)
      BOXMIN = BOXMIN + XSHIFT
      endif
c-----Y min
      if(BOYMIN.lt.YINCHP(1)) then
      YSHIFT = YINCHP(1) - BOYMIN
      BOYMIN = YINCHP(1)
      BOYMAX = BOYMAX + YSHIFT
      endif
c-----Y max
      if(BOYMAX.gt.YINCHP(2)) then
      YSHIFT = YINCHP(2) - BOYMAX
      BOYMAX = YINCHP(2)
      BOYMIN = BOYMIN + YSHIFT
      endif
c-----end of LOOP
   30 continue
      RETURN
      END
      SUBROUTINE SCALXY(IPASS)
C=================================================================
C
C     DEFINE X AND Y LIMITS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/ERRBAR/IXBAR,IYBAR
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/TITMAX/MAXTIT
      COMMON/TERPIT/INTERD,INTERR
      COMMON/CNEXT/NEXTC,ISTAR1,IEND1,JSTAR1,KSTAR1,MSTAR1
      INCLUDE 'plottab.h'
C-----DEFINE INDICES TO FIRST CURVE.
      ISTAR1=LIMCUR(1,1)
      IEND1=LIMCUR(2,1)
C
C     SCALE FOR CONTINUOUS CURVE (IF ANY).
C
C-----INITIALIZE FLAG TO SHOW IF ANY DATA IN REQUESTED ENERGY DATA.
      IPASS=0
      KPASS=0
C-----INITIALIZE MAXIMUM NUMBER OF PLOTTED CHARACTERS IN LEGEND BOX.
      MAXTIT=0
C-----INITIALIZE NUMBER OF CURVES ON NEXT PLOT.
      JMONC=0
C-----SKIP THIS SECTION IF NO CURVES.
      IF(NUMCUR.LE.0) GO TO 120
C-----DEFINE INDEX TO NEXT AVAILABLE CURVE CORE LOCATION.
      NEXTC=LIMCUR(2,NUMCUR)+1
C
C     IF USING RATIOS DEFINE INDEX TO FIRST POINT OF FIRST CURVE IN
C     X RANGE OF PLOT.
C
      DO 10 KSTAR1=ISTAR1,IEND1
      IF(KWANT(1,1).le.0) go to 20
      IF(XCURVE(KSTAR1).ge.XRANGE(1)) go to 20
   10 CONTINUE
      KSTAR1=IEND1+1
C
C     LOOP OVER CURVES.
C
C-----INITIALIZE ALL POINT COUNTS.
   20 DO 30 K=1,60
      IMONC(K)=0
   30 CONTINUE
      DO 110 KCURVE=1,NUMCUR
C-----DEFINE INDICES TO CURRENT CURVE.
      IPT1=LIMCUR(1,KCURVE)
      IPT2=LIMCUR(2,KCURVE)
C-----INITIALIZE INDEX TO START OF FIRST CURVE.
      JSTAR1=KSTAR1
      MSTAR1=KSTAR1
C-----INITIALIZE FLAG TO SHOW CURVE NOT YET IN ENERGY RANGE.
      IPICK=0
      DO 90 IPT=IPT1,IPT2
C-----DEFINE NEXT POINT.
      XS=XCURVE(IPT)
      YS=YCURVE(IPT)
C
C     SKIP ALL TESTS IF ALL DATA WILL BE PLOTTED.
C
      IF(KWANT(1,1).LE.0.AND.KWANT(2,1).LE.0) GO TO 70
C
C     ONLY SELECT POINTS IN REQUESTED X RANGE.
C
c-----Skip below X range - but keep for interpolation.
      IF(KWANT(1,1).gt.0.and.XS.lt.XRANGE(1)) go to 80
C-----Use in X range.
      IF(KWANT(2,1).le.0.or.XS.lt.XRANGE(2)) go to 40
C-----POINT IS ABOVE UPPER X LIMIT. IF FIRST POINT SKIP CURVE. OTHERWISE
C-----USE POINT.
      IF(IPT.le.IPT1) go to 110
      go to 50
C-----POINT IS IN REQUESTED X RANGE. IF THIS IS THE FIRST POINT USE IT.
   40 IF(IPT.EQ.IPT1) GO TO 70
C-----THIS IS NOT FIRST POINT. IF IT IS FIRST POINT IN X RANGE
C-----INTERPOLATE TO LOWER X LIMIT. OTHERWISE USE IT.
   50 IF(IPICK.GT.0) GO TO 60
C
C     INTERPOLATE TO LOWER BOUNDARY.
C
      YS=TERPUP(XRANGE(1),XS,XLASTK,YS,YLASTK,INTERD)
      XS=XRANGE(1)
C-----UPDATE X-Y LIMITS.
      CALL RANGEC(XS,YS,KCURVE,IPASS,KPASS,IPICK,IPT)
C-----RESET VALUES.
      XS=XCURVE(IPT)
      YS=YCURVE(IPT)
C
C     INTERPOLATE TO UPPER BOUNDARY WHEN FIRST POINT OUT OF RANGE.
C
   60 IF(KWANT(2,1).LE.0) GO TO 70
      IF(XS.le.XRANGE(2)) go to 70
C-----INTERPOLATE TO UPPER BOUNDARY (SET INTERPOLATION FLAG).
      YS=TERPUP(XRANGE(2),XS,XLASTK,YS,YLASTK,INTERD)
      XS=XRANGE(2)
C-----UPDATE X-Y LIMITS.
      CALL RANGEC(XS,YS,KCURVE,IPASS,KPASS,IPICK,IPT)
C-----UPPER X LIMIT REACHED. END OF CURVE.
      GO TO 100
C
C     POINT IS WITHIN X RANGE OF PLOT.
C
C-----UPDATE X-Y LIMITS.
   70 CALL RANGEC(XS,YS,KCURVE,IPASS,KPASS,IPICK,IPT)
C-----SAVE LAST X, Y FOR INTERPOLATION.
   80 XLASTK=XS
      YLASTK=YS
   90 CONTINUE
  100 IF(IMONC(KCURVE).LE.0) GO TO 110
C-----INCREMENT COUNT OF CURVES ON NEXT PLOT AND INCREMENT MAXIMUM
C-----NUMBER OF CHARACTERS IN LEGEND BOX.
      JMONC=JMONC+1
      IF(NTITC(KCURVE).GT.MAXTIT) MAXTIT=NTITC(KCURVE)
  110 CONTINUE
C
C     SCALE FOR DISCRETE POINTS (IF ANY).
C
C-----INITIALIZE NUMBER OF SETS OF POINTS ON NEXT PLOT.
  120 JMONP=0
      IF(NUMSET.LE.0) GO TO 230
C-----INITIALIZE ALL POINT COUNTS.
      DO 130 K=1,60
      IMONP(K)=0
  130 CONTINUE
C-----DEFINE INDEX TO NEXT AVAILABLE CURVE CORE LOCATION.
      NEXTP=LIMPT(2,NUMSET)+1
      DO 220 K=1,NUMSET
      I1=LIMPT(1,K)
      I2=LIMPT(2,K)
C-----INITIALIZE INDEX TO START OF FIRST CURVE.
      JSTAR1=KSTAR1
      MSTAR1=KSTAR1
C-----DEFINE INDEX TO RATIO.
      KRAT=NUMSET+K
      LIMPT(1,KRAT)=NEXTP
      LIMPT(2,KRAT)=NEXTP
      DO 210 I=I1,I2
C-----DEFINE NEXT POINT.
      XNOW=XPT(I)
      YNOW=YPT(I)
C-----ONLY SELECT POINTS IN X AND Y RANGE.
      IF(KWANT(1,1).GT.0.AND.XNOW.LT.XRANGE(1)) GO TO 210
      IF(KWANT(2,1).GT.0.AND.XNOW.GT.XRANGE(2)) GO TO 210
      IF(KWANT(1,2).GT.0.AND.YNOW.LT.YRANGE(1)) GO TO 210
      IF(KWANT(2,2).GT.0.AND.YNOW.GT.YRANGE(2)) GO TO 210
      IMONP(K)=IMONP(K)+1
C-----DEFINE LIMITS (IGNORE ERROR BARS IF NOT REQUESTED).
      IF(IXBAR.NE.0) GO TO 140
      XNOWM=XNOW
      XNOWP=XNOW
      GO TO 150
C-----LIMIT SCALING FOR ERROR BARS
c-----2014/4/28 - NO LIMITS ON ERROR BARS
  140 DXMMM = DXPTM(I)
      DXPPP = DXPTP(I)
      XNOWM=XNOW-DXMMM
      XNOWP=XNOW+DXPPP
  150 IF(IYBAR.NE.0) GO TO 160
      YNOWM=YNOW
      YNOWP=YNOW
      GO TO 170
C-----LIMIT SCALING FOR ERROR BARS
c-----2014/4/23 - Scaling no longer limited
  160 DYMMM = DYPTM(I)
      DYPPP = DYPTP(I)
      YNOWM=YNOW-DYMMM
      YNOWP=YNOW+DYPPP
c-----20143/4/28 - if FORCED log range, ignore non-positive.
  170 if(IABS(IWANT(1)).eq.2.and.XNOWM.le.0.0d+0) go to 190
      if(IABS(IWANT(2)).eq.2.and.YNOWM.le.0.0d+0) go to 190
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
      IF(IPASS.GT.0) GO TO 180
C-----INITIALIZE LIMITS.
      IPASS=1
      XLIM(1)=XNOWM
      XLIM(2)=XNOWP
      YLIM(1)=YNOWM
      YLIM(2)=YNOWP
      GO TO 190
C-----UPDATE RANGE.
  180 IF(XNOWM.LT.XLIM(1)) XLIM(1)=XNOWM
      IF(XNOWP.GT.XLIM(2)) XLIM(2)=XNOWP
      IF(YNOWM.LT.YLIM(1)) YLIM(1)=YNOWM
      IF(YNOWP.GT.YLIM(2)) YLIM(2)=YNOWP
C
C     IF USING RATIOS DEFINE THEM NOW.
C
  190 IF(MPLOT.LT.2.OR.NEXTP.GT.MAXPT) GO TO 210
C-----DEFINE VALUE OF STANDARD CURVE AT XNOW
      CALL CURVED(XNOW,CURVE1,IMOK)
c-----Skip ratios outside Y range of plot.
      if(CURVE1.lt.YLIM(1)) go to 210
      if(CURVE1.gt.YLIM(2)) go to 210
C-----CANNOT DEFINE RATIO IF NO STANDARD CURVE IN THIS X RANGE OR
C-----STANDARD IS ZERO.
      IF(IMOK.LE.0.OR.CURVE1.EQ.0.0) GO TO 210
C-----DEFINE NEXT RATIO POINT (SAME X VALUES, Y VALUES RATIO TO
C-----STANDARD).
      XPT(NEXTP)=XPT(I)
      DXPTP(NEXTP)=DXPTP(I)
      DXPTM(NEXTP)=DXPTM(I)
      YPT(NEXTP)=YPT(I)/CURVE1
      DYPTP(NEXTP)=DYPTP(I)/CURVE1
      DYPTM(NEXTP)=DYPTM(I)/CURVE1
C-----INCREMENT POINT COUNT FOR SET AND INDEX TO NEXT AVAILABLE
C-----LOCATION.
      IMONP(KRAT)=IMONP(KRAT)+1
      LIMPT(2,KRAT)=NEXTP
      NEXTP=NEXTP+1
C-----RE-DEFINE Y LIMITS FOR SCALING.
      YNOWM=YNOWM/CURVE1
      YNOWP=YNOWP/CURVE1
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
c-----2014/4/28 - IF FORCED LOG Y, IGNORE NEGATIVES.
      if(IABS(IWANT(2)).eq.2.and.YNOWM.le.0.0d+0) go to 210
      if(IABS(IWANT(2)).eq.2.and.YNOWP.le.0.0d+0) go to 210
      IF(KPASS.GT.0) GO TO 200
C-----INITIALIZE Y LIMITS.
      KPASS=1
      YLIMR(1)=YNOWM
      YLIMR(2)=YNOWP
      GO TO 210
C-----UPDATE Y RANGE.
  200 IF(YNOWM.LT.YLIMR(1)) YLIMR(1)=YNOWM
      IF(YNOWP.GT.YLIMR(2)) YLIMR(2)=YNOWP
  210 CONTINUE
      IF(IMONP(K).LE.0) GO TO 220
C-----INCREMENT COUNT OF SETS OF POINTS ON NEXT PLOT AND INCREMENT
C-----MAXIMUM NUMBER OF CHARACTERS IN LEGEND BOX.
      JMONP=JMONP+1
      IF(NTITP(K).GT.MAXTIT) MAXTIT=NTITP(K)
  220 CONTINUE
C-----IF REQUESTED SET X LIMITS.
  230 IF(KWANT(1,1).GT.0) XLIM(1)=XRANGE(1)
      IF(KWANT(2,1).GT.0) XLIM(2)=XRANGE(2)
C-----IF REQUESTED SET Y LIMITS OF DATA.
      IF(KWANT(1,2).GT.0) YLIM(1)=YRANGE(1)
      IF(KWANT(2,2).GT.0) YLIM(2)=YRANGE(2)
      RETURN
      END
      SUBROUTINE RANGEC(XS,YS,KCURVE,IPASS,KPASS,IPICK,IPT)
C=================================================================
C
C     X-Y LIMITS FOR CURVE. IF USING RATIOS DEFINE THEM.
C
C     DEFINE X-Y LIMITS OF PLOTTING AREA. POINT HAS ALREADY BEEN
C     DEFINED TO BE IN X RANGE. TEST Y RANGE, IF NECESSARY.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
C
C     IGNORE POINT IF NOT POSITIVE AND LOG SCALING REQUESTED.
C
C-----IGNORE NON-POSITIVE X IF LOG X SCALING.
      IF(IABS(IWANT(1)).EQ.2.AND.XS.LE.0.0) RETURN
C-----INCREMENT COUNT OF POINTS IN X RANGE.
      IPICK=IPICK+1
C-----ONLY SELECT POINTS IN Y RANGE.
      IF(KWANT(1,2).le.0) go to 10
      IF(YS.ge.YRANGE(1)) go to 10
      IYNOW=-1
      GO TO 20
   10 IF(KWANT(2,2).le.0) go to 30
      IF(YS.le.YRANGE(2)) go to 30
      IYNOW=1
C-----POINT IS NOT IN Y RANGE OF PLOT. IF NO POINTS YET IN X RANGE
C-----SAVE WHERE POINT IS RELATIVE TO PLOT. OTHERWISE TEST FOR
C-----CHANGE...IF ANY USE POINT.
   20 IF(IPICK.LE.1) GO TO 80
      IF(IYNOW.eq.IYLAST) go to 80
      go to 50
C-----IN REQUESTED Y RANGE. IGNORE NON-POSITIVE Y IF LOG Y SCALING.
   30 IF(IABS(IWANT(2)).NE.2.OR.YS.GT.0.0) GO TO 40
      IYNOW=-1
      GO TO 70
C-----POINT IS IN Y RANGE OF PLOT.
   40 IYNOW=0
C-----INCREMENT POINT COUNT.
   50 IMONC(KCURVE)=IMONC(KCURVE)+1
C-----2014/4/28 - if forced Y log, ignore non-positive.
      IF(IABS(IWANT(2)).EQ.2.AND.YS.LE.0.0) RETURN
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
      IF(IPASS.GT.0) GO TO 60
      IPASS=1
      XLIM(1)=XS
      XLIM(2)=XS
      YLIM(1)=YS
      YLIM(2)=YS
      GO TO 70
C-----UPDATE RANGE.
   60 IF(XS.LT.XLIM(1)) XLIM(1)=XS
      IF(XS.GT.XLIM(2)) XLIM(2)=XS
      IF(YS.LT.YLIM(1)) YLIM(1)=YS
      IF(YS.GT.YLIM(2)) YLIM(2)=YS
C
C     IF USING RATIOS DEFINE IT NOW.
C
   70 CALL RATCUR(XS,YS,KCURVE,KPASS,IPT)
C-----SAVE WHERE POINT IS RELATIVE TO PLOT AND COORDINATES OF POINT.
   80 IYLAST=IYNOW
      RETURN
      END
      SUBROUTINE RATCUR(XS,YS,KCURVE,KPASS,IPT)
C=================================================================
C
C     DEFINE RATIO FOR PRESENT CURVE TO FIRST CURVE AT XS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/ERRBIG/BIGERR,BIGX
      COMMON/CNEXT/NEXTC,ISTAR1,IEND1,JSTAR1,KSTAR1,MSTAR1
      COMMON/TERPIT/INTERD,INTERR
      INCLUDE 'plottab.h'
C
C     IF USING RATIOS DEFINE IT NOW, UNLESS NO CORE NEXT.
C
      IF(MPLOT.LT.2.OR.NEXTC.GT.MAXCUR) RETURN
C
C     NO RATIO IF XS IS NOT IN RANGE OF FIRST CURVE.
C
      IF(XS.LT.XCURVE(ISTAR1)) RETURN
      IF(XS.GT.XCURVE(IEND1).AND.JSTAR1.GT.IEND1) RETURN
C
C     NEXT RATIO POINT WILL BE AT THE X VALUE OF EITHER THE CURRENT OR
C     FIRST CURVE, WHICHEVER IS SMALLER.
C
C-----USE CURRENT CURVE POINT IF NO MORE FIRST CURVE POINTS LEFT.
   10 IF(JSTAR1.GT.IEND1) GO TO 90
      IF(XS.lt.XCURVE(JSTAR1)) go to 90
      IF(XS.eq.XCURVE(JSTAR1)) go to 80
C
C     NEXT RATIO AT X VALUE OF FIRST CURVE.
C
C-----NO INTERPOLATION IF FIRST POINT OF CURVE.
      IF(IPT.LE.LIMCUR(1,KCURVE)) GO TO 90
      XS1=XCURVE(JSTAR1)
C-----NO INTERPOLATION IF FIRST CURVE POINT IS NOT IN PRECEDING X
C-----INTERVAL.
      IF(XS1.GE.XCURVE(IPT-1)) GO TO 20
      JSTAR1=JSTAR1+1
      GO TO 10
   20 YS1=TERPUP(XS1,XCURVE(IPT-1),XCURVE(IPT),YCURVE(IPT-1),
     1 YCURVE(IPT),INTERD)
      CURVE1=YCURVE(JSTAR1)
      IF(CURVE1.NE.0.0) GO TO 40
      IF(YS1.NE.0.0) GO TO 30
C-----BOTH = 0 - DEFINE RATIO = 1
      YSR=1.0
      GO TO 50
C-----ONLY CURVE1 = 0 - DEFINE RATIO = + OR - 999.
   30 YSR=999.0
      IF(YS1.LT.0.0) YSR=-999.0
      GO TO 50
C-----DEFINE RATIO.
   40 YSR=YS1/CURVE1
C-----INCREMENT POINT COUNT AND SAVE POINT.
   50 LCURVE=KCURVE+NUMCUR
      IF(IMONC(LCURVE).EQ.0) LIMCUR(1,LCURVE)=NEXTC
      XCURVE(NEXTC)=XS1
      YCURVE(NEXTC)=YSR
      LIMCUR(2,LCURVE)=NEXTC
      NEXTC=NEXTC+1
      IMONC(LCURVE)=IMONC(LCURVE)+1
C-----SAVE BIGGEST DIFFERENCE.
      ERRNOW=YSR-1.0
      IF(DABS(ERRNOW).LE.DABS(BIGERR)) GO TO 60
      BIGERR=ERRNOW
      BIGX=XS1
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
   60 JSTAR1=JSTAR1+1
      IF(KPASS.GT.0) GO TO 70
      IF(IABS(IWANT(2)).EQ.2.AND.YSR.LE.0.0) GO TO 10
      KPASS=1
      YLIMR(1)=YSR
      YLIMR(2)=YSR
      GO TO 10
C-----UPDATE RANGE.
   70 IF(IABS(IWANT(2)).EQ.2.AND.YSR.LE.0.0) GO TO 10
      IF(YSR.LT.YLIMR(1)) YLIMR(1)=YSR
      IF(YSR.GT.YLIMR(2)) YLIMR(2)=YSR
      GO TO 10
C-----USE CURRENT POINT FROM FIRST CURVE AND INCREMENT INDEX TO FIRST
C-----CURVE.
   80 CURVE1=YCURVE(JSTAR1)
      JSTAR1=JSTAR1+1
      GO TO 100
C
C     NEXT RATIO AT X VALUE OF CURRENT CURVE.
C
C-----DEFINE VALUE OF FIRST CURVE..IF FIRST CURVE DOES NOT INCLUDE
C-----THIS X NO RATIO.
   90 CALL CURVED(XS,CURVE1,IMOK)
      IF(IMOK.LE.0) GO TO 160
  100 CONTINUE
      IF(CURVE1.NE.0.0) GO TO 120
      IF(YS.NE.0.0) GO TO 110
      YSR=1.0
      GO TO 130
  110 YSR=999.0
      IF(YS.LT.0.0) YSR=-999.0
      GO TO 130
  120 YSR=YS/CURVE1
C-----INCREMENT POINT COUNT AND SAVE POINT.
  130 LCURVE=KCURVE+NUMCUR
      IF(IMONC(LCURVE).EQ.0) LIMCUR(1,LCURVE)=NEXTC
      XCURVE(NEXTC)=XS
      YCURVE(NEXTC)=YSR
      LIMCUR(2,LCURVE)=NEXTC
      NEXTC=NEXTC+1
      IMONC(LCURVE)=IMONC(LCURVE)+1
C-----SAVE BIGGEST DIFFERENCE.
      ERRNOW=YSR-1.0
      IF(DABS(ERRNOW).LE.DABS(BIGERR)) GO TO 140
      BIGERR=ERRNOW
      BIGX=XS
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
  140 IF(KPASS.GT.0) GO TO 150
      IF(IABS(IWANT(2)).EQ.2.AND.YSR.LE.0.0) GO TO 160
      KPASS=1
      YLIMR(1)=YSR
      YLIMR(2)=YSR
      GO TO 160
C-----UPDATE RANGE.
  150 IF(IABS(IWANT(2)).EQ.2.AND.YSR.LE.0.0) GO TO 160
      IF(YSR.LT.YLIMR(1)) YLIMR(1)=YSR
      IF(YSR.GT.YLIMR(2)) YLIMR(2)=YSR
  160 RETURN
      END
      SUBROUTINE YLIMIT(XBOX,YBOX)
C=================================================================
C
C     DEFINE Y LIMITS OF DATA WITHIN X RANGE OF LEGEND BOX.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/ERRBAR/IXBAR,IYBAR
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/TERPIT/INTERD,INTERR
      INCLUDE 'plottab.h'
      DIMENSION XBOX(2),YBOX(2)
C
C     SCALE FOR CONTINUOUS CURVE (IF ANY).
C
C-----INITIALIZE FLAG TO SHOW IF ANY DATA IN REQUESTED ENERGY DATA.
      IPASS=0
      IF(JMONC.LE.0) GO TO 130
C-----SELECT DATA OR RATIOS.
      IF(NPLOT.EQ.1) GO TO 10
      KMIN=NUMCUR+1
      KMAX=NUMCUR+NUMCUR
      INTERX=INTERR
      GO TO 20
   10 KMIN=1
      KMAX=NUMCUR
      INTERX=INTERD
   20 DO 120 K=KMIN,KMAX
C-----IGNORE IF NO POINTS ON PLOT.
      IF(IMONC(K).LE.0) GO TO 120
      I1=LIMCUR(1,K)
      I2=LIMCUR(2,K)
C-----INITIALIZE FLAG TO SHOW CURVE NOT YET IN ENERGY RANGE.
      IMOFF=0
      DO 110 I=I1,I2
C-----INITIALIZE FLAG TO SHOW NOT INTERPOLATING.
   30 LOOP=-1
      XS=XCURVE(I)
      YS=YCURVE(I)
C-----ONLY SELECT POINTS IN REQUESTED X RANGE.
      IF(XS.lt.XBOX(1)) go to 100
      IF(XS.eq.XBOX(1)) go to 70
C-----INTERPOLATE TO LOWER BOUNDARY WHEN FIRST POINT IN RANGE IS FOUND
C-----UNLESS NO POINTS ON PLOT.
      IF(IMOFF.GT.0) GO TO 50
C-----FOR FIRST POINT OF CURVE, (1) IF ABOVE UPPER LIMIT, THEN CURVE
C-----IS NOT IN REQUESTED RANGE, (2) OTHERWISE DO NOT INTERPOLATE.
      IF(I.GT.I1) GO TO 40
      IF(XS.lt.XBOX(2)) go to 70
      go to 120
C-----INTERPOLATE TO LOWER BOUNDARY (SET INTERPOLATION FLAG).
   40 YS=TERPUP(XBOX(1),XS,XLASTK,YS,YLASTK,INTERX)
      XS=XBOX(1)
      LOOP=0
      GO TO 70
C-----INTERPOLATE TO UPPER BOUNDARY WHEN FIRST POINT OUT OF RANGE
C-----UNLESS NO POINTS ON PLOT.
   50 IF(XS.lt.XBOX(2)) go to 70
      IF(IMOFF.LE.0) GO TO 120
      IF(XS.EQ.XBOX(2)) GO TO 60
C-----INTERPOLATE TO UPPER BOUNDARY (SET INTERPOLATION FLAG).
      YS=TERPUP(XBOX(2),XS,XLASTK,YS,YLASTK,INTERX)
      XS=XBOX(2)
   60 LOOP=1
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
   70 IF(IPASS.GT.0) GO TO 80
      IPASS=1
      IMOFF=1
      YBOX(1)=YS
      YBOX(2)=YS
      GO TO 90
C-----UPDATE RANGE.
   80 IMOFF=IMOFF+1
      IF(YS.LT.YBOX(1)) YBOX(1)=YS
      IF(YS.GT.YBOX(2)) YBOX(2)=YS
C-----IF INTERPOLATING TO LOWER BOUNDARY USE SAME POINT AGAIN.
   90 IF(LOOP.eq.0) go to 30
      IF(LOOP.gt.0) go to 120
C-----SAVE LAST X, Y FOR INTERPOLATION.
  100 XLASTK=XCURVE(I)
      YLASTK=YCURVE(I)
  110 CONTINUE
  120 CONTINUE
C
C     SCALE FOR DISCRETE POINTS (IF ANY).
C
  130 IF(JMONP.LE.0) GO TO 210
C-----SELECT DATA OR RATIOS.
      IF(NPLOT.EQ.1) GO TO 140
      KMIN=NUMSET+1
      KMAX=NUMSET+NUMSET
      GO TO 150
  140 KMIN=1
      KMAX=NUMSET
  150 DO 200 K=KMIN,KMAX
      I1=LIMPT(1,K)
      I2=LIMPT(2,K)
C-----INITIALIZE FLAG TO SHOW POINTS NOT YET IN ENERGY RANGE.
      IMOFF=0
      DO 190 I=I1,I2
C-----ONLY SELECT POINTS IN X RANGE.
      IF(XPT(I).LT.XBOX(1).OR.XPT(I).GT.XBOX(2)) GO TO 190
      IMOFF=IMOFF+1
C-----DEFINE LIMITS (IGNORE ERROR BARS IF NOT REQUESTED).
      IF(IYBAR.NE.0) GO TO 160
      YNOWM=YPT(I)
      YNOWP=YNOWM
      GO TO 170
C-----LIMIT SCALING FOR ERROR BARS
c-----2014/4/23 - Scaling no longer limited
  160 DYMMM = DYPTM(I)
      DYPPP = DYPTP(I)
      YNOWM=YPT(I)-DYMMM
      YNOWP=YPT(I)+DYPPP
c-----2014/4/28 - if FORCED log range, ignore non-positive.
  170 if(IABS(IWANT(2)).eq.2.and.YNOWM.le.0.0d+0) go to 190
      if(IABS(IWANT(2)).eq.2.and.YNOWP.le.0.0d+0) go to 190
C-----INITIALIZE LIMITS ON FIRST POINT. OTHERWISE UPDATE RANGE.
      IF(IPASS.GT.0) GO TO 180
C-----INITIALIZE LIMITS.
      IPASS=1
      YBOX(1)=YNOWM
      YBOX(2)=YNOWP
      GO TO 190
C-----UPDATE RANGE.
  180 IF(YNOWM.LT.YBOX(1)) YBOX(1)=YNOWM
      IF(YNOWP.GT.YBOX(2)) YBOX(2)=YNOWP
  190 CONTINUE
  200 CONTINUE
  210 RETURN
      END
      SUBROUTINE XROUND
C=================================================================
C
C     ROUND X LIMITS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/WAYS/IWAY(2)
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/LEGOFF/NOLEGS
      DIMENSION XBOX(2),YBOX(2),BOXBIG(2,2)
C
C     ONLY DEFINE X LIMITS BASED ON DATA, NOT RATIO.
C
      IF(NPLOT.NE.1) RETURN
C
C     INITIALIZE LEGEND OFF SCREEN - LEAVE IT THERE IF
C     NO LEGEND BOX REQUESTED.
C
      BOXMIN=-10.0
      BOXMAX=-10.0
      BOYMIN=-10.0
      BOYMAX=-10.0
      IF(NOLEGS.NE.0) GO TO 10
C
C     INITIALIZE LEGEND BOX IN UPPER RIGHT HAND CORNER.
C
      BOXMAX=XINCHP(2)
      BOYMAX=YINCHP(2)
      CALL BOXSIZ
C
C     DEFINE LINEAR OR LOG SCALING
C
   10 IWAY(1)=IABS(IWANT(1))
      IF(IWAY(1).EQ.0) IWAY(1)=2
      IF(IWANT(1).EQ.0.AND.XLIM(2).LT.10.0*XLIM(1)) IWAY(1)=1
      IF(XLIM(1).LE.0.0) IWAY(1)=1
C
C     PREVENT ZERO X RANGE.
C
      IF(XLIM(2).GT.XLIM(1)) GO TO 50
      IF(XLIM(1).lt.0) go to 30
      IF(XLIM(1).eq.0) go to 40
      IF(IABS(IWANT(1)).NE.2) GO TO 20
C-----POSITIVE LOG LIMITS.
      XLIM(1)=0.1*XLIM(1)
      XLIM(2)=10.0*XLIM(2)
      IWAY(1)=2
      GO TO 50
C-----POSITIVE LINEAR LIMITS.
   20 XLIM(1)=0.5*XLIM(1)
      XLIM(2)=1.5*XLIM(2)
      IWAY(1)=1
      GO TO 70
C-----NEGATIVE LINEAR LIMITS.
   30 XLIM(1)=1.5*XLIM(1)
      XLIM(2)=0.5*XLIM(2)
      IWAY(1)=1
      GO TO 70
C-----LIMITS ABOUT ZERO.
   40 XLIM(1)=-1.05
      XLIM(2)=1.05
      IWAY(1)=1
      GO TO 70
C
C     IF REQUIRED, CONVERT LIMITS TO LOG.
C
   50 IF(IWAY(1).EQ.1) GO TO 60
      XLIM(1)=DLOG10(XLIM(1))
      XLIM(2)=DLOG10(XLIM(2))
C
C     ROUND X LIMITS - UNLESS REQUESTED NOT TO.
C
   60 IF(NROUND(1).EQ.1) GO TO 70
C-----MOVE LIMITS OUTWARD TO PREVENT OVERLAP WITH GRID.
      DXLIM=0.5*(XLIM(2)-XLIM(1))
      XMID=0.5*(XLIM(2)+XLIM(1))
      IF(NROUND(1).NE.3) XLIM(1)=XMID-1.04*DXLIM
      IF(NROUND(1).NE.2) XLIM(2)=XMID+1.04*DXLIM
C
C     NOTHING TO DO IF NO LEGEND BOX ON PLOT.
C
   70 IF(NOLEGS.NE.0) GO TO 250
C
C     TRY TO FIND OPEN AREA FOR LEGEND BOX.
C
C-----INITIALIZE BOX TO UPPER RIGHT CORNER.
      IMBIG3=3
      DXLIM=XLIM(2)-XLIM(1)
      DYLIM=YLIM(2)-YLIM(1)
      DXINCH=XINCHP(2)-XINCHP(1)
      DYINCH=YINCHP(2)-YINCHP(1)
      DXBOX=BOXMAX-BOXMIN
      DYBOX=BOYMAX-BOYMIN
C-----IF LEGEND BOX COVERS ENTIRE Y RANGE POSITION LEGEND BOX IN UPPER
C-----RIGHT HAND CORNER.
      IF(BOYMIN.LE.YINCHP(1)) GO TO 230
C-----TRY UPPER AND THEN LOWER X BORDERS AND THEN MIDDLE OF PLOT FOR
C-----POSITION OF LEGEND BOX.
      IMBIG1=0
      IMBIG2=0
      IMBIG3=0
      BIGBOX=0.0
      BIGEDG=0.0
C-----TRY LEFT, CENTER, RIGHT.
      DO 200 ISIDE=1,3
      GO TO (80,90,100),ISIDE
   80 BOXMIN=XINCHP(1)
      BOXMAX=BOXMIN+DXBOX
      GO TO 110
   90 XMID=XINCHP(2)+XINCHP(1)
      BOXMIN=0.5*(XMID-DXBOX)
      BOXMAX=0.5*(XMID+DXBOX)
      GO TO 110
  100 BOXMAX=XINCHP(2)
      BOXMIN=BOXMAX-DXBOX
C-----DEFINE X LIMITS OF LEGEND BOX IN UNITS OF THE DATA.
  110 XBOX(1)=((BOXMIN-XINCHP(1))*XLIM(2)+(XINCHP(2)-BOXMIN)*XLIM(1))/
     1 DXINCH
      XBOX(2)=((BOXMAX-XINCHP(1))*XLIM(2)+(XINCHP(2)-BOXMAX)*XLIM(1))/
     1 DXINCH
      IF(IWAY(1).EQ.2) XBOX(1)=10.0**XBOX(1)
      IF(IWAY(1).EQ.2) XBOX(2)=10.0**XBOX(2)
C-----DEFINE Y LIMITS OF DATA IN X RANGE OF LEGEND BOX.
      CALL YLIMIT(XBOX,YBOX)
C-----FOR LOG SCALING IF Y LIMITS ARE NOT POSITIVE DEFINE LIMIT TO BE
C-----WELL BELOW THE LOWER LIMIT OF THE PLOT
      IF(IWAY(2).NE.2) GO TO 140
      IF(YBOX(1).GT.0.0) GO TO 130
      YBOX(1)=-10.0*YINCHP(1)
      IF(YBOX(2).GT.0.0) GO TO 120
      YBOX(2)=-10.0*YINCHP(2)
      GO TO 150
  120 YBOX(2)=DLOG10(YBOX(2))
      YBOX(2)=((YBOX(2)-YLIM(1))*YINCHP(2)+(YLIM(2)-YBOX(2))*YINCHP(1))/
     1 DYLIM
      GO TO 150
  130 YBOX(1)=DLOG10(YBOX(1))
      YBOX(2)=DLOG10(YBOX(2))
  140 YBOX(1)=((YBOX(1)-YLIM(1))*YINCHP(2)+(YLIM(2)-YBOX(1))*YINCHP(1))/
     1 DYLIM
      YBOX(2)=((YBOX(2)-YLIM(1))*YINCHP(2)+(YLIM(2)-YBOX(2))*YINCHP(1))/
     1 DYLIM
C
C     CAN BOX FIT AT TOP Y (UPPER Y LIMIT OF DATA BELOW BOTTOM OF BOX).
C
  150 BOYNOW=YINCHP(2)-YBOX(2)
C-----KEEP TRACK OF BIGGEST CORNER.
      IF(ISIDE.EQ.2) GO TO 160
      IF(BOYNOW.LE.BIGEDG) GO TO 160
      IMBIG3=ISIDE
      BIGEDG=BOYNOW
C-----KEEP TRACK OF BIGGEST ANYPLACE.
  160 IF(BOYNOW.LE.BIGBOX) GO TO 170
      IMBIG2=2
      BIGBOX=BOYNOW
      BOXBIG(1,1)=BOXMIN
      BOXBIG(2,1)=BOXMAX
      BOXBIG(1,2)=YINCHP(2)-DYBOX
      BOXBIG(2,2)=YINCHP(2)
      YDAT1=YBOX(1)
      YDAT2=YBOX(2)
  170 IF(BOYNOW.GE.DYBOX) IMBIG1=1
C
C     CAN BOX FIT AT BOTTOM Y (LOWER Y LIMIT OF DATA ABOVE TOP OF BOX).
C
C-----KEEP TRACK OF BIGGEST CORNER.
      BOYNOW=YBOX(1)-YINCHP(1)
      IF(ISIDE.EQ.2) GO TO 180
      IF(BOYNOW.LE.BIGEDG) GO TO 180
      IMBIG3=ISIDE
      BIGEDG=BOYNOW
C-----KEEP TRACK OF BIGGEST ANYPLACE.
  180 IF(BOYNOW.LE.BIGBOX) GO TO 190
      IMBIG2=1
      BIGBOX=BOYNOW
      BOXBIG(1,1)=BOXMIN
      BOXBIG(2,1)=BOXMAX
      BOXBIG(1,2)=YINCHP(1)
      BOXBIG(2,2)=YINCHP(1)+DYBOX
      YDAT1=YBOX(1)
      YDAT2=YBOX(2)
  190 IF(BOYNOW.GE.DYBOX) IMBIG1=1
  200 CONTINUE
C
C     DEFINE FINAL POSITION OF LEGEND BOX.
C
      BOXMIN=BOXBIG(1,1)
      BOXMAX=BOXBIG(2,1)
      BOYMIN=BOXBIG(1,2)
      BOYMAX=BOXBIG(2,2)
      DXBOX = BOXMAX - BOXMIN
      DYBOX = BOYMAX - BOYMIN
C
C     IF BOX FITS USE IT.
C
      IF(IMBIG1.GT.0) GO TO 240
C
C     LEGEND BOX WILL NOT FIT ON PLOT. MUST EXPAND X OR Y RANGE.
C
C     DEFINE SIZE OF PLOTTING AREA WHICH WILL CONTAIN DATA IF
C     X OR Y RANGE IS EXPANDED AND EXPAND WHICHEVER WILL RESULT
C     IN THE BIGGEST USED AREA.
C
      XPAND=(DXINCH-DXBOX)*DYINCH
      YPAND=DXINCH*(DYINCH-(DYBOX-BIGBOX))
      IF(XPAND.GT.YPAND) GO TO 220
C
C     EXPAND Y RANGE.
C
      IF(IMBIG2.EQ.2) GO TO 210
C
C-----BOTTOM OF BOX...EXPAND Y RANGE DOWN TO MOVE DATA OUT OF BOX.
C-----PRESENT OPEN AREA IS FROM YDAT1 TO YINCHP(2)...SCALE THIS TO
C-----BOYMAX TO YINCHP(2).
      BOXBIG(1,2) = YINCHP(1)
      BOXBIG(2,2) = YINCHP(1) + DYBOX
      BOYMIN=BOXBIG(1,2)
      BOYMAX=BOXBIG(2,2)
      DYUSED=YINCHP(2)-BOYMAX
      DYOPEN=YINCHP(2)-YDAT1
      YLIM(1)=YLIM(2)-1.05*DYLIM*DYOPEN/DYUSED
      GO TO 240
C-----TOP OF BOX...EXPAND Y RANGE UP TO MOVE DATA OUT OF BOX.
C-----PRESENT OPEN AREA IS FROM YDAT2 TO YINCHP(1)...SCALE THIS TO
C-----BOYMIN TO YINCHP(1).
  210 BOXBIG(2,2) = YINCHP(2)
      BOXBIG(1,2) = YINCHP(2) - DYBOX
      BOYMIN=BOXBIG(1,2)
      BOYMAX=BOXBIG(2,2)
      DYUSED=BOYMIN-YINCHP(1)
      DYOPEN=YDAT2-YINCHP(1)
      YLIM(2)=YLIM(1)+1.05*DYLIM*DYOPEN/DYUSED
      GO TO 240
C
C     POSITION BOX IN CORNER AND EXPAND X RANGE.
C
  220 BOYMIN=YINCHP(1)
      BOYMAX=YINCHP(1) + DYBOX
      IF(IMBIG3.EQ.3) GO TO 230
C-----LEFT OF PLOT...EXPAND X RANGE DOWN TO MOVE DATA OUT OF BOX.
C-----SCALE X TO PUT DATA IN RANGE BOXMAX TO XINCHP(2).
      BOXMIN=XINCHP(1)
      BOXMAX=XINCHP(1) + DXBOX
      DXUSED=XINCHP(2)-BOXMAX
      XLIM(1)=XLIM(2)-DXLIM*DXINCH/DXUSED
      GO TO 240
C-----RIGHT OF PLOT...EXPAND X RANGE UP TO MOVE DATA OUT OF BOX.
C-----SCALE X TO PUT DATA IN RANGE XINCHP(1) TO BOXMIN.
  230 BOXMIN=XINCHP(2) - DXBOX
      BOXMAX=XINCHP(2)
      DXUSED=BOXMIN-XINCHP(1)
      XLIM(2)=XLIM(1)+DXLIM*DXINCH/DXUSED
      GO TO 240
C
C     DEFINE FINAL LEGEND BOX PARAMETERS.
C
  240 CALL BOXSIZ
  250 RETURN
      END
      SUBROUTINE GRID
C=================================================================
C
C     PLOT X AND Y AXIS TICK MARKS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/WAYS/IWAY(2)
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/LOGTAB/TABLOG(10)
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/GRIDDY/IMFINE(2)
      COMMON/MULTHT/HTMULT
      CALL PEN(2)
C-----SAVE FINE GRID FLAG.
      IMFIN2=IMFINE(2)
C
C     X AXIS
C
      YR1=YINCHP(1)
      YR2=YR1+BOX2
      YR3=YR2+BOX2
      YR4=YR3+BOX2
      IF(IWAY(1).EQ.1) GO TO 130
C
C     PLOT X SCALE LOG10 DECADES.
C
C-----DEFINE GRID PARAMETERS.
      IXMIN=XLIM(1)
      IF(XLIM(1).LT.0.0) IXMIN=IXMIN-1
      IXMAX=XLIM(2)+1.0
      NDEC=HTMULT*(XLIM(2)-XLIM(1))
      IF(NDEC.LE.100) GO TO 10
      ILOG1=10
      KLOG1=10
      GO TO 40
   10 IF(NDEC.LE.50) GO TO 20
      ILOG1=5
      KLOG1=5
      GO TO 40
   20 IF(NDEC.LE.20) GO TO 30
      ILOG1=2
      KLOG1=2
      GO TO 40
   30 ILOG1=2
      KLOG1=1
C-----DECIDE WHETHER OR NOT TO INCLUDE FINE GRID.
   40 IF(IMFIN2.LE.0) GO TO 50
      XI=(XINCHP(2)-XINCHP(1))/DXLIM
      IF(XI.LT.0.5) IMFINE(2)=0
C-----LOOP OVER LOWER AND UPPER AXIS.
   50 DO 120 LOOP=1,2
C-----COARSE GRID LOOP.
      DO 110 I=IXMIN,IXMAX
      XR=I
      IF(XR.LT.XLIM(1).OR.XR.GT.XLIM(2)) GO TO 80
      XI=((XR-XLIM(1))*XINCHP(2)+(XLIM(2)-XR)*XINCHP(1))/DXLIM
C-----SELECT GRID TYPE.
      IF(IMFINE(1).EQ.0) GO TO 60
      IF(LOOP.EQ.1) CALL PLOTZ(XI,1,IMFINE(1))
      GO TO 70
   60 CALL PLVH1(XI,YR1,3)
      CALL PLVH1(XI,YR4,2)
C-----FINE GRID LOOP.
   70 IF(ILOG1.GT.9) GO TO 110
   80 DO 100 J=ILOG1,9,KLOG1
      XZ=XR+TABLOG(J)
      IF(XZ.LT.XLIM(1).OR.XZ.GT.XLIM(2)) GO TO 100
      XI=((XZ-XLIM(1))*XINCHP(2)+(XLIM(2)-XZ)*XINCHP(1))/DXLIM
      YRY=YR2
      IF(J.EQ.5) YRY=YR3
      IF(IMFINE(2).LE.0) GO TO 90
      IF(LOOP.EQ.1) CALL PLOTZ(XI,1,IMFINE(2))
      GO TO 100
   90 CALL PLVH1(XI,YR1,3)
      CALL PLVH1(XI,YRY,2)
  100 CONTINUE
  110 CONTINUE
C-----SWITCH POSITIONS TO OTHER AXIS.
      YR1=YINCHP(2)
      YR2=YR1-BOX2
      YR3=YR2-BOX2
      YR4=YR3-BOX2
  120 CONTINUE
      GO TO 260
C
C     PLOT X SCALE LINEAR UNITS.
C
C-----DEFINE GRID PARAMETERS.
  130 NDEC=(XLIM(2)-XLIM(1))/XSTEP1
      IF(NDEC.LE.100) GO TO 140
      LOOP2=1
      GO TO 170
  140 IF(NDEC.LE.50) GO TO 150
      LOOP2=2
      GO TO 170
  150 IF(NDEC.LE.20) GO TO 160
      LOOP2=5
      GO TO 170
  160 LOOP2=10
  170 XLOOP2=LOOP2
      XSTEPX=XSTEP1/XLOOP2
      XBASEX=XBASE-XSTEP1
C-----DECIDE WHETHER OR NOT TO INCLUDE FINE GRID.
      IF(IMFIN2.LE.0) GO TO 180
      XI=XSTEP1*(XINCHP(2)-XINCHP(1))/DXLIM
      IF(XI.LT.0.5) IMFINE(2)=0
C-----LOOP OVER LOWER AND UPPER AXIS.
  180 DO 250 LOOP=1,2
      XR=XBASEX
C-----LOOP OVER COARSE GRID.
  190 YRY=YR3
C-----LOOP OVER FINE GRID.
      DO 230 II=1,LOOP2
      IF(XR.LT.XLIM(1)) GO TO 220
      IF(XR.GT.XLIM(2)) GO TO 240
      XI=((XR-XLIM(1))*XINCHP(2)+(XLIM(2)-XR)*XINCHP(1))/DXLIM
C-----SELECT GRID TYPE.
      IF(II.NE.1) GO TO 200
C-----COARSE GRID.
      IF(IMFINE(1).EQ.0) GO TO 210
      IF(LOOP.EQ.1) CALL PLOTZ(XI,1,IMFINE(1))
      GO TO 220
C-----FINE GRID.
  200 IF(IMFINE(2).LE.0) GO TO 210
      IF(LOOP.EQ.1) CALL PLOTZ(XI,1,IMFINE(2))
      GO TO 220
  210 CALL PLVH1(XI,YR1,3)
      CALL PLVH1(XI,YRY,2)
  220 XR=XR+XSTEPX
      YRY=YR2
  230 CONTINUE
      GO TO 190
C-----SWITCH POSITIONS TO OTHER AXIS.
  240 YR1=YINCHP(2)
      YR2=YR1-BOX2
      YR3=YR2-BOX2
      YR4=YR3-BOX2
  250 CONTINUE
C
C     Y AXIS
C
C-----RESET FINE GRID FLAG.
  260 IMFINE(2)=IMFIN2
      XR1=XINCHP(1)
      XR2=XR1+BOX2
      XR3=XR2+BOX2
      XR4=XR3+BOX2
      IF(IWAY(2).EQ.1) GO TO 380
C
C     PLOT Y SCALE LOG10 DECADES.
C
C-----DEFINE GRID PARAMETERS.
      IYMIN=YLIM(1)
      IF(YLIM(1).LT.0.0) IYMIN=IYMIN-1
      IYMAX=YLIM(2)+1.0
      NDEC=HTMULT*(YLIM(2)-YLIM(1))
      IF(NDEC.LE.100) GO TO 270
      ILOG1=10
      KLOG1=10
      GO TO 300
  270 IF(NDEC.LE.50) GO TO 280
      ILOG1=5
      KLOG1=5
      GO TO 300
  280 IF(NDEC.LE.20) GO TO 290
      ILOG1=2
      KLOG1=2
      GO TO 300
  290 ILOG1=2
      KLOG1=1
C-----DECIDE WHETHER OR NOT TO INCLUDE FINE GRID.
  300 IF(IMFIN2.LE.0) GO TO 310
      YI=(YINCHP(2)-YINCHP(1))/DYLIM
      IF(YI.LT.0.5) IMFINE(2)=0
C-----LOOP OVER LOWER AND UPPER AXIS.
  310 DO 370 LOOP=1,2
C-----COARSE GRID LOOP.
      DO 360 I=IYMIN,IYMAX
      YR=I
      IF(YR.LT.YLIM(1).OR.YR.GT.YLIM(2)) GO TO 330
      YI=((YR-YLIM(1))*YINCHP(2)+(YLIM(2)-YR)*YINCHP(1))/DYLIM
C-----SELECT GRID TYPE.
      IF(IMFINE(1).EQ.0) GO TO 320
      IF(LOOP.EQ.1) CALL PLOTZ(YI,2,IMFINE(1))
      GO TO 330
  320 CALL PLVH1(XR1,YI,3)
      CALL PLVH1(XR4,YI,2)
C-----FINE GRID LOOP.
  330 IF(ILOG1.GT.9) GO TO 360
      DO 350 J=ILOG1,9,KLOG1
      YZ=YR+TABLOG(J)
      IF(YZ.LT.YLIM(1).OR.YZ.GT.YLIM(2)) GO TO 350
      YI=((YZ-YLIM(1))*YINCHP(2)+(YLIM(2)-YZ)*YINCHP(1))/DYLIM
      XRX=XR2
      IF(J.EQ.5) XRX=XR3
      IF(IMFINE(2).LE.0) GO TO 340
      IF(LOOP.EQ.1) CALL PLOTZ(YI,2,IMFINE(2))
      GO TO 350
  340 CALL PLVH1(XR1,YI,3)
      CALL PLVH1(XRX,YI,2)
  350 CONTINUE
  360 CONTINUE
C-----SWITCH POSITIONS TO OTHER AXIS.
      XR1=XINCHP(2)
      XR2=XR1-BOX2
      XR3=XR2-BOX2
      XR4=XR3-BOX2
  370 CONTINUE
      GO TO 510
C
C     PLOT Y SCALE LINEAR UNITS.
C
C-----DEFINE GRID PARAMETERS.
  380 NDEC=(YLIM(2)-YLIM(1))/ YSTEP1
      IF(NDEC.LE.100) GO TO 390
      LOOP2=1
      GO TO 420
  390 IF(NDEC.LE.50) GO TO 400
      LOOP2=2
      GO TO 420
  400 IF(NDEC.LE.20) GO TO 410
      LOOP2=5
      GO TO 420
  410 LOOP2=10
  420 YLOOP2=LOOP2
      YSTEPY=YSTEP1/YLOOP2
      YBASEY=YBASE-YSTEP1
C-----DECIDE WHETHER OR NOT TO INCLUDE FINE GRID.
      IF(IMFIN2.LE.0) GO TO 430
      YI=YSTEP1*(YINCHP(2)-YINCHP(1))/DYLIM
      IF(YI.LT.0.5) IMFINE(2)=0
C-----LOOP OVER LOWER AND UPPER AXIS.
  430 DO 500 LOOP=1,2
      YR=YBASEY
C-----COARSE GRID LOOP.
  440 XRX=XR3
C-----FINE GRID LOOP.
      DO 480 II=1,LOOP2
      IF(YR.LT.YLIM(1)) GO TO 470
      IF(YR.GT.YLIM(2)) GO TO 490
      YI=((YR-YLIM(1))*YINCHP(2)+(YLIM(2)-YR)*YINCHP(1))/DYLIM
C-----SELECT GRID TYPE.
      IF(II.NE.1) GO TO 450
C-----COARSE GRID.
      IF(IMFINE(1).EQ.0) GO TO 460
      IF(LOOP.EQ.1) CALL PLOTZ(YI,2,IMFINE(1))
      GO TO 470
C-----FINE GRID.
  450 IF(IMFINE(2).LE.0) GO TO 460
      IF(LOOP.EQ.1) CALL PLOTZ(YI,2,IMFINE(2))
      GO TO 470
  460 CALL PLVH1(XR1,YI,3)
      CALL PLVH1(XRX,YI,2)
  470 YR=YR+YSTEPY
      XRX=XR2
  480 CONTINUE
      GO TO 440
C-----SWITCH POSITIONS TO OTHER AXIS.
  490 XR1=XINCHP(2)
      XR2=XR1-BOX2
      XR3=XR2-BOX2
      XR4=XR3-BOX2
  500 CONTINUE
C-----RESTORE FINE GRID FLAG.
  510 IMFINE(2)=IMFIN2
      RETURN
      END
      SUBROUTINE YROUND
C=================================================================
C
C     ROUND Y LIMITS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/WAYS/IWAY(2)
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/YMINUS/IMINUS
      COMMON/RATLIM/RATMAX,RATMIN
C-----FOR RATIO DATA SET UPPER AND LOWER Y LIMITS.
      IF(NPLOT.EQ.1) GO TO 20
      IF(RATMAX.LE.0.0) GO TO 10
      IF(YLIM(1).LT.RATMIN) YLIM(1)=RATMIN
      IF(YLIM(2).GT.RATMAX) YLIM(2)=RATMAX
C-----FOR RATIO DATA INSURE THAT LIMITS ARE AT LEAST 1 PER-CENT ON
C-----EITHER SIDE OF UNITY.
   10 IF(YLIM(1).GT.0.99) YLIM(1)=0.99
      IF(YLIM(2).LT.1.01) YLIM(2)=1.01
C-----SET FLAG TO SHOW IF Y IS NEGATIVE.
   20 IMINUS=0
      IF(YLIM(1).LT.0.0) IMINUS=1
C
C     DEFINE LINEAR OR LOG SCALING
C
      IWAY(2)=IABS(IWANT(2))
      IF(IWAY(2).EQ.0) IWAY(2)=2
C-----FOR PLOT OF RATIO USE LINEAR SCALE UNLESS THERE IS A LARGE RANGE.
      IF(NPLOT.EQ.1) GO TO 30
      IWAY(2)=1
      IF(YLIM(2).GE.10.0*YLIM(1)) IWAY(2)=2
      IF(YLIM(1).LE.0.0) IWAY(2)=1
      GO TO 40
   30 IF(IWANT(2).EQ.0.AND.YLIM(2).LT.10.0*YLIM(1)) IWAY(2)=1
      IF(YLIM(1).LE.0.0) IWAY(2)=1
C
C     PREVENT ZERO Y RANGE.
C
   40 IF(YLIM(2).GT.YLIM(1)) GO TO 80
      IF(YLIM(1).lt.0.0d+0) go to 60
      IF(YLIM(1).eq.0.0d+0) go to 70
      IF(IABS(IWANT(2)).NE.2) GO TO 50
C-----POSITIVE LOG LIMITS.
      YLIM(1)=0.1*YLIM(1)
      YLIM(2)=10.0*YLIM(2)
      IWAY(2)=2
      GO TO 80
C-----POSITIVE LINEAR LIMITS.
   50 YLIM(1)=0.5*YLIM(1)
      YLIM(2)=1.5*YLIM(2)
      IWAY(2)=1
      GO TO 100
C-----NEGATIVE LINEAR LIMITS.
   60 YLIM(1)=1.5*YLIM(1)
      YLIM(2)=0.5*YLIM(2)
      IWAY(2)=1
      GO TO 100
C-----LIMITS ABOUT ZERO.
   70 YLIM(1)=-1.05
      YLIM(2)=1.05
      IWAY(2)=1
      GO TO 100
C
C     IF REQUIRED, CONVERT LIMITS TO LOG.
C
   80 IF(IWAY(2).EQ.1) GO TO 90
      YLIM(1)=DLOG10(YLIM(1))
      YLIM(2)=DLOG10(YLIM(2))
C
C     ROUND Y LIMITS - UNLESS REQUESTED NOT TO.
C
   90 IF(NROUND(2).EQ.1) GO TO 100
      YMID=0.5*(YLIM(2)+YLIM(1))
      YSPAN=0.5*(YLIM(2)-YLIM(1))
      IF(NROUND(2).NE.3) YLIM(1)=YMID-1.04*YSPAN
      IF(NROUND(2).NE.2) YLIM(2)=YMID+1.04*YSPAN
  100 RETURN
      END
      SUBROUTINE UNITED
C=================================================================
C
C     SELECT X AND Y UNIT MULTIPLIERS TO PUT AXIS ANNOTATION IN
C     NORMAL FORM.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/WAYS/IWAY(2)
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/XYREAL/XREAL(2),YREAL(2)
      DATA TEN/1.0E+01/
C
C     DEFINE REAL X AND Y LIMITS.
C
      IF(IWAY(1).EQ.2) GO TO 10
      XREAL(1)=XLIM(1)
      XREAL(2)=XLIM(2)
      GO TO 20
   10 XREAL(1)=TEN**XLIM(1)
      XREAL(2)=TEN**XLIM(2)
   20 IF(IWAY(2).EQ.2) GO TO 30
      YREAL(1)=YLIM(1)
      YREAL(2)=YLIM(2)
      GO TO 40
   30 YREAL(1)=TEN**YLIM(1)
      YREAL(2)=TEN**YLIM(2)
C
C     SELECT X AND Y UNITS. DEFINE AXIS LABELS AND MULTIPLIERS.
C
C-----DEFINE X UNITS AND MULTIPLIER.
   40 XTOP=DABS(XLIM(1))
      IF(DABS(XLIM(2)).GT.XTOP) XTOP=DABS(XLIM(2))
      CALL ZNORM(XTOP,XMULT,IXMULT,IWAY(1))
      XLIM(1)=XLIM(1)*XMULT
      XLIM(2)=XLIM(2)*XMULT
      DXLIM=XLIM(2)-XLIM(1)
C-----DEFINE Y UNITS AND MULTIPLIER.
      YTOP=DABS(YLIM(1))
      IF(DABS(YLIM(2)).GT.YTOP) YTOP=DABS(YLIM(2))
      CALL ZNORM(YTOP,YMULT,IYMULT,IWAY(2))
      YLIM(1)=YLIM(1)*YMULT
      YLIM(2)=YLIM(2)*YMULT
      DYLIM=YLIM(2)-YLIM(1)
C-----DEFINE X AXIS LABEL INCREMENTS.
      CALL SPACER(XLIM,XBASE,XSTEP1,XSTEP2,IXSTEP,IWAY(1),1)
C-----DEFINE Y AXIS LABEL INCREMENTS.
      CALL SPACER(YLIM,YBASE,YSTEP1,YSTEP2,IYSTEP,IWAY(2),2)
      RETURN
      END
      SUBROUTINE SPACER(ZLIM,ZBASE,ZSTEP1,ZSTEP2,IZSTEP,IZWAY,IAXIS)
C=================================================================
C
C     DEFINE LINEAR X OR Y AXIS LABEL INCREMENTS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/MULTHT/HTMULT
c-----13/07/24 = extended to 3 digits after decimal point.
      DIMENSION ZLIM(2),STEPS(16),ISTEPS(16),ICASES(2,3)
      DATA STEPS/100.,50.,20.,10.,5.,2.,1.,.5,.2,.1,.05,.02,.01,
     1 .005,.002,.001/
      DATA ISTEPS/-1,-1,-1,-1,-1,-1,-1,1,1,1,2,2,2,3,3,3/
      DATA ICASES/10,15,   5,10,   4,8/
C-----NOTHING TO DO FOR LOG SCALING.
      IF(IZWAY.EQ.2) RETURN
      DZLIM=HTMULT*(ZLIM(2)-ZLIM(1))
      KCASES=1
C-----FEWER GRID LINES FOR X AXIS IF NUMBERS OVER 100.0
      ZTOP=DABS(ZLIM(1))
      IF(DABS(ZLIM(2)).GT.ZTOP) ZTOP=DABS(ZLIM(2))
      IF(ZTOP.GE.100.0.AND.IAXIS.EQ.1) KCASES=2
C-----FEWER GRID LINES FOR RATIO Y AXIS.
      IF(NPLOT.EQ.2.AND.IAXIS.EQ.2) KCASES=2
      IF(ZTOP.GE.100.0) KCASES=3
c-----13/07/24 = extended to 3 digits after decimal point.
      DO 10 I=1,16
      IF(I.EQ.7) KCASES=2
      J=DZLIM/STEPS(I)
      K=DZLIM/STEPS(I+1)
      IF(J.GE.ICASES(1,KCASES).OR.K.GE.ICASES(2,KCASES)) GO TO 20
   10 CONTINUE
      I=16
   20 ZSTEP1=STEPS(I)
      IZBASE=ZLIM(1)/ZSTEP1
      ZBASE=FLOAT(IZBASE)*ZSTEP1
      IZSTEP=ISTEPS(I)
      SPACEM=1.0
      IF(J.LE.10) SPACEM=2.0
      IF(J.LE.2) SPACEM=5.0
      IF(J.LE.1) SPACEM=10.0
      ZSTEP2=ZSTEP1/SPACEM
      RETURN
      END
      SUBROUTINE BORDER
C=================================================================
C
C     PLOT BORDER AND ALL AXIS LABELS.
C
C=================================================================
      INCLUDE 'implicit.h'
      INCLUDE 'plottab.h'
      CHARACTER*1 DIGITS,XLABEL,YLABEL,MAXDIF,PERCNT,AT,PARENL,
     1 PARENR,TIME10,RATBCD,TITLES,FIELD11a(11),OVER100(9)
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/STITLE/TITLES(72,2)
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/WAYS/IWAY(2)
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/XYLABC/XLABEL(72),YLABEL(72)
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
      COMMON/LOGTAB/TABLOG(10)
      COMMON/SPOTS/TOP2,TOP3,BOT1,BOT2,BOT3,XLEFT1,XLEFT2,RIGHT3,
     1 RIGHT4,RIGHT5,RIGHT6,RIGHT7,RIGHT8,RIGHT9
      COMMON/NEEDED/YNEEDS(3)
      COMMON/YMINUS/IMINUS
      COMMON/ERRBIG/BIGERR,BIGX
      COMMON/EDGE/XYEDGE(2,2)
      COMMON/THICKY/THICK,ITHICK,NTHICK(3)
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/LEGOFF/NOLEGS
      COMMON/MULTHT/HTMULT
c-----11/22/2013 - Added BOXBOTH, BOYBOTH for COLORBOX arguments
      DIMENSION DIGITS(9),MAXDIF(19),AT(6),TIME10(2),RATBCD(6),
     1 BOXBOTH(2),BOYBOTH(2),PERCNT(1),PARENR(1),PARENL(1)
      DATA MAXDIF/
     1 ' ','M','a','x','i','m','u','m',' ',
     2 'D','i','f','f','e','r','e','n','c','e'/
      DATA PERCNT/'%'/
      DATA OVER100/ 'O','v','e','r',' ','1','0','0','%'/
c                    1   2   3   4   5   6   7   8   9
      DATA AT/' ','a','t',' ','X','='/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA RATBCD/'R','a','t','i','o','s'/
      DATA DIGITS/'1','2','3','4','5','6','7','8','9'/
      DATA TIME10/'1','0'/
      CALL PEN(2)
C-----IF REQUESTED DRAW BORDER AROUND PLOT.
      ITHICK=NTHICK(3)
      IF(NBORD.LE.0) GO TO 10
      CALL PLOT1(XYEDGE(1,1),XYEDGE(1,2),3)
      CALL PLOT1(XYEDGE(1,1),XYEDGE(2,2),2)
      CALL PLOT1(XYEDGE(2,1),XYEDGE(2,2),2)
      CALL PLOT1(XYEDGE(2,1),XYEDGE(1,2),2)
      CALL PLOT1(XYEDGE(1,1),XYEDGE(1,2),2)
C-----FILL INTERIOR.
   10 CALL COLORBOX(XINCHP(1),YINCHP(1),0,2)
C-----DRAW BORDER AROUND EDGE OF GRID.
      CALL PLVHN(XINCHP(1),YINCHP(1),3)
      CALL PLVHN(XINCHP(1),YINCHP(2),2)
      CALL PLVHN(XINCHP(2),YINCHP(2),2)
      CALL PLVHN(XINCHP(2),YINCHP(1),2)
      CALL PLVHN(XINCHP(1),YINCHP(1),2)
      ITHICK=NTHICK(2)
C
C     DEFINE POSITION OF AXIS LABELS.
C
C     TOP2   = Y POSITION OF FIRST TITLE LINE
C     TOP3   = Y POSITION OF SECOND TITLE LINE
C     BOT1   = Y POSITION OF X AXIS NUMBERS (LINEAR)
C            = Y POSITION OF X AXIS LOG EXPONENTS (LOG)
C     BOT2   = Y POSITION OF X AXIS NUMBERS (LOG)
C     BOT3   = Y POSITION OF X AXIS LABEL
C     XLEFT1 = X POSITION OF Y AXIS NUMBERS
C     XLEFT2 = X POSITION OF Y AXIS LABEL
C     TOPY   = Y POSITION OF TOP OF LAST CHARACTER DRAWN ON Y AXIS
C              (USED TO PREVENT OVERWRITING CHARACTERS)
C
      TOP3=YFINCH(2)+HT
      TOP2=TOP3+1.75*HT
      BOT1=YFINCH(1)-1.75*HT
      BOT2=YFINCH(1)-2.75*HT
      BOT3=YFINCH(1)-5.0*HT
      XLEFT1=XINCHP(1)-6.5*WT
      XLEFT2=XINCHP(1)-7.0*HT
      XLEFT2=XINCHP(1)-7.0*HT
      TOPY=BOT3
C-----DEFINE TRUE CENTER OF PLOT.
      XMID=0.5*(XINCHP(1)+XINCHP(2))
      YMID=0.5*(YINCHP(1)+YINCHP(2))
C-----DEFINE LOCATION OF X AXIS LABEL (DIFFERENT FOR LINEAR OR LOG).
      BOTX3=BOT3
      IF(IWAY(1).EQ.1) BOTX3=BOTX3+HT
C
C     USE FIRST 2 LINES OF TITLE TO IDENTIFY PLOT.
C
      TOPX=TOP2
      IF(ITITS(2).LE.0) TOPX=TOP3
      DO 30 IT=1,2
      IF(ITITS(IT).LE.0) GO TO 20
      XZ=XMID-0.5*WT*FLOAT(NTITS(IT))
      CALL SYMBL1(XZ,TOPX,HT,TITLES(1,IT),0.0D+0,ITITS(IT))
   20 TOPX=TOP3
   30 CONTINUE
C-----IF ANY Y VALUES ARE NEGATIVE DRAW A LINE AT Y=0.0 IF THIS IS
C-----WITHIN THE Y RANGE OF THE PLOT.
      IF(IMINUS.EQ.0) GO TO 40
      IF(YLIM(2).LT.0.0.OR.YLIM(1).GT.0.0) GO TO 40
      CALL PLOTX(XLIM(1),0.0D+0,3)
      CALL PLOTX(XLIM(2),0.0D+0,2)
C
C     PLOT BORDER FOR LEGEND (ONLY FOR DATA).
C
   40 IF(NOLEGS.NE.0) GO TO 60
      IF(NPLOT.NE.1) GO TO 50
C-----DRAW LEGEND BOX.
c-----11/22/2013 - Added for COLORBOX arguments
      BOXBOTH(1) = BOXMIN
      BOXBOTH(2) = BOXMAX
      BOYBOTH(1) = BOYMIN
      BOYBOTH(2) = BOYMAX
      CALL COLORBOX(BOXBOTH(1),BOYBOTH(1),0,2)
      CALL PEN(2)
      CALL PLOT1(BOXMIN,BOYMIN,3)
      CALL PLOT1(BOXMIN,BOYMAX,2)
      CALL PLOT1(BOXMAX,BOYMAX,2)
      CALL PLOT1(BOXMAX,BOYMIN,2)
      CALL PLOT1(BOXMIN,BOYMIN,2)
      GO TO 60
C
C     IDENTIFY BIGGEST DIFFERENCE IN RATIOS.
C
   50 IF(NUMCUR.le.1) GO TO 60
      YI=YNEEDS(3)
      CALL PEN(3)
      CALL SYMBL1(RIGHT3,YI,HT,MAXDIF(1),0.0D+0,19)
      YI=YI-1.75*HT
      ERRPC=100.0*BIGERR
      AERRPC=DABS(ERRPC)
C
C     PER-CENT OF MAXIMUM DIFFERENCE.
C
      IF(AERRPC.GE.100.0) THEN       ! too Big
      DXI=8.0
      CALL SYMBL1(RIGHT3+DXI*WT,YI,HT,OVER100(1),0.0D+0,9)
      ELSE
C-----DIFFERENCE IN F FORMAT.
      DXI=8.0
      IF(ERRPC.LT.0.0) DXI=DXI - 1.0
c-----  0.000 to XX.XXX  [5 to 6]
c----- -0.000 to-XX.XXX  [6 to 7]
      CALL NUMBR1(RIGHT3+DXI*WT,YI,HT,ERRPC,0.0D+0,3)
      IF(ERRPC.LT.0.0) DXI=DXI + 1.0                   ! position %
      DXI=DXI + 6.0
      if(AERRPC.ge.10.0) DXI = DXI + 1.0
      CALL SYMBL1(RIGHT3+DXI*WT,YI,HT,PERCNT(1),0.0D+0,1) ! draw %
      ENDIF
C
C     IDENTIFY X WHERE MAXIMUM DIFFERENCE OCCURRED.
C
c-----Skip if no difference
      IF(AERRPC.le.0.0d+0) go to 60
      YI=YI-1.75*HT
      CALL SYMBL1(RIGHT3,YI,HT,AT(1),0.0D+0,6)
C-----X IN E FORMAT.
      CALL OUT9(BIGX,FIELD11a(1))
      DXI=7.0
      IF(BIGX.LT.0.0) DXI=6.0
      CALL SYMBL1(RIGHT3+DXI*WT,YI,HT,FIELD11a(1),0.0D+0,11)
C
C     PLOT BORDER FOR FIGURE
C
   60 CALL PEN(2)
      CALL PLVHN(XINCHP(1),YINCHP(1),3)
      CALL PLVHN(XINCHP(1),YINCHP(2),2)
      CALL PLVHN(XINCHP(2),YINCHP(2),2)
      CALL PLVHN(XINCHP(2),YINCHP(1),2)
      CALL PLVHN(XINCHP(1),YINCHP(1),2)
C
C     PLOT X AXIS LABEL AND UNITS (ONLY FOR LAST SUB-PLOT).
C
      IF(NPLOT.NE.MPLOT) GO TO 90
      XI=XMID-WTH*FLOAT(NXLAB(2))
      IF(IXMULT.EQ.0) GO TO 80
C-----ADD MULTIPLIER BEFORE UNITS.
      ZXMULT=IXMULT
      IZLAB=4
      IF(IABS(IXMULT).GE.10) IZLAB=5
      IF(IXMULT.LT.0) IZLAB=IZLAB+1
      XI=XI-WTH*FLOAT(IZLAB)
      IF(IXLAB(2).GT.IXLAB(1)) GO TO 70
C-----NO UNITS. LABEL FOLLOWED BY (.
      CALL SYMBL1(XI,BOTX3,HT,XLABEL(1),0.0D+0,IXLAB(1))
      XI=XI+WT*FLOAT(NXLAB(1)+1)
      CALL SYMBL1(XI,BOTX3,HT,PARENL(1),0.0d+0,1)
C-----MULTIPLIER FOLLOWED BY ).
      XI=XI+WT
      CALL SYMBL1(XI,BOTX3,HT,TIME10(1),0.0D+0,2)
      XI=XI+2.0*WT
      CALL NUMBR1(XI,BOTX3+0.75*HT,HT,ZXMULT,0.0D+0,-1)
      XI=XI+WT*FLOAT(IZLAB-2)
      CALL SYMBL1(XI,BOTX3,HT,PARENR(1),0.0D+0,1)
      GO TO 90
C-----LABEL FOLLOWED BY (.
   70 CALL SYMBL1(XI,BOTX3,HT,XLABEL(1),0.0D+0,IXLAB(1)+2)
C-----MULTIPLIER.
      XI=XI+WT*FLOAT(NXLAB(1)+2)
      CALL SYMBL1(XI,BOTX3,HT,TIME10(1),0.0D+0,2)
      XI=XI+2.0*WT
      CALL NUMBR1(XI,BOTX3+0.75*HT,HT,ZXMULT,0.0D+0,-1)
C-----UNITS.
      XI=XI+WT*FLOAT(IZLAB-2)
      I1=IXLAB(1)+3
      I2=IXLAB(2)-I1+1
      CALL SYMBL1(XI,BOTX3,HT,XLABEL(I1),0.0D+0,I2)
      GO TO 90
C-----LABELS AND UNITS WITHOUT MULTIPLIER.
   80 CALL SYMBL1(XI,BOTX3,HT,XLABEL(1),0.0D+0,IXLAB(2))
   90 IF(IWAY(1).EQ.1) GO TO 170
C
C     PLOT X SCALE LOG10 DECADES.
C
      IXMIN=XLIM(1)
      IF(XLIM(1).LT.0.0) IXMIN=IXMIN-1
      IXMAX=XLIM(2)+1.0
      NDEC=HTMULT*(XLIM(2)-XLIM(1))
      NSTEPX=1
      IF(NDEC.LE.15) GO TO 100
      ILOG1=10
      KLOG1=10
      NSTEPX=(NDEC+14)/15
      IXSTEP=NSTEPX*(IXMIN/NSTEPX)
      IF(IXSTEP.LT.IXMIN) IXSTEP=IXSTEP+NSTEPX
      IXMIN=IXSTEP
      GO TO 130
  100 IF(NDEC.LE.6) GO TO 110
      ILOG1=5
      KLOG1=5
      GO TO 130
  110 IF(NDEC.LE.3) GO TO 120
      ILOG1=2
      KLOG1=2
      GO TO 130
  120 ILOG1=2
      KLOG1=1
  130 DO 160 I=IXMIN,IXMAX,NSTEPX
      XR=I
      IF(XR.LT.XLIM(1).OR.XR.GT.XLIM(2)) GO TO 140
      XI=((XR-XLIM(1))*XINCHP(2)+
     1 (XLIM(2)-XR)*XINCHP(1))/(XLIM(2)-XLIM(1))
      CALL SYMBL1(XI-WT,BOT2,HT,TIME10(1),0.0D+0,2)
      CALL NUMBR1(XI+WT,BOT1,HT,XR,0.0D+0,-1)
  140 IF(ILOG1.GT.9) GO TO 160
      DO 150 J=ILOG1,9,KLOG1
      XZ=XR+TABLOG(J)
      IF(XZ.LT.XLIM(1).OR.XZ.GT.XLIM(2)) GO TO 150
      XI=((XZ-XLIM(1))*XINCHP(2)+
     1 (XLIM(2)-XZ)*XINCHP(1))/(XLIM(2)-XLIM(1))
      CALL SYMBL1(XI-WT38,BOT1,HT34,DIGITS(J),0.0D+0,1)
  150 CONTINUE
  160 CONTINUE
      GO TO 200
C
C     PLOT X SCALE LINEAR UNITS.
C
  170 XR=XBASE
C-----DEFINE OFFSET FOR NUMBER OF DIGITS AFTER DECIMAL POINT.
      XIOFF=WTH
      IF(IXSTEP.EQ.1) XIOFF=XIOFF+WT
      IF(IXSTEP.EQ.2) XIOFF=XIOFF+WTH
c-----13/07/24 - extended to 3 digits after decimal point
      IF(IXSTEP.EQ.3) XIOFF=XIOFF+WTH+WT
C-----ONLY PLOT WITHIN LIMITS OF PLOT.
  180 IF(XR.LT.XLIM(1)) GO TO 190
      IF(XR.GT.XLIM(2)) GO TO 200
      XI=((XR-XLIM(1))*XINCHP(2)+
     1 (XLIM(2)-XR)*XINCHP(1))/(XLIM(2)-XLIM(1))
      XI=XI-XIOFF
C-----DEFINE OFFSET NEGATIVE NUMBERS AND DIGITS PRECEDING DECIMAL POINT.
      IF(XR.LT.0.0) XI=XI-WTH
      IF(DABS(XR).GE.10.0) XI=XI-WTH
      IF(DABS(XR).GE.100.0) XI=XI-WTH
      CALL NUMBR1(XI,BOT1,HT,XR,0.0D+0,IXSTEP)
  190 XR=XR+XSTEP1
      GO TO 180
C
C     PLOT Y AXIS LABEL AND UNITS (DIFFERENT FOR DATA AND RATIO).
C
  200 IF(NPLOT.EQ.1) GO TO 210
C-----RATIO.
      YI=YMID-6.0*WTH
      CALL SYMBL1(XLEFTX,YI,HT,RATBCD(1),90.0D+0,6)
      GO TO 240
C-----DATA.
  210 YI=YMID-WTH*FLOAT(NYLAB(2))
      XLEFTX=XLEFT2
      IF(IWAY(2).EQ.2) XLEFTX=XLEFTX-HT
      IF(IYMULT.EQ.0) GO TO 230
C-----ADD MULTIPLIER BEFORE UNITS.
      ZYMULT=IYMULT
      IZLAB=4
      IF(IABS(IYMULT).GE.10) IZLAB=5
      IF(IYMULT.LT.0) IZLAB=IZLAB+1
      YI=YI-WTH*FLOAT(IZLAB)
      IF(IYLAB(2).GT.IYLAB(1)) GO TO 220
C-----NO UNITS. LABEL FOLLOWED BY (.
      CALL SYMBL1(XLEFTX,YI,HT,YLABEL(1),90.0D+0,IYLAB(1))
      YI=YI+WT*FLOAT(NYLAB(1)+1)
      CALL SYMBL1(XLEFTX,YI,HT,PARENL(1),90.0D+0,1)
C-----MULTIPLIER FOLLOWED BY ).
      YI=YI+WT
      CALL SYMBL1(XLEFTX,YI,HT,TIME10(1),90.0D+0,2)
      YI=YI+2.0*WT
      CALL NUMBR1(XLEFTX-0.75*HT,YI,HT,ZYMULT,90.0D+0,-1)
      YI=YI+WT*FLOAT(IZLAB-2)
      CALL SYMBL1(XLEFTX,YI,HT,PARENR(1),90.0D+0,1)
      GO TO 240
C-----LABEL FOLLOWED BY (.
  220 CALL SYMBL1(XLEFTX,YI,HT,YLABEL(1),90.0D+0,IYLAB(1)+2)
C-----MULTIPLIER.
      YI=YI+WT*FLOAT(NYLAB(1)+2)
      CALL SYMBL1(XLEFTX,YI,HT,TIME10(1),90.0D+0,2)
      YI=YI+2.0*WT
      CALL NUMBR1(XLEFTX-0.75*HT,YI,HT,ZYMULT,90.0D+0,-1)
C-----UNITS.
      YI=YI+WT*FLOAT(IZLAB-2)
      I1=IYLAB(1)+3
      I2=IYLAB(2)-I1+1
      CALL SYMBL1(XLEFTX,YI,HT,YLABEL(I1),90.0D+0,I2)
      GO TO 240
C-----LABELS AND UNITS WITHOUT MULTIPLIER.
  230 CALL SYMBL1(XLEFTX,YI,HT,YLABEL(1),90.0D+0,IYLAB(2))
  240 IF(IWAY(2).EQ.1) GO TO 320
C
C     PLOT Y SCALE LOG10 DECADES.
C
      IYMIN=YLIM(1)
      IF(YLIM(1).LT.0.0) IYMIN=IYMIN-1
      IYMAX=YLIM(2)+1.0
      NDEC=HTMULT*(YLIM(2)-YLIM(1))
      NSTEPY=1
      IF(NDEC.LE.15) GO TO 250
      ILOG1=10
      KLOG1=10                                      ! step = 10
      NSTEPY=(NDEC+14)/15
      IYSTEP=NSTEPY*(IYMIN/NSTEPY)
      IF(IYSTEP.LT.IYMIN) IYSTEP=IYSTEP+NSTEPY
      IYMIN=IYSTEP
      GO TO 280
  250 IF(NDEC.LE.6) GO TO 260
      ILOG1=5
      KLOG1=5                                       ! step = 5
      GO TO 280
  260 IF(NDEC.LE.3) GO TO 270
      ILOG1=2
      KLOG1=2                                       ! step = 2
      GO TO 280
  270 ILOG1=2
      KLOG1=1                                       ! step = 1
  280 DO 310 I=IYMIN,IYMAX,NSTEPY
      YR=I
      IF(YR.LT.YLIM(1).OR.YR.GT.YLIM(2)) GO TO 290
      YI=((YR-YLIM(1))*YINCHP(2)+
     1 (YLIM(2)-YR)*YINCHP(1))/(YLIM(2)-YLIM(1))
      CALL SYMBL1(XLEFT1,YI,HT,TIME10(1),0.0D+0,2)
      CALL NUMBR1(XLEFT1+2.0*WT,YI+HT,HT,YR,0.0D+0,-1)
  290 IF(ILOG1.GT.9) GO TO 310
      DO 300 J=ILOG1,9,KLOG1
      YZ=YR+TABLOG(J)
      IF(YZ.LT.YLIM(1).OR.YZ.GT.YLIM(2)) GO TO 300
      YI=((YZ-YLIM(1))*YINCHP(2)+
     1 (YLIM(2)-YZ)*YINCHP(1))/(YLIM(2)-YLIM(1))
C-----PREVENT WRITING CHARACTERS ONE OVER THE OTHER.
      IF(YI.LE.TOPY) GO TO 300
      CALL SYMBL1(XLEFT1+5.0*WT,YI,HT34,DIGITS(J),0.0D+0,1)
      TOPY=YI+1.2*HT34
  300 CONTINUE
  310 CONTINUE
      GO TO 350
C
C     PLOT Y SCALE LINEAR UNITS.
C
  320 YR=YBASE
C-----DEFINE OFFSET FOR NUMBER OF DIGITS AFTER DECIMAL POINT.
      XIOFF=WT
c-----13/07/24 - extended to 3 digits after decimal point
      IF(IYSTEP.LT.0) XIOFF=XIOFF-3.0*WT
      IF(IYSTEP.EQ.1) XIOFF=XIOFF-WT
      IF(IYSTEP.EQ.2) XIOFF=XIOFF+WTH
      IF(IYSTEP.EQ.3) XIOFF=XIOFF+WT
C-----ONLY PLOT WITHIN LIMITS OF PLOT.
  330 IF(YR.LT.YLIM(1)) GO TO 340
      IF(YR.GT.YLIM(2)) GO TO 350
      YI=((YR-YLIM(1))*YINCHP(2)+
     1 (YLIM(2)-YR)*YINCHP(1))/(YLIM(2)-YLIM(1))
C-----PREVENT WRITING CHARACTERS ONE OVER THE OTHER.
      IF(YI.LE.TOPY) GO TO 340
      XI=XLEFT1-XIOFF
C-----DEFINE OFFSET NEGATIVE NUMBERS AND DIGITS PRECEDING DECIMAL POINT.
      IF(YR.GE.0.0) XI=XI+WT
      IF(DABS(YR).LT.100.0) XI=XI+WT
      IF(DABS(YR).LT.10.0) XI=XI+WT
      CALL NUMBR1(XI,YI,HT,YR,0.0D+0,IYSTEP)
      TOPY=YI+1.2*HT
  340 YR=YR+YSTEP1
      GO TO 330
  350 RETURN
      END
      SUBROUTINE ZNORM(Z,ZMULT,IZRANG,IZWAY)
C=================================================================
C
C     DEFINE MULTIPLIER AND UNITS TO PUT ENERGY IN NORMAL FORM
C     NORMAL FORM = 1 TO 3 DIGITS PRECEDING DECIMAL POINT.
C     E.G., 1.2E-12 IS SCALED TO 1.2 WITH AN EXPONENT OF -12.
C
C=================================================================
      INCLUDE 'implicit.h'
C-----USE STANDARD UNITS FOR LOG SCALING.
      IZRANG=0
      ZMULT=1.0
      IF(IZWAY.EQ.2) RETURN
C-----USE STANDARD UNITS IF NUMBER IS BETWEEN 0.1 AND 999.0
      IF(Z.GE.0.1.AND.Z.LE.999.0) RETURN
C-----SELECT MULTIPLIER.
      IF(Z.LT.1.0) GO TO 20
      ZRANGE=1000.0
      IZRANG=0
   10 IF(Z.LT.ZRANGE) GO TO 40
      ZRANGE=1000.0*ZRANGE
      IZRANG=IZRANG+3
      GO TO 10
   20 ZRANGE=0.001
      IZRANG=-3
   30 IF(Z.GE.ZRANGE) GO TO 50
      ZRANGE=0.001*ZRANGE
      IZRANG=IZRANG-3
      GO TO 30
   40 ZRANGE=ZRANGE/1000.0
   50 ZMULT=1.0/ZRANGE
      RETURN
      END
      SUBROUTINE CURVED(X,CURVE1,IMOK)
C=================================================================
C
C     DEFINE VALUE OF STANDARD CURVE (CURVE1) AT X.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/TERPIT/INTERD,INTERR
      COMMON/CNEXT/NEXTC,ISTAR1,IEND1,JSTAR1,KSTAR1,MSTAR1
      INCLUDE 'plottab.h'
C-----ASSUME FOUND O.K.
      IMOK = 1
c-----CHECK FOR START OF X RANGE
      IF(X.eq.XCURVE(ISTAR1)) then
      CURVE1 = YCURVE(ISTAR1)
      MSTAR1=ISTAR1+1
      RETURN
      ENDIF
c-----CHECK FOR END OF X RANGE
      IF(X.eq.XCURVE(IEND1)) then
      CURVE1 = YCURVE(IEND1)
      MSTAR1=ISTAR1
      RETURN
      ENDIF
C-----CHECK FOR X IN RANGE OF FIRST CURVE.
      IF(X.lt.XCURVE(ISTAR1).or.X.gt.XCURVE(IEND1)) go to 70
C
C     IN X RANGE OF THE FIRST CURVE - SEARCH FOR Y VALUE
C
      IF(X.eq.XCURVE(MSTAR1)) go to 50
      IF(X.gt.XCURVE(MSTAR1)) go to 10
c-----X < XCURVE(MSTAR1) - SEARCH FROM START OF ENERGY
      MSTAR=ISTAR1
      GO TO 20
c-----X >= XCURVE(MSTAR1) - SEARCH UP IN ENERGY = first point above X.
   10 MSTAR=MSTAR1
   20 DO 30 IPT1=MSTAR,IEND1
      IF(X.lt.XCURVE(IPT1)) go to 40
      IF(X.eq.XCURVE(IPT1)) go to 60
   30 CONTINUE
c-----OUT OF X RANGE???
      GO TO 70
C-----BETWEEN POINTS - INTERPOLATE TO DEFINE VALUE.
   40 CURVE1=TERPUP(X,XCURVE(IPT1-1),XCURVE(IPT1),YCURVE(IPT1-1),
     1 YCURVE(IPT1),INTERD)
C-----RESET INDEX TO FIRST CURVE = start of same interval.
      IF(IPT1.le.ISTAR1) THEN
      MSTAR1 = ISTAR1
      ELSE
      MSTAR1=IPT1-1
      ENDIF
      RETURN
C-----MATCH TO CURRENT START POINT.
   50 IPT1=MSTAR1
C-----MATCH TO TABULATED VALUE.
   60 CURVE1=YCURVE(IPT1)
C-----INCREMENT INDEX TO FIRST CURVE.
      MSTAR1=IPT1+1
      IF(MSTAR1.GT.IEND1) MSTAR1=IEND1
      RETURN
C
C     OUT OF X RANGE - all cases
C
   70 IMOK=0
      CURVE1=0.0
      MSTAR1=ISTAR1
      RETURN
      END
      FUNCTION TERPUP(X,X1,X2,Y1,Y2,INTERP)
C=================================================================
C
C     INTERPOLATE DATA ASSUMING AN INTERPOLATION LAW OF
C     INTERP = 1 - LIN-X VS. LIN-Y
C              2 - LIN-X VS. LOG-Y
C              3 - LOG-X VS. LIN-Y
C              4 - LOG-X VS. LOG-Y
C
C     IN ORDER TO MINIMIZE THE NUMBER OF OPERATIONS REQUIRED AND ALSO
C     TO IMPROVE NUMERICAL STABILITY, IN ALL CASES THE INTERPOLATED
C     VALUE WILL BE DEFINED AS A WEIGHTED SUM OF THE CONTRIBUTIONS
C     FROM THE 2 ENDS OF THE INTERVAL AND IN ALL CASES THE SUM OF THE
C     WEIGHTS WILL ALWAYS TO EXACTLY 1.0
C
C     THIS ROUTINE WILL TRY TO HANDLE ALL ODD BALL SITUATIONS AS
C     FOLLOWS,
C
C     IF NO X INTERVAL (X1 = X2) RETURN THE AVERAGE OF Y1 AND Y2
C
C     IF Y IS CONSTANT (Y1 = Y2) RETURN Y1
C
C     IF LOG INTERPOLATION IS NOT POSSIBLE SWITCH TO LINEAR (THIS
C     APPLIES TO X AND/OR Y)
C
C     IF THE INTERPOLATION CODE IS NOT 1 TO 4 USE LIN X LIN Y
C
C=================================================================
      INCLUDE 'implicit.h'
      DATA ONE/1.0E+00/
C-----IF NO X INTERVAL RETURN AVERAGE VALUE.
      IF(X1.NE.X2) GO TO 10
      TERPUP=(Y1+Y2)/2.0
      RETURN
C-----IF CONSTANT Y RETURN VALUE.
   10 IF(Y1.NE.Y2) GO TO 20
      TERPUP=Y1
      RETURN
C-----IF UNDEFINED INTERPOLATION USE LIN X LIN Y
   20 KTERP=INTERP
      IF(KTERP.LT.1.OR.KTERP.GT.4) KTERP=1
      GO TO (30,50,60,80),KTERP
C-----LIN X LIN Y
   30 WT1=(X-X2)/(X1-X2)
      WT2=ONE-WT1
   40 TERPUP=WT1*Y1+WT2*Y2
      RETURN
C-----LIN X LOG Y
   50 WT1=(X-X2)/(X1-X2)
      WT2=ONE-WT1
C-----IF LOG Y NOT POSSIBLE USE LIN Y
      IF(Y1.LE.0.0.OR.Y2.LE.0.0) GO TO 40
      TERPUP=DEXP(WT1*DLOG(Y1)+WT2*DLOG(Y2))
      RETURN
C-----LOG X LIN Y...IF LOG X NOT POSSIBLE USE LIN X
   60 IF(X.LE.0.0.OR.X1.LE.0.0.OR.X2.LE.0.0) GO TO 30
      WT1=DLOG(X/X2)/DLOG(X1/X2)
      WT2=ONE-WT1
   70 TERPUP=WT1*Y1+WT2*Y2
      RETURN
C-----LOG X LOG Y...IF LOG X NOT POSSIBLE USE LIN X
   80 IF(X.LE.0.0.OR.X1.LE.0.0.OR.X2.LE.0.0) GO TO 50
      WT1=DLOG(X/X2)/DLOG(X1/X2)
      WT2=ONE-WT1
C-----IF LOG Y NOT POSSIBLE USE LIN Y
      IF(Y1.LE.0.0.OR.Y2.LE.0.0) GO TO 70
      TERPUP=DEXP(WT1*DLOG(Y1)+WT2*DLOG(Y2))
      RETURN
      END
      SUBROUTINE PLTCUR
C=================================================================
C
C     PLOT CONTINUOUS CURVES (IF ANY)
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 TITLEC
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/CTITLE/TITLEC(40,30)
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/NEEDED/YNEEDS(3)
      COMMON/SPOTS/TOP2,TOP3,BOT1,BOT2,BOT3,XLEFT1,XLEFT2,RIGHT3,
     1 RIGHT4,RIGHT5,RIGHT6,RIGHT7,RIGHT8,RIGHT9
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/TERPIT/INTERD,INTERR
      COMMON/THICKY/THICK,ITHICK,NTHICK(3)
      COMMON/XYREAL/XREAL(2),YREAL(2)
      COMMON/LEGOFF/NOLEGS
      COMMON/REMAST/MASTER
      COMMON/THICKX/KTHICK(3)
      COMMON/SHOWPT/MYSHOW
      INCLUDE 'plottab.h'
      ITHICK=NTHICK(2)
C-----RETURN IS NO CONTINUOUS CURVES.
      IF(NUMCUR.LE.0) RETURN
C-----SAVE LINE THICKNESSES.
      DO 10 I=1,3
      KTHICK(I)=NTHICK(I)
   10 CONTINUE
C-----INITIALIZE LINE TYPE AND COLOR.
      LININ=0
      ICOLOR=2
      YNEED=YNEEDS(1)
C-----SELECT DATA OR RATIOS.
      IF(NPLOT.EQ.1) GO TO 20
      KMIN=NUMCUR+1
      KMAX=NUMCUR+NUMCUR
      INTERX=INTERR
      GO TO 30
   20 KMIN=1
      KMAX=NUMCUR
      INTERX=INTERD
C-----SET UP LOOP OVER CURVES.
   30 DO 140 KCURVE=KMIN,KMAX
C-----INCREMENT LINE TYPE AND COLOR AND SET COLOR.
      LININ=LININ+1
      LINTYP=LININ
      ICOLOR=ICOLOR+1
C-----IGNORE IF CURVE NOT IN ENERGY RANGE.
      IF(IMONC(KCURVE).LE.0) GO TO 140
      CALL PEN(ICOLOR)
C-----SOLID LINE FOR MASTER CURVE
      IF(LININ.EQ.MASTER) LINTYP=1
C-----IDENTIFY REFERENCE (ONLY FOR DATA).
      IF(NPLOT.NE.1.OR.NOLEGS.NE.0) GO TO 40
      YMID=YNEED+0.5*HT
C-----THICK LINE FOR MASTER CURVE
      ITHICK=NTHICK(2)
      CALL DASH(RIGHT6,YMID,3,LINTYP)
      CALL DASH(RIGHT9,YMID,2,LINTYP)
C-----RESET LINE THICKNESS FOR LABEL (NO THICK MASTER LABEL).
      NTHICK(2)=KTHICK(2)
      ITHICK=NTHICK(2)
      CALL SYMBL1(RIGHT5,YNEED,HT,TITLEC(1,KCURVE),0.0D+0,ITITC(KCURVE))
      YNEED=YNEED-1.75*HT
C-----INITIALIZE IPEN TO MOVE (NOT DRAW) TO FIRST POINT.
   40 IPEN=3
C-----THICK SOLID CURVE FOR MASTER
      ITHICK=NTHICK(2)
C-----DEFINE LOWER AND UPPER POINT INDICES FOR NEXT CURVE AND PLOT IT.
      ISTARK=LIMCUR(1,KCURVE)
      IENDK=LIMCUR(2,KCURVE)
C-----IF REQUESTED, SHOW DATA POINT.
      IF(MYSHOW.LE.0) GO TO 60
C-----ONLY SHOW POINTS THAT ARE WITHIN THE PLOTTING AREA.
      DO 50 I=ISTARK,IENDK
      XS=XCURVE(I)
      YS=YCURVE(I)
      IF(XS.le.XREAL(1)) go to 50
      IF(XS.ge.XREAL(2)) go to 60
      IF(YS.LE.YREAL(1).OR.YS.GE.YREAL(2)) GO TO 50
      CALL PTSHOW(XS,YS)
   50 CONTINUE
C-----PLOT CURVE.
   60 IPASS=0
      DO 130 I=ISTARK,IENDK
   70 LOOP=-1
      XS=XCURVE(I)
      YS=YCURVE(I)
C-----IGNORE POINTS BELOW REQUESTED X RANGE (SAVE X,Y FOR INTERPOLATION)
      IF(XS.lt.XREAL(1)) go to 120
      IF(XS.eq.XREAL(1)) go to 110
C-----IF NECESSARY INTERPOLATE TO LOWER LIMIT OF PLOT.
      IF(IPASS.GT.0) GO TO 90
      IF(I.NE.ISTARK) GO TO 80
C-----IF FIRST POINT IF ABOVE UPPER LIMIT OF PLOT SKIP REMAINDER OF
C-----CURVE....OTHERWISE MOVE TO IT.
      IF(XS.lt.XREAL(2)) go to 110
      go to 140
   80 YS=TERPUP(XREAL(1),XLASTK,XS,YLASTK,YS,INTERX)
      XS=XREAL(1)
      LOOP=0
      GO TO 110
C-----IF NECESSARY INTERPOLATE TO UPPER LIMIT OF PLOT.
   90 IF(XS.lt.XREAL(2)) go to 110
      IF(XS.eq.XREAL(2)) go to 100
      IF(IPASS.EQ.0) GO TO 140
      YS=TERPUP(XREAL(2),XLASTK,XS,YLASTK,YS,INTERX)
      XS=XREAL(2)
  100 LOOP=1
C-----INDICATE CURVE ON PLOT. SCALE, MOVE OR DRAW.
  110 IPASS=1
      CALL CLIPY(XS,YS,IPEN,LINTYP)
      IPEN=2
C-----IF INTERPOLATING CHOOSE SAME POINT AGAIN.
      IF(LOOP.eq.0) go to 70
      IF(LOOP.gt.0) go to 140
C-----SAVE LAST POINT FOR INTERPOLTATION.
  120 XLASTK=XCURVE(I)
      YLASTK=YCURVE(I)
  130 CONTINUE
  140 CONTINUE
C-----RESTORE LINE THICKNESSES.
      DO 150 I=1,3
      NTHICK(I)=KTHICK(I)
  150 CONTINUE
      RETURN
      END
      SUBROUTINE PTSHOW(XS,YS)
C=================================================================
C
C     SHOW DATA POINT FROM A CURVE
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/WAYS/IWAY(2)
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
C-----DEFINE FOR INTERNAL USE
      XP=XS
      YP=YS
C-----SCALE TO THE PLANE OF THE DATA
      IF(IWAY(1).EQ.2) XP=DLOG10(XP)
      IF(IWAY(2).EQ.2) YP=DLOG10(YP)
      XP=XP*XMULT
      YP=YP*YMULT
      XP=((XP-XLIM(1))*XINCHP(2)+(XLIM(2)-XP)*XINCHP(1))/DXLIM
      YP=((YP-YLIM(1))*YINCHP(2)+(YLIM(2)-YP)*YINCHP(1))/DYLIM
C-----DEFINE CORNERS OF DIAMOND.
      DPT=0.20*BOX
      XP1=XP-DPT
      XP2=XP+DPT
      YP1=YP-DPT
      YP2=YP+DPT
C-----IGNORE IF INSIDE LEGEND BOX.
      IF(XP2.LT.BOXMIN.OR.XP1.GT.BOXMAX) GO TO 10
      IF(YP2.LT.BOYMIN.OR.YP1.GT.BOYMAX) GO TO 10
      RETURN
C-----DRAW POINT.
   10 CALL PLOT1(XP1,YP,3)
      CALL PLOT1(XP,YP2,2)
      CALL PLOT1(XP2,YP,2)
      CALL PLOT1(XP,YP1,2)
      CALL PLOT1(XP1,YP,2)
      RETURN
      END
      SUBROUTINE PLTPT
C=================================================================
C
C     PLOT DISCRETE POINTS (IF ANY)
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 TITLEP
      COMMON/WAYS/IWAY(2)
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/PTITLE/TITLEP(40,30)
      COMMON/TITLEI/ITITS(2),ITITC(30),ITITP(30),NTITS(2),NTITC(30),
     1 NTITP(30)
      COMMON/NEEDED/YNEEDS(3)
      COMMON/SPOTS/TOP2,TOP3,BOT1,BOT2,BOT3,XLEFT1,XLEFT2,RIGHT3,
     1 RIGHT4,RIGHT5,RIGHT6,RIGHT7,RIGHT8,RIGHT9
      COMMON/PAINT/BOX,BOX2,HT,HT34,WT,WTH,WT38
      COMMON/ONIT/IMONC(60),IMONP(60),JMONC,JMONP
      COMMON/ERRBAR/IXBAR,IYBAR
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/XYREAL/XREAL(2),YREAL(2)
      COMMON/LEGOFF/NOLEGS
      INCLUDE 'plottab.h'
C-----RETURN IF NO DISCRETE POINTS.
      IF(NUMSET.LE.0) RETURN
C-----SELECT SYMBOL SIZE BASED ON NUMBER OF DISCRETE POINTS.
      BOXU=4.0*BOX
      IF(LIMPT(2,NUMSET).GE. 100) BOXU=0.5*BOXU
      IF(LIMPT(2,NUMSET).GE. 600) BOXU=0.5*BOXU
      IF(LIMPT(2,NUMSET).GE.3600) BOXU=0.5*BOXU
C-----INITIALIZE COLOR AND REFERENCE INDEX.
C-----2016/11/30 - Switched from 2+NUMCUR to 2 (same color curve+points)
c     ICOLOR=2+NUMCUR
      ICOLOR=2
      KCHAR=0
      YNEED=YNEEDS(2)
C-----SELECT DATA OR RATIOS.
      IF(NPLOT.EQ.1) GO TO 10
      KMIN=NUMSET+1
      KMAX=NUMSET+NUMSET
      GO TO 20
   10 KMIN=1
      KMAX=NUMSET
C-----SET UP LOOP OVER REFERENCES.
   20 DO 110 KSET=KMIN,KMAX
C-----INCREMENT COLOR AND REFERENCE INDEX.
      ICOLOR=ICOLOR+1
      KCHAR=KCHAR+1
C-----IGNORE IF NO POINTS ON PLOT.
      IF(IMONP(KSET).LE.0) GO TO 110
C-----IGNORE IF NO POINTS IN REQUESTED X RANGE.
      IF(IMONP(KSET).LE.0) GO TO 110
C-----DEFINE COLOR.
      CALL PEN(ICOLOR)
C-----DEFINE LOWER AND UPPER POINT INDICES.
      ISTARK=LIMPT(1,KSET)
      IENDK=LIMPT(2,KSET)
C-----IDENTIFY REFERENCE TO THE RIGHT OF THE PLOT.
      IF(NPLOT.NE.1.OR.NOLEGS.NE.0) GO TO 30
      XMID=(RIGHT7+RIGHT8)/2.0
      YMID=YNEED+0.5*HT
C-----TEMPORARILY MOVE LEGEND BOX OFF PLOT.
      BOXMIN=-BOXMIN
      BOXMAX=-BOXMAX
      CALL SYMREF(XMID,XMID,XMID,YMID,YMID,YMID,BOXU,KCHAR)
      CALL SYMBL1(RIGHT5,YNEED,HT,TITLEP(1,KCHAR),0.0D+0,ITITP(KCHAR))
C-----RESTORE LEGEND BOX.
      BOXMIN=-BOXMIN
      BOXMAX=-BOXMAX
      YNEED=YNEED-1.75*HT
   30 DO 100 I=ISTARK,IENDK
C-----ONLY SELECT POINTS IN REQUESTED X AND Y RANGE.
      XS=XPT(I)
      YS=YPT(I)
      IF(XS.LT.XREAL(1)) GO TO 100
      IF(XS.GT.XREAL(2)) GO TO 100
      IF(YS.LT.YREAL(1)) GO TO 100
      IF(YS.GT.YREAL(2)) GO TO 100
C-----IF ERROR BARS ARE NOT REQUESTED IGNORE THEM.
      IF(IXBAR.NE.0) GO TO 40
      XSP=XS
      XSM=XS
      GO TO 50
   40 XSP=XS+DXPTP(I)
      XSM=XS-DXPTM(I)
      IF(XSM.LT.XREAL(1)) XSM = XREAL(1)
      IF(XSP.GT.XREAL(2)) XSP = XREAL(2)
   50 IF(IYBAR.NE.0) GO TO 60
      YSP=YS
      YSM=YS
      GO TO 70
   60 YSP=YS+DYPTP(I)
      YSM=YS-DYPTM(I)
      IF(YSM.LT.YREAL(1)) YSM = YREAL(1)
      IF(YSP.GT.YREAL(2)) YSP = YREAL(2)
C-----IF NECESSARY CONVERT TO LOGS.
   70 IF(IWAY(1).EQ.1) GO TO 80
      XS=DLOG10(XS)
      XSP=DLOG10(XSP)
      XSM=DLOG10(XSM)
   80 IF(IWAY(2).EQ.1) GO TO 90
      YS=DLOG10(YS)
      YSP=DLOG10(YSP)
      YSM=DLOG10(YSM)
C-----SCALE DATA.
   90 XS=XS*XMULT
      XSP=XSP*XMULT
      XSM=XSM*XMULT
      YS=YS*YMULT
      YSP=YSP*YMULT
      YSM=YSM*YMULT
C-----DEFINE COORDINATES IN PLANE OF THE PLOT.
      XI=((XS-XLIM(1))*XINCHP(2)+(XLIM(2)-XS)*XINCHP(1))/DXLIM
      XIP=((XSP-XLIM(1))*XINCHP(2)+(XLIM(2)-XSP)*XINCHP(1))/DXLIM
      XIM=((XSM-XLIM(1))*XINCHP(2)+(XLIM(2)-XSM)*XINCHP(1))/DXLIM
      YI=((YS-YLIM(1))*YINCHP(2)+(YLIM(2)-YS)*YINCHP(1))/DYLIM
      YIP=((YSP-YLIM(1))*YINCHP(2)+(YLIM(2)-YSP)*YINCHP(1))/DYLIM
      YIM=((YSM-YLIM(1))*YINCHP(2)+(YLIM(2)-YSM)*YINCHP(1))/DYLIM
C-----SKIP POINT IF OUTSIDE X OR Y RANGE OF PLOT.
C-----2014/4/28 - SKIP POINT IF OUTSIDE X RANGE OF PLOT = KEEP Y
      IF(XI.LT.XINCHP(1).OR.XI.GT.XINCHP(2)) GO TO 100
c-----2014/4/28 - Limit Y to Y range of plot.
      IF(YI.LT.YINCHP(1)) YI = YINCHP(1)
      IF(YI.GT.YINCHP(2)) YI = YINCHP(2)
C-----RESTRICT ERROR BARS TO WITHIN X AND Y RANGE OF PLOT.
      IF(XIM.LT.XINCHP(1)) XIM=XINCHP(1)
      IF(XIP.GT.XINCHP(2)) XIP=XINCHP(2)
      IF(YIM.LT.YINCHP(1)) YIM=YINCHP(1)
      IF(YIP.GT.YINCHP(2)) YIP=YINCHP(2)
C-----DRAW SYMBOL AND ERROR BARS.
      CALL SYMREF(XI,XIM,XIP,YI,YIM,YIP,BOXU,KCHAR)
  100 CONTINUE
  110 CONTINUE
      RETURN
      END
      SUBROUTINE DASHN(X2,Y2,IPEN,LINTYP)
C=================================================================
C
C     DRAW THAT PORTION OF A LINE THAT LIES OUTSIDE OF THE LEGEND
C     BOX. THIS SUBROUTINE ASSUMES THAT BY THE TIME THIS SUBROUTINE IS
C     CALLED THE LINE HAS ALREADY BEEN TRUNCATED TO ONLY THAT PORTION
C     OF THE LINE WHICH LIES WITHIN THE PLOTTING AREA.
C
C     THE LINE TO BE DRAWN EXTENDS FROM THE COORDINATES OF THE LAST
C     POINT (X1,Y1) TO THE COORDINATES OF THE CURRENT POINT (X2,Y2).
C     THE LINE MAY BE BLANK (IPEN=3) OR DRAWN (IPEN NOT =3).
C
C     THE BEGINNING OF ANY CURVE TO BE DRAWN MUST BE STARTED BY A
C     CALL TO THIS ROUTINE WITH IPEN=3 (BLANK LINE) IN ORDER TO DEFINE
C     THE INITIALIZE COORDINATES OF THE CURVE.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/LEGOFF/NOLEGS
C-----INITIALIZE COORDINATES OF LAST POINT TO ORIGIN.
      DATA X1/0.0/
      DATA Y1/0.0/
C
C     DEFINE ARITHMETIC STATEMENT FUNCTION FOR LINEAR INTERPOLATION.
C
      TERPX(X)=((X-X1)*Y2+(X2-X)*Y1)/(X2-X1)
      TERPY(Y)=((Y-Y1)*X2+(Y2-Y)*X1)/(Y2-Y1)
C
C     IF LINE IS BLANK OR THE LINE DOES NOT OVERLAP THE LEGEND BOX IN
C     THE X OR Y DIRECTION DRAW ENTIRE LINE.
C
      IF(IPEN.EQ.3.OR.NOLEGS.NE.0) GO TO 150
C
C     NO OVERLAP IF BOTH Y VALUES BELOW OR ABOVE LEGEND BOX.
C
      IF(Y1.LE.BOYMIN.AND.Y2.LE.BOYMIN) GO TO 150
      IF(Y1.GE.BOYMAX.AND.Y2.GE.BOYMAX) GO TO 150
C
C     SIMPLE TREATMENT FOR VERTICAL LINE = X1 = X2
C
      IF(X1.NE.X2) GO TO 60
      IF(X1.LT.BOXMIN.OR.X1.GT.BOXMAX) GO TO 150
      IF(Y1.eq.Y2) go to 160
      IF(Y1.gt.Y2) go to 20
C
C     MOVING BOTTOM TO TOP
C
C-----TO BOTTOM OF BOX.
      IF(Y1.GE.BOXMIN) GO TO 10
      Y1=BOXMIN
      CALL DASH(X1,Y1,2,LINTYP)
C-----ACROSS BOX.
   10 IF(Y2.LE.BOXMAX) GO TO 50
      Y1=BOXMAX
      CALL DASH(X1,Y1,3,LINTYP)
      GO TO 40
C
C     MOVING TOP TO BOTTOM.
C
C-----TO TOP OF BOX.
   20 IF(Y1.LE.BOXMAX) GO TO 30
      Y1=BOXMAX
      CALL DASH(X1,Y1,2,LINTYP)
C-----ACROSS BOX
   30 IF(Y2.GE.BOXMIN) GO TO 50
      Y1=BOXMIN
      CALL DASH(X1,Y1,3,LINTYP)
C-----TO FINAL POINT.
   40 CALL DASH(X1,Y2,2,LINTYP)
   50 Y1=Y2
      RETURN
C
C     NO OVERLAP IF START IS ABOVE OR END IS BELOW.
C
   60 IF(X1.GE.BOXMAX.OR.X2.LE.BOXMIN) GO TO 150
C
C     ADVANCE TO LOWER X LIMIT OF LEGEND BOX (IF NOT ALREADY THERE).
C
      IF(X1.GE.BOXMIN) GO TO 70
      Y1=TERPX(BOXMIN)
      X1=BOXMIN
      CALL DASH(X1,Y1,2,LINTYP)
C
C     CHECK FOR ENTRY INTO LEGEND BOX.
C
C-----CHECK FOR POSSIBLE INTERCEPT TOP OF LEGEND BOX.
   70 IF(Y1.LE.BOYMAX) GO TO 80
      IF(Y2.GE.BOYMAX) GO TO 150
C
C     POSSIBLE INTERCEPT TOP OF LEGEND BOX.
C
      XP=TERPY(BOYMAX)
      IF(XP.GE.X2) GO TO 150
C-----INTERCEPT BEFORE X2. DRAW TO INTERCEPT.
      X1=XP
      Y1=BOYMAX
      CALL DASH(X1,Y1,2,LINTYP)
      GO TO 100
C-----CHECK FOR POSSIBLE INTERCEPT BOTTOM OF LEGEND BOX.
   80 IF(Y1.GE.BOYMIN) GO TO 90
      IF(Y2.LE.BOYMIN) GO TO 150
C
C     POSSIBLE INTERCEPT BOTTOM OF LEGEND BOX.
C
      XP=TERPY(BOYMIN)
      IF(XP.GE.X2) GO TO 150
C-----INTERCEPT BEFORE X2. DRAW TO INTERCEPT.
      X1=XP
      Y1=BOYMIN
      CALL DASH(X1,Y1,2,LINTYP)
      GO TO 110
C-----WITHIN Y RANGE OF BOX. WILL LINE LEAVE AT BOOTOM Y, TOP X OR TOP Y
   90 IF(Y2.eq.Y1) go to 120
      IF(Y2.gt.Y1) go to 110
C
C     CHECK FOR LEAVING LEGEND BOX.
C
C-----LEAVE BOTTOM Y OR TOP X.
  100 XP=TERPY(BOYMIN)
      IF(XP.GT.BOXMAX) XP=BOXMAX
      GO TO 130
C-----LEAVE TOP Y OR TOP X.
  110 XP=TERPY(BOYMAX)
      IF(XP.GT.BOXMAX) XP=BOXMAX
      GO TO 130
C-----LEAVE TOP X.
  120 XP=BOXMAX
C-----IS LINE TO X2 STILL INSIDE LEGEND BOX.
  130 IF(XP.GE.X2) GO TO 140
C
C     LEAVING LEGEND BOX.
C
      Y1=TERPX(XP)
      X1=XP
      CALL DASH(X1,Y1,3,LINTYP)
      GO TO 150
C
C     STILL INSIDE LEGEND BOX.
C
  140 CALL DASH(X2,Y2,3,LINTYP)
      GO TO 160
C
C     MOVE OR DRAW TO FINAL POSITION.
C
  150 CALL DASH(X2,Y2,IPEN,LINTYP)
C
C     SAVE COORDINATES FOR NEXT CALL.
C
  160 X1=X2
      Y1=Y2
      RETURN
      END
      SUBROUTINE CLIPY(X2,Y2,IPEN,LINTYP)
C=================================================================
C
C     RESTRICT Y TO Y RANGE OF PLOT.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYREAL/XREAL(2),YREAL(2)
      COMMON/TERPIT/INTERD,INTERR
      DIMENSION INTERX(4)
      DATA INTERX/1,3,2,4/
C
C     DEFINE WHETHER CURRENT POINT IS ABOVE, ON OR BELOW PLOTTING AREA.
C
      IF(Y2.LE.YREAL(2)) GO TO 10
      IMON2=1
      GO TO 30
   10 IF(Y2.GE.YREAL(1)) GO TO 20
      IMON2=-1
      GO TO 30
   20 IMON2=0
   30 IF(IPEN.NE.2) GO TO 130
C
C     DETERMINE WHETHER OR NOT LINE FROM LAST POINT TO CURRENT POINT
C     CROSSES LOWER AND/OR UPPER Y LIMITS.
C
      IF(IMON1.eq.0) go to 40
      IF(IMON1.gt.0) go to 50
      IF(IMON2.lt.0) go to 140
      IF(IMON2.eq.0) go to 60
      go to 70
   40 IF(IMON2.lt.0) go to 80
      IF(IMON2.eq.0) go to 100
      go to 90
   50 IF(IMON2.lt.0) go to 120
      IF(IMON2.eq.0) go to 110
      go to 140
C
C     LAST POINT WAS BELOW PLOTTING AREA.
C
C-----LINE CROSSES BOTTOM OF PLOT.
   60 X1=TERPUP(YREAL(1),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(1)
      CALL DASHP(X1,Y1,3,LINTYP)
      CALL DASHP(X2,Y2,2,LINTYP)
      GO TO 140
C-----LINE CROSSES BOTTOM AND TOP OF PLOT.
   70 X1=TERPUP(YREAL(1),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(1)
      CALL DASHP(X1,Y1,3,LINTYP)
      X1=TERPUP(YREAL(2),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(2)
      CALL DASHP(X1,Y1,2,LINTYP)
      GO TO 140
C
C     LAST POINT WAS ON PLOTTING AREA.
C
C-----LINE CROSSES BOTTOM OF PLOT.
   80 X1=TERPUP(YREAL(1),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(1)
      CALL DASHP(X1,Y1,2,LINTYP)
      GO TO 140
C-----LINE CROSSES TOP OF PLOT.
   90 X1=TERPUP(YREAL(2),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(2)
      CALL DASHP(X1,Y1,2,LINTYP)
      GO TO 140
C-----ENTIRE LINE IS ON PLOT.
  100 CALL DASHP(X2,Y2,2,LINTYP)
      GO TO 140
C
C     LAST POINT WAS ABOVE PLOTTING AREA.
C
C-----LINE CROSSES TOP OF PLOT.
  110 X1=TERPUP(YREAL(2),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(2)
      CALL DASHP(X1,Y1,3,LINTYP)
      CALL DASHP(X2,Y2,2,LINTYP)
      GO TO 140
C-----LINE CROSSES TOP AND BOTTOM OF PLOT.
  120 X1=TERPUP(YREAL(2),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(2)
      CALL DASHP(X1,Y1,3,LINTYP)
      X1=TERPUP(YREAL(1),Y1,Y2,X1,X2,INTERX(INTERD))
      Y1=YREAL(1)
      CALL DASHP(X1,Y1,2,LINTYP)
      GO TO 140
C-----MOVE. ONLY DO IN CURRENT POINT IS ON PLOT.
  130 IF(IMON2.EQ.0) CALL DASHP(X2,Y2,IPEN,LINTYP)
C-----SAVE COORDINATES AND BELOW/ON/OVER FLAG.
  140 X1=X2
      Y1=Y2
      IMON1=IMON2
      RETURN
      END
      SUBROUTINE DASHP(X2,Y2,IPEN,LINTYP)
C=================================================================
C
C     STARTING FROM (X2,Y2) IN THE PLANE OF THE DATA TRANSFORM THE
C     COORDINATES TO THE PLANE OF THE PLOT AND PLOT ONE OF 30
C     POSSIBLE TYPES OF DASHED LINE FROM THE LAST POINT TO THE
C     COORDINATES DEFINED BY (X2,Y2). LINTYP DEFINES THE TYPE OF
C     DASHING.
C
C     ASSUMING THE DATA IS LINEARLY INTERPOLABLE, IF THE PLOT IS NOT
C     LINEAR-LINEAR AND POINTS ARE TOO FAR APART INTERPOLATE DATA ONTO
C     THE PLOT IN SMALL STEPS TO OBTAIN A SMOOTH CURVE.
C
C     INTERPOLATION MAY BE TURNED OFF BY PROGRAM INPUT (SEE, INPUT
C     DESCRIPTION AT BEGINNING OF PROGRAM).
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/WAYS/IWAY(2)
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      DATA RASTER/0.01/
      DATA DINMAX/0.05/
C-----DEFINE COORDINATES FOR INTERNAL USE.
      XS=X2
      YS=Y2
C-----TRANSFORM TO PLANE OF THE DATA.
      IF(IWAY(1).EQ.2) XS=DLOG10(XS)
      IF(IWAY(2).EQ.2) YS=DLOG10(YS)
      XS=XS*XMULT
      YS=YS*YMULT
      XINOW=((XS-XLIM(1))*XINCHP(2)+(XLIM(2)-XS)*XINCHP(1))/DXLIM
      YINOW=((YS-YLIM(1))*YINCHP(2)+(YLIM(2)-YS)*YINCHP(1))/DYLIM
C-----RESTRICT Y TO WITHIN Y RANGE OF PLOT.
      IF(YINOW.LT.YINCHP(1)) YINOW=YINCHP(1)
      IF(YINOW.GT.YINCHP(2)) YINOW=YINCHP(2)
C-----NO INTERPOLATION REQUIRED IF BEAM IS OFF OR PLOT IS LIN-LIN OR NO
C-----INTERPOLATION REQUESTED.
      IF(IPEN.NE.2) GO TO 60
      IF(IWAY(1).EQ.1.AND.IWAY(2).EQ.1) GO TO 60
      IF(IWANT(1).EQ.-2.OR.IWANT(2).EQ.-2) GO TO 60
C-----COMPUTE INCH CHANGES IN X AND Y DIRECTION.
      DXINCH=XINOW-XILAST
      DYINCH=YINOW-YILAST
C-----NO INTERPOLATION IF X OR Y CHANGE IS LESS THAN ONE RASTER POINT
C-----SPACING.
      ABSDX=DABS(DXINCH)
      ABSDY=DABS(DYINCH)
      IF(ABSDX.LE.RASTER.OR.ABSDY.LE.RASTER) GO TO 60
C-----SELECT LARGEST INCH CHANGE. IF LESS THAN ALLOWABLE LENGTH
C-----NO INTERPOLATION REQUIRED.
      IF(ABSDX.LT.ABSDY) ABSDX=ABSDY
      IF(ABSDX.LE.DINMAX) GO TO 60
C-----INTERPOLATION REQUIRED. DEFINE NUMBER AND SIZE OF STEP
      NSTEP=ABSDX/DINMAX+1.0
      FSTEP=NSTEP
C-----DEFINE REQUIRED STEP CHANGE IN X.
      IF(IWAY(1).EQ.1) DSTEP=(X2-X1)/FSTEP
      IF(IWAY(1).EQ.2) DSTEP=DEXP(DLOG(X2/X1)/FSTEP)
C
C     SPACE POINTS IN EQUAL INCH INCREMENTS ALONG X AXIS.
C
C-----INITIALIZE COORDINATES AND X INTERVAL.
      X0=X1
      Y0=Y1
      DX=X2-X1
C-----SET UP LOOP OVER STEPS.
      DO 50 LSTEP=1,NSTEP
C-----INSURE LAST STEP ENDS UP AT (X2,Y2).
      IF(LSTEP.NE.NSTEP) GO TO 10
      X0=X2
      Y0=Y2
      GO TO 40
C-----INCREMENT X IN EQUAL PLOT INCHES.
   10 IF(IWAY(1).EQ.2) GO TO 20
      X0=X0+DSTEP
      GO TO 30
   20 X0=X0*DSTEP
C-----DEFINE Y BY LINEAR INTERPOLATION.
   30 Y0=((X2-X0)*Y1+(X0-X1)*Y2)/DX
C-----IF LOG PLOT TRANSFORM COORDINATES.
   40 XS=X0
      YS=Y0
      IF(IWAY(1).EQ.2) XS=DLOG10(XS)
      IF(IWAY(2).EQ.2) YS=DLOG10(YS)
      XS=XS*XMULT
      YS=YS*YMULT
C-----TRANSFORM TO COORDINATES OF PLOT.
      XINOW=((XS-XLIM(1))*XINCHP(2)+(XLIM(2)-XS)*XINCHP(1))/DXLIM
      YINOW=((YS-YLIM(1))*YINCHP(2)+(YLIM(2)-YS)*YINCHP(1))/DYLIM
C-----MOVE BEAM TO NEXT POINT.
      CALL DASHN(XINOW,YINOW,IPEN,LINTYP)
   50 CONTINUE
      GO TO 70
C-----MOVE BEAM TO FINAL COORDINATES.
   60 CALL DASHN(XINOW,YINOW,IPEN,LINTYP)
C-----SAVE COORDINATES OF LAST POINT.
   70 X1=X2
      Y1=Y2
      XILAST=XINOW
      YILAST=YINOW
      RETURN
      END
      SUBROUTINE DASH(X,Y,IPEN,LINTYP)
C=================================================================
C
C     PLOT ONE OF 30 POSSIBLE TYPES OF DASHED LINE FROM THE LAST POINT
C     TO THE COORDINATES (X,Y). LINTYP DEFINES THE TYPE OF DASHING.
C
C     ALL LINE TYPES ARE DEFINED BY THE SOFTWARE LINE TYPE TABLE.
C
C     WARNING...IN ORDER TO PROPERLY DRAW A CURVE CONNECTING A SERIES OF
C               POINTS TO DEFINE THE FIRST POINT CALL THIS ROUTINE WITH
C               IPEN=3 (MOVE...DO NOT DRAW) AND WITH IPEN=2 (DRAW) FOR
C               ALL REMAINING POINTS.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/REFTB2/XREF(2000),YREF(2000),IRFPEN(2000),INDREF(2,256),
     1 IREFER,IREF
      DATA JSTART/0/
C-----IF MOVE (NOT DRAW) INITIALIZE ALL PARAMETERS AND MOVE.
      IF(IPEN.EQ.3) GO TO 30
C-----IF PATTERN NOT DEFINED USE SOLID LINE.
      IF(IMSOFT.GT.IREFER) GO TO 40
C-----CALCULATE STRAIGHT LINE DISTANCE FROM LAST POINT (XL,YL) TO
C-----CURRENT POINT (X,Y) AND RETURN IF CURRENT POINT IS THE SAME AS THE
C-----LAST POINT.
      DXY=SQRT((X-XL)**2+(Y-YL)**2)
      IF(DXY.LE.0.0) GO TO 50
C-----DEFINE DIRECTION COSINE AND SINE.
      COST=(Y-YL)/DXY
      SINT=(X-XL)/DXY
C-----IF ENTIRE CURRENT STROKE DRAWN SELECT NEXT STROKE OF PATTERN.
C-----OTHERWISE CONTINUE WITH REMAINDER OF CURRENT STROKE.
   10 IF(DLEFT.GT.0.0) GO TO 20
C-----END OF STROKE. SELECT NEXT STROKE FROM PATTERN. AT END OF PATTERN
C-----RE-INITIALIZE TO BEGINNING OF PATTERN.
      ISTEP=ISTEP+1
      IF(ISTEP.GT.ISTOP) ISTEP=JSTART
      DLEFT=XREF(ISTEP)
      KPEN=IRFPEN(ISTEP)
C-----DEFINE LENGTH OF NEXT STROKE (REMAINDER OF STROKE OR DISTANCE TO
C-----FINAL POSITION, WHICHEVER IS LESS).
   20 DMOVE=DLEFT
      IF(DXY.LT.DMOVE) DMOVE=DXY
C-----DEFINE NEW COORDINATE AND MOVE TO IT.
      XL=XL+DMOVE*SINT
      YL=YL+DMOVE*COST
      CALL PLOT1(XL,YL,KPEN)
C-----DEFINE REMAINING LENGTH OF CURRENT STROKE AND DISTANCE TO FINAL
C-----POSITION.
      DLEFT=DLEFT-DMOVE
      DXY=DXY-DMOVE
C-----FINISHED IF NO DISTANCE TO (X,Y) LEFT. OTHERWISE SELECT NEXT
C-----STROKE OF PATTERN AND CONTINUE
      IF(DXY.le.0.0) go to 50
      go to 10
C-----IPEN=3 (MOVE). DEFINE INDEX TO SOFTWARE LINE TYPE TABLE AND
C-----INITIALIZE PATTERN.
   30 IMSOFT=LINTYP+30
C-----IF PATTERN NOT DEFINED USE SOLID LINE.
      IF(IMSOFT.GT.IREFER) GO TO 40
      JSTART=INDREF(1,IMSOFT)
      ISTOP=INDREF(2,IMSOFT)
      ISTEP=JSTART
      DLEFT=XREF(ISTEP)
      KPEN=IRFPEN(ISTEP)
C-----MOVE OR DRAW TO FINAL POSITION.
   40 CALL PLOT1(X,Y,IPEN)
C-----END OF DRAW OR MOVE. SAVE NEW POSITION.
   50 XL=X
      YL=Y
      RETURN
      END
      SUBROUTINE PLVH1(X,Y,IPEN)
C=================================================================
C
C     ONLY DRAW PORTION OF LINE WHICH IS OUTSIDE OF LEGEND BOX
C     VH - ONLY VERTICAL OR HORIZONTAL LINES
C      1 - NO THICK LINES.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/LEGOFF/NOLEGS
C-----NOTHING TO DO IF A MOVE.
      IF(IPEN.NE.2) GO TO 120
      IF(X.NE.X1) GO TO 60
C
C     CONSTANT X.
C
C-----NOTHING TO DO IF OUTSIDE X RANGE OF BOX.
      IF(NOLEGS.NE.0) GO TO 120
      IF(X.LT.BOXMIN.OR.X.GT.BOXMAX) GO TO 120
      IF(Y.lt.Y1) go to 30
      IF(Y.eq.Y1) go to 140
C-----LINE MOVING UPWARDS. NOTHING TO DO IF LINE ENTIRELY BELOW OR ABOVE
C-----THE BOX.
      IF(Y.LE.BOYMIN.OR.Y1.GE.BOYMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(Y.LE.BOYMAX.AND.Y1.GE.BOYMIN) GO TO 140
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(Y1.LT.BOYMIN.AND.Y.GT.BOYMIN) GO TO 10
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(Y1.LT.BOYMAX.AND.Y.GT.BOYMAX) GO TO 20
      GO TO 120
C-----BOTTOM INTERCEPT (ENTER).
   10 CALL PLOTP(X,BOYMIN,2)
C-----CHECK FOR TOP INTERCEPT ALSO.
      IF(Y.LE.BOYMAX) GO TO 130
C-----TOP INTERCEPT (LEAVE).
   20 CALL PLOTP(X,BOYMAX,3)
      GO TO 120
C-----LINE MOVING DOWNWARDS. NOTHING TO DO IF LINE ENTIRELY BELOW OR
C-----ABOVE THE BOX.
   30 IF(Y1.LE.BOYMIN.OR.Y.GE.BOYMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(Y1.LE.BOYMAX.AND.Y.GE.BOYMIN) GO TO 140
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(Y.LT.BOYMAX.AND.Y1.GT.BOYMAX) GO TO 40
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(Y.LT.BOYMIN.AND.Y1.GT.BOYMIN) GO TO 50
      GO TO 120
C-----TOP INTERCEPT (ENTER).
   40 CALL PLOTP(X,BOYMAX,2)
C-----CHECK FOR BOTTOM INTERCEPT ALSO.
      IF(Y.GE.BOYMIN) GO TO 130
C-----BOTTOM INTERECPT (LEAVE).
   50 CALL PLOTP(X,BOYMIN,3)
      GO TO 120
C
C     CONSTANT Y.
C
C-----NOTHING TO DO IF OUTSIDE Y RANGE OF BOX.
   60 IF(Y.LT.BOYMIN.OR.Y.GT.BOYMAX) GO TO 120
      IF(X.lt.X1) go to 90
      IF(X.eq.X1) go to 140
C-----LINE MOVING RIGHT. NOTHING TO DO IF LINE ENTIRELY BELOW OR ABOVE
C-----THE BOX.
      IF(X.LE.BOXMIN.OR.X1.GE.BOXMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(X.LE.BOXMAX.AND.X1.GE.BOXMIN) GO TO 140
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(X1.LT.BOXMIN.AND.X.GT.BOXMIN) GO TO 70
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(X1.LT.BOXMAX.AND.X.GT.BOXMAX) GO TO 80
      GO TO 120
C-----BOTTOM INTERECPT (ENTER).
   70 CALL PLOTP(BOXMIN,Y,2)
C-----CHECK FOR TOP INTERCEPT ALSO.
      IF(X.LE.BOXMAX) GO TO 130
C-----TOP INTERCEPT (LEAVE).
   80 CALL PLOTP(BOXMAX,Y,3)
      GO TO 120
C-----LINE MOVING LEFT. NOTHING TO DO IF LINE ENTIRELY BELOW OR
C-----ABOVE THE BOX.
   90 IF(X1.LE.BOXMIN.OR.X.GE.BOXMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(X1.LE.BOXMAX.AND.X.GE.BOXMIN) GO TO 140
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(X.LT.BOXMAX.AND.X1.GT.BOXMAX) GO TO 100
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(X.LT.BOXMIN.AND.X1.GT.BOXMIN) GO TO 110
      GO TO 120
C-----TOP INTERCEPT (ENTER).
  100 CALL PLOTP(BOXMAX,Y,2)
C-----CHECK FOR BOTTOM INTERCEPT ALSO.
      IF(X.GE.BOXMIN) GO TO 130
C-----BOTTOM INTERECPT (LEAVE).
  110 CALL PLOTP(BOXMIN,Y,3)
C-----MOVE OR DRAW TO FINAL POSITION.
  120 CALL PLOTP(X,Y,IPEN)
      GO TO 140
C-----MOVE TO FINAL POSITION.
  130 CALL PLOTP(X,Y,3)
  140 X1=X
      Y1=Y
      RETURN
      END
      SUBROUTINE PLVHN(X,Y,IPEN)
C=================================================================
C
C     ONLY DRAW PORTION OF LINE WHICH IS OUTSIDE OF LEGEND BOX
C     VH - ONLY VERTICAL OR HORIZONTAL LINES
C      N - THICK LINES.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/LEGOFF/NOLEGS
C-----NOTHING TO DO IF A MOVE.
      IF(IPEN.NE.2) GO TO 120
      IF(X.NE.X1) GO TO 60
C
C     CONSTANT X.
C
C-----NOTHING TO DO IF OUTSIDE X RANGE OF BOX.
      IF(NOLEGS.NE.0) GO TO 120
      IF(X.LT.BOXMIN.OR.X.GT.BOXMAX) GO TO 120
      IF(Y.lt.Y1) go to 30
      IF(Y.eq.Y1) go to 140
C-----LINE MOVING UPWARDS. NOTHING TO DO IF LINE ENTIRELY BELOW OR ABOVE
C-----THE BOX.
      IF(Y.LE.BOYMIN.OR.Y1.GE.BOYMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(Y.LE.BOYMAX.AND.Y1.GE.BOYMIN) GO TO 140
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(Y1.LT.BOYMIN.AND.Y.GT.BOYMIN) GO TO 10
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(Y1.LT.BOYMAX.AND.Y.GT.BOYMAX) GO TO 20
      GO TO 120
C-----BOTTOM INTERCEPT (ENTER).
   10 CALL PLOT1(X,BOYMIN,2)
C-----CHECK FOR TOP INTERCEPT ALSO.
      IF(Y.LE.BOYMAX) GO TO 130
C-----TOP INTERCEPT (LEAVE).
   20 CALL PLOT1(X,BOYMAX,3)
      GO TO 120
C-----LINE MOVING DOWNWARDS. NOTHING TO DO IF LINE ENTIRELY BELOW OR
C-----ABOVE THE BOX.
   30 IF(Y1.LE.BOYMIN.OR.Y.GE.BOYMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(Y1.LE.BOYMAX.AND.Y.GE.BOYMIN) GO TO 140
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(Y.LT.BOYMAX.AND.Y1.GT.BOYMAX) GO TO 40
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(Y.LT.BOYMIN.AND.Y1.GT.BOYMIN) GO TO 50
      GO TO 120
C-----TOP INTERCEPT (ENTER).
   40 CALL PLOT1(X,BOYMAX,2)
C-----CHECK FOR BOTTOM INTERCEPT ALSO.
      IF(Y.GE.BOYMIN) GO TO 130
C-----BOTTOM INTERECPT (LEAVE).
   50 CALL PLOT1(X,BOYMIN,3)
      GO TO 120
C
C     CONSTANT Y.
C
C-----NOTHING TO DO IF OUTSIDE Y RANGE OF BOX.
   60 IF(Y.LT.BOYMIN.OR.Y.GT.BOYMAX) GO TO 120
      IF(X.lt.X1) go to 90
      IF(X.eq.X1) go to 140
C-----LINE MOVING RIGHT. NOTHING TO DO IF LINE ENTIRELY BELOW OR ABOVE
C-----THE BOX.
      IF(X.LE.BOXMIN.OR.X1.GE.BOXMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(X.LE.BOXMAX.AND.X1.GE.BOXMIN) GO TO 140
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(X1.LT.BOXMIN.AND.X.GT.BOXMIN) GO TO 70
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(X1.LT.BOXMAX.AND.X.GT.BOXMAX) GO TO 80
      GO TO 120
C-----BOTTOM INTERECPT (ENTER).
   70 CALL PLOT1(BOXMIN,Y,2)
C-----CHECK FOR TOP INTERCEPT ALSO.
      IF(X.LE.BOXMAX) GO TO 130
C-----TOP INTERCEPT (LEAVE).
   80 CALL PLOT1(BOXMAX,Y,3)
      GO TO 120
C-----LINE MOVING LEFT. NOTHING TO DO IF LINE ENTIRELY BELOW OR
C-----ABOVE THE BOX.
   90 IF(X1.LE.BOXMIN.OR.X.GE.BOXMAX) GO TO 120
C-----CHECK FOR LINE ENTIRELY INSIDE BOX.
      IF(X1.LE.BOXMAX.AND.X.GE.BOXMIN) GO TO 140
C-----CHECK FOR INTERCEPT TOP OF BOX.
      IF(X.LT.BOXMAX.AND.X1.GT.BOXMAX) GO TO 100
C-----CHECK FOR INTERCEPT BOTTOM OF BOX.
      IF(X.LT.BOXMIN.AND.X1.GT.BOXMIN) GO TO 110
      GO TO 120
C-----TOP INTERCEPT (ENTER).
  100 CALL PLOT1(BOXMAX,Y,2)
C-----CHECK FOR BOTTOM INTERCEPT ALSO.
      IF(X.GE.BOXMIN) GO TO 130
C-----BOTTOM INTERECPT (LEAVE).
  110 CALL PLOT1(BOXMIN,Y,3)
C-----MOVE OR DRAW TO FINAL POSITION.
  120 CALL PLOT1(X,Y,IPEN)
      GO TO 140
C-----MOVE TO FINAL POSITION.
  130 CALL PLOT1(X,Y,3)
  140 X1=X
      Y1=Y
      RETURN
      END
      SUBROUTINE PLOT1(X,Y,IPEN)
C=================================================================
C
C     PLOT FROM LAST (X,Y) TO CURRENT (X,Y) EITHER NORMAL OR THICK LINE.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/THICKY/THICK,ITHICK,NTHICK(3)
C-----IF MOVE, NOT DRAW OR NORMAL LINE DO IT WITH 1 STROKE.
      IF(IPEN.NE.2.OR.ITHICK.LE.0) GO TO 30
      DXY=SQRT((X-XL)**2+(Y-YL)**2)
      IF(DXY.LE.0.0) GO TO 40
C-----DEFINE DIRECTION COSINE AND SINE.
      COST=(Y-YL)/DXY
      SINT=(X-XL)/DXY
C-----DEFINE OFFSET FOR LINE THICKNESS.
      DXT=-THICK*COST
      DYT=THICK*SINT
C-----DRAW THICK LINE.
      CALL PLOTP(X,Y,2)
      DXT1=DXT
      DYT1=DYT
      DO 10 I=1,ITHICK
      CALL PLOTP(XL+DXT,YL+DYT,3)
      CALL PLOTP(X+DXT,Y+DYT,2)
      DXT=DXT+DXT1
      DYT=DYT+DYT1
   10 CONTINUE
      DXT=DXT1
      DYT=DYT1
      DO 20 I=1,ITHICK
      CALL PLOTP(XL-DXT,YL-DYT,3)
      CALL PLOTP(X-DXT,Y-DYT,2)
      DXT=DXT+DXT1
      DYT=DYT+DYT1
   20 CONTINUE
      CALL PLOTP(X,Y,3)
      GO TO 40
C-----DRAW NORMAL WIDTH LINE.
   30 CALL PLOTP(X,Y,IPEN)
   40 XL=X
      YL=Y
      RETURN
      END
      SUBROUTINE PLOTZ(Z,IWAY,MYGRID)
C=================================================================
C
C     DRAW SOLID OR DASHED GRID LINE THAT LIES OUTSIDE OF LEGEND BOX.
C
C     Z      = CONSTANT X OR Y VALUE
C     IWAY   = 1 - X AXIS - CONSTANT X FROM YLIM1 TO YLIM2
C            = 2 - Y AXIS - CONSTANT Y FROM XLIM1 TO XLIM2
C     MYGRID = 1 - SOLID
C            = 2 - DASHED
C
C     THE X AND Y LIMITS OF THE PLOT ARE DEFINED BY PLTLIM
C     THE X AND Y LIMITS OF THE BOX  ARE DEFINED BY BOXLIM
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      DIMENSION ZDASH(3)
      EQUIVALENCE (XINCHP(1),XLIM1),(XINCHP(2),XLIM2),
     1            (YINCHP(1),YLIM1),(YINCHP(2),YLIM2)
      DATA ZDASH/0.0,0.0,0.0/
C
C     DEFINE LENGTH OF TICK MARKS (FOR 10 PATTERNS PER INCH -
C     1 DASH, 6 BLANKS.
C
      ZDASH(2)=1.0/70.0
      ZDASH(3)=6.0*ZDASH(2)
C
C     SELECT X OR Y AXIS.
C
      IF(IWAY.NE.1) GO TO 90
C
C     X AXIS - VERTICAL LINE FROM YLIM1 TO YLIM2.
C
      YLAST=YLIM1
      KPEN=3
C-----START AT LOWER Y AXIS.
      CALL PLOTP(Z,YLIM1,3)
C-----CHECK FOR NO OVERLAP WITH LEGEND BOX.
      IF(Z.LE.BOXMIN.OR.Z.GT.BOXMAX) GO TO 60
C-----CHECK FOR NOTHING TO DRAW - IF LEGEND BOX COVERS ENTIRE Y RANGE.
      IF(BOYMAX.GE.YLIM2.AND.BOYMIN.LE.YLIM1) RETURN
      IF(YLIM1.GE.BOYMAX.OR.YLIM2.LE.BOYMIN) GO TO 60
C-----OVERLAP WITH LEGEND BOX.
      IF(MYGRID.EQ.2) GO TO 10
C-----SOLID EXCEPT IN BOX.
      CALL PLOTP(Z,BOYMIN,2)
C-----MOVE TO TOP OF BOX OR UPPER LIMIT OF PLOT (WHICHEVER IS LOWER).
      ZZ=BOYMAX
      IF(ZZ.GT.YLIM2) ZZ=YLIM2
      CALL PLOTP(Z,ZZ,3)
C-----DRAW TO TOP OF PLOT.
      CALL PLOTP(Z,YLIM2,2)
      RETURN
C-----DASHED EXCEPT IN BOX.
C-----UP TO LOWER LIMIT OF BOX.
   10 KPEN=5-KPEN
      YLAST=YLAST+ZDASH(KPEN)
      IF(YLAST.ge.BOYMIN) go to 20
      CALL PLOTP(Z,YLAST,KPEN)
      GO TO 10
C-----ACROSS BOX.
   20 CALL PLOTP(Z,BOYMIN,KPEN)
   30 KPEN=5-KPEN
      YLAST=YLAST+ZDASH(KPEN)
      IF(YLAST.GE.YLIM2) RETURN
      IF(YLAST.lt.BOYMAX) go to 30
C-----TO UPPER Y AXIS.
      CALL PLOTP(Z,BOYMAX,3)
      IF(YLAST.GE.YLIM2) RETURN
      CALL PLOTP(Z,YLAST,KPEN)
   40 KPEN=5-KPEN
      YLAST=YLAST+ZDASH(KPEN)
      IF(YLAST.ge.YLIM2) go to 50
      CALL PLOTP(Z,YLAST,KPEN)
      GO TO 40
   50 CALL PLOTP(Z,YLIM2,KPEN)
      RETURN
C
C     NO OVERLAP WITH LEGEND BOX.
C
   60 IF(MYGRID.EQ.2) GO TO 70
C-----SOLID.
      CALL PLOTP(Z,YLIM2,2)
      RETURN
C-----DASHED.
   70 KPEN=5-KPEN
      YLAST=YLAST+ZDASH(KPEN)
      IF(YLAST.ge.YLIM2) go to 80
      CALL PLOTP(Z,YLAST,KPEN)
      GO TO 70
   80 CALL PLOTP(Z,YLIM2,KPEN)
      RETURN
C
C     Y AXIS - HORIZONTAL LINE FROM XLIM1 TO XLIM2.
C
   90 XLAST=XLIM1
      KPEN=3
C-----START AT LOWER X AXIS.
      CALL PLOTP(XLIM1,Z,3)
C-----CHECK FOR NO OVERLAP WITH LEGEND BOX.
      IF(Z.LE.BOYMIN.OR.Z.GT.BOYMAX) GO TO 150
      IF(XLIM1.GE.BOXMAX.OR.XLIM2.LE.BOXMIN) GO TO 150
      IF(MYGRID.EQ.2) GO TO 100
C-----SOLID EXCEPT IN BOX.
      CALL PLOTP(BOXMIN,Z,2)
      CALL PLOTP(BOXMAX,Z,3)
      CALL PLOTP(XLIM2,Z,2)
      RETURN
C-----DASHED EXCEPT IN BOX.
C-----UP TO LOWER LIMIT OF BOX.
  100 KPEN=5-KPEN
      XLAST=XLAST+ZDASH(KPEN)
      IF(XLAST.ge.BOXMIN) go to 110
      CALL PLOTP(XLAST,Z,KPEN)
      GO TO 100
C-----ACROSS BOX.
  110 CALL PLOTP(BOXMIN,Z,KPEN)
  120 KPEN=5-KPEN
      XLAST=XLAST+ZDASH(KPEN)
      IF(XLAST.lt.BOXMAX) go to 120
C-----TO UPPER Y AXIS.
      CALL PLOTP(BOXMAX,Z,3)
      IF(XLAST.GT.XLIM2) GO TO 140
      CALL PLOTP(XLAST,Z,KPEN)
  130 KPEN=5-KPEN
      XLAST=XLAST+ZDASH(KPEN)
      IF(XLAST.ge.XLIM2) go to 140
      CALL PLOTP(XLAST,Z,KPEN)
      GO TO 130
  140 CALL PLOTP(XLIM2,Z,KPEN)
      RETURN
C
C     NO OVERLAP WITH LEGEND BOX.
C
  150 IF(MYGRID.EQ.2) GO TO 160
C-----SOLID.
      CALL PLOTP(XLIM2,Z,2)
      RETURN
C-----DASHED.
  160 KPEN=5-KPEN
      XLAST=XLAST+ZDASH(KPEN)
      IF(XLAST.ge.XLIM2) go to 170
      CALL PLOTP(XLAST,Z,KPEN)
      GO TO 160
  170 CALL PLOTP(XLIM2,Z,KPEN)
      RETURN
      END
      SUBROUTINE PLOTX(X,Y,IPEN)
C=================================================================
C
C     TRANSLATE DATA FROM THE PLANE OF THE DATA TO THE PLANE OF THE
C     PLOT.
C     - VERTICAL OR HORIZONTAL LINE
C     - NO THICK LINES
C     - CLIIPED NOT TO BE IN LEGEND BOX
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      XI=((X-XLIM(1))*XINCHP(2)+(XLIM(2)-X)*XINCHP(1))/DXLIM
      YI=((Y-YLIM(1))*YINCHP(2)+(YLIM(2)-Y)*YINCHP(1))/DYLIM
      CALL PLVH1(XI,YI,IPEN)
      RETURN
      END
      SUBROUTINE PLOTP(XIN,YIN,IPEN)
C=================================================================
C
C     TRANSLATE AND SCALE EACH STROKE TO THE PLANE OF THE PLOTTER AND
C     PLOT.
C
C=================================================================
      INCLUDE 'implicit.h'
      REAL*4 X,Y
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
      COMMON/XYOFF/XOFF,YOFF,XSCALE,YSCALE,XSIZEP,YSIZEP
      IF(IFLIP.GT.0) GO TO 10
      X=XSCALE*XIN+XOFF
      Y=YSCALE*YIN+YOFF
      CALL PLOT(X,Y,IPEN)
      RETURN
   10 Y=XSCALE*XIN+XOFF
      X=YSCALE*YIN+YOFF
      CALL PLOT(X,Y,IPEN)
      RETURN
      END
      SUBROUTINE COLORBOX(XB,YB,IFILL,IBORDER)
C=================================================================
C
C     TRANSLATE AND SCALE EACH STROKE TO THE PLANE OF THE PLOTTER AND
C     FILL A RECTANGLE.
C
C=================================================================
      INCLUDE 'implicit.h'
      REAL*4 XP,YP
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
      COMMON/XYOFF/XOFF,YOFF,XSCALE,YSCALE,XSIZEP,YSIZEP
      DIMENSION XB(2),YB(2),XP(2),YP(2)
      IF(IFLIP.GT.0) GO TO 10
      XP(1)=XSCALE*XB(1)+XOFF
      YP(1)=YSCALE*YB(1)+YOFF
      XP(2)=XSCALE*XB(2)+XOFF
      YP(2)=YSCALE*YB(2)+YOFF
      CALL BOXCOLOR(XP,YP,IFILL,IBORDER)
      RETURN
   10 YP(1)=XSCALE*XB(1)+XOFF
      XP(1)=YSCALE*YB(1)+YOFF
      YP(2)=XSCALE*XB(2)+XOFF
      XP(2)=YSCALE*YB(2)+YOFF
      CALL BOXCOLOR(XP,YP,IFILL,IBORDER)
      RETURN
      END
      SUBROUTINE LEFTY(BCD,IBCD,NBCD,KBCD)
C=================================================================
C
C     LEFT ADJUST TITLES AND DEFINE NUMBER OF NON-BLANK CHARACTERS AND
C     NUMBER OF PLOTTED CHARACTERS (NON-BLANK MINUS CONTROL CHARACTERS).
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 BCD,BLANK,CHRTAB,CHRTRL
      COMMON/SYMTB1/CHRTAB(256),CHRTRL(256)
      COMMON/SYMTB2/XCHAR(5000),YCHAR(5000),ICHPEN(5000),
     1 INDCHR(2,256),ICHAR,ICNTRL,ISYM
      DIMENSION BCD(KBCD)
      DATA BLANK/' '/
C-----FIND LAST NON-BLANK CHARACTER.
      I=KBCD
      DO 10 II=1,KBCD
      IF(BCD(I).NE.BLANK) GO TO 20
      I=I-1
   10 CONTINUE
      IBCD=0
      NBCD=0
      GO TO 70
C-----FIND FIRST NON-BLANK CHARACTER.
   20 DO 30 J=1,I
      IF(BCD(J).NE.BLANK) GO TO 40
   30 CONTINUE
      IBCD=0
      NBCD=0
      GO TO 70
   40 IBCD=I
C-----IF REQUIRED SHIFT CHARACTERS LEFT.
      IF(J.EQ.1) GO TO 70
      K=0
      DO 50 L=J,I
      K=K+1
      BCD(K)=BCD(L)
   50 CONTINUE
      IBCD=K
      K=K+1
      DO 60 I=K,KBCD
      BCD(I)=BLANK
   60 CONTINUE
C-----COUNT SPECIAL NON-PRINTING CHARACTERS.
   70 NBCD=IBCD
      IF(ICNTRL.LE.0) GO TO 100
      DO 90 I=1,IBCD
      DO 80 J=1,ICNTRL
      IF(BCD(I).NE.CHRTRL(J)) GO TO 80
      NBCD=NBCD-1
      GO TO 90
   80 CONTINUE
   90 CONTINUE
  100 RETURN
      END
      SUBROUTINE OUT9(ZIN,FIELD)
C=======================================================================
C
C     PURPOSE
C     =======
C     FORMAT NUMBER FOR OUTPUT TO INCLUDE AS MANY DIGITS OF
C     ACCURACY AS POSSIBLE.
C     12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENT
C                  No test for 4 or more digit exponent
C     11/26/2013 - Limited to 2 Digit Exponent - too many
c                  computers were getting ERROR messages.
c
C     040923 - CHANGED ZLOW FROM 1.0D-4 TO 1.0D-3
C              NEAR 1.0D-3 PRECISION GOES FROM 999,999 TO 1,000,000
C              FOR SMOOTHEST TRANSITION FROM 6 TO 7 DIGITS
C
C     ARGUMENTS
C     =========
C     Z        = FLOATING POINT NUMBER OF BE OUTPUT (INPUT)
C     FIELD    = 11A1 CHARACTERS TO OUTPUT          (OUTPUT)
C
C     METHOD
C     ======
C     COLUMNS            12345678901     ACCURACY
C     -------------------------------------------
C     0 TO 10^-9          1.2345E-12     5 DIGITS
C     10^-9 TO 10^-3      1.23456E-8     6 DIGITS
C     10^-3 TO 10^-2      .001234567     7 DIGITS
C     10^-2 TO 10^-1      .012345678     8 DIGITS
C     10^-1 TO 1          .123456789     9 DIGITS
C     1 TO 10^9           12345.6789     9 DIGITS
C     10^9 TO 10^10       1.23456E+9     6 DIGITS
C     10^10 >             1.2345E+12     5 DIGITS
C
C     OUTPUT WILL BE IN 11 COLUMN FORMAT
C
C     WARNING - THIS IS NOT A GENERAL ROUNDING ROUTINE WHICH WILL WORK
C               FOR ROUNDING TO ANY NUMBER OF DIGITS - IT WILL ONLY
C               WORK PROPERLY FOR THE RANGES INDICATED ABOVE, FOR
C               11 COLUMN OUTPUT.
C
C=======================================================================
      implicit real*8 (a-h,o-z)
      implicit integer*4 (i-n)
c-----REAL*8 for long integers
      integer*8 INMANT,INMAN9,INMAN8,INMAN7,INMAN6,INMAN5,INMAN4
      save
      CHARACTER*1 FIELD,DIGITS,ZEROH
C-----12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENT
      DIMENSION DIGITS(0:9),FIELD(11),ZEROH(11),
     1 TENS(-99:99),ROUNDER(-99:99)
c-----REAL*8 for long integers
      DATA INMAN9 / 1000000000/
      DATA INMAN8 /  100000000/
      DATA INMAN7 /   10000000/
      DATA INMAN6 /    1000000/
      DATA INMAN5 /     100000/
      DATA INMAN4 /      10000/
      DATA DIGITS/
     1 '0','1','2','3','4','5','6','7','8','9'/
C-----RETURN FOR = 0
      DATA ZEROH/
     1 ' ','0','.','0',' ',' ',' ',' ',' ',' ',' '/
C-----LOWER TRANSITION POINT FROM 7 TO 9 DIGIT OUTPUT
      DATA ZLOW/1.0D-03/
C-----UPPER TRANSITION POINT FROM 9 TO 7 DIGIT OUTPUT
      DATA ZHIGH/1.0D+09/
      DATA TENTH/1.0D-01/
c-----------------------------------------------------------------------
c
c     ON FIRST CALL INITIALIZE POWERS OF 10
c
c-----------------------------------------------------------------------
      DATA IPASS/0/
      IF(IPASS.NE.0) GO TO 50
      IPASS=1
      TENS(0)=1.0D+00
C-----12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENT
      DO 10 I=1,99
      TENS( I)=TENS(I-1)*10.0D+00
      TENS(-I)=TENS(1-I)/10.0D+00
      ROUNDER(I)  = 5.001D-05
   10 CONTINUE
      DO 20 I=-99,-10
      ROUNDER(I)  = 5.001D-05
   20 CONTINUE
      DO 30 I=-9,-4
      ROUNDER(I)  = 5.001D-06
   30 CONTINUE
      ROUNDER(-3) = 5.001D-07
      ROUNDER(-2) = 5.001D-08
      ROUNDER(-1) = 5.001D-09
      ROUNDER( 0) = 5.001D-09
      DO 40 I=1,8
      ROUNDER(I)  = 5.001D-09
   40 CONTINUE
      ROUNDER(9)  = 5.001D-06
c-----------------------------------------------------------------------
C
C     IMMEDIATELY RETURN 0.00000+00.
C
c-----------------------------------------------------------------------
C-----02/14/04 - ADDED, JUST IN CASE
   50 IF(DABS(ZIN).le.0.0) GO TO 60
      IF(DABS(ZIN).lt.1.0D-99) GO TO 60    ! Only 2 digit expoents
      IF(DABS(ZIN).gt.1.0D+99) GO TO 60
      IF(ZIN.lt.0.0d+0) go to 80
      IF(ZIN.gt.0.0d+0) go to 90
   60 DO 70 I=1,11
      FIELD(I)=ZEROH(I)
   70 CONTINUE
      RETURN
c-----------------------------------------------------------------------
C
C     DEFINE SIGN OF MANTISSA AND ABSOLUTE MANTISSA
C
c-----------------------------------------------------------------------
C-----NEGATIVE.
   80 FIELD(1)='-'
      Z=-ZIN
      GO TO 100
C-----POSITIVE.
   90 FIELD(1)=' '
      Z=ZIN
c-----------------------------------------------------------------------
c
c     DEFINE EXPONENT AND NORMALIZED MANTISSA
c
c-----------------------------------------------------------------------
  100 IEXP=DLOG10(Z)
c-----Limit to 2 Digits - do not use 99 - can change by 1 or 2
      if(iabs(IEXP).gt.97) go to 60
      IF(Z.LT.1.0D+00) IEXP = IEXP - 1
c-----11/22/2013 - Decide here on F or D Output
      if(ZIN.lt.0.0D+0) then
      ZN=Z*TENS(-IEXP) + ROUNDER(IEXP)       ! Standard
      else
      if(Z.LE.ZLOW.OR.Z.GE.ZHIGH) then
      ZN=Z*TENS(-IEXP) + TENTH*ROUNDER(IEXP) ! Extra Digit
      else
      ZN=Z*TENS(-IEXP) + ROUNDER(IEXP)       ! Standard
      endif
      endif
      IF(ZN.eq.1.0D+00) go to 120         ! Test rounding underflow
      IF(ZN.gt.1.0D+00) go to 110         ! Test rounding underflow
      IEXP=IEXP-1
      GO TO 120
  110 IF(ZN.lt.10.0D+00) go to 120         ! Test rounding overflow
      IEXP=IEXP+1
      ZN=ZN/10.0D+00
  120 Z = ZN*TENS(IEXP)
c-----------------------------------------------------------------------
C
C     SELECT F OR D FORMAT
C
c-----------------------------------------------------------------------
      IF(Z.LE.ZLOW.OR.Z.GE.ZHIGH) GO TO 150
c-----------------------------------------------------------------------
C
C     F FORMAT
C
C     12345678901
C      X.XXXXXXXX = 9 DIGITS
C      .001234567
C      123456789.
C
c-----------------------------------------------------------------------
C-----DEFINE 6 TO 9 DIGIT MANTISSA WITH ROUNDING
      IPOWER=8-IEXP
      IF(IEXP.LT.0) IPOWER=8
      INMANT=Z*TENS(IPOWER)
C-----CHECK FOR OVERFLOW DUE TO ROUNDING
      IF(INMANT.lt.INMAN9) go to 130
      INMANT=INMAN8
      IEXP=IEXP+1
C-----DECIMAL POINT.
  130 IDOT=3+IEXP
      IF(IDOT.LE.2) THEN
C----- IF < 1, MOVE DECIMAL POINT TO COLUMN 2 AND ADD A DIGIT
      IDOT=2
      INMANT=Z*10.0D+00*TENS(IPOWER)
      ENDIF
      FIELD(IDOT)='.'
C-----MANTISSA - LAST DIGIT TO FIRST.
      II=11
      DO     I=2,11
      IF(II.EQ.IDOT) GO TO 140
      I2=INMANT/10
      I3=INMANT-10*I2
      FIELD(II)=DIGITS(I3)
      INMANT=I2
  140 II=II-1
      ENDDO
      RETURN
c-----------------------------------------------------------------------
C
C     D FORMAT
C
C     12345678901
C      X.XXXXD+NN = 5 DIGITS
C      X.XXXXXD+N = 6 DIGITS
C
C     11/22/2013 - If not negative, use first column
C     12345678901
C     X.XXXXXD+NN = 6 DIGITS
C     X.XXXXXXD+N = 7 DIGITS
c
c-----------------------------------------------------------------------
C-----Negative?
  150 IF(ZIN.lt.0.0d+0) go to 170
c
c     POsitive. Use first column - Decimal point is always in column 2
c
      FIELD(2)='.'
      KDOT    = 2
      ISTART  = 1
      IF(IABS(IEXP).GE.10) GO TO 160
      ID=8                               ! 1 Digit exponent
      INMANT=(1.0D+06)*ZN
      IF(INMANT.lt.INMAN7) go to 190
      INMANT=INMAN6
      IEXP=IEXP+1
      IF(IABS(IEXP).LT.10) GO TO 190
  160 ID=7                               ! 2 Digit exponent
      INMANT=(1.0D+05)*ZN
C-----CHECK FOR OVERFLOW DUE TO ROUNDING
      IF(INMANT.lt.INMAN6) go to 190
      INMANT=INMAN5
      IEXP=IEXP+1
c
c     Negative Number - Cannot use first column
c
C-----DECIMAL POINT IS ALWAYS IN COLUMN 3
  170 FIELD(3)='.'
      KDOT    = 3
      ISTART  = 2
      IF(IABS(IEXP).GE.10) GO TO 180
      ID=8                                 ! 1 Digit Exponent
      INMANT=(1.0D+05)*ZN
      IF(INMANT.lt.INMAN6) go to 190
      INMANT=INMAN5
      IEXP=IEXP+1
      IF(IABS(IEXP).LT.10) GO TO 190
  180 ID=7                                 ! 2 Digit Exponent
      INMANT=(1.0D+04)*ZN
      IF(INMANT.lt.INMAN5) go to 190
      INMANT=INMAN4
      IEXP=IEXP+1
C
C     DEFINE MANTISSA
C
  190 IEXPS=ID+1
      II=ID
      DO     I=ISTART,ID
      IF(II.EQ.KDOT) GO TO 200
      I2=INMANT/10
      I3=INMANT-10*I2
      FIELD(II)=DIGITS(I3)
      INMANT=I2
  200 II=II-1
      ENDDO
C
C     D
C
      FIELD(IEXPS) = 'D'
      IEXPS = IEXPS + 1
C
C     SIGN OF EXPONENT
C
      IF(IEXP.ge.0) go to 210
      IEXP=-IEXP
      FIELD(IEXPS)='-'
      GO TO 220
  210 FIELD(IEXPS)='+'
C
C     EXPONENT
C
  220 IF(IEXP.lt.10) go to 230
      KEXP=IEXP/10
      FIELD(10)=DIGITS(KEXP)
      IEXP=MOD(IEXP,10)
  230 FIELD(11)=DIGITS(IEXP)
c
c     If using column 1 but mantissa ends in 0, move mantissa right.
c
      if(KDOT.eq.2.and.FIELD(ID).eq.'0') then
      do k=ID-1,1,-1
      FIELD(k+1)=FIELD(k)
      enddo
      FIELD(1) = ' '
      endif
      RETURN
      END
      SUBROUTINE IN9(E,FIELD)
C=======================================================================
C
C     PURPOSE
C     =======
C     CONVERT FROM HOLLERITH TO FLOATING POINT.
C     12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENT (I Thank Viktor Zerkin)
C                  More than 3 digit exponent = ERROR - return 0.0
C     11/26/2013 - Limited to 2 Digit Exponent - too many
c                  computers were getting ERROR messages.
c
C
C     ARGUMENTS
C     =========
C     E       = FLOATING POINT NUMBER (OUTPUT)
C     FIELD   = 11A1 CHARACTER STRING (INPUT)
C
C     METHOD
C     ======
C     FIELD IS A STRING OF 11 CHARACTERS.
C     IT IS CONVERTED INTO A FLOATING POINR NUMBER (E)
C
C=======================================================================
      implicit real*8 (a-h,o-z)
      implicit integer*4 (i-n)
      save
      CHARACTER*1 MESS,DIGIT,FIELD,IFIELD
C-----12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENTS
      DIMENSION FIELD(11),TENS(-99:99),DIGIT(0:9),MESS(11),XDIG(0:9)
      DATA MESS/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/
      DATA XDIG/0.0D+00,1.0D+00,2.0D+00,3.0D+00,4.0D+00,
     1          5.0D+00,6.0D+00,7.0D+00,8.0D+00,9.0D+00/
C-----ON FIRST CALL DEFINE POWERS OF 10
      DATA IPASS/0/
      IF(IPASS.NE.0) GO TO 20
      IPASS=1
      TENS(0)=1.0D+00
C-----12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENTS
      DO 10 I=1,99
      TENS( I)=TENS(I-1)*10.0D+00
      TENS(-I)=TENS(1-I)/10.0D+00
   10 CONTINUE
C
C     TRANSLATE MANTISSA.
C
C-----SKIP LEADING BLANK CHARACTERS.
   20 DO 30 I=1,11
      IF(FIELD(I).NE.' ') GO TO 40
   30 CONTINUE
C-----FIELD IS COMPLETELY BLANK. RETURN ZERO.
      E=0.0D+00
      RETURN
C-----INITIALIZE SIGN TO PLUS AND THEN CHECK FOR LEADING MINUS SIGN.
   40 SIGN=1.0D+00
C-----06/02/09 - ADDED TEST FOR LEADING + SIGN.
      IF(FIELD(I).NE.'-') GO TO 50
      SIGN=-1.0D+00
      I=I+1
c-----added leading +
      GO TO 60
   50 IF(FIELD(I).EQ.'+') I = I + 1
C-----INITIALIZE FIXED POINT INPUT FIELD AND POSITION OF DECIMAL POINT.
   60 X9IN=0.0
      IPT=-20
      IMZERO=0
C-----SCAN REMAINDER OF MANTISSA.
      DO 120 J=I,11
      IFIELD=FIELD(J)
C-----SCAN FOR DIGIT OR DECIMAL POINT (WHICH ARE PART OF MANTISSA).
      DO 70 K=0,9
      IF(IFIELD.EQ.DIGIT(K)) GO TO 90
   70 CONTINUE
      IF(IFIELD.NE.'.') GO TO 80
      IPT=0
      GO TO 120
C-----SCAN FOR BLANK (WHICH ENDS MANTISSA).
   80 IF(IFIELD.EQ.' ') GO TO 130
C-----SCAN FOR e, E, d, D, - OR + (WHICH BEGINS EXPONENT).
      IF(IFIELD.EQ.'e'.OR.IFIELD.EQ.'E') GO TO 160
      IF(IFIELD.EQ.'d'.OR.IFIELD.EQ.'D') GO TO 160
      IF(IFIELD.EQ.'-') GO TO 190
      IF(IFIELD.EQ.'+') GO TO 170
C-----ERROR. CANNOT IDENTIFY CHARACTER.
      GO TO 240
C-----DIGIT FOUND. SAVE TRAILING ZEROES AFTER DECIMAL POINT.
   90 IF(IPT.LT.0) GO TO 110
      IF(K.NE.0) GO TO 100
C-----SAVE TRAILING ZEROES.
      IMZERO=IMZERO+1
      GO TO 120
  100 IF(IMZERO.LE.0) GO TO 110
C-----INSERT ZEROES BEFORE NEXT NUMBER.
      X9IN=10.0D+00*X9IN
      IPT=IPT+1
      IMZERO=IMZERO-1
      GO TO 100
C-----DIGIT FOUND. INCREMENT FIXED POINT EQUIVALENT AND DECIMAL POINT
C-----OFFSET.
  110 X9IN=10.0D+00*X9IN+XDIG(K)
      IPT=IPT+1
  120 CONTINUE
C-----ENTIRE FIELD TRANSLATED (NO EXPONENT). CONVERT TO FLOATING POINT.
      GO TO 150
C-----BLANK FOUND (END OF MANTISSA). SCAN REMAINDER OF FIELD FOR
C-----EXPONENT.
  130 I=J+1
      IF(I.GT.11) GO TO 150
      DO 140 J=I,11
      IFIELD=FIELD(J)
      IF(IFIELD.EQ.' ') GO TO 140
      IF(IFIELD.EQ.'e'.OR.IFIELD.EQ.'E') GO TO 160
      IF(IFIELD.EQ.'d'.OR.IFIELD.EQ.'D') GO TO 160
      IF(IFIELD.EQ.'-') GO TO 190
      IF(IFIELD.EQ.'+') GO TO 170
C-----ERROR. CANNOT IDENTIFY CHARACTER.
      GO TO 240
  140 CONTINUE
C-----ENTIRE FIELD TRANSLATED (NO EXPONENT). CONVERT TO FLOATING POINT.
  150 E=X9IN
      IF(IPT.GT.0) E=E/TENS(IPT)
      E=SIGN*E
      RETURN
C
C     TRANSLATE EXPONENT.
C
C-----BEGINNING OF EXPONENT FOUND (E OR D). CHECK FOR FOLLOWING - OR +.
  160 J=J+1
      IFIELD=FIELD(J)
      IF(IFIELD.EQ.'-') GO TO 190
      IF(IFIELD.NE.'+') GO TO 180
C----- + FOUND. INITIALIZE EXPONENT SIGN.
  170 J=J+1
  180 ISIGN=1
      GO TO 200
C----- - FOUND. INITIALIZE EXPONENT SIGN.
  190 J=J+1
      ISIGN=-1
C-----INITIALIZE EXPONENT AND SCAN REMAINING CHARACTERS FOR EXPONENT.
  200 IEXP=0
      DO 230 I=J,11
      IFIELD=FIELD(I)
      IF(IFIELD.EQ.' ') GO TO 230
      DO 210 K=0,9
      IF(IFIELD.EQ.DIGIT(K)) GO TO 220
  210 CONTINUE
C-----ERROR. CANNOT IDENTIFY CHARACTER.
      GO TO 240
C-----DIGIT FOUND. INCREMENT EXPONENT.
C-----OFFSET.
  220 IEXP=10*IEXP+K
  230 CONTINUE
C-----ENTIRE FIELD TRANSLATED (WITH EXPONENT). CONVERT TO FLOATING
C-----POINT.
      E=X9IN
      IEXP=ISIGN*IEXP
      IF(IPT.GT.0) IEXP=IEXP-IPT
C-----12/18/2012 - EXTENDED FOR 3 DIGIT EXPONENTS
C-----11/26/2013 - Limited to 2 Digit Exponents
      IF(iabs(IEXP).GT.99) GO TO 240
      E=SIGN*E*TENS(IEXP)
      RETURN
C
C     ERROR CONDITIONS.
C
C-----ILLEGAL CHARACTER.
  240 MESS(J)='*'
      write(*,250) FIELD,MESS
  250 FORMAT(1X,11A1/1X,11A1/' ERROR in Input Data...Translated as 0.')
      E=0.0D+00
      MESS(J)=' '
      RETURN
      END
      SUBROUTINE INTGER(INT,FIELD)
C=================================================================
C
C     CONVERT FROM HOLLERITH TO INTEGER.
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 BLANK,PLUS,MINUS,STAR,MESS,DIGIT,FIELD
      DIMENSION FIELD(11),DIGIT(10),MESS(11)
      DATA BLANK/' '/
      DATA PLUS/'+'/
      DATA MINUS/'-'/
      DATA STAR/'*'/
      DATA MESS/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/
C-----INITIALIZE INTEGER TO ZERO AND SIGN TO PLUS.
      INT=0
      ISIGN=1
C-----SKIP LEADING BLANKS.
      DO 10 I=1,11
      IF(FIELD(I).NE.BLANK) GO TO 20
   10 CONTINUE
C-----FIELD IS BLANK. RETURN ZERO.
      RETURN
C-----ALLOW LEADING PLUS OR MINUS SIGN.
   20 IF(FIELD(I).EQ.PLUS) GO TO 30
      IF(FIELD(I).NE.MINUS) GO TO 40
      ISIGN=-1
C-----ERROR IF LAST CHARACTER IS SIGN.
   30 J=I
      IF(I.EQ.11) GO TO 110
      I=I+1
C-----SCAN FOR BLANK (END OF INTEGER) OR DIGITS.
   40 DO 70 J=I,11
      IF(FIELD(J).EQ.BLANK) GO TO 80
      DO 50 K=1,10
      IF(FIELD(J).EQ.DIGIT(K)) GO TO 60
   50 CONTINUE
C-----ERROR. CANNOT RECOGNIZE CHARACTER.
      GO TO 110
C-----DIGIT FOUND.
   60 INT=10*INT+(K-1)
   70 CONTINUE
      GO TO 100
C-----TRAILING BLANK FOUND. INSURE REMAINDER OF FIELD IS BLANK.
   80 K=J
      DO 90 J=K,11
      IF(FIELD(J).NE.BLANK) GO TO 110
   90 CONTINUE
C-----ENTIRE NUMBER TRANSLATED. RETURN SIGNED NUMBER.
  100 INT=ISIGN*INT
      RETURN
  110 MESS(J)=STAR
      WRITE(3,120) FIELD,MESS
      MESS(J)=BLANK
      INT=0
      RETURN
  120 FORMAT(' Subroutine INTGER ERROR '/
     1 1X,11A1/1X,11A1/' Translated as 0')
      END
      SUBROUTINE CONCAT(BCD1,IBCD1,BCD2,IBCD2)
C=================================================================
C
C     CONCATENATE 2 CHARACTER STRINGS TOGETHER.
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 BCD1,BCD2
      DIMENSION BCD1(IBCD1),BCD2(IBCD2)
      DO 10 I=1,IBCD2
      IBCD1=IBCD1+1
      BCD1(IBCD1)=BCD2(I)
   10 CONTINUE
      RETURN
      END
      SUBROUTINE NUMBR1(XI,YI,HT,Z,ANG,IZ)
C=================================================================
C
C     CONVERT FLOATING POINT NUMBER OF CHARACTER STRING AND PLOT WIDE.
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 DIGIT,MINUS,DOT,FIELD
      DIMENSION DIGIT(10),FIELD(16)
      DATA DIGIT/'1','2','3','4','5','6','7','8','9','0'/
      DATA MINUS/'-'/
      DATA DOT/'.'/
C
C     ROUND-OFF NUMBER TO REQUIRED DIGITS, E.G. IF WRITING 54.321 WITH
C     2 DIGITS AFTER DECIMAL POINT DEFINE MR=5432 (ENTIRE STRING) AND
C     MR1=54 (DIGITS PRECEDING DECIMAL POINT).
C
      AZ=DABS(Z)
      IIZ=IZ
      IF(IIZ.LE.0) IIZ=0
      Z10=10.0**IIZ
      MR=AZ*Z10+0.5
      IZ10=Z10
      MR1=MR/IZ10
C
C     DETERMINE NUMBER OF DIGITS PRECEDING DECIMAL POINT.
C
      M10=1
      DO 10 IDIG=1,12
      NR=MR1/M10
      IF(NR.LE.0) GO TO 20
      M10=10*M10
   10 CONTINUE
C
C     NUMBER IS TOO BIG...NO PLOTTING.
C
      RETURN
   20 IF(IDIG.EQ.1) GO TO 30
      IDIG=IDIG-1
      M10=M10/10
C
C     ADD DIGITS AFTER DECIMAL POINT.
C
   30 IDIG=IDIG+IIZ
      M10=M10*IZ10
C
C     IF NUMBER IS ZERO, PLOT ZERO AND RETURN.
C
      IF(IDIG.GT.0) GO TO 40
      IFIELD=1
      FIELD(1)=DIGIT(10)
      GO TO 80
C
C     INITIALIZE CHARACTER COUNT.
C
   40 IFIELD=0
C
C     IF NUMBER IS NEGATIVE INSERT MINUS SIGN.
C
      IF(Z.GE.0.0) GO TO 50
      FIELD(1)=MINUS
      IFIELD=1
C
C     DEFINE POSITION OF DECIMAL POINT (IF ANY).
C
   50 IDOT=IDIG-IZ
      IF(IZ.LT.0) IDOT=IDIG+2
C
C     INSERT DIGITS AND DECIMAL POINT (IF ANY) IN STRING.
C
      DO 70 I=1,IDIG
      NDIG=MR/M10
      KDIG=NDIG
      IF(KDIG.EQ.0) KDIG=10
      IFIELD=IFIELD+1
      FIELD(IFIELD)=DIGIT(KDIG)
C
C     INSERT DECIMAL POINT AT APPROPRIATE POSITION.
C
      IF(I.NE.IDOT) GO TO 60
      IFIELD=IFIELD+1
      FIELD(IFIELD)=DOT
   60 MR=MR-M10*NDIG
      M10=M10/10
   70 CONTINUE
C
C     ENTIRE FIELD FORMATTED. PLOT IT.
C
   80 CALL SYMBL1(XI,YI,HT,FIELD(1),ANG,IFIELD)
      RETURN
      END
      SUBROUTINE SYMBL1(X,Y,HTIN,MESS,ANG,NMESS)
C=================================================================
C
C     DRAW THICK CHARACTERS DEFINED BY STROKES IN SYMBOL TABLE
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 MESS,CHRTAB,CHRTRL
      COMMON/SYMTB1/CHRTAB(256),CHRTRL(256)
      COMMON/SYMTB2/XCHAR(5000),YCHAR(5000),ICHPEN(5000),
     1 INDCHR(2,256),ICHAR,ICNTRL,ISYM
      COMMON/THICKY/THICK,ITHICK,NTHICK(3)
      COMMON/THINME/IMTHIN
      COMMON/SIZEHT/HTSIZE
      DIMENSION MESS(NMESS)
C-----INITIALIZE FLAG TO USE STANDARD CHARACTER SET.
      DATA IALTER/0/
C-----INITIALIZE X AND Y OFFSET (USED FOR SUB AND SUPER SCRIPTS).
      DATA XSET/0.0/
      DATA YSET/0.0/
C-----IF NO SOFTWARE CHARACTERS RETURN.
      IF(ICHAR.LE.0) RETURN
C-----IF REQUESTED USE THIN CHARACTERS.
      IF(IMTHIN.EQ.0) GO TO 10
      ITHICK=0
      GO TO 20
C-----DEFINE SCALED LINE WIDTH.
   10 ITHICK=NTHICK(2)
      IF(HTIN.GT.HTSIZE) ITHICK=NTHICK(3)
      IF(HTIN.LT.HTSIZE) ITHICK=NTHICK(1)
C-----INITIALIZE POSITION AND DEFINE INCREMENTS.
   20 X1=X
      Y1=Y
      KWAY=0
      IF(DABS(ANG).GT.1.0) KWAY=1
      IF(KWAY.NE.0) GO TO 30
      DX1=HTIN
      DY1=0.0
      GO TO 40
   30 DX1=0.0
      DY1=HTIN
C-----SET UP LOOP TO PLOT CHARACTERS ONE AT A TIME.
   40 DO 140 N=1,NMESS
C-----INITIALIZE COUNT OF THE NUMBER OF TIMES CHARACTER HAS BEEN FOUND
C-----(TO SELECT STANDARD OR ALTERNATE CHARACTER SET).
      NALTER=0
      DO 60 I=1,ICHAR
      IF(MESS(N).NE.CHRTAB(I)) GO TO 60
C-----ALWAYS USE CONTROL CHARACTERS REGARDLESS OF CHARACTER SET.
      I1=INDCHR(1,I)
      IF(ICHPEN(I1).LE.0) GO TO 70
C-----SELECT STANDARD OR ALTERNATE CHARACTER SET.
      IF(NALTER.NE.IALTER) GO TO 50
C-----CHARACTER FOUND.
      I2=INDCHR(2,I)
      GO TO 90
   50 NALTER=NALTER+1
   60 CONTINUE
C-----NOT SPECIAL CHARACTER...IGNORE.
      GO TO 140
C-----CONTROL CHARACTER...CHANGE CHARACTER SET OR RE-DEFINE OFFSET.
   70 IF(ICHPEN(I1).EQ.0) GO TO 80
C-----CHANGE CHARACTER SETS.
      IALTER=1-IALTER
      GO TO 140
C-----DEFINE OFFSET.
   80 XSET=XSET+XCHAR(I1)
      YSET=YSET+YCHAR(I1)
      GO TO 140
   90 IF(KWAY.NE.0) GO TO 110
C-----HORIZONTAL.
      DO 100 I=I1,I2
      CALL PLOT1(X1+HTIN*(XSET+XCHAR(I)),Y1+HTIN*(YSET+YCHAR(I)),
     1 ICHPEN(I))
  100 CONTINUE
C-----ALL FOLLOWING CHARACTERS WILL BE POSITIONED RELATIVE TO THE OFFSET
      X1=X1+XSET*HTIN
      GO TO 130
C-----VERTICAL.
  110 DO 120 I=I1,I2
      CALL PLOT1(X1-HTIN*(YSET+YCHAR(I)),Y1+HTIN*(XSET+XCHAR(I)),
     1 ICHPEN(I))
  120 CONTINUE
C-----ALL FOLLOWING CHARACTERS WILL BE POSITIONED RELATIVE TO THE OFFSET
      Y1=Y1+XSET*HTIN
C-----MOVE TO NEXT CHARACTER POSITION.
  130 X1=X1+DX1
      Y1=Y1+DY1
C-----TURN OFF ALTERNATE CHARACTER SET FLAG AND SET OFFSET TO ZERO.
      IALTER=0
      XSET=0.0
      YSET=0.0
  140 CONTINUE
C-----RESTORE LINE WIDTH.
      ITHICK=NTHICK(2)
      RETURN
      END
      SUBROUTINE SYMIN
C=================================================================
C
C     LOAD SPECIAL SYMBOL TABLE.
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 CHRTAB,CHRTRL
      COMMON/SYMTB1/CHRTAB(256),CHRTRL(256)
      COMMON/SYMTB2/XCHAR(5000),YCHAR(5000),ICHPEN(5000),
     1 INDCHR(2,256),ICHAR,ICNTRL,ISYM
C-----DEFINE CORE SIZE.
      DATA ICORE/5000/
C-----INITIALIZE CHARACTER INDEX AND COUNT OF CONTROL CHARACTERS.
      IHIGH=0
      ICNTRL=0
C-----SET UP LOOP TO READ UP TO 256 SPECIAL CHARACTERS.
      DO 30 ICHAR=1,256
C-----READ FIRST LINE TO DEFINE CHARACTER AND NUMBER OF STROKES.
      READ(ISYM,60,ERR=40,END=40) CHRTAB(ICHAR),ICOUNT
      LOWEST=IHIGH+1
      IHIGH=IHIGH+ICOUNT
C-----INSURE THERE IS AVAILABLE CORE.
      IF(IHIGH.GT.ICORE) GO TO 40
C-----READ STROKES (X, Y, PEN POSITION).
      DO 10 I=LOWEST,IHIGH
      READ(ISYM,70,ERR=40,END=40) XCHAR(I),YCHAR(I),ICHPEN(I)
   10 CONTINUE
C-----SAVE CONTROL CHARACTERS.
      IF(ICOUNT.NE.1) GO TO 20
      IF(ICHPEN(LOWEST).GT.0) GO TO 20
      ICNTRL=ICNTRL+1
      CHRTRL(ICNTRL)=CHRTAB(ICHAR)
C-----DEFINE INDICES TO SPECIAL CHARACTER STROKE TABLE.
   20 INDCHR(1,ICHAR)=LOWEST
      INDCHR(2,ICHAR)=IHIGH
   30 CONTINUE
      ICHAR=256
      GO TO 50
C-----END OF DATA OR ERROR.
   40 ICHAR=ICHAR-1
   50 RETURN
   60 FORMAT(1X,A1,I5)
   70 FORMAT(2F7.3,I5)
      END
      SUBROUTINE SYMREF(X1,X2,X3,Y1,Y2,Y3,HT,NREF)
C=================================================================
C
C     PLOT SYMBOL AND ERROR BARS FOR DATA POINT
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/REFTB2/XREF(2000),YREF(2000),IRFPEN(2000),INDREF(2,256),
     1 IREFER,IREF
      COMMON/REFTB3/REFWTH(256)
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      DATA XSET/0.5/
      DATA YSET/0.5/
C-----FIRST CHECK FOR SPECIAL CHARACTERS.
      IF(NREF.GT.IREFER) GO TO 50
C-----SPECIAL CHARACTER...USE PLOT TO PLOT STROKES FOR CHARACTER.
      I1=INDREF(1,NREF)
      I2=INDREF(2,NREF)
      BOXSIZE=0.25*HT
      DO 10 I=I1,I2
C-----DEFINE X AND Y AND TRUNCATE TO INTERIOR OF PLOT.
      XP=X1+BOXSIZE*(XREF(I)-XSET)
      YP=Y1+BOXSIZE*(YREF(I)-YSET)
      IF(XP.LT.XINCHP(1)) XP=XINCHP(1)
      IF(XP.GT.XINCHP(2)) XP=XINCHP(2)
      IF(YP.LT.YINCHP(1)) YP=YINCHP(1)
      IF(YP.GT.YINCHP(2)) YP=YINCHP(2)
      CALL PLVHN(XP,YP,IRFPEN(I))
   10 CONTINUE
C-----DRAW ERROR BARS.
      BOZ=BOXSIZE/4.0
      HTY=BOXSIZE/2.0
      HTX=HTY*REFWTH(NREF)
      XA=X1-HTX
      IF(XA.LE.X2) GO TO 20
      CALL PLVHN(XA,Y1,3)
      CALL PLVHN(X2,Y1,2)
      CALL PLVHN(X2,Y1-BOZ,3)
      CALL PLVHN(X2,Y1+BOZ,2)
   20 XB=X1+HTX
      IF(XB.GE.X3) GO TO 30
      CALL PLVHN(XB,Y1,3)
      CALL PLVHN(X3,Y1,2)
      CALL PLVHN(X3,Y1-BOZ,3)
      CALL PLVHN(X3,Y1+BOZ,2)
   30 YA=Y1-HTY
      IF(YA.LE.Y2) GO TO 40
      CALL PLVHN(X1,YA,3)
      CALL PLVHN(X1,Y2,2)
      CALL PLVHN(X1-BOZ,Y2,3)
      CALL PLVHN(X1+BOZ,Y2,2)
   40 YB=Y1+HTY
      IF(YB.GE.Y3) GO TO 50
      CALL PLVHN(X1,YB,3)
      CALL PLVHN(X1,Y3,2)
      CALL PLVHN(X1-BOZ,Y3,3)
      CALL PLVHN(X1+BOZ,Y3,2)
   50 RETURN
      END
      SUBROUTINE REFIN
C=================================================================
C
C     LOAD SPECIAL SYMBOL AND LINE TYPE TABLES.
C
C=================================================================
      INCLUDE 'implicit.h'
      COMMON/REFTB2/XREF(2000),YREF(2000),IRFPEN(2000),INDREF(2,256),
     1 IREFER,IREF
      COMMON/REFTB3/REFWTH(256)
C-----DEFINE CORE SIZE.
      DATA ICORE/2000/
C-----INITIALIZE CHARACTER INDEX.
      IHIGH=0
C-----SET UP LOOP TO READ UP TO 256 SPECIAL CHARACTERS.
      DO 20 IREFER=1,256
C-----READ FIRST LINE TO DEFINE CHARACTER AND NUMBER OF STROKES.
      READ(IREF,50,ERR=30,END=30) ICOUNT,REFWTH(IREFER)
      LOWEST=IHIGH+1
      IHIGH=IHIGH+ICOUNT
C-----INSURE THERE IS AVAILABLE CORE.
      IF(IHIGH.GT.ICORE) GO TO 30
C-----READ STROKES (X, Y, PEN POSITION).
      DO 10 I=LOWEST,IHIGH
      READ(IREF,60,ERR=30,END=30) XREF(I),YREF(I),IRFPEN(I)
   10 CONTINUE
C-----DEFINE INDICES TO SPECIAL CHARACTER STROKE TABLE.
      INDREF(1,IREFER)=LOWEST
      INDREF(2,IREFER)=IHIGH
   20 CONTINUE
      IREFER=256
      GO TO 40
C-----END OF DATA OR ERROR.
   30 IREFER=IREFER-1
   40 RETURN
   50 FORMAT(2X,I5,F7.3)
   60 FORMAT(2F7.3,I5)
      END
      SUBROUTINE FILEIO
C=================================================================
C
C     DEFINE ALL I/O UNITS AND OPTIONALLY DEFINE FILE NAMES.
C
C=================================================================
      INCLUDE 'implicit.h'
      INTEGER*4 OUTP
      COMMON/UNITS/INP,OUTP,ITAPE1,ITAPE2
      COMMON/SYMTB2/XCHAR(5000),YCHAR(5000),ICHPEN(5000),
     1 INDCHR(2,256),ICHAR,ICNTRL,ISYM
      COMMON/REFTB2/XREF(2000),YREF(2000),IRFPEN(2000),INDREF(2,256),
     1 IREFER,IREF
C-----DEFINE ALL I/O UNITS.
      INP=2
      OUTP=3
      ITAPE1=10
      ITAPE2=11
      ISYM=12
      IREF=14
C-----OPTIONALLY DEFINE FILE NAMES.
C***** NAMES ******
      OPEN(INP,FILE='PLOTTAB.INP')
      OPEN(OUTP,FILE='PLOTTAB.LST')
      OPEN(ITAPE1,FILE='PLOTTAB.CUR')
      OPEN(ITAPE2,FILE='PLOTTAB.PNT')
      OPEN(ISYM,FILE='PLOT.CHR')
      OPEN(IREF,FILE='PLOT.SYM')
C***** NAMES ******
      RETURN
      END
      SUBROUTINE ENDIT
C=================================================================
C
C     CLOSE ALL FILES AND TERMINATE PLOTTING AND EXECUTION
C
C=================================================================
      INCLUDE 'implicit.h'
      INTEGER*4 OUTP
      COMMON/UNITS/INP,OUTP,ITAPE1,ITAPE2
      COMMON/SYMTB2/XCHAR(5000),YCHAR(5000),ICHPEN(5000),
     1 INDCHR(2,256),ICHAR,ICNTRL,ISYM
      COMMON/REFTB2/XREF(2000),YREF(2000),IRFPEN(2000),INDREF(2,256),
     1 IREFER,IREF
C-----TERMINATE PLOTTING.
      CALL ENDPLOTS
C-----CLOSE ALL I/O FILES.
      CLOSE(INP)
      CLOSE(OUTP)
      CLOSE(ITAPE1)
      CLOSE(ITAPE2)
      CLOSE(ISYM)
      CLOSE(IREF)
C-----TERMINATE EXECUTION.
      CALL EXIT
      END
      SUBROUTINE ACTION(IMACTIVE)
C=======================================================================
C
C     SERVICE ALL INTERACTIVE INPUT
C
C     THIS ROUTINE SETS (IMACTIVE) TO INDICATE WHETHER OR NOT
C     THERE WAS INTERACTIVE INPUT.
C
C     IMACTIVE = 0 - NO INTERACTION
C              = 1 - INTERACTION
C
C     ALL SELECTED OPTIONS ARE SERVICED INSIDE THIS ROUTINE BY
C     SETTING VARIOUS PLOT OPTIONS. UPON RETURN IF IMACTIVE = 0,
C     PROCEED TO THE NEXT PLOT. IF IMACTIVE = 1, PLOT THE SAME
C     DATA OVER AGAIN WITH THE NEW OPTIONS.
C
C=======================================================================
      INCLUDE 'implicit.h'
      CHARACTER*10 NOPT
      COMMON/OPTION/NROUND(2),IWANT(2),XRANGE(2),YRANGE(2),KWANT(2,2)
      COMMON/XYLIM/XLIM(2),XLIMR(2),YLIM(2),YLIMR(2),DXLIM,DYLIM
      COMMON/XYOFF/XOFF,YOFF,XSCALE,YSCALE,XSIZE,YSIZE
      COMMON/PLTLIM/XINCHP(2),YINCHP(2),DXINCH,DYINCH
      COMMON/PLTTOP/TINCHP(2)
      COMMON/BOXLIM/BOXMIN,BOXMAX,BOYMIN,BOYMAX,DXBOX,DYBOX
      COMMON/WAYS/IWAY(2)
      COMMON/OPS2/NOPT(40)
      COMMON/XYBOXES/XBOXER(9),YBOXER(6)
      COMMON/SHOWPT/MYSHOW
      COMMON/STARTX/XSTART(2),ISTARTX(2),LSTART(2),IWAYD(2),
     1 KNTERD,KNTERR
      COMMON/TERPIT/INTERD,INTERR
      COMMON/SUBPLT/YFINCH(2),YSINCH(2,3),NPLOT,MPLOT
      COMMON/XYLABI/IXLAB(2),IYLAB(2),NXLAB(2),NYLAB(2),XMULT,YMULT,
     1 XBASE,XSTEP1,XSTEP2,YBASE,YSTEP1,YSTEP2,IXSTEP,IYSTEP,IXMULT,
     2 IYMULT
      COMMON/GRIDDY/IMFINE(2)
      COMMON/LEGOFF/NOLEGS
      COMMON/MULTHT/HTMULT
c-----2014/4/28 - Added X and Y Error bars (8 and 9)
      COMMON/ERRBAR/IXBAR,IYBAR
C-----INITIALIZE TO MOUSE INPUT OPTION.
      IMACTIVE=1
C-----DISPLAY OPTION BOXES
   10 CALL TOPPER
C-----DELAY FOR OPTION SELECTION
      CALL PEN(2)
      CALL SHOWTEXT(54,0,'Use MOUSE to Select Option',26)
      CALL PLOTD(XBOXER(1),YBOXER(1),3)
      CALL PLOTD(XBOXER(9),YBOXER(1),2)
      CALL KIWI(KOPT,IX,IY)
C-----RETURN IF NO KEYBOARD INPUT.
      IF(KOPT.LE.0) GO TO 220
      CALL PEN(3)
      CALL SHOWTEXT(54,0,'                          ',26)
      CALL PLOTD(XBOXER(1),YBOXER(1),3)
      CALL PLOTD(XBOXER(9),YBOXER(1),2)
C-----HIGHLIGHT OPTION
      CALL TEXTBOX(IX,IY,NOPT(KOPT),3)
      CALL PEN(3)
      CALL SHOWTEXT(36,0,NOPT(KOPT),10)
C-----RESTORE BOX.
      CALL PEN(6)
      CALL BOXCOLORD(XBOXER(IX),YBOXER(IY),-1,3)
C=======================================================================
C
C     EXECUTE OPTION
C
C=======================================================================
C
C     1 = LIN/LOG X
C
      IF(KOPT.NE.1) GO TO 20
c-----2014/4/29 - Cannot change if input X range < 0
      IF(XRANGE(1).lt.0.0d+0) RETURN
      IF(XRANGE(2).lt.0.0d+0) RETURN
c-----2014/4/29 - Explicitly Handle ALL values.
      IF(IWAYD(1).eq. 2) IWAY(1) =  1
      IF(IWAYD(1).eq. 1) IWAY(1) =  2
      IF(IWAYD(1).eq.-1) IWAY(1) = -2
      IF(IWAYD(1).eq.-2) IWAY(1) = -1
      IWANT(1)=IWAY(1)
      IF(IWANT(1).EQ.IABS(LSTART(1))) IWANT(1)=LSTART(1)
      INTERD=KNTERD
      INTERR=KNTERR
      RETURN
C
C     2 = LIN/LOG Y
C
   20 IF(KOPT.NE.2) GO TO 30
C-----LIN/LOG Y
c-----2014/4/29 - Cannot change if input Y range < 0
      IF(YRANGE(1).lt.0.0d+0) RETURN
      IF(YRANGE(2).lt.0.0d+0) RETURN
c-----2014/4/29 - Explicitly Handle ALL values.
      IF(IWAYD(2).eq. 2) IWAY(2) =  1
      IF(IWAYD(2).eq. 1) IWAY(2) =  2
      IF(IWAYD(2).eq.-1) IWAY(2) = -2
      IF(IWAYD(2).eq.-2) IWAY(2) = -1
      IWANT(2)=IWAY(2)
      IF(IWANT(2).EQ.IABS(LSTART(2))) IWANT(2)=LSTART(2)
      INTERD=KNTERD
      INTERR=KNTERR
      RETURN
C
C     3 = ZOOM X
C
   30 IF(KOPT.EQ.3) GO TO 150
C
C     4 = POINTS.
C
      IF(KOPT.NE.4) GO TO 40
      MYSHOW=1-MYSHOW
      RETURN
C
C     5 = NEXT PLOT
C
   40 IF(KOPT.EQ.5) GO TO 220
C
C     6 = SHOW ALL
C
      IF(KOPT.NE.6) GO TO 50
C-----DEFINE ORIGINAL RANGE
      XI1=XSTART(1)
      XI2=XSTART(2)
C-----DEFINE ORIGINAL SCALING AND INTERPOLATION.
      IWAY(1)=ISTARTX(1)
      IWAY(2)=ISTARTX(2)
      IWANT(1)=LSTART(1)
      IWANT(2)=LSTART(2)
      INTERD=KNTERD
      INTERR=KNTERR
      GO TO 210
C
C     7 - RATIO
C
   50 IF(KOPT.NE.7) GO TO 60
      MPLOT=3-MPLOT
      RETURN
C
C     2014/4/28 - Added X and Y Error bars (8 and 9).
C
C     8 - X Err Bar
C
   60 IF(KOPT.NE.8) GO TO 70
      IXBAR = 1 - IXBAR
      RETURN
C
C     9 - Y Err Bar
C
   70 IF(KOPT.NE.9) GO TO 80
      IYBAR = 1 - IYBAR
      RETURN
C
C     10 - BLACK/WHITE
C
   80 IF(KOPT.NE.10) GO TO 90
      CALL NEWBACK
      RETURN
C
C     11 TO 16 GRID
C
   90 IF(KOPT.LT.11.OR.KOPT.GT.16) GO TO 100
      IMFINE(1)=0
      IMFINE(2)=0
      II=KOPT-11
      IF(II.GT.0) IMFINE(1)=1
      IF(II.EQ.1.OR.II.EQ.3) IMFINE(1)=2
      IF(II.GT.2) IMFINE(2)=2
      IF(II.EQ.5) IMFINE(2)=1
      RETURN
C
C     17 - LEGEND BOX.
C
  100 IF(KOPT.NE.17) GO TO 110
      NOLEGS=1-NOLEGS
      RETURN
C
C     18 - BIGGER CHARACTERS
C
  110 IF(KOPT.NE.18) GO TO 120
      IF(HTMULT.GE.2.0) RETURN
c-----PREVENT LEGEND BOX FROM BEING TOO BIG < 50% of X/Y plot range.
      DXINCH = XINCHP(2) - XINCHP(1)
      DTINCH = TINCHP(2) - TINCHP(1)
      DXBOX  = BOXMAX - BOXMIN
      DYBOX  = BOYMAX - BOYMIN
      if(DXBOX.gt.0.5*DXINCH.or.
     1   DYBOX.gt.0.5*DTINCH) RETURN
c-----Increase Character size.
      HTMULT=1.2*HTMULT
      IF(HTMULT.GT.2.0) HTMULT=2.0
      IMTHRU=1
      CALL SETUP(IMTHRU)
      RETURN
C
C     19 - SMALLER CHARACTERS
C
  120 IF(KOPT.NE.19) GO TO 130
      IF(HTMULT.LT.0.5) RETURN
c-----Decrease Character size.
      HTMULT=HTMULT/1.2
      IF(HTMULT.LT.0.5) HTMULT=0.5
      IMTHRU=1
      CALL SETUP(IMTHRU)
      RETURN
C
C     25 = COLOR DUMP
C
  130 IF(KOPT.NE.25) GO TO 140
      CALL PRINTIT
      GO TO 10
C
C     36 = STOP.
C
  140 IF(KOPT.EQ.36) CALL ENDIT
C-----RETURN IF OPTION IS NOT DEFINED.
      RETURN
C=======================================================================
C
C     ZOOM X USING MOUSE
C
C=======================================================================
C
C     REQUEST MOUSE INPUT TO DEFINE X LIMITS.
C
  150 CALL PEN(2)
      CALL SHOWTEXT(45,0,'Use MOUSE to Define Zoomed X Limits',35)
C
C     DEFINE LOWER X LIMIT
C
  160 CALL MOUSEYD(KWAY,XIN1,YI1,1,4)
C-----RETURN IF KEYBOARD INPUT.
      IF(KWAY.EQ.4) GO TO 220
      XI1=(XIN1-XOFF)/XSCALE
      IF(XI1.LT.XINCHP(1).OR.XI1.GT.XINCHP(2)) GO TO 160
      CALL PEN(1)
      YIN1=YSCALE*YFINCH(1)+YOFF
      YIN2=YSCALE*YFINCH(2)+YOFF
      CALL PLOTD(XIN1,YIN1,3)
      CALL PLOTD(XIN1,YIN2,2)
C
C     DEFINE UPPER X LIMIT
C
C-----RETURN IF KEYBOARD INPUT.
  170 CALL MOUSEYD(KWAY,XIN2,YI2,1,4)
      IF(KWAY.EQ.4) GO TO 220
      XI2=(XIN2-XOFF)/XSCALE
      IF(XI2.LT.XINCHP(1).OR.XI2.GT.XINCHP(2)) GO TO 170
      CALL PEN(1)
      CALL PLOTD(XIN2,YIN1,3)
      CALL PLOTD(XIN2,YIN2,2)
C
C     ACCEPT ZOOMED X RANGE
C
C-----SORT INTO ASCENDING ORDER.
      IF(XI1.lt.XI2) go to 180
      IF(XI1.eq.XI2) go to 220
      XI3=XI1
      XI1=XI2
      XI2=XI3
C-----CONVERT FROM INCHES TO DATA UNITS.
  180 DXINCH=XINCHP(2)-XINCHP(1)
      XI1=(XLIM(2)*(XI1-XINCHP(1))+XLIM(1)*(XINCHP(2)-XI1))/DXINCH
      XI2=(XLIM(2)*(XI2-XINCHP(1))+XLIM(1)*(XINCHP(2)-XI2))/DXINCH
      IF(IWAY(1).EQ.1) GO TO 190
      XI1=10.0**XI1
      XI2=10.0**XI2
      GO TO 200
C
C     CORRECT FOR LINEAR OFFSET MULTIPLIER
C
  190 XI1=XI1*(10.0**IXMULT)
      XI2=XI2*(10.0**IXMULT)
C
C     X RANGE SELECTED.
C
C-----ALLOW AUTOMATIC LIN/LOG SCALING FOR NEXT PLOT
  200 IWANT(1)=0
      IWANT(2)=0
      IWAY(1)=0
      IWAY(2)=0
      INTERD=KNTERD
      INTERR=KNTERR
C
C     DEFINE REQUESED X RANGE AND SET KWANT TO INDICATE REQUEST
C
  210 XRANGE(1)=XI1
      XRANGE(2)=XI2
      KWANT(1,1)=1
      KWANT(2,1)=1
      RETURN
C
C     KEYBOARD INPUT - NO INTERACTION
C
  220 IMACTIVE=0
      RETURN
      END
      SUBROUTINE SETMOUSE
C==================================================================
C
C     INITIAL SETUP FOR INTERACTION.
C
C     DEFINE LIMITS OF OPTION BOXES AND DISPLAY ALL OPTIONS.
C
C     OPTION LIMITS
C     XBOXER 1 THROUGH 9 - LEFT TO RIGHT - COLUMNS 1 THROUGH 8
C     YBOXER 1 THROUGH 6 - TOP TO BOTTOM - ROWS 1 THROUGH 5
C
C     OPTIONS 8 BY 5 = 40 OPTIONS
C
C     OPTION INDEX = IY + 5*(IX - 1)
C     IY = 1 TO 5
C     IX = 1 TO 8
C
C==================================================================
      INCLUDE 'implicit.h'
      COMMON/PLOTXY/XYPLOT(2,2),NBORD,IFLIP
      COMMON/XYBOXES/XBOXER(9),YBOXER(6)
      REAL*4 XTOPPER,YTOPPER
      COMMON/TOPXY/XTOPPER(2),YTOPPER(2)
C-----RE-SET SCREEN LIMITS TO THOSE OF THE LOCAL SCREEN.
      CALL MYSIZED(XYPLOT(1,1),XYPLOT(1,2))
C-----DEFINE X LIMITS OF OPTION BOXES
      DX=(XYPLOT(2,1)-XYPLOT(1,1))/8.0
      XBOXER(1)=XYPLOT(1,1)
      DO 10 I=2,9
      XBOXER(I)=XBOXER(I-1)+DX
   10 CONTINUE
      DY=(XYPLOT(2,2)-XYPLOT(1,2))/30.0
C-----DEFINE Y LIMITS OF OPTION BOXES
      YBOXER(1)=XYPLOT(2,2)-DY
      DO 20 I=2,6
      YBOXER(I)=YBOXER(I-1)-DY
   20 CONTINUE
C-----DEFINE AREA AT TOP TO BLANK.
      XTOPPER(1)=XYPLOT(1,1)
      XTOPPER(2)=XYPLOT(2,1)
      YTOPPER(1)=YBOXER(6)
      YTOPPER(2)=XYPLOT(2,2)
C-----RE-DEFINE TOP OF PLOTTING AREA.
      XYPLOT(2,2)=YBOXER(6)-0.01
C-----DISPLAY OPTIONS
      CALL TOPPER
C-----DISPLAY STARTING MESSAGE
c     CALL PEN(2)
c     CALL SHOWTEXT(54,0,'    Press ANY KEY to Start',26)
      RETURN
      END
      SUBROUTINE TOPPER
C==================================================================
C
C     ON FIRST CALL LOAD DEFINITION OF OPTIONS FROM 'PAGE.DAT'
C
C     DISPLAY OPTION BOXES.
C
C==================================================================
      INCLUDE 'implicit.h'
      CHARACTER*10 NOPT,NOPT1
      COMMON/OPS2/NOPT(40)
      COMMON/XYBOXES/XBOXER(9),YBOXER(6)
      REAL*4 XTOPPER,YTOPPER
      COMMON/TOPXY/XTOPPER(2),YTOPPER(2)
C
C     ON FIRST CALL READ OPTIONS
C
      DATA IPASS/0/
      IF(IPASS.NE.0) GO TO 40
      IPASS=1
C-----READ OPTIONS
      OPEN(30,FILE='PAGE.DAT')
      DO 10 I=1,40
      NOPT(I)=' '
   10 CONTINUE
   20 READ(30,80,END=30,ERR=30) IOPT,NOPT1
      IF(IOPT.LT.1.OR.IOPT.GT.40) GO TO 20
      NOPT(IOPT)=NOPT1
      GO TO 20
   30 CLOSE(30)
C
C     DISPLAY OPTIONS.
C
C-----BLANK THE TOP OF THE SCREEN
   40 CALL BOXCOLOR(XTOPPER,YTOPPER,0,0)
      CALL PEN(2)
      CALL SHOWTEXT(1,0,'PLOTTAB (Version 2025-1)',24)
      CALL SHOWTEXT(54,0,'Use MOUSE to Select Option',26)
      CALL PLOTD(XBOXER(1),YBOXER(1),3)
      CALL PLOTD(XBOXER(9),YBOXER(1),2)
C-----DISPLAY OPTIONS
      CALL PEN(2)
      KOPT=0
      DO 60 IX=1,8
      DO 50 IY=1,5
      KOPT=KOPT+1
      CALL TEXTBOX(IX,IY,NOPT(KOPT),4)
   50 CONTINUE
   60 CONTINUE
C-----RESTORE OPTION BOXES
      CALL PEN(6)
      DO 70 IX=1,8
      DO    IY=1,5
      CALL BOXCOLORD(XBOXER(IX),YBOXER(IY),-1,3)
      ENDDO
   70 CONTINUE
      CALL PEN(2)
      CALL PLOTD(XBOXER(1),YBOXER(1),3)
      CALL PLOTD(XBOXER(9),YBOXER(1),2)
      RETURN
   80 FORMAT(I3,1X,A10,A10,A60)
      END
      SUBROUTINE KIWI(KOPT,IX,IY)
C==================================================================
C
C     SELECT INPUT OPTION
C
C     KOPT  = 0 = KEYBOARD INPUT
C           = 1 THROUGH 40 = OPTION BOX
C     IX    = OPTION COLUMN - 1 THROUGH 8
C     IY    = OPTION ROW    - 1 THROUGH 5
C
C==================================================================
      INCLUDE 'implicit.h'
      COMMON/XYBOXES/XBOXER(9),YBOXER(6)
C-----DELAY FOR MOUSE OR KEYBOARD INPUT.
   10 CALL MOUSEYD(KWAY,XM,YM,1,4)
C-----RETURN ON KEYBOARD INPUT
      IF(KWAY.NE.4) GO TO 20
      IX=0
      IY=0
      KOPT=0
      RETURN
C-----SEE IF MOUSE X,Y IS INSIDE ON OPTION BOX.
   20 DO 30 IX=1,8
      IF(XM.LT.XBOXER(IX)) GO TO 10
      IF(XM.LE.XBOXER(IX+1)) GO TO 40
   30 CONTINUE
C-----NO - KEEP READING MOUSE.
      GO TO 10
   40 DO 50 IY=1,5
      IF(YM.GT.YBOXER(IY)) GO TO 10
      IF(YM.GE.YBOXER(IY+1)) GO TO 60
   50 CONTINUE
C-----NO - KEEP READING MOUSE.
      GO TO 10
C-----YES
   60 KOPT=IY+5*(IX-1)
      RETURN
      END
      FUNCTION LENGTH(CHAR,NCHAR)
C=====================================================================
C
C     DEFINE THE NON-BLANK LENGTH OF A CHARACTER STRING
C
C=====================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 CHAR,BLANK
      DIMENSION CHAR(NCHAR)
      DATA BLANK/' '/
      DO 10 I=NCHAR,1,-1
      IF(CHAR(I).NE.BLANK) GO TO 20
   10 CONTINUE
      I=0
   20 LENGTH=I
      RETURN
      END
      SUBROUTINE TEXTBOX(IX,IY,OPT10,MYCOLOR)
C=====================================================================
C
C     DISPLAY OPTION
C
C     IX      = 1 THROUGH 8 = COLUMN
C     IY      = 1 THROUGH 5 = ROW
C     OPT10   = 10 CHARACTER OPTION
C     MYCOLOR = COLOR DISPLAYED
C
C=====================================================================
      INCLUDE 'implicit.h'
      CHARACTER*10 OPT10
      LONG=LENGTH(OPT10,10)
      IF(LONG.LE.0) RETURN
      CALL PEN(MYCOLOR)
C-----DISPLAY OPTION IN OPTION BOX
      CALL SHOWTEXT(10*(IX-1)+1,IY,OPT10,10)
      RETURN
      END
C=======================================================================
C
C     REAL*8 TO REAL*4 INTERFACE
C
C=======================================================================
      SUBROUTINE PLOTD(XD,YD,IWAY)
C=======================================================================
C
C     input arguments REAL*8 converted to REAL*4 for use with PLOT
c
C=======================================================================
      REAL*8 XD,YD
      REAL*4 X ,Y
      X = XD
      Y = YD
      CALL PLOT(X,Y,IWAY)
      RETURN
      END
      SUBROUTINE MYSIZED(XD,YD)
C=======================================================================
C
C     input arguments REAL*8 converted to REAL*4 for use with MYSIZE
c
C=======================================================================
      REAL*8 XD(2),YD(2)
      REAL*4 X (2),Y (2)
      CALL MYSIZE(X(1),Y(1))
      XD(1) = X(1)
      XD(2) = X(2)
      YD(1) = Y(1)
      YD(2) = Y(2)
      RETURN
      END
      SUBROUTINE MOUSEYD(KWAY,XD,YD,IWAY1,IWAY2)
C=======================================================================
C
C     input arguments REAL*8 converted to REAL*4 for use with MOUSEY
c
C=======================================================================
      REAL*8 XD,YD
      REAL*4 X ,Y
      CALL MOUSEY(KWAY,X,Y,IWAY1,IWAY2)
      XD = X
      YD = Y
      RETURN
      END
      SUBROUTINE BOXCOLORD(XD,YD,IWAY1,IWAY2)
C=======================================================================
C
C     input arguments REAL*8 converted to REAL*4 for use with BOXCOLOR
c
C=======================================================================
      REAL*8 XD(2),YD(2)
      REAL*4 X (2),Y (2)
      X(1) = XD(1)
      X(2) = XD(2)
      Y(1) = YD(1)
      Y(2) = YD(2)
      CALL BOXCOLOR(X(1),Y(1),IWAY1,IWAY2)
      RETURN
      END
      SUBROUTINE PALTAB(PENMAP,RTAB,GTAB,BTAB,NPAL)
C=======================================================================
C
C     DEFINE PALLETTE OF 256 RGB COLORS
C     NPAL  = 1 = MAXIMUM CONTRAST PALLETTE
C          <> 1 = RAINBOW PALLETTE
C
C=======================================================================
      INCLUDE 'implicit4.h'
      INTEGER*4 R1,G1,B1,R2,G2,B2,PAL1,PAL2,RTAB,GTAB,BTAB,PENMAP
      DIMENSION R1(256),G1(256),B1(256),R2(256),G2(256),B2(256),
     1 RTAB(256),GTAB(256),BTAB(256),PAL1(256),PAL2(256),PENMAP(256)
C-----MAXIMUM CONTRAST PALLETTE
      DATA PAL1/
     1   0, 15, 71, 23, 87,135,231, 39,167,119,215,247,103, 55,151,199,
     2  11,188, 76, 26, 90,138,236, 42,170,124,220,252,108, 60,156,204,
     3  10, 36, 67, 21, 83,131,227, 37,163,115,211,243, 99, 51,147,195,
     4   9,185, 56, 27, 89,137,234, 35,172,122,218,250,106,162,157,205,
     5   8, 92, 58, 25, 91,141,238, 54,136,125,221,253,109, 45,154,206,
     6  12,177, 72, 29, 88,142,237, 53,134,126,222,254,110, 44,153,202,
     7   6, 97, 74, 24,100,140,232, 41,164,123,203, 30, 65,244,155,111,
     8   7,113, 73, 28,101,171,233, 38,149,121,210, 31, 69, 17,152,127,
     9   4, 95, 70, 22,102,133,229, 40,187,120,213, 13, 66, 52,168,143,
     A 183,145, 75, 19, 84,139,217, 34,189,117,201,255, 80, 62,150,158,
     1  79,161, 77, 18,104,173,228, 48,190,116,197,249, 96, 49,169, 93,
     2 208,196, 47, 20,105,174,216, 16,207,114,212,239, 81,  3,184,191,
     3 160,193, 59,224,107,175,235, 64,165,159,226,245, 82, 61,182,144,
     4   5,209, 57,240, 86,166,214, 32,146,112,200,246, 68, 46,181,223,
     5   1,225, 78,241, 85,148,230, 33,130,118,198,248,129, 14,180,192,
     6   2,176, 43,242, 98,132,219, 50,186, 94,194,251,128, 63,179,178/
      DATA R1/
     1  16, 32, 48, 64, 80, 96,112,128,144,160,176,192,208,224,240,255,
     2  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     3  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     4  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     5  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     6  44, 56, 68, 80, 92,104,116,128,142,156,170,184,198,212,226,240,
     7   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     8   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     9   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     A   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     1   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     2   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     3  44, 56, 68, 80, 92,104,116,128,142,156,170,184,198,212,226,240,
     4  66, 84,102,120,138,156,174,192,199,206,213,220,227,234,241,248,
     5  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     6  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255/
      DATA G1/
     1  16, 32, 48, 64, 80, 96,112,128,144,160,176,192,208,224,240,255,
     2   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     3  44, 56, 68, 80, 92,104,116,128,142,156,170,184,198,212,226,240,
     4  66, 84,102,120,138,156,174,192,199,206,213,220,227,234,241,248,
     5  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     6  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     7  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     8  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     9  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     A  66, 84,102,120,138,156,174,192,199,206,213,220,227,234,241,248,
     1  44, 56, 68, 80, 92,104,116,128,142,156,170,184,198,212,226,240,
     2   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     3   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     4   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     5   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     6   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224/
      DATA B1/
     1  16, 32, 48, 64, 80, 96,112,128,144,160,176,192,208,224,240,255,
     2   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     3   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     4   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     5   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     6   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     7   0,  0,  0,  0,  0,  0,  0,  0, 28, 56, 84,112,140,168,196,224,
     8  55, 70, 85,100,115,130,145,160,170,181,191,202,212,223,233,244,
     9  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     A  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     1  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     2  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     3  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     4  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     5  88,112,136,160,184,208,232,255,255,255,255,255,255,255,255,255,
     6  22, 28, 34, 40, 46, 52, 58, 64, 85,106,127,148,169,190,211,232/
C-----RAINBOW PALLETTE
      DATA PAL2/
     1   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
     2  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
     3  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
     4  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
     5  64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
     6  80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
     7  96, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111,
     8 112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     9 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     A 144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     1 160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     2 176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     3 192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     4 208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     5 224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     6 240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255/
      DATA R2/
     1   0,255,240,224,208,192,176,160,144,128,112, 96, 80, 64, 48, 32,
     2 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     3 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     4 255,255,255,255,255,255,255,255,252,246,240,234,228,222,216,210,
     5 204,198,192,186,180,174,168,162,156,150,144,138,132,126,120,114,
     6 108,102, 96, 90, 84, 78, 72, 66, 60, 54, 48, 42, 36, 30, 24, 18,
     7   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     8   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     9   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     A   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     1   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     2  18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96,102,108,
     3 114,120,126,132,138,144,150,156,162,168,174,180,186,192,198,204,
     4 210,216,222,228,234,240,246,252,255,255,255,255,255,255,255,255,
     5 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     6 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255/
      DATA G2/
     1   0,255,240,224,208,192,176,160,144,128,112, 96, 80, 64, 48, 32,
     2  18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96,102,108,
     3 114,120,126,132,138,144,150,156,162,168,174,180,186,192,198,204,
     4 210,216,222,228,234,240,246,252,255,255,255,255,255,255,255,255,
     5 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     6 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     7 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     8 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     9 255,255,255,255,255,255,255,255,252,246,240,234,228,222,216,210,
     A 204,198,192,186,180,174,168,162,156,150,144,138,132,126,120,114,
     1 108,102, 96, 90, 84, 78, 72, 66, 60, 54, 48, 42, 36, 30, 24, 18,
     2   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     4   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     6   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0/
      DATA B2/
     1   0,255,240,224,208,192,176,160,144,128,112, 96, 80, 64, 48, 32,
     2   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     3   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     4   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     6   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     7  18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96,102,108,
     8 114,120,126,132,138,144,150,156,162,168,174,180,186,192,198,204,
     9 210,216,222,228,234,240,246,252,255,255,255,255,255,255,255,255,
     A 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     1 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     2 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     3 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
     4 255,255,255,255,255,255,255,255,252,246,240,234,228,222,216,210,
     5 204,198,192,186,180,174,168,162,156,150,144,138,132,126,120,114,
     6 108,102, 96, 90, 84, 78, 72, 66, 60, 54, 48, 42, 36, 30, 24, 18/
      IF(NPAL.NE.1) GO TO 20
C-----MAXIMUM CONTRAST PALLETTE
      DO 10 I=1,256
      RTAB(I)=R1(I)
      GTAB(I)=G1(I)
      BTAB(I)=B1(I)
      PENMAP(I)=PAL1(I)
   10 CONTINUE
      RETURN
C-----RAINBOW PALLETTE
   20 IF(NPAL.NE.2) GO TO 40
      DO 30 I=1,256
      RTAB(I)=R2(I)
      GTAB(I)=G2(I)
      BTAB(I)=B2(I)
      PENMAP(I)=PAL2(I)
   30 CONTINUE
      RETURN
C-----SHADING PALLETTE
   40 IF(NPAL.NE.3) GO TO 90
C-----BASIC 16 COLORS
      DO 50 I=1,16
      K=PAL1(I)+1
      RTAB(I)=R1(K)
      GTAB(I)=G1(K)
      BTAB(I)=B1(K)
      PENMAP(I)=I-1
   50 CONTINUE
      DO 60 I=17,256
      PENMAP(I)=I-1
   60 CONTINUE
      RGBMULT=1.0
      DRGBMULT=1.0/22.0
      DO 80 I1=17,256,14
      I2=I1+13
      IF(I2.GT.256) I2=256
      KK=3
      RGBMULT=RGBMULT-DRGBMULT
      DO 70 I=I1,I2
      RTAB(I)=RGBMULT*RTAB(KK)
      GTAB(I)=RGBMULT*GTAB(KK)
      BTAB(I)=RGBMULT*BTAB(KK)
      KK=KK+1
   70 CONTINUE
   80 CONTINUE
   90 RETURN
      END
