#
# MacIntel OsX 14.7.8
# GFortran 13.3.0
#
#
os:=$(shell uname -s)

ifeq ($(os),Darwin)
     CFLAGS = -I/opt/X11/include -w
     LIBS   = -lXt -lX11
     LIBDIR = -L/opt/X11/lib
else
     CFLAGS = -I/usr/X11/include -w
     LIBS   = -lX11
     LIBDIR = -L/usr/X11/lib
endif

FFLAGS = -O0 -w -static-libgfortran
CFLAGS = -I/usr/X11/include
CC     = gcc 
FC     = gfortran -std=legacy

FSUB1=          plottab.f

FSUB2=          plot.f 

CSUBS=          dash.c
#

OBJ=            $(FSUB1:.f=.o) $(FSUB2:.f=.o) $(CSUBS:.c=.o)

SRC=            $(FSUB1) $(FSUB2) $(CSUBS)

all: plottab plotsave          

plottab: $(OBJ)
	$(FC) -o plottab $(FFLAGS) $(OBJ) $(LIBDIR) $(LIBS) 

plotsave: 
	$(FC) -o plotsave $(FFLAGS) plottab.o saveps.f

plotsave1: 
	$(FC) -o plotsave $(FFLAGS) plottab.o saveps1.f


