c=======================================================================
c
c     PROGRAM X4TOC4
c     Version 2025-1
c     ==============
c     Added Convert X4TOC4 output to PLOTTAB.PNT inpue
c
c=======================================================================
C-Title  : Program X4TOC4
C-Purpose: Translate Data from EXFOR to Computational Format
C-Version: 86-1 (August 1986)
C-V  01/03 (March 2001)  *Minor corrections
C-V  02/10 Read sample thickness, convert transmission to x-sect.
C-V  04/01 Define all input filenames from input.
C-V  04/10 Redefine MT>=9000 to define incident particle.
C-V  05/07 Introduce F90 features for characters and do-loops
C-V  05/12 If E-level is zero, redefine MT 51 to MT 4
C-V  06/02 Fix Y2K date in references
C-V  06/04 Deleted SF9, V.Zerkin@iaea.org
C-V  06/04 Extended dimensions 400->11111 (large EXFOR14A.DAT) Z.V.
C-V  06/12 Ratio-to-rutherfors scattering for charged particles
C-V  07/04 Trivial syntax correction (V. Zerkin)
C-V        Interpret Q-value as Level-Energy for inelastic (A.Trkov)
C-V  07/06 Fix uncert. when converting from ratio-to-Rutherford
C-V  08/07 Fix unit conversion of multiple-column uncertainties.
C-V  08/10 Overwrite energy uncertainty (if given) when EN-MIN, EN-MAX
C-V        pair is processed (A. Trkov).
C-V        Correct Angstrom to eV conversion (N. Otsuka, V. Zerkin).
C-V  09/09 Identify resonance energy when given as data (V. Zerkin)
C-V        Convert Energy/
C-Author :
C-A  OWNED, MAINTAINED AND DISTRIBUTED BY:
C-A  -------------------------------------
C-A  The Nuclear Data Section
C-A  International Atomic Energy Agency
C-A  P.O. Box 100
C-A  A-1400, VIENNA, AUSTRIA
C-A  EUROPE
C-A
C-A  ORIGINALLY WRITTEN BY:
C-A  ----------------------
C-A  Dermott E. Cullen
C-A  University of California
C-A  Lawrence Livermore National Laboratory
C-A  L-86
C-A  P.O. Box 808
C-A  Livermore, CA 94550
C-A  U.S.A.
C-A  Telephone  925-423-7359
C-A  e-mail     CULLEN1@LLNL.GOV
C-A  Website    HTTP://REDDOG1.LLNL.GOV
C-A
C-A  VERSION 2001/03 AND LATER IMPLEMENTED BY:
C-A  ----------------------------------------
C-A  Andrej Trkov
C-A  The Nuclear Data Section
C-A  International Atomic Energy Agency
C-A  P.O. Box 100
C-A  A-1400, VIENNA, AUSTRIA
C-A  EUROPE
C-A  e-mail     A.Trkov@iaea.org
C-
C-M
C-M  USERS' GUIDE FOR PROGRAM X4TOC4
C-M  ===============================
C-M
C-M  PURPOSE
C-M  -------
C-M  This program is designed to translate experimental data from the
C-M  EXFOR format to a computation format.
C-M
C-M  WHAT COMPUTERS WILL THE PROGRAM RUN ON
C-M  --------------------------------------
C-M  The program has been implemented on a variety of computers from
C-M  Cray and IBM mainframe to Sun workstations to a PC. The
C-M  program is small enough to run on virtually any computer.
C-M
C-M  EXFOR FORMAT
C-M  ------------
C-M  The EXFOR format is designed to allow experimentally measured data
C-M  to be coded in a computer readable format in a very flexible form.
C-M  In particular the data can be entered in essentially any set of
C-M  units (e.g., eV vs. barns or KeV vs. milli-barns) and in any table
C-M  format; essentially the table may be entered exactly as published
C-M  by an author (e.g., energy followed by columns of cross sections
C-M  in any order).
C-M
C-M  The EXFOR format is table oriented in the sense that data from a
C-M  given measurement are collected together and can be presented in
C-M  a single, or as a series of tables.
C-M
C-M  The advantage of the EXFOR format is that since data can be coded
C-M  essentially as published by an author problems of unit conversion
C-M  and re-formatting tables prior to coding are avoided and the
C-M  author can easily check the coded data. The result is a greatly
C-M  improved reliability of the coded data.
C-M
C-M  The disadvantage of the EXFOR format is that since physically
C-M  comparable data from different measurements (e.g. Fe-56 total
C-M  cross sections) may be given in a variety of different units and
C-M  formats it is very difficult to use in applications. In addition
C-M  the table oriented EXFOR system makes it difficult to collect
C-M  together physically comparable data from different measurements.
C-M
C-M  COMPUTATION FORMAT
C-M  ------------------
C-M  The computation format used by this program is designed to present
C-M  experimental data in a fixed set of units and column order. By
C-M  starting from data in the EXFOR format and translating data to
C-M  the computation format it is possible to combine the advantages
C-M  of the improved reliability of the data coded in the EXFOR format
C-M  with the advantages of a fixed unit and column order format for
C-M  use in subsequent applications.
C-M
C-M  In addition the computation format is point oriented (as opposed
C-M  the table oriented EXFOR format). Each line of the computation
C-M  format represents a single data point. This makes it possible to
C-M  sort data in the computation format into any desired order for use
C-M  in application, e.g., sort 26-Fe-26 (n,2n) data from a number of
C-M  measurements together into energy order to simplify comparisons.
C-M
C-M  EXFOR VS. COMPUTATION FORMAT
C-M  ----------------------------
C-M  The computation format is not intented as a substitute for the
C-M  EXFOR format, rather the two are complementary. The EXFOR format
C-M  contains much more information than can be included in computation
C-M  formats and this information should be consulted and used during
C-M  evaluation. The computation format is only intended to simplify
C-M  use of the data during evaluation, or other applications.
C-M
C-M  RELATIONSHIP TO ENDF
C-M  --------------------
C-M  It is assumed that one of the major uses of this program will be
C-M  to prepare data for subsequent use in evaluation and/or to compare
C-M  available evaluated and experimental data. As such the computation
C-M  format has been designed to allow data to be reduced to a form in
C-M  which data are classified in a manner similar to ENDF data.
C-M
C-M  In particular the EXFOR classification of data by the EXFOR
C-M  keyword reaction (or ISO-QUANT, etc.) is replaced by classifying
C-M  the data by (1) projectile, (2) target - ZA, (3) type of data
C-M  (ENDF MF number), (4) reaction (ENDF MT number). In addition the
C-M  standard units used by the translation program were selected to
C-M  be the same as the units used by ENDF (e.g., eV, barns, etc.).
C-M
C-M  The result of putting data into the computation format is that it
C-M  is easy to decide if the data is comparable to evaluated data
C-M  (e.g. same ZA, MF, MT) and once it is decided that data is
C-M  comparable, evaluation and/or comparison is simplified because the
C-M  data is in the same units as ENDF (e.g., eV vs. barns).
C-M
C-M  EXTENSIONS OF ENDF CONVENTIONS
C-M  ------------------------------
C-M  For all types of data which are physically comparable to data,
C-M  which can be included in the ENDF data, this program uses
C-M  the ENDF definitions of (1) type of data (ENDF MF number),
C-M  (2) reaction (ENDF MT number). For example all cross sections
C-M  are represented by MF=3, angular distributions by MF=4, energy
C-M  distributions by MF=5 and double differential distributions
C-M  by MF=6. Similarly for simple reactions such as total, elastic
C-M  etc., the data are translated into corresponding MT=1,2, etc.,
C-M  respectively.
C-M
C-M  Since many types of data which appear in EXFOR do not have a one
C-M  to one correspondence to data which appears in ENDF the ENDF
C-M  classification of type of data (MF) and reaction (MT) have been
C-M  extended to allow additional types of data and reactions to be
C-M  translated (e.g., define MF numbers for ratios, define MT numbers
C-M  for (n,np)+(n,na) reactions).
C-M
C-M  The ENDF MF is a 2 digit number and the MT is a 3 digit number.
C-M  In the computation format MF has been extended to 3 digits and the
C-M  MT has been expanded to 4 digits. These extensions allow the user
C-M  the flexibility to translate virtually any EXFOR data to a fixed
C-M  set of units and column order for subsequent use in applications.
C-M
C-M  Some extensions of MF and MT have already been established (for,
C-M  details see the input dictionaries described below) and if at all
C-M  possible these conventions should be followed by the user. The
C-M  user has the flexibility of establishing any conventions that may
C-M  be required to meet his or her needs, but in this case it is the
C-M  responsibility of the user to properly interpret and use the
C-M  translated data.
C-M
C-M  DIRECT COMPARISON TO ENDF DATA
C-M  ------------------------------
C-M  Although the ENDF classification system of MF and MT is used for
C-M  translation, generally very little of the EXFOR data is directly
C-M  comparable to ENDF data. Generally cross sections (MF=3) are
C-M  directly comparable. However, it must be realized that angular
C-M  (MF=4) and energy (MF=5) and double differential (MF=6) data are
C-M  given in ENDF in a normalized (i.e., normalized to unity when
C-M  intergrated) form, whereas data in EXFOR are generally given in an
C-M  unnormalized form (e.g.,angular distributions in barns/steradian).
C-M
C-M  After this program has been used to translate EXFOR data to the
C-M  computation format the user may make additional data directly
C-M  comparable to the corresponding ENDF data by either,
C-M  (1) Normalizing the data in the computation format, or,
C-M  (2) Converting ENDF data to unnormalized form.
C-M  This involves selecting an intgrated cross section as a standard
C-M  to use for the comparison (e.g., for a 14.2 MeV elastic angular
C-M  distribution use the 14.2 MeV ENDF elastic cross section).
C-M
C-M  Since the selection of a standard to use for comparison in highly
C-M  application dependent it has been decided that it is better to use
C-M  this program to translate data exactly as given in EXFOR (except
C-M  for conversion to a standard set of units) and to allow the user
C-M  to subsequently select a standard for renormalization.
C-M
C-M  CONTROL OF TRANSLATION
C-M  ----------------------
C-M  The user has complete control over what data is translated, where
C-M  given types of data appear in the computation format and the units
C-M  of the data in the computation format.
C-M
C-M  This is accomplished by using three dictionaries which control
C-M  the translation. All three of these dictionaries are distributed
C-M  with this program. Each dictionary is a simple card image file
C-M  which may be modified by the user at any time to meet specific
C-M  needs. The three dictionaries are:
C-M
C-M  (1) EXFOR REACTION - PROJECTILE, MF, MT EQUIVALENCE
C-M      This dictionary tells the program for each EXFOR reaction
C-M      what projectile, MF and MT to output in the computation format
C-M      (e.g.,(n,tot) = neutron, MF =3 (cross section),MT =1 (total)).
C-M      If a reaction read from the EXFOR format is not found in this
C-M      dictionary, or the assigned MF or MT is not positive the EXFOR
C-M      data will simply be skipped and not translated. Using this
C-M      dictionary the user has control over which data is translated
C-M      and what MF and MT are assigned to each EXFOR reaction.
C-M
C-M  (2) EXFOR COLUMN TITLE - COMPUTATION FORMAT OUTPUT FIELD
C-M      Once the EXFOR reaction has been translated and assigned an
C-M      equivalent MF and MT this dictionary tells the program where
C-M      to place each EXFOR column in the computation format. The
C-M      assigned MF number can be used to output an EXFOR column
C-M      with the same title into different columns of the computation
C-M      format based on different mf numbers. For example, for cross
C-M      sections (MF=3) the user may use EN-MIN and EN-MAX to define
C-M      an average incident energy to be output in the first field
C-M      of the computation format and an equivalent energy uncertainty
C-M      in the second field of the computation format. Alternatively,
C-M      for resonance integrals (MF=213) the user may decide to output
C-M      EN-MIN and EN-MAX in the first two fields of the computation
C-M      format to define the energy range of the resonance integral.
C-M
C-M      There are 8 output fields in the computation format and for
C-M      any given MF number the user may output any EXFOR column
C-M      into any of these fields. Any EXFOR title which is not
C-M      assigned to an output field 1 to 8 will be ignored and not
C-M      output. This allows the user to selectively translate portions
C-M      of EXFOR data tables to meet any given need. For example, by
C-M      simply modifying this dictionary the user has control over
C-M      whether an EXFOR column DATA-ERR3 is translated or ignored,
C-M      and if translated the user has control over which of the 8
C-M      computation format data fields DATA-ERR3 will appear in.
C-M
C-M  (3) EXFOR COLUMN UNITS - COMPUTATION FORMAT UNITS
C-M      This dictionary tells the program how to convert each EXFOR
C-M      unit into standard units. As distributed this dictionary will
C-M      convert all EXFOR units to ENDF compatible units. However,
C-M      the user has the option to change this dictionary at any time
C-M      to obtain any output units to meet his or her needs. For
C-M      example if the user would like output in MeV vs. milli-barns
C-M      instead of eV vs. barns it is merely necessary to modify this
C-M      dictionary.
C-M
C-M  OPERATIONS ON DATA
C-M  ------------------
C-M  In addition to the information described above each of the three
C-M  dictionaries allows the user to select from a menu of operations
C-M  which may be performed on the data (for a complete and up-to-date
C-M  list of available operations see the dictionaries). For example,
C-M  the reaction dictionary allows the user to specify that legendre
C-M  coefficents may be re-normalized, the title dictionary allows the
C-M  user to specify that EN-MIN and EN-MAX are to be converted to an
C-M  average energy and associated energy uncertainty and the units
C-M  dictionary allows the user to specify that angles should be
C-M  converted to cosines.
C-M
C-M  These operations are completely under the control of the user and
C-M  by simply modifying the dictionaries the user can control whether
C-M  or not each operation is performed (e.g., if you want to output
C-M  angles instead of cosines modify the units dictionary by removing
C-M  the option to convert from angle to cosine from the EXFOR units
C-M  ASEC, AMIN and ADEG).
C-M
C-M  COMPUTATION FORMAT UNITS
C-M  ------------------------
C-M  As distributed the Units dictionary will convert all EXFOR units
C-M  to ENDF units:
C-M
C-M  eV         = energy
C-M  barns      = cross section
C-M  steradians = solid angle
C-M  seconds    = time
C-M  kelvin     = temperature
C-M
C-M  If the user would like to obtain any other output units it is
C-M  merely necessary to modify the units dictionary (see units
C-M  dictionary for details).
C-M
C-M  A LEARNING PROGRAM
C-M  ------------------
C-M  As distributed the three translation dictionaries do not contain
C-M  definitions of how to translate all EXFOR reactions, titles and
C-M  units. At the present time this program has only been used to
C-M  translate a small portion of the data included in the EXFOR system
C-M  and the dictionaries only contain sufficient information to
C-M  translate the EXFOR data which has been encountered to date.
C-M
C-M  It is difficult and dangerous to try to define translation rules
C-M  for all types of EXFOR data without examining actual EXFOR data.
C-M  therefore only when a new reaction, title or unit is encountered
C-M  during translation will the actual EXFOR data be examined, a
C-M  decision made as to how to best translate the data and the
C-M  dictionaries updated.
C-M
C-M  Generally once a given type of EXFOR data has been encountered and
C-M  the dictionaries updated to define how to translate the data the
C-M  same rules can be used to translate all similar data. Therefore
C-M  over a period of time user experience will be accumulated in the
C-M  translation dictionaries and the program will learn to properly
C-M  translate more and more types of EXFOR data.
C-M
C-M  UNDEFINED EXFOR REACTIONS, TITLES AND UNITS
C-M  -------------------------------------------
C-M  In order to assist the user to define new types of EXFOR data as
C-M  they are encountered during translation the output report from
C-M  this program will indicate the number of EXFOR reactions, titles
C-M  and units which have been encountered during translation which are
C-M  not defined in the translation dictionaries. In additional all
C-M  undefined reactions, titles and units will be written to output
C-M  Unit 4 (NEWX4).
C-M
C-M  Based on comparison to the reaction, title and units dictionaries
C-M  if an EXFOR reaction, title or units is encountered during
C-M  translation that is not defined in the dictionaries it will be
C-M  written to Unit 4 (NEWX4). This information is written in a form
C-M  that can be easily edited and added to a translation dictionary.
C-M  After updating the dictionaries if this program is then run a
C-M  second time using the same EXFOR data all of the EXFOR data can
C-M  be translated.
C-M
C-M  COMPUTATION FORMAT
C-M  ------------------
C-M  The computation format uses a classification system and units
C-M  which are compatible with ENDF. Data is classified by (1) ZA
C-M  of projectile, (2) ZA of target, (3) metastable state of target,
C-M  (4) MF - type of data, (5) MT - reaction, (6) metastable state
C-M  of residual nucleus. To identify the source of the data the first
C-M  author and year and the EXFOR accession and sub-accession number
C-M  are included in the format. In addition, fields are assigned to
C-M  define the status of the EXFOR data (e.g., S = superceded),
C-M  whether data is in the laboratory or center-of-mass frame of
C-M  reference and the physical significance of the last 2 output
C-M  fields (LVL = level energy, HL = half-life). Finally the format
C-M  includes 8 fields in which the output data are contained (e.g.,
C-M  incident energy, data, cosine, uncertainties, etc.)
C-M
C-M  Columns   Description
C-M  -------   -----------
C-M    1-  5   Projectile ZA (e.g. neutron =1, proton =1001)
C-M            (defined by reaction dictionary).
C-M    6- 11   Target ZA (e.g. 26-Fe-56 =  26056)
C-M            (defined by EXFOR reaction).
C-M       12   Target metastable state (e.g. 26-FE-56m = M)
C-M            (defined by EXFOR reaction).
C-M   13- 15   MF (ENDF conventions, plus additions)
C-M            (defined by reaction dictionary).
C-M   16- 19   MT (ENDF conventions, plus additions)
C-M            (defined by reaction dictionary).
C-M       20   Product metastable state (e.g. 26-FE-56M = M)
C-M            (defined by EXFOR reaction).
C-M       21   EXFOR status
C-M            (defined by EXFOR keyword status).
C-M       22   Center-of-mass flag (C=center-of-mass, blank=lab)
C-M            (defined by EXFOR title dictionary).
C-M   23- 94   8 data fields (each in E9.3 format defined below)
C-M            (defined by MF and title dictionary).
C-M   95- 97   Identification of data fields 7 and 8
C-M            (e.g., LVL=level, HL=half-life, etc.).
C-M            For a complete list of codes see title dictionary
C-M            (defined by MF and title dictionary).
C-M   98-122   Reference (first author and year)
C-M            (defined by EXFOR keywords title and reference).
C-M  123-127   EXFOR accession number
C-M            (defined by EXFOR format).
C-M  128-130   EXFOR sub-accession number
C-M            (defined by EXFOR format).
C-M      131   Multi-dimension table flag
C-M            (defined by EXFOR keyword reaction or common fields).
C-M
C-M  PRECISION OF THE 8 DATA FIELDS
C-M  ------------------------------
C-M  If written in normal format E9.2 format the output from this
C-M  this program would give data to only 2 or 3 digits of accuracy,
C-M  depending on the computer used (e.g., 0.23E+02 or 2.34E+01), which
C-M  is not sufficient for many applications (e.g., energy of cross
C-M  section points in the resonance region).
C-M
C-M  In order to avoid this problem this program will output data in
C-M  a special compatible format to allow up to 7 digits of accuracy
C-M  (i.e.,more than the full word accuracy of IBM computers).
C-M
C-M  Numbers between 0.01 and less than 10 million will be output in F
C-M  (rather than E format). For example, the energy 12.3456 KeV will
C-M  be output as 123456.0. Numbers less than 0.01 or greater than
C-M  10 million will be output in E format, but without as E and an
C-M  exponent of 1 or 2 digits. For example 14.123 MeV will be output
C-M  as "1.4123+7".
C-M
C-M  These output conventions have been used for many years with ENDF
C-M  related programs and have been proven to be FORTRAN compatible forx
C-M  use on virtually any computer. For example, any fortran program
C-M  which is written to read this data using an E9.2 format will read
C-M  the data properly whether the data is actually in E or F format.
C-M
C-M  Generally maintaining high precision in the data is most important
C-M  for the independent variable, particularly incident energy. Since
C-M  we do not expect very narrow resonance structure below 0.01 eV or
C-M  above 10 MeV generally these output conventions will maintain the
C-M  accuracy of the EXFOR data to meet requirements.
C-M
C-M  DEFINITION OF 8 COMPUTATION FORMAT DATA FIELDS
C-M  ----------------------------------------------
C-M  The user may use the title dictionary to output any EXFOR column
C-M  into any computation format data field. As distributed the title
C-M  dictionary contains a number of conventions which if at all
C-M  possible should be followed by the users. The general definitions
C-M  of the 8 computation format data fields are:
C-M
C-M  Data field   Definition
C-M  ----------   ----------
C-M    1          Projectile incident energy
C-M    2          Projectile incident energy uncertainty
C-M    3          Data, e.g., cross section, angular distribution, etc.
C-M    4          Data uncertainty
C-M    5          Cosine or legendre order
C-M    6          Cosine uncertainty
C-M    7          Identified by columns 95-97 (e.g.,level E, half-life)
C-M    8          Identified by columns 95-97 (e.g.,level E, uncertainty
C-M
C-M  The physical significance of each field is defined by the assigned
C-M  MF number. For example, for MF =3 (cross sections), columns 1 and
C-M  2 contain the incident projectile energy and its uncertainty in
C-M  eV, respectively and columns 3 - 4 contain the cross section and
C-M  its uncertainty in barns, respectively and columns 7 and 8 may
C-M  contain a level energy and its uncertainty in eV or a half-life
C-M  and its uncertainty in seconds.
C-M
C-M  SPECIAL CONVENTIONS
C-M  The above conventions are appropriate for most types of data
C-M  in the ENDF system. In order to allow this program to plot
C-M  additional types of data the following special conventions have
C-M  been adopted,
C-M
C-M  Cross section ratios  - Field 5 = MT of denominator.
C-M  (MF = 203)              Field 6 = ZA of denominator.
C-M  Resonance integrals   - Field 1 = lower energy limit.
C-M  (MF = 213)              Field 2 = upper energy limit.
C-M  Spectrum averages     - Field 1 = lower energy limit.
C-M  (MF = 223)              Field 2 = upper energy limit.
C-M  Fission yield data    - Field 5 = ZA of fission fragment.
C-M  (MF = 801)              Field 6 = mass of fission fragment.
C-M  Production            - Field 6 = ZA of product.
C-M  (MT = 9000-9999)
C-M
C-M  See, remarks below on metastable state flags.
C-M
C-M  REQUIRED DATA FIELDS
C-M  --------------------
C-M  For various types of data the program will check if all required
C-M  fields are defined and non-blank. If they are not warning messages
C-M  will be printed. If the data field (Field 3) is not defined or
C-M  blank the data point will not be output. If the data field is not
C-M  defined this usually indicates an error in the EXFOR data. Blank
C-M  data fields are quite common in multi-dimensional tables and a
C-M  warning may or may not indicate an error (check the EXFOR data to
C-M  see if it is correct).
C-M
C-M  The program considers that the following fields are required:
C-M
C-M   MF (Data type)         Data field (X = Required)
C-M  ---------------------   -------------------------
C-M                           1  2  3  4  5  6  7  8
C-M  ---------------------   -------------------------
C-M    3 (Cross sections)     X     X
C-M    4 (Angular dist.)      X     X     X
C-M    5 (Energy dist.)       X     X           X
C-M    6 (Double diff.)       X     X     X     X
C-M  154 (Legendre coeff.)    X     X     X
C-M  203 (Ratios)             X     X     X  X
C-M  801 (Yield data).        X     X     X  X
C-M
C-M  (See the above definition of the 8 data fields).
C-M
C-M  MULTI-DIMENSIONAL TABLES
C-M  ------------------------
C-M  The program can translate multi-dimensional EXFOR tables for:
C-M  (1) Multiple reactions following the EXFOR keyword reaction
C-M      (ISO-QUANT, etc.) with each reaction identified by a character
C-M      in column 11.
C-M  (2) Single reactions with multiple common fields each identified
C-M      by a character in the eleventh column of each field.
C-M  (3) The old ISO-QUANT, etc. convention of reactions separated by
C-M      commas, e.g., ((90-TH-232,NG)/(29-CU-0,NG)),(29-CU-0,NG)).
C-M
C-M  TRANSLATION OF EXFOR REACTIONS
C-M  ------------------------------
C-M  Not all EXFOR reactions (ISO-QUANT, etc.) can be translated by
C-M  this program. In order to translate each reaction the program will
C-M  first break each reaction into a series of simple reactions and
C-M  remove and save the target and residual ZA, E.G.:
C-M
C-M  ((26-FE-56(N,G)26-FE-57-M1,,SIG)/(26-FE-56(N,G)26-FE-57-G,,SIG))
C-M
C-M  is broken down to define
C-M
C-M  ZA-target = 26056 , ZA-residual = 260571, reaction = (N,G),SIG
C-M
C-M  Note residual metastable state flags. See explanation below.
C-M
C-M  The program will then define an equivalent MF, MT for each
C-M  reaction.
C-M
C-M  The program will next translate the following types of
C-M  reactions:
C-M  (1) Simple reactions
C-M      (N,G),SIG
C-M  (2) Equivalent reactions
C-M      ((N,G),SIG)=...anything else....
C-M      After decoding the first simple reaction the program assumes
C-M      that the first simple reaction is truely equivalent to the
C-M      remainder of the reaction and defines ZA, MF and MT based on
C-M      the first simple reaction.
C-M  (3) Simple ratios
C-M      ((N,G)M1/G,,SIG/RAT) or ((N,G)M1,SIG)/((N,G)G,SIG)
C-M  (4) Complex reactions - all with the same equivalent ZA
C-M      ((N,EL),WID,,G)*((N,G),WID)/((N,TOT),WID)
C-M  (5) Other reactions
C-M      (((N,G),SIG)/((N,G),SIG),(N,G),SIG))
C-M
C-M      If the reaction is not one of the above types the program will
C-M      try to use the entire EXFOR reaction, including target and
C-M      residual ZA and see if it is defined in reaction equivalent
C-M      dictionary. If an MF, MT is defined for the entire reaction
C-M      the program will use the target and residual ZA from the first
C-M      simple reaction to translate the data. This last form may be
C-M      used to insure that almost all EXFOR reaction can be
C-M      translated, regardless of how complicated it is (for examples
C-M      see reaction dictionary) however the user should carefully
C-M      check the output to insure that the data has been translated
C-M      as intended.
C-M
C-M  The only reactions that have so far been found that cannot be
C-M  correctly translated are ratios of production cross sections,
C-M  e.g., (29-CU-0(P,X)26-FE-56)/(28-NI-0(P,X)26-FE-58)
C-M  because ratio data requires fields 5 and 6 for the denominator
C-M  MT and ZA and ratio data requires field 5 for the product ZA.
C-M  When this case is encountered the program will print an error
C-M  message and output the denominator MT and ZA in fields 5 and 6.
C-M  In this case the output will identify the numerator as ZA=29000,
C-M  MT=9001 and the denominator as ZA=28000, MT=9001. One solution
C-M  is to modify the output of this program by defining two reactions,
C-M  e.g., MT = 8001 = (p,x) 26-Fe-56 and MT = 8002 = (p,x) 26-Fe-58,
C-M  modify the numerator MT to 8001 and denominator MT to 8002 and
C-M  then properly interpreting the data using these definition in all
C-M  applications (for examples, see program PLOTC4 input directionary
C-M  for proton induced reactions).
C-M
C-M  Sometimes elastic scattering reactions may be represented in the
C-M  form of the ratio to Coulomb scattering cross section (sometimes
C-M  referred to as "Ratio-to-Rutherford), identified by reaction
C-M  modifier flag RTH. Masses of the target and the projectile are
C-M  required, which are read from the Audi-Wapstra mass tables
C-M  in the file specified on input. The file is available from the
C-M  IAEA web site. The expression for Coulomb scattering corresponds
C-M  to the equations 6.11 and 6.12 in the ENDF-102 formats manual.
C-M
C-M  OUTPUT REPORT
C-M  -------------
C-M  This program will write a report on Unit 6 (OUTP) to allow the
C-M  user to monitor the translation of the EXFOR data. It is extremely
C-M  important that the user read this report and not simply assume
C-M  that all of the data has been properly translated.
C-M
C-M  After identifying each EXFOR accession, sub-accession number,
C-M  ZA, MF, MT and reaction the program can print two types of
C-M  messages:
C-M
C-M  WARNING    = Something unusual has occurred. The user should
C-M               carefully check to insure that the output data has
C-M               been properly translated.
C-M  OPERATION  = One of the defined reaction, title or unit operations
C-M               has been performed on the data. The user should
C-M               carefully check to insure that the proper operation
C-M               has been performed.
C-M
C-M  If the user does not agree with how the data has been translated
C-M  the three dictionaries may to be modified and the program re-run.
C-M  For example, if the program prints a warning that the title
C-M  dictionary tells it to output E-ERR1, E-ERR2, E-ERR3 all in the
C-M  same computation format field, followed by an operation that says
C-M  the program will only output E-ERR1 and ignore the other 2 EXFOR
C-M  fields, if the user would rather output E-ERR2 and ignore E-ERR1
C-M  and E-ERR3 it is merely necessary to modify the title dictionary
C-M  to ignore E-ERR1 and E-ERR3 and select E-ERR2 and then re-run the
C-M  program.
C-M
C-M  METASTABLE STATE
C-M  ----------------
C-M  The computation format allows the metastable state of the target
C-M  and residual nucleus to be identified. For ratio data metastable
C-M  state of both numerator and denominator of the ratio may be
C-M  defined.
C-M
C-M  The metastable state of the target is identified in column 12 and
C-M  the metastable state of the residual nuclues in column 20. For
C-M  ratio data the metastable state of the denominator target and
C-M  residual nucleus are identified by output the denominator ZA and
C-M  MT in the form ZA.M and MT.M (e.g., 26056.9 and 102.1). Columns
C-M  12 and 20 could contain characters such as M, but to maintain the
C-M  eight output fields in strictly numerical form the denominator
C-M  ZA.M and MT.M will be output in numerical form. The possible
C-M  characters that may appear in columns 12 or 20 and their numerical
C-M  equivalents used with ratio denominator ZA and MT include:
C-M
C-M  Definition    Column 12 or 20     Equivalent
C-M  ----------    ---------------     ----------
C-M  ground              G                0
C-M  m1                  1                1
C-M  m2                  2                2
C-M  m3                  3                3
C-M  m4                  4                4
C-M  m5                  5                5
C-M  unknown             ?                6
C-M  m                   M                7
C-M  more than 1         +                8
C-M  all or total        T                9
C-M  all or total      blank              9
C-M
C-M  By convention if an EXFOR reaction does not specify a metastable
C-M  state the state is defined in the computation format to be..ALL..
C-M  (i.e., blank in column 12 or 20, 9 in ratio ZA or MT).
C-M
C-M  For example, for a ratio if the ZA.m and MT.m are output as
C-M  26056.9 and 102.1, respectively the ratio denominator target is
C-M  26-Fe-56 (all) and the reaction is capture (MT=102) leaving the
C-M  residual nucleus in the m1 state.
C-M
C-M  NOTE: Since most data will not contain a metastable state flag
C-M  the above convention to output the ZA and MT of the denominator
C-M  of ratios allows the user to read and use the denominator ZA and
C-M  MT as integers (effectively ignoring any metastable state flag) or
C-M  if necessary to determine the metastable state.
C-M
C-M  EXFOR STATUS
C-M  ------------
C-M  Column 21 of each computation format record may contain blank
C-M  (status not specified) or one to the following characters:
C-M
C-M  Column 21   Definition
C-M  ---------   ----------
C-M     U        Unnormalized (indicated by unit translation dictionary)
C-M              This condition has priority over the EXFOR status and
C-M              is used to indicate that the data is not in standard
C-M              output units).
C-M     A        Approved by author
C-M     C        Correlated
C-M     D        Dependent
C-M     O        Outdated
C-M     P        Preliminary
C-M     R        Renormalized
C-M     S        Superceded
C-M
C-M  If data has any other EXFOR status (e.g., translated from SCISRS)
C-M  it will be ignored and the status field will be output as blank.
C-M
C-M  INPUT FILES
C-M  -----------
C-M  Unit Name     Description
C-M  ---- -------  -----------
C-M    5  X4INP    X4TOC4.INP  Input defining filenames (fixed filename)
C-M   10  X4       EXFOR data to be translated (default 'X4.DAT')
C-M   12  EXFOR14A EXFOR reaction dictionary (default 'EXFOR14A.DAT')
C-M   14  EXFOR24A EXFOR title dictionary (default 'EXFOR24A.DAT')
C-M   15  EXFOR25A EXFOR units dictionary (default 'EXFOR25A.DAT')
C-M   16  ATMASS   Audi-Wapstra mass table (default 'mass.mas03')
C-M
C-M  OUTPUT FILES
C-M  ------------
C-M  Unit Name     Description
C-M  ---- -------  -----------
C-M    4  X4NEW    List of all undefined EXFOR reactions, titles
C-M                and units found during the translation, if any
C-M                (default 'NEWX4.DAT')
C-M    6  X4LST    X4TOC4.LST output report (default 'X4TOC4.LST')
C-M   11  C4       Output data in computation format (default 'C4.DAT')
C-M
C-M  SCRATCH FILES
C-M  -------------
C-M  NONE
C-M
C-M  INPUT PARAMETERS
C-M  ----------------
C-M  The input file contains the list of files in the following order:
C-M    X4       EXFOR data (to be translated)
C-M    C4       Output data in computation format
C-M    EXFOR14A EXFOR reaction dictionary
C-M    EXFOR24A EXFOR title dictionary
C-M    EXFOR25A EXFOR units dictionary
C-M    ATMASS   Audi-Wapstra mass table
C-M  If any of the filenames is blank or if an end-of-file mark is
C-M  encountered, the remaining filenames assume their default
C-M  values.
C-M
C-M  REPORTING ERRORS
C-M  ----------------
C-M  In order to improve this code and make future versions more
C-M  compatible for use on as many different types of computers as
C-M  possible please report all compiler diagnostics and/or operating
C-M  problems to the author at the above address.
C-M
C-M  Please remember if you simply report "I'VE GOT A PROBLEM" and do
C-M  not adequately describe exactly how you were using the program
C-M  it will be impossible for the author to help you. When a problem
C-M  arises please write to the author, describe the problem in as much
C-M  detail as possible, identify the version of the program that you
C-M  are using (e.g. Version 2001-3) and send the following information
C-M  in computer-readable form (e-mail, floppy disc, etc.) to the author
C-M
C-M  (1) A copy of the program you are using
C-M  (2) A copy of compiler diagnostics (if any)
C-M  (3) A copy of the JCL deck you used to execute the program
C-M  (4) A copy of the 3 translation dictionaries you are using
C-M  (5) A copy of the EXFOR format data you using
C-M  (6) A copy of the computation format data you produce
C-M  (7) A copy of the output report from the program.
C-M
C-M  Without all of this information it is impossible to exactly
C-M  simulate the problem that you ran and to determine the source
C-M  of your problem.
C-M
C***** COMPUTER DEPENDENT CODING ******
C-M
C-M COMPUTER DEPENDENT CODING
C-M -------------------------
C-M
C-M * This program is designed to be used with a Fortran-77 or
C-M  Fortran-90 compiler.
C-M
C-M * The only compiler dependent format statements involve,
C-M  (1) CHARACTER*1 and CHARACTER*4
C-M  (2) Testing for errors and end of file during reads.
C-M
C-M * It is assumed that characters are stored in successive storage
C-M   locations and that characters may be treated as continuous strings
C-M   of characters in either CHARACTER*4 or CHARACTER*1 format.
C-M
C-M * For example, if one subroutine contains,
C-M
C-M   CHARACTER*4 BCD
C-M   DIMENSION BCD(10)
C-M
C-M  the array BCD is assumed to be an array of 40 characters in
C-M  successive byte locations.
C-M
C-M  It is assumed that this array can be passed as an argument to
C-M  another subroutine and used as CHARACTER*1, e.g.,
C-M
C-M   CALL DUMMY(BCD)
C-M
C-M   SUBROUTINE DUMMY(BCD)
C-M   CHARACTER*1 BCD
C-M   DIMENSION BCD(40)
C-M
C-M * This convention will work on all 32 bit per word computers (e.g.,
C-M   IBM or IBM compatible computers).
C-M
C-M * For longer word length computers (e.g., CDC or CRAY) it is
C-M   suggested that before implementing and using this program the
C-M   user first verify that character strings can be treated as
C-M   described above, e.g., write a simple program to read a character
C-M   string of 40 characters in CHARACTER*4 format, pass it to a
C-M   subroutine which uses the character string in CHARACTER*1 format
C-M   and print the character string in the subroutine. If the character
C-M   string is printed as a continuous string you will be able to use
C-M   this program. If the character string is not printed as a
C-M   continuous string it is not recommended that you use this program.
C-M
C-M * This program using the Fortran-77 convention for testing for
C-M   reading errors and end of file during reads, e.g.,
C-M
C-M   READ(10,1000,END=100,ERR=200) A,B,C,D
C-M
C***** COMPUTER DEPENDENT CODING ******
      INTEGER      OUTP,OTAPE
      CHARACTER*40 X4,X4NEW,C4,X4INP,X4LST,FLNM,BLNK
      CHARACTER*60 EXFOR14A,EXFOR24A,EXFOR25A,FLNM60,ATMASS
      CHARACTER*11 CARD1,KEYTAB,ENDSUB
      CHARACTER*1  CARD2,ENT,SUBENT
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDS/CARD1(6),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/POINTR/MPOINT(9)
      DIMENSION KEYTAB(5)
      DATA KEYTAB/
     & 'SUBENT     ','NOSUBENT   ','BIB        ','COMMON     ',
     & 'DATA       '/
      DATA ENDSUB/'ENDSUBENT  '/
C-----DEFINE ALL I/O UNITS.
      DATA BLNK     /'                                        '/
     1     X4INP    /'X4TOC4.INP'/
     1     X4LST    /'X4TOC4.LST'/
     2     X4       /'X4.DAT'/
     3     C4       /'C4.DAT'/
     4     X4NEW    /'NEWX4.DAT'/
     5     EXFOR14A /'EXFOR14A.DAT'/
     6     EXFOR24A /'EXFOR24A.DAT'/
     7     EXFOR25A /'EXFOR25A.DAT'/
     8     ATMASS   /'mass.mas03'/
c=======================================================================
c
c     IDENTIFY
c
c=======================================================================
      write(*,5)
    5 format(//
     1 ' ================================='/
     2 ' X4TOC$ 2025-1: Create PLOTTAB.PNT'/
     3 ' =================================')
      NEWX4=4
      INP=5
      OUTP=8
      ITAPE=10
      OTAPE=11
      NTAPE1=12
      NTAPE2=14
      NTAPE3=15
      NMASS=16
      OPEN (UNIT=INP,FILE=X4INP,STATUS='OLD',ERR=9)
      READ (INP,'(A40)',END=9) FLNM
      IF(FLNM.NE.BLNK) X4=FLNM
      READ (INP,'(A40)',END=9) FLNM
      IF(FLNM.NE.BLNK) C4=FLNM
      READ (INP,'(A60)',END=9) FLNM60
      IF(FLNM60(1:40).NE.BLNK) EXFOR14A=FLNM60
      READ (INP,'(A60)',END=9) FLNM60
      IF(FLNM60(1:40).NE.BLNK) EXFOR24A=FLNM60
      READ (INP,'(A60)',END=9) FLNM60
      IF(FLNM60(1:40).NE.BLNK) EXFOR25A=FLNM60
      READ (INP,'(A60)',END=9) FLNM60
      IF(FLNM60(1:40).NE.BLNK) ATMASS=FLNM60
    9 CLOSE(UNIT=INP)
C*
      WRITE(*,*)'INPUT  FILE : ',X4INP
      WRITE(*,*)'SOURCE FILE : ',X4
      WRITE(*,*)'OUTPUT FILE : ',C4
      OPEN (UNIT=ITAPE ,FILE=X4      ,STATUS='OLD')
      OPEN (UNIT=NTAPE1,FILE=EXFOR14A,STATUS='OLD')
      OPEN (UNIT=NTAPE2,FILE=EXFOR24A,STATUS='OLD')
      OPEN (UNIT=NTAPE3,FILE=EXFOR25A,STATUS='OLD')
      OPEN (UNIT=OUTP  ,FILE=X4LST   ,STATUS='UNKNOWN')
      OPEN (UNIT=OTAPE ,FILE=C4      ,STATUS='UNKNOWN')
      OPEN (UNIT=NEWX4 ,FILE=X4NEW   ,STATUS='UNKNOWN')
      OPEN (UNIT=NMASS ,FILE=ATMASS,STATUS='OLD',ERR=22)
      GO TO 24
   22   NMASS=-NMASS
   24 CONTINUE
C-----INITIALIZE COUNTS.
      DO I=1,9
        MPOINT(I)=0
      END DO
C-----PRINT TITLE FOR OUTPUT.
      WRITE(OUTP,6000)
C-----READ REACTION VS. MF/MT TABLE
      CALL MFMTIN(NTAPE1)
C-----READ COLUMN HEADINGS VS. MF/FIELDS.
      CALL TITLEI(NTAPE2)
C-----READ UNITS AND CONVERSION FACTORS TO STANDARD UNITS.
      CALL UNITI(NTAPE3)
      WRITE(OUTP,6030)
C
C     READ EXFOR CARDS AND PROCESS SUBENT, BIB, COMMON OR DATA.
C
   20 READ(ITAPE,1000,END=110,ERR=100) CARD1,CARD2
      DO I=1,5
        INKEY=I
        IF(CARD1(1).EQ.KEYTAB(INKEY)) GO TO 50
      END DO
      GO TO 20
C-----PROCESS SUBENT CARD.
   50 IF(INKEY.GT.2) GO TO 60
      CALL SUBIN
      GO TO 20
C-----TRANSLATE N1, N2 FOR BIB, COMMON OR DATA.
   60 CALL INTGER(CARD1(2),N1,11)
      CALL INTGER(CARD1(3),N2,11)
      IF(INKEY.NE.3) GO TO 90
      CALL BIBIN
C-----IF SAN>1 AND NO REACTIONS TRANSLATED SKIP SUBENTRY.
      IF(ISAN.LE.1) GO TO 20
      IF(KSANR.GT.0) GO TO 20
      MPOINT(2)=MPOINT(2)+1
   70 READ(ITAPE,1000,END=110,ERR=100) CARD1,CARD2
      IF(CARD1(1).NE.ENDSUB) GO TO 70
      GO TO 20
C-----PROCESS COMMON OR DATA.
   90 IF(INKEY.EQ.4) CALL COMIN
      IF(INKEY.EQ.5) CALL DATIN
      GO TO 20
C-----ERROR READING EXFOR DATA.
  100 WRITE(OUTP,6020)
      GO TO 120
C-----END OF RUN. PRINT SUMMARY OF TRANSLATION.
  110 WRITE(OUTP,6010) MPOINT
  120 END FILE OTAPE
      END FILE NEWX4
c-----finish PLOTTAB.PNT adding blank line st end
      write(16,1600)
 1600 format(66x,'(BLANK LINE)')
      write(*,55)
   55 format(
     1 ' ================================='/
     2 ' End of Run'/
     3 ' =================================')
      CALL EXIT
 1000 FORMAT(6A11,14A1)
 6000 FORMAT(' TRANSLATE DATA FROM EXFOR TO COMPUTATION FORMAT',
     1 ' (X4TOC4 VERSION 05/07)'/1X,70('=')/
     2 ' READING TRANSLATION TABLES'/1X,70('='))
 6010 FORMAT(1X,70('=')/' TRANSLATION SUMMARY'/1X,70('=')/
     1 ' SUBENTRIES TRANSLATED--------',I7/
     2 ' SUBENTRIES SKIPPED-----------',I7,' (NO OUTPUT)'/
     3 ' POINTS READ------------------',I7/
     4 ' POINTS TRANSLATED------------',I7/
     5 ' DATA FIELDS NOT DEFINED------',I7,' (NO OUTPUT)'/
     6 ' DATA FIELDS BLANK------------',I7,' (NO OUTPUT)'/
     7 ' UNDEFINED REACTIONS----------',I7/
     8 ' UNDEFINED TITLES-------------',I7/
     9 ' UNDEFINED UNITS--------------',I7/1X,70('='))
 6020 FORMAT(10X,'ERROR READING EXFOR DATA...EXECUTION TERMINATED')
 6030 FORMAT(1X,70('=')/'    AN SAN PROJECT  TARGET RESIDUAL',
     1 '  MF   MT REACTION'/
     1 1X,70('='))
      END
      SUBROUTINE SUBIN
C
C     SUBENT OR NOSUBENT CARD. INITIALIZE COUNTERS AND ARRAYS.
C
      INTEGER      OUTP,OTAPE
      CHARACTER*11 CARD1
      CHARACTER*1  CARD2,ENT,SUBENT,AUTH1,AUTHN,REFER1,REFERN,STAT1
     1            ,STATN,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDS/CARD1(6),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/AUTHI/IAUTH,NAUTH
      COMMON/AUTHC/AUTH1(25),AUTHN(25)
      COMMON/REFERI/IREF,NREF
      COMMON/REFERC/REFER1(4),REFERN(4)
      COMMON/STATUC/STAT1,STATN
      DATA BLANK/' '/
C
C     CHECK FOR NEW ENTRY OR SUBENTRY 1.
C
C-----ALLOW FOR EXFOR FILES WITHOUT IDENTS IN COLUMNS 67-80
C-----READ ENT/SUBENT FROM COLUMNS 12-22 IF COLUMNS 67-80 ARE BLANK
C
      DO I=1,14
        IF(CARD2(I).NE.BLANK) GO TO 8
      END DO
      DO I=1,8
        CARD2(I)=CARD1(2)(I+3:I+3)
      END DO
    8 CONTINUE
      IRESET=0
C-----SAVE ENTRY NUMBER.
      DO I=1,5
        IF(ENT(I).NE.CARD2(I)) IRESET=1
        ENT(I)=CARD2(I)
      END DO
C-----SAVE SUBENTRY.
      DO I=1,3
        SUBENT(I)=CARD2(I+5)
      END DO
C-----CONVERT SUBENTRY NUMBER TO INTEGER.
      CALL INTGER(CARD2(6),ISAN,3)
      IF(ISAN.EQ.1) IRESET=1
C
C     RESET COUNTS AND ARRAYS.
C
      IF(IRESET.EQ.0) GO TO 50
C-----NEW ENTRY OR SUBENTRY 1. RESET COMMON SUBENT COUNTS AND ARRAYS.
      ICOM1=0
      KSAN1=0
      STAT1=BLANK
      IAUTH=0
      DO I=1,25
        AUTH1(I)=BLANK
      END DO
      IREF=0
      DO I=1,4
        REFER1(I)=BLANK
      END DO
C-----RESET ORDINARY SUBENT COUNTS AND ARRAYS.
   50 ICOMN=ICOM1
      IDATN=0
      KSANR=KSAN1
      STATN=BLANK
      NAUTH=0
      DO I=1,25
        AUTHN(I)=BLANK
      END DO
      NREF=0
      DO I=1,4
        REFERN(I)=BLANK
      END DO
      RETURN
      END
      SUBROUTINE BIBIN
C
C     BIB CARD READ. PROCESS ENTIRE BIB SECTION.
C
      INTEGER      OUTP,OTAPE
      CHARACTER*10 BIBKEY,KEYWD1
      CHARACTER*1  CARD1,CARD2,KEYWD2,STAT1,STATN,AUTH1,AUTHN,REFER1
     1            ,REFERN,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/BIBCRD/KEYWD1,KEYWD2,CARD1(55),CARD2(14)
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/AUTHI/IAUTH,NAUTH
      COMMON/AUTHC/AUTH1(25),AUTHN(25)
      COMMON/REFERI/IREF,NREF
      COMMON/REFERC/REFER1(4),REFERN(4)
      COMMON/STATUC/STAT1,STATN
      DIMENSION BIBKEY(9)
      DATA BLANK/' '/
      DATA BIBKEY/
     1 'ENDBIB    ','REACTION  ','ISO-QUANT ','NUC-QUANT ',
     5 'CMPD-QUANT','STATUS    ','REFERENCE ','AUTHOR    ',
     9 'TITLE     '/
C-----READ ALL BIB CARDS AND LIST REQUIRED KEYWORDS AND CONTINUATIONS.
   10 READ(ITAPE,1000,END=80,ERR=80) KEYWD1,KEYWD2,CARD1,CARD2
   20 DO K=1,9
        IF(KEYWD1.EQ.BIBKEY(K)) GO TO 50
      END DO
C-----REQUIRED KEYWORD NOT FOUND. CONTINUE READING.
      GO TO 10
C-----RETURN ON ENDBIB. OTHERWISE PROCESS.
   50 IF(K.EQ.1) GO TO 70
C-----PROCESS ISO-QUNT, CMP-QUANT, NUC-QUANT OR REACTION.
      IF(K.GT.5) GO TO 60
      CALL REACTN(K-1)
      GO TO 20
C-----PROCESS STATUS.
   60 IF(K.EQ.6) CALL STATUS
C-----PROCESS REFERENCE.
      IF(K.EQ.7) CALL REFERS
C-----PROCESS AUTHOR.
      IF(K.EQ.8) CALL AUTHOR
      GO TO 10
C-----END OF BIB SECTION.
   70 RETURN
C-----ERROR READING EXFOR DATA.
   80 WRITE(OUTP,6000)
      CALL EXIT
 1000 FORMAT(A10,A1,55A1,14A1)
 6000 FORMAT(10X,'ERROR READING EXFOR DATA...EXECUTION TERMINATED')
      END
c---zvv+++
c delete SF9 and end-commas from reaction-string
c by V.Zerkin, IAEA-NDS, 2006-04-11
      function deleteSF9(ZAR1,KZAR1)
      CHARACTER*300  ZAR1,tmp,tmp2
      tmp=' '
      tmp(1:1)='('
      tmp(2:KZAR1+1)=ZAR1(1:KZAR1)
      tmp(KZAR1+2:KZAR1+2)=')'
c     call outCharArray(tmp,KZAR1+3)
      deleteSF9=0
      i=replaceStr(tmp,300,',CALC)',')')      !--- Calculated data
      i=replaceStr(tmp,300,',DERIV)',')')     !--- Derived data
      i=replaceStr(tmp,300,',EVAL)',')')      !--- Evaluated data
      i=replaceStr(tmp,300,',EXP)',')')       !--- Evaluated data
      i=replaceStr(tmp,300,',RECOM)',')')     !--- Recommended data
      i=replaceStr(tmp,300,',)',')')          !--- delete comas at the e
c     call outCharArray(tmp,KZAR1+3)
      ll=mylen(tmp)
c     write (*,*) ' LL=',ll
      tmp2=' '
      tmp2(1:ll-2)=tmp(2:ll-1)
      ll=mylen(tmp2)
c     call outCharArray(tmp2,ll+1)
      deleteSF9=ll
      return
      end
      subroutine outCharArray(str,lstr)
      CHARACTER*1 str(lstr)
      WRITE(*,4000) '"',(str(I),I=1,lstr),'"'
 4000 FORMAT(1X,60A1/(10X,60A1))
      end
 
      function mylen(str)
      CHARACTER*1 str(1)
      mylen=0
      do i=1,300
c       call outCharArray(str(i),1)
        if (str(i).eq.' ') return
        mylen=mylen+1
      end do
      return
      end
      function replaceStr(str0,lstr0,str1,str2)
      CHARACTER(LEN=*) str0,str1,str2
      lstr1=len(str1)
      lstr2=len(str2)
      replaceStr=0
      do i=1,300
        ind=INDEX(str0,str1)
c       write (*,*) ' ind=',ind,' L1=',lstr1,' L2=',lstr2
        if (ind.le.0) return
        lshift=lstr0-(ind+lstr1)
        str0(ind+lstr2:ind+lstr2+lshift)
     & =str0(ind+lstr1:ind+lstr1+lshift)
        str0(ind:ind+lstr2)=str2(1:lstr2)
        replaceStr=replaceStr+1
      end do
      return
      end
c---zvv---
      SUBROUTINE REACTN(KTYPE)
C
C     TRANSLATE EACH REACTION (UP TO 30) SEPERATELY.
C
C     ZAR1   = ENTIRE REACTION (BETWEEN BALANCED PARENTHESIS...OUTSIDE
C              PARENTHESIS REMOVED...PRINTED IF REACTION CANNOT BE
C              DECODED).
C     ZARBAK = BAKCUP COPY OF ZAR1 (USED FOR COMPLEX REACTIONS).
C     RN     = COMPLEX REACTION WITH ZA REMOVED.
C     R1     = SIMPLE REACTION WITH ZA REMOVED.
C
      INTEGER      OUTP,OTAPE
      CHARACTER*1  BLANK,PARENL,PARENR,ZAR1,ZAN,ZA1,R1,RN,FLAGR,CARD1
     &            ,CARD2,ENT,SUBENT,ZARBAK,KEYWD2,LABCM,ZARES,ZANRES
     &            ,ZANRAT,SLASH,EQUAL,MRAT,COMMA,ZASAVE
      CHARACTER*10 KEYWD1,BLANK10
      CHARACTER*1  iResPointer
      COMMON/iResCommon/iResFlag,iResPointer
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/BIBCRD/KEYWD1,KEYWD2,CARD1(55),CARD2(14)
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/ZART1I/KZAR1
      COMMON/ZART1C/ZAR1(300)
      COMMON/ZAT1I/KZA1,KR1
      COMMON/ZAT1C/ZA1(7),R1(300)
      COMMON/RATMET/MRAT
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/ZATNC1/FLAGR(30),ZAN(7,30),ZANRES(7,30),ZANRAT(14,30),
     1 LABCM(30)
      COMMON/ZATNC2/RN(300)
      COMMON/POINTR/MPOINT(9)
      COMMON/RESIDI/KZARES
      COMMON/RESIDC/ZARES(7)
      DIMENSION ZARBAK(300),ZASAVE(300,10),NSAVE(10)
      DATA BLANK10/'          '/
      DATA BLANK/' '/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA SLASH/'/'/
      DATA COMMA/','/
      DATA EQUAL/'='/
      DATA IZERO/0/
C-----INITIALIZE REACTION COUNT AND SAVED REACTION FLAG.
      KSANR=KSAN1
      ISAVE=0
      KSAVE=1
      iResFlag=0
C
C     START OF NEW REACTION. COPY ENTIRE REACTION INTO ZAR1 (REACTION
C     MAY BE CONTINUED ONTO MULTIPLE CARDS).
C
C-----FIRST CARD HAS ALREADY BEEN READ. BRANCH TO TEST FOR MACHINE
C-----READABLE REACTION.
      GO TO 80
C
C     IF OLD CONVENTION FOR MULTIPLE REACTIONS AND CHARACTERS ARE SAVED
C     RESTORE THEM AND CONTINUE TRANSLATION.
C
   10 IF(KSAVE.GT.ISAVE) GO TO 70
C-----LOAD UP TO 55 CHARACTERS INTO INPUT CARD ARRAY.
      NSAVEK=NSAVE(KSAVE)
      MSAVE=NSAVEK
      IF(MSAVE.GT.55) MSAVE=55
      DO I=1,MSAVE
        CARD1(I)=ZASAVE(I,KSAVE)
      END DO
      IF(MSAVE.GE.55) GO TO 40
      NN=MSAVE+1
      DO I=NN,55
        CARD1(I)=BLANK
      END DO
C-----IF ANY CHARACTERS REMAIN SHIFT THEN FORWARD IN SAVED ARRAY.
   40 IF(MSAVE.GE.NSAVEK) GO TO 60
      II=0
      JJ=MSAVE+1
      DO J=JJ,NSAVEK
        II=II+1
        ZASAVE(II,KSAVE)=ZASAVE(J,KSAVE)
      END DO
      NSAVE(KSAVE)=II
      GO TO 80
   60 KSAVE=KSAVE+1
      GO TO 80
C-----READ NEXT CARD.
   70 READ(ITAPE,1000,END=630,ERR=630) KEYWD1,KEYWD2,CARD1,CARD2
      ISAVE=0
      KSAVE=1
C-----CONTINUE DECODING IF KEYWORD FIELD IS BLANK.
      IF(KEYWD1.NE.BLANK10) GO TO 610
C-----TO BE MACHINE READABLE COLUMN 12 MUST CONTAIN (. IF NOT, ASSUME
C-----COMMENT CARD AND SKIP IT.
   80 IF(CARD1(1).NE.PARENL) GO TO 10
C-----INITIALIZE CHARACTER COUNT, LEVEL AND INDEX TO NEXT CHARACTER.
      KZAR1=0
      LEVEL=1
      LVLMAX=1
      II=2
C-----INITIALIZE CROSS SECTION RATIO FLAG OFF.
      IMRATS=0
C-----SAVE REACTION FLAG FROM COLUMN 11 AND INITIALIZE TARGET AND
C-----RESIDUAL NUCLEUS, RATIO DENOMINATOR ZA AND MT, REACTION MF AND MT
C-----AND CENTER-OF-MASS FLAG.
      KSANP=KSANR+1
      IF(KSANP.GT.30) GO TO 620
      FLAGR(KSANP)=KEYWD2
      KZANRS(KSANP)=0
      DO I=1,7
        ZAN(I,KSANP)=BLANK
        ZANRAT(I,KSANP)=BLANK
        ZANRES(I,KSANP)=BLANK
      END DO
      INPART(KSANP)=0
      MFR(KSANP)=0
      MTR(KSANP)=0
      MTRAT(KSANP)=0
      LABCM(KSANP)=BLANK
C
C     START OF NEW CARD (EITHER NEW REACTION OR CONTINUATION CARD).
C
C-----COPY UP TO BALANCED PARENTHESIS.
  100 DO 130 I=II,55
      IF(CARD1(I).EQ.BLANK) GO TO 130
      IF(CARD1(I).NE.PARENL) GO TO 110
      LEVEL=LEVEL+1
      IF(LEVEL.GT.LVLMAX) LVLMAX=LEVEL
      GO TO 120
  110 IF(CARD1(I).NE.PARENR) GO TO 120
      LEVEL=LEVEL-1
      IF(LEVEL.EQ.0) GO TO 140
  120 KZAR1=KZAR1+1
      IF(KZAR1.GT.300) GO TO 600
      ZAR1(KZAR1)=CARD1(I)
  130 CONTINUE
C-----PARENTHESIS NOT BALANCED YET. READ NEXT CARD.
      READ(ITAPE,1000,END=630,ERR=630) KEYWD1,KEYWD2,CARD1,CARD2
C-----ERROR IF KEYWORD FIELD IS NOT BLANK.
      IF(KEYWD1.NE.BLANK10) GO TO 600
C-----RESET TO BEGIN SCAN AT BEGINNING OF NEXT CARD.
      II=1
      GO TO 100
C
C     ENTIRE REACTION COPIED. SAVE IT. DETERMINE IF THIS IS A SIMPLE
C     OR COMPLEX REACTION
C     FOR SIMPLE REACTION KEYWORD,
C     REACTION IMPLIES ONLY 2 SETS OF PARENTHESIS.
C     OTHERS SUCH AS ISO-QUANT IMPLIES ONLY 1 SET OF PARENTHESIS.
C
  140 KZABAK=KZAR1
c---zvv+++
c     WRITE(*,4000) ENT,ISAN,'<',(ZAR1(I),I=1,KZAR1),'>'     !---zvv-tst
      KZAR1=deleteSF9(ZAR1,KZAR1)
      KZABAK=KZAR1
c     WRITE(*,4000) ENT,ISAN,'<',(ZAR1(I),I=1,KZAR1),'>'     !---zvv-tst
c---zvv---
      DO I=1,KZABAK
        ZARBAK(I)=ZAR1(I)
      END DO
      IF(KZABAK.GE.60) GO TO 180
      J=KZABAK+1
      DO I=J,60
        ZARBAK(I)=BLANK
      END DO
  180 IF(KTYPE.EQ.1.AND.LVLMAX.LE.2) GO TO 540
      IF(LVLMAX.LE.1) GO TO 540
C
C     FOR OLD ISO-QUANT FORMALISM TEST FOR COMPLETE REACTIONS SEPERATED
C     BY COMMAS. IF FOUND SAVE AND PROCESS EACH REACTION SEPERATELY.
C
      IF(KTYPE.EQ.1.OR.ISAVE.GT.0) GO TO 260
      J=1
      ISAVE=0
      KSAVE=1
      LVLOLD=0
  190 DO I=J,KZABAK
        IF(ZARBAK(I).EQ.PARENL) LVLOLD=LVLOLD+1
        IF(ZARBAK(I).EQ.PARENR) LVLOLD=LVLOLD-1
        IF(LVLOLD.EQ.0) GO TO 210
      END DO
      GO TO 260
  210 J=I+1
      IF(J.GE.KZABAK) GO TO 260
      IF(ZARBAK(J).NE.COMMA) GO TO 190
C-----MULTIPLE REACTIONS FOUND. DEFINE FIRST REACTION AS BEGINNING UP TO
C-----CURRENT POINT.
      ISAVE=1
      DO J=1,I
        ZASAVE(J,ISAVE)=ZARBAK(J)
      END DO
      NSAVE(ISAVE)=I
C-----COLLECT REMAINING REACTIONS.
  230 ISAVE=ISAVE+1
      LSAVE=0
      LVLOLD=0
      J=I+2
      DO 240 I=J,KZABAK
      LSAVE=LSAVE+1
      ZASAVE(LSAVE,ISAVE)=ZARBAK(I)
      IF(ZARBAK(I).EQ.PARENL) LVLOLD=LVLOLD+1
      IF(ZARBAK(I).EQ.PARENR) LVLOLD=LVLOLD-1
      IF(LVLOLD.NE.0) GO TO 240
      IF(I.EQ.KZABAK) GO TO 250
      IF(ZARBAK(I+1).EQ.COMMA) GO TO 250
  240 CONTINUE
      I=KZABAK
  250 NSAVE(ISAVE)=LSAVE
      IF(I.LT.KZABAK) GO TO 230
      GO TO 10
C
C     COMPLEX REACTION. BREAK INTO PARTS AND DECODE EACH PART SEPERATELY
C     SAVE ALL ENCLOSING PARENTHESIS AND OTHER CHARACTERS TO DEFINE
C     COMPLEX REACTION WITHOUT ZA.
C
C-----INCREMENT REACTION COUNT. ALLOW NO MORE THAN 30 REACTIONS.
  260 LOOP=0
C-----COPY ALL LEADING LEFT PARENTHESIS INTO RN.
      DO IBAK=1,KZABAK
        IF(ZARBAK(IBAK).NE.PARENL) GO TO 320
        RN(IBAK)=ZARBAK(IBAK)
      END DO
C
C     CANNOT TRANSLATE. ATEMPT TO TRANSLATE ENTIRE REACTION.
C
  280 DO I=1,7
        ZA1(I)=ZAN(I,KSANP)
        ZARES(I)=ZANRES(I,KSANP)
      END DO
      CALL MFMTX(ZARBAK,INPART(KSANP),MFR(KSANP),MTR(KSANP),
     1 IRFLAG(KSANP),KNOWN)
  300 WRITE(OUTP,6030) ENT,ISAN,INPART(KSANP),ZA1,ZARES,
     1 MFR(KSANP),MTR(KSANP),FLAGR(KSANP),(ZARBAK(I),I=1,KZABAK)
C-----INCREASE REACTION COUNT IF MF/MT ARE BOTH POSITIVE.
      IF(MFR(KSANP).LE.0.OR.MTR(KSANP).LE.0) GO TO 310
      KSANR=KSANP
      GO TO 10
C
C     WRITE REACTION TO NEWX4 FILE.
C
  310 IF(KNOWN.GT.0) GO TO 10
      WRITE(NEWX4,4000) ENT,ISAN,(ZARBAK(I),I=1,KZABAK)
      MPOINT(7)=MPOINT(7)+1
      GO TO 10
C-----DEFINE INITIALIZE NUMBER OF CHARACTERS COPIED.
  320 KRN=IBAK-1
C
C     START OF SIMPLE REACTION FOUND. COPY TO BALANCED PARENTHESIS.
C
  330 LVL=1
      JBAK=IBAK
      KZAR1=0
      DO IBAK=JBAK,KZABAK
        IF(ZARBAK(IBAK).EQ.PARENL) LVL=LVL+1
        IF(ZARBAK(IBAK).EQ.PARENR) LVL=LVL-1
        IF(LVL.EQ.0) GO TO 350
        KZAR1=KZAR1+1
        ZAR1(KZAR1)=ZARBAK(IBAK)
      END DO
      GO TO 280
C-----SIMPLE REACTION DEFINED (IN ZAR1). TRANSLATE IT.
  350 CALL REACT1
C-----SEE IF REACTION HAS BEEN TRANSLATED.
      IF(KR1.LE.0) GO TO 280
C-----DEFINE MF/MT EQUIVALENT.
      IF(KR1.GE.60) GO TO 370
      JR1=KR1+1
      DO I=JR1,60
        R1(I)=BLANK
      END DO
  370 CALL MFMTX(R1,INPARX,MFRX,MTRX,IRFLGX,KNOWN)
C-----SEE IF REACTION CAN BE TRANSLATED. IF NOT, TRY TO TRANSLATE ENTIRE
C-----REACTION.
      IF(MFRX.LE.0.OR.MTRX.LE.0) GO TO 280
C-----ONLY ALLOW CROSS SECTION RATIOS FOR CROSS SECTIONS.
      IF(MFRX.NE.3) IMRATS=0
C-----AFTER FIRST SIMPLE REACTION INSURE ALL OTHERS HAVE SAME TARGET
C-----AND RESIDUAL ZA (OTHERWISE CANNOT TRANSLATE).
      IF(LOOP.EQ.0) GO TO 420
C-----IF THIS IS SECOND REACTION AND RATIO FLAG IS SET SAVE TARGET AND
C-----PRODUCT ZA AND MT AND CONTINUE DECODING.
      IF(LOOP.NE.1.OR.IMRATS.LE.0) GO TO 390
      DO I=1,7
        ZANRAT(I,KSANP)=ZA1(I)
        ZANRAT(I+7,KSANP)=ZARES(I)
      END DO
      MTRAT(KSANP)=MTRX
      GO TO 440
C-----CHECK FOR SAME TARGET AND RESIDUAL ZA....IF NOT, CANNOT TRANSLATE.
  390 IF(KZA1.NE.KZAN(KSANP)) GO TO 280
      DO I=1,KZA1
        IF(ZAN(I,KSANP).NE.ZA1(I)) GO TO 280
      END DO
      IF(KZARES.NE.KZANRS(KSANP)) GO TO 280
      IF(KZARES.LE.0) GO TO 440
      DO I=1,KZARES
        IF(ZANRES(I,KSANP).NE.ZARES(I)) GO TO 280
      END DO
      GO TO 440
C-----SAVE FIRST TARGET AND RESIDUAL ZA (ONLY CROSS SECTIONS), INCIDENT
C-----PARTICLE, MF, MT AND REACTION OPERATION FLAG.
  420 KZAN(KSANP)=KZA1
      KZANRS(KSANP)=KZARES
      DO I=1,7
        ZAN(I,KSANP)=ZA1(I)
        ZANRES(I,KSANP)=ZARES(I)
      END DO
      INPART(KSANP)=INPARX
      MFR(KSANP)=MFRX
      MTR(KSANP)=MTRX
      IRFLAG(KSANP)=IRFLGX
C-----INCREMENT SIMPLE REACTION COUNT.
  440 LOOP=LOOP+1
C-----ADD NEXT SIMPLE REACTION TO COMPLEX REACTION STRING.
      DO I=1,KR1
        KRN=KRN+1
        RN(KRN)=R1(I)
      END DO
C
C     COPY TO BEGINNING OF NEXT SIMPLE REACTION, OR END OF COMPLEX
C     REACTION. SIMPLE REACTION STARTS AT FIRST CHARACTER AFTER NEXT
C     SET OF LEFT PARENTHESIS.
C
C-----IF ONLY ONE REACTION READ SO FAR AND NEXT CHARACTER IS = ASSUME
C-----REMAINDER OF REACTION EQUIVALENT TO FIRST SIMPLE REACTION.
      IF(LOOP.EQ.1.AND.ZARBAK(IBAK+1).EQ.EQUAL) GO TO 470
C-----IF ONLY ONE REACTION READ SO FAR AND NEXT CHARACTER IS / SET FLAG
C-----TO INDICATE POSSIBLE SIMPLE RATIO.
      IF(LOOP.EQ.1.AND.ZARBAK(IBAK+1).EQ.SLASH) IMRATS=1
C-----COPY UP TO NEXT LEFT PARENTHESIS OR END OF COMPLEX REACTION.
      JBAK=IBAK
      DO IBAK=JBAK,KZABAK
        KRN=KRN+1
        RN(KRN)=ZARBAK(IBAK)
        IF(ZARBAK(IBAK).EQ.PARENL) GO TO 490
      END DO
C-----ENTIRE REACTION COPIED. IF SIMPLE RATIO INCREASE MF BY 200 AND
C-----USE ZA/MF/MT FROM FIRST REACTION. OTHERWISE ATTEMPT TO TRANSLATE
C-----COMPLEX REACTION.
      IF(LOOP.NE.2.OR.IMRATS.NE.1) GO TO 510
      MFR(KSANP)=MFR(KSANP)+200
  470 DO I=1,7
        ZA1(I)=ZAN(I,KSANP)
        ZARES(I)=ZANRES(I,KSANP)
      END DO
      GO TO 300
C-----COPY ALL LEFT PARENTHESIS AND THEN BRANCH BACK TO DEFINE SIMPLE
C-----REACTION.
  490 JBAK=IBAK+1
      IF(JBAK.GT.KZABAK) GO TO 280
      DO IBAK=JBAK,KZABAK
        IF(ZAR1(IBAK).NE.PARENL) GO TO 330
        KRN=KRN+1
        RN(KRN)=ZARBAK(IBAK)
      END DO
      GO TO 280
C
C     COMPLEX TRANSLATION COMPLETED. MOVE TO R1 AND ZA1 TO DEFINE
C     PROJECTILE, MF AND MT.
C
  510 KR1=KRN
      DO I=1,KRN
        R1(I)=RN(I)
      END DO
      DO I=1,7
        ZA1(I)=ZAN(I,KSANP)
        ZARES(I)=ZANRES(I,KSANP)
      END DO
      GO TO 560
C
C     SIMPLE REACTION. TRANSLATE IT.
C
  540 CALL REACT1
C-----SEE IF REACTION HAS BEEN TRANSLATED.
      IF(KR1.LE.0) GO TO 280
C-----SAVE TARGET ZA.
      KZAN(KSANP)=KZA1
      KZANRS(KSANP)=KZARES
      DO I=1,7
        ZAN(I,KSANP)=ZA1(I)
        ZANRES(I,KSANP)=ZARES(I)
      END DO
C
C     DEFINE MF/MT EQUIVALENT.
C
  560 IF(KR1.GE.60) GO TO 580
      JR1=KR1+1
      DO I=JR1,60
        R1(I)=BLANK
      END DO
  580 CALL MFMTX(R1,INPART(KSANP),MFR(KSANP),MTR(KSANP),
     1 IRFLAG(KSANP),KNOWN)
      WRITE(OUTP,6030) ENT,ISAN,INPART(KSANP),ZA1,ZARES,
     1 MFR(KSANP),MTR(KSANP),FLAGR(KSANP),(R1(I),I=1,KR1)
c---zvv+++2009.09.09
      if (KR1.gt.3) then
        if ((R1(KR1-2).eq.',')
     +       .and.(R1(KR1-1).eq.'E')
     +       .and.(R1(KR1).eq.'N')) then
          iResFlag=1
          iResPointer=FLAGR(KSANP)
        endif
c     WRITE(*,*) 'KSANP=',KSANP,'mf=',MFR(KSANP),' mt=',MTR(KSANP)
c    +,' pointer=',FLAGR(KSANP),' KR1=',KR1,' iResFlag=',iResFlag
c    +,' R1=[',R1(KR1-2),R1(KR1-1),R1(KR1),']'
      endif
c---zvv---2009.09.09
C-----INCREASE REACTION COUNT IF MF/MT ARE BOTH POSITIVE.
      IF(MFR(KSANP).LE.0.OR.MTR(KSANP).LE.0) GO TO 310
      KSANR=KSANP
C-----IF SIMPLE RATIO DEFINE NUMERATOR AND DENOMINATOR TO BE THE SAME.
      IF(MFR(KSANP).NE.203) GO TO 10
      DO I=1,7
        ZANRAT(I,KSANP)=ZA1(I)
        ZANRAT(I+7,KSANP)=ZARES(I)
      END DO
C-----ASSUME RATIO OF METASTABLE STATES DEFINED.
      ZANRAT(14,KSANP)=MRAT
      MTRAT(KSANP)=MTR(KSANP)
      GO TO 10
C
C     ERROR DECODING REACTIONS.
C
C-----PARENTHESIS DO NOT BALANCE.
  600 WRITE(OUTP,6000) (ZAR1(I),I=1,KZAR1)
      WRITE(OUTP,6010)
C---zvv+++2009.09.09 no reac with pointers
  610 continue
      if (KSANR.eq.1) iResFlag=0
c     WRITE(*,*) '---zvv:KSANR=',KSANR,' iResFlag=',iResFlag
      RETURN
C---zvv---
C-----OVER 30 REACTIONS.
  620 WRITE(OUTP,6020)
      RETURN
C-----ERROR READING EXFOR DATA FILE.
  630 WRITE(OUTP,6040)
      CALL EXIT
 1000 FORMAT(A10,A1,55A1,14A1)
 4000 FORMAT(1X,5A1,I3,1X,60A1/(10X,60A1))
 6000 FORMAT(10X,80A1)
 6010 FORMAT(10X,'FORMAT ERROR...PARENTHESIS DO NOT BALANCE')
 6020 FORMAT(10X,'OVER 30 REACTIONS...WILL ONLY TREAT FIRST 30')
 6030 FORMAT(1X,5A1,I4,I8,1X,7A1,2X,7A1,I4,I5,1X,A1,1X,60A1/(46X,60A1))
 6040 FORMAT(10X,'ERROR READING EXFOR DATA...EXECUTION TERMINATED')
      END
      SUBROUTINE REACT1
C
C     DECODE SIMPLE REACTION (ZAR1) INTO Z,A AND BASIC REACTION.
C
      INTEGER      OUTP,OTAPE
      CHARACTER*1  BLANK,PARENL,PARENR,DASH,COMMA,ZERO,DIGIT,ZAR1
     &            ,ZA1,R1,NX,FLAGR,ZAN,LABCM,ZARES,ZANRES,ZANRAT
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/ZART1I/KZAR1
      COMMON/ZART1C/ZAR1(300)
      COMMON/ZAT1I/KZA1,KR1
      COMMON/ZAT1C/ZA1(7),R1(300)
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/ZATNC1/FLAGR(30),ZAN(7,30),ZANRES(7,30),ZANRAT(14,30),
     1 LABCM(30)
      COMMON/RESIDI/KZARES
      COMMON/RESIDC/ZARES(7)
      DIMENSION DIGIT(10),NX(2)
      DATA BLANK/' '/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA DASH/'-'/
      DATA COMMA/','/
      DATA ZERO/'0'/
      DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/
      DATA NX/',','X'/
C-----INITIALIZE RESIDUAL NUCLEUS ZA.
      KZARES=0
      DO I=1,7
        ZARES(I)=BLANK
      END DO
C-----DECODE TARGET ZA AND CHECK FOR ERROR.
      CALL DECOZA(ZAR1,KZAR1,1,INOW,ZA1,KZA1)
      IF(KZA1.LE.0) GO TO 130
C
C     END OF TARGET Z, A. IF LEFT PARENTHESIS FOUND COPY REACTION UP
C     TO RIGHT PARENTHESIS,E.G. (N,P). OTHERWISE OLD EXFOR FORMAT...
C     COPY REMAINDER OF REACTION.
C
      KR1=0
      IF(ZAR1(INOW).NE.PARENL) GO TO 90
      DO 20 JNOW=INOW,KZAR1
      KR1=KR1+1
      R1(KR1)=ZAR1(JNOW)
      IF(ZAR1(JNOW).EQ.PARENR) GO TO 30
   20 CONTINUE
C-----ERROR. CANNOT LOCATE END OF REACTION.
      GO TO 120
C
C     REACTION COPIED. TRANSLATE RESIDUAL NUCLEUS ZA. IF REACTION ENDS
C     WITH ,X DEFINE LENGTH OF RESIDUAL NUCLEUS ZA.
C
   30 JNOW=JNOW+1
      IF(JNOW.GT.KZAR1) GO TO 140
C-----DECODE RSIDUAL NUCLEUS ZA AND CHECK FOR ERROR.
      CALL DECOZA(ZAR1,KZAR1,JNOW,INOW,ZARES,KZARES)
C-----IF LEGAL RESIDUAL FIELD NOT FOUND SKIP TO COPY REMAINDER OF
C-----REACTION (WITHOUT ADVANCING CHARACTER INDEX). IF NEXT CHARACTER
C-----IS COMMA SKIP IT (EMPTY RESIDUAL NUCLEUS FIELD).
      IF(INOW.GT.JNOW) GO TO 40
      IF(ZAR1(JNOW).EQ.COMMA) GO TO 90
      GO TO 100
   40 IF(KZARES.LE.0) GO TO 90
C-----REMOVE LEADING ZEROES (EXCEPT THE LAST ONE) FROM RESIDUAL NUCLEUS.
      DO I=1,5
        IF(ZARES(I).NE.BLANK) GO TO 60
      END DO
      GO TO 80
   60 DO J=I,5
        IF(ZARES(J).NE.ZERO) GO TO 80
        ZARES(J)=BLANK
      END DO
C-----IF REACTION DOES NOT END WITH ,X) IS RESIDUAL CHARACTER COUNT=0
   80 IF(R1(KR1-2).NE.NX(1).OR.R1(KR1-1).NE.NX(2)) KZARES=0
C
C     COPY REMAINDER OF REACTION.
C
   90 INOW=INOW+1
  100 IF(INOW.GT.KZAR1) GO TO 140
      DO JNOW=INOW,KZAR1
        KR1=KR1+1
        R1(KR1)=ZAR1(JNOW)
      END DO
      GO TO 140
C-----ERROR. CANNOT LOCATE END OF REACTION.
  120 WRITE(OUTP,6000) (ZAR1(I),I=1,KZAR1)
      WRITE(OUTP,6020)
  130 KZA1=0
      KR1=0
  140 RETURN
 6000 FORMAT(10X,80A1)
 6020 FORMAT(10X,'FORMAT ERROR...CANNOT LOCATE END OF REACTION')
      END
      SUBROUTINE DECOZA(ZARACT,KSIZE,KSTART,KNOW,ZAX,KZAX)
C
C     DECODE TARGET OR RESIDUAL NUCLEUS ZA.
C
C     INPUT
C     =====
C     ZARACT = EXFOR SIMPLE REACTION.
C     KSIZE  = LENGTH OF EXFOR SIMPLE REACTION STRING
C     KSTART = STARTING LOCATION TO BEGIN DECODING ZA.
C
C     STARTING AT LOCATION KSTART AND NOT EXTENDING BEYOND LOCATION
C     KSIZE OF THE ARRAY ZARACT THIS ROUTINE EXPECTS TO FIND A STRING
C     OF THE FORM,
C
C     ZZZ-SS-AAA-M = ZZZ = ATOMIC NUMBER
C                    SS  = CHEMICAL SYMBOL
C                    AAA = ATOMIC WEIGHT
C                    M   = METASTABLE STATE FLAG (MAY NOT BE PRESENT)
C
C     FOLLOWED BY , OR ( OR )
C
C     THIS ROUTINE WILL REMOVE THE CHEMICAL SYMBOL AND RIGHT ADJUST
C     THE COMBINED ZZZ, AAA AND M TO THE FORM ZZZAAAM. IF ZZZ IS LESS
C     THAN 3 CHARACTERS LONG IT WILL BE RIGHT ADJUSTED TO 3 CHARACTERS
C     WITH LEADING BLANKS. IF AAA IS LESS THAN 3 CHARACTERS LONG IT WILL
C     BE RIGHT ADJUSTED WITH LEADING ZEROES. IF M IS NOT PRESENT IT WILL
C     BE SET TO BLANK.
C
C     E.G., 26-FE-56-M = 26056M
C
C     THIS ROUTINE WILL RETURN,
C
C     ZAX  = 7 CHARACTER ZZZAAAM
C     KZAX = COUNT OF CHARACTERS IN ZAX
C          = 7 - NORMALLY
C          = 0 - ERROR (CANNOT DECODE ZA)
C     KNOW = POINTER TO FIRST CHARACTER IN THE ARRAY ZARACT FOLLOWING
C            THE ZA FIELD.
C
      INTEGER OUTP,OTAPE
      CHARACTER*1 ZARACT,ZAX,BLANK,ZERO,PARENL,PARENR,COMMA,DASH,MRAT,
     1 METBCD
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/RATMET/MRAT
      DIMENSION ZARACT(300),ZAX(7),METBCD(20)
      DATA BLANK/' '/
      DATA ZERO/'0'/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA COMMA/','/
      DATA DASH/'-'/
C-----INITIALIZE ZA.
      KNOW=KSTART
      KZAX=0
      DO I=1,7
        ZAX(I)=BLANK
      END DO
C-----INITIALIZE METASTABLE FIELD CHARACTER COUNT.
      MRAT=BLANK
      METAF=0
C-----COPY FIELD IF NOT TWO DASHES BEFORE NEXT COMMA (ONLY RESIDUAL
C-----NUCLEUS FIELD).
      IDASH=0
      DO I=KSTART,KSIZE
        IF(ZARACT(I).EQ.COMMA) GO TO 30
        IF(ZARACT(I).EQ.DASH) IDASH=IDASH+1
      END DO
      RETURN
   30 IF(IDASH.GE.2) GO TO 40
      RETURN
C-----INITIALIZE DASH COUNT.
   40 IDASH=-1
C-----SET UP LOOP OVER CHARACTERS.
      DO 140 KNOW=KSTART,KSIZE
C-----SEARCH FOR DASH (-).
      IF(ZARACT(KNOW).EQ.DASH) GO TO 50
C-----CHARACTER IS NOT A DASH. SKIP CHEMICAL SYMBOL BY SKIPPING ALL
C-----CHARACTERS BETWEEN FIRST AND SECOND DASH.
      IF(IDASH) 60,140,120
C-----CHARACTER IS A DASH.
   50 IF(IDASH) 70,100,110
C-----NO DASH FOUND YET. DEFINE Z TO BE UP TO 3 CHARACTERS PRECEDING
C-----FIRST DASH (SKIP ALL CHARACTERS AFTER 3).
   60 IF(KZAX.GE.3) GO TO 140
      KZAX=KZAX+1
      ZAX(KZAX)=ZARACT(KNOW)
      GO TO 140
C-----FIRST DASH FOUND. IF NECESSARY RIGHT ADJUST Z WITH LEADING BLANKS.
   70 IDASH=0
      IF(KZAX.GE.3) GO TO 140
      MM=3
      LL=KZAX
      DO 80 M=1,KZAX
      ZAX(MM)=ZAX(LL)
      MM=MM-1
   80 LL=LL-1
      DO M=1,MM
        ZAX(M)=BLANK
      END DO
      KZAX=3
      GO TO 140
C-----SECOND DASH FOUND. CHEMICAL SYMBOL HAS BEEN SKIPPED. SET DASH
C-----COUNT TO COPY A FIELD.
  100 IDASH=1
      GO TO 140
C-----MORE THAN 2 DASHES. SET DASH COUNT FOR METASTABLE STATE FIELD.
  110 IDASH=2
      GO TO 140
C-----AFTER SECOND DASH SEARCH FOR END OF STRING...( OR ) OR ,
  120 IF(ZARACT(KNOW).EQ.PARENL.OR.ZARACT(KNOW).EQ.PARENR.OR.
     1 ZARACT(KNOW).EQ.COMMA) GO TO 150
C-----NOT THE END OF STRING. IF MORE THAN 2 DASHES SAVE CHARACTERS FROM
C-----METASTABLE STATE FIELD.
      IF(IDASH.EQ.1) GO TO 130
      IF(METAF.GT.20) GO TO 140
      METAF=METAF+1
      METBCD(METAF)=ZARACT(KNOW)
      GO TO 140
C-----IF 2 DASHES HAVE BEEN FOUND DEFINE A TO BE UP TO NEXT 3 CHARACTERS
C-----(SKIP ALL CHARACTERS AFTER 3).
  130 IF(KZAX.GE.6) GO TO 140
      KZAX=KZAX+1
      ZAX(KZAX)=ZARACT(KNOW)
  140 CONTINUE
C-----ERROR. CANNOT LOCATE END OF ZA.
      GO TO 190
C-----END OF A FOUND. IF NECESSARY RIGHT ADJUST A WITH LEADING ZEROES.
  150 IF(KZAX.GE.6) GO TO 180
      MM=6
      LL=KZAX
      DO M=4,KZAX
        ZAX(MM)=ZAX(LL)
        MM=MM-1
        LL=LL-1
      END DO
      DO M=4,MM
        ZAX(M)=ZERO
      END DO
  180 KZAX=7
C-----IF NECESSARY DECODE METASTABLE STATE FIELD.
      IF(METAF.GT.0) CALL DECODM(METBCD,METAF,ZAX,MRAT)
      RETURN
C-----ERROR. CANNOT LOCATE END OF ZA. PRINT ERROR AND SET ZA CHARACTER
C-----COUNT TO ZERO.
  190 WRITE(OUTP,6000) (ZARACT(I),I=KSTART,KSIZE)
      WRITE(OUTP,6010)
      KZAX=0
      KNOW=KSIZE+1
      RETURN
 6000 FORMAT(10X,80A1)
 6010 FORMAT(10X,'FORMAT ERROR...CANNOT LOCATE END OF ZA')
      END
      SUBROUTINE DECODM(METBCD,METAF,ZAX,MRAT)
C
C     DECODE METASTABLE STATE FIELD.
C
      INTEGER OUTP,OTAPE
      CHARACTER*1 METBCD,ZAX,MRAT,SLASH,M,PLUS,WHAT,BLANK,TOTAL,MET1
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      DIMENSION METBCD(20),ZAX(7)
      DATA SLASH/'/'/
      DATA BLANK/' '/
      DATA M/'M'/
      DATA PLUS/'+'/
      DATA WHAT/'?'/
      DATA TOTAL/'T'/
C
C     DETERMINE IF THIS IS RATIO OF METASTABLE STATES.
C
      JFIELD=1
      DO I=1,METAF
        IF(METBCD(I).EQ.SLASH) GO TO 20
      END DO
C-----NO. SET DENOMINATOR TO BLANK AND DECODE ONLY ONE FIELD.
      MRAT=BLANK
      KFIELD=1
      NFIELD=METAF
      GO TO 30
C-----YES. DECODE 2 FIELDS SEPARATELY.
   20 KFIELD=2
      NFIELD=I-1
C
C     SET UP LOOP OVER FIELDS TO DECODE.
C
   30 DO 110 K=1,KFIELD
      ICHAR=NFIELD-JFIELD+1
C
C     IF ONLY ONE CHARACTER USE AS DEFINITION.
C
      IF(ICHAR-1) 80,40,50
   40 MET1=METBCD(JFIELD)
      IF(MET1.EQ.TOTAL) MET1=BLANK
      IF(K.EQ.1) ZAX(7)=METBCD(JFIELD)
      IF(K.EQ.2) MRAT=METBCD(JFIELD)
      GO TO 100
C
C     IF ONLY TWO CHARACTERS AND FIRST IS M USE SECOND CHARACTER.
C
   50 IF(METAF.GT.2) GO TO 60
      IF(METBCD(JFIELD).NE.M) GO TO 80
      IF(K.EQ.1) ZAX(7)=METBCD(JFIELD+1)
      IF(K.EQ.2) MRAT=METBCD(JFIELD+1)
      GO TO 100
C
C     MORE THAN TWO CHARACTERS. SEE IF SUM OF STATES.
C
   60 DO I=JFIELD,NFIELD
        IF(METBCD(I).EQ.PLUS) GO TO 90
      END DO
C
C     CANNOT DECODE. DEFINE ?
C
   80 IF(K.EQ.1) ZAX(7)=WHAT
      IF(K.EQ.2) MRAT=WHAT
      GO TO 100
C
C     SUM OF STATES. DEFINE +
C
   90 IF(K.EQ.1) ZAX(7)=PLUS
      IF(K.EQ.2) MRAT=PLUS
  100 JFIELD=NFIELD+2
  110 NFIELD=METAF
      RETURN
      END
      SUBROUTINE STATUS
C
C     DEFINE STATUS.
C
      CHARACTER*10 KEYWD1
      CHARACTER*1 CARD1,CARD2,KEYWD2,BLANK,PARENL,STAT1,STATN,STATAB
      COMMON/BIBCRD/KEYWD1,KEYWD2,CARD1(55),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/STATUC/STAT1,STATN
      DIMENSION STATAB(7,7)
      DATA BLANK/' '/
      DATA PARENL/'('/
      DATA STATAB/
     1 'P','R','E','L','M',' ','P',
     2 'S','P','S','D','D',' ','S',
     3 'D','E','P',' ',' ',' ','D',
     4 'C','O','R','E','L',' ','C',
     5 'A','P','R','V','D',' ','A',
     6 'O','U','T','D','T',' ','O',
     7 'R','N','O','R','M',' ','R'/
C-----INITIALIZE STATUS.
      STATN=BLANK
      IF(ISAN.EQ.1) STAT1=BLANK
      IF(CARD1(1).NE.PARENL) RETURN
C-----FIND END OF STATUS.
      DO 20 I=1,7
      DO 10 J=1,6
      IF(STATAB(J,I).EQ.BLANK) GO TO 30
      IF(CARD1(J+1).NE.STATAB(J,I)) GO TO 20
   10 CONTINUE
      GO TO 30
   20 CONTINUE
C-----STATUS NOT DEFINED.
      RETURN
C-----DEFINE STATUS.
   30 STATN=STATAB(7,I)
      IF(ISAN.EQ.1) STAT1=STATN
      RETURN
      END
      SUBROUTINE REFERS
C
C     SAVE LATEST YEAR FROM REFERENCES.
C
      INTEGER OUTP,OTAPE
      CHARACTER*10 KEYWD1
      CHARACTER*1 CARD1,CARD2,KEYWD2,REFER1,REFERN,BLANK,PARENL,PARENR,
     1 COMMA,DIGITS
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/BIBCRD/KEYWD1,KEYWD2,CARD1(55),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/REFERI/IREF,NREF
      COMMON/REFERC/REFER1(4),REFERN(4)
      DIMENSION DIGITS(10)
      DATA DIGITS/'1','2','3','4','5','6','7','8','9','0'/
      DATA BLANK/' '/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA COMMA/','/
C-----INITIALIZE REFERENCE.
      NREF=0
      DO I=1,4
        REFERN(I)=BLANK
      END DO
      IF(CARD1(1).NE.PARENL) GO TO 70
C-----FIND END OF REFERENCE AND LAST PRECEDING COMMA.
      ICOM=0
      LVL=1
      DO IEND=2,55
        IF(CARD1(IEND).EQ.PARENL) LVL=LVL+1
        IF(CARD1(IEND).EQ.PARENR) LVL=LVL-1
        IF(CARD1(IEND).EQ.COMMA) ICOM=IEND
        IF(LVL.LE.0) GO TO 30
      END DO
      GO TO 70
C-----SEARCH FOR YEAR BETWEEN LAST COMMA AND END OF REFERENCE.
   30 IF(ICOM.LE.0) GO TO 70
C-----SELECT LAST TWO DIGITS OF YEAR.
      IEND=IEND-1
      IDIG=IEND-ICOM
      IF(IDIG.EQ.2) GO TO 60
      IF(IDIG.EQ.4) GO TO 40
C-----6 DIGIT DATE. SELECT MIDDLE TWO DIGITS AS MONTH.
      IF(IDIG.GT.6) GO TO 50
C-----(START OF  YEAR...19YY, 20YY) SELECT THIRD AND FOURTH DIGITS.
      IF( (CARD1(ICOM+1).EQ.DIGITS(1).AND.CARD1(ICOM+2).EQ.DIGITS(9))
     &.OR.(CARD1(ICOM+1).EQ.DIGITS(2).AND.CARD1(ICOM+2).LT.DIGITS(4))
     &.OR. CARD1(ICOM+1).EQ.DIGITS(10)) GO TO 50
      GO TO 60
C-----4 DIGIT DATE. IF FIRST DIGITS IS 0 OR 1 (START OF MONTH 1 TO 12
C-----OR START OF  YEAR...1975) SELECT THIRD AND FOURTH DIGITS.
   40 IF( (CARD1(ICOM+1).EQ.DIGITS(1).AND.CARD1(ICOM+2).EQ.DIGITS(9))
     &.OR.(CARD1(ICOM+1).EQ.DIGITS(2).AND.CARD1(ICOM+2).LT.DIGITS(4))
     &.OR. CARD1(ICOM+1).EQ.DIGITS(10)) GO TO 50
C-----IF LAST TWO DIGITS ARE A MONTH (E.G. 00 TO 12...LEADING
C-----DIGIT 0 OR 1) SELECT FIRST TWO DIGITS.
      IF(CARD1(ICOM+3).EQ.DIGITS(1).OR.
     1 CARD1(ICOM+3).EQ.DIGITS(10)) GO TO 60
   50 ICOM=ICOM+2
   60 NREF=4
      REFERN(1)=PARENL
      REFERN(2)=CARD1(ICOM+1)
      REFERN(3)=CARD1(ICOM+2)
      REFERN(4)=PARENR
C-----IF THIS IS SUBENTRY 1 SAVE COMMON YEAR.
   70 IF(ISAN.NE.1) GO TO 90
      IREF=NREF
      IF(IREF.LE.0) GO TO 90
      DO I=1,4
        REFER1(I)=REFERN(I)
      END DO
   90 RETURN
      END
      SUBROUTINE AUTHOR
C
C     SAVE FIRST AUTHOR. IF MORE THAN ONE AUTHOR ADD ET.EL.
C
      INTEGER OUTP,OTAPE
      CHARACTER*10 KEYWD1
      CHARACTER*1 CARD1,CARD2,KEYWD2,AUTH1,AUTHN,BLANK,PARENL,PARENR,
     1 COMMA,ETAL
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/BIBCRD/KEYWD1,KEYWD2,CARD1(55),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/AUTHI/IAUTH,NAUTH
      COMMON/AUTHC/AUTH1(25),AUTHN(25)
      DIMENSION ETAL(7)
      DATA BLANK/' '/
      DATA PARENL/'('/
      DATA PARENR/')'/
      DATA COMMA/','/
      DATA ETAL/',','E','T','.','A','L','.'/
C-----INITIALIZE AUTHOR.
      NAUTH=0
      DO I=1,25
        AUTHN(I)=BLANK
      END DO
C-----TO BE MACHINE READABLE COLUMN 11 MUST CONTAIN (
      IF(CARD1(1).NE.PARENL) GO TO 60
C-----DEFINE FIRST AUTHOR UP TO ) OR ,
      DO 20 I=2,21
      IF(CARD1(I).EQ.PARENR) GO TO 60
      IF(CARD1(I).EQ.COMMA) GO TO 30
      NAUTH=NAUTH+1
      AUTHN(NAUTH)=CARD1(I)
   20 CONTINUE
      GO TO 60
C-----MORE THAN 1 AUTHOR. INSTER ET.AL. IF THERE IS ROOM.
C-----OTHERWISE JUST INSERT COMMA.
   30 IF(NAUTH.LE.13) GO TO 40
      NAUTH=NAUTH+1
      AUTHN(NAUTH)=COMMA
      GO TO 60
   40 DO I=1,7
        NAUTH=NAUTH+1
        AUTHN(NAUTH)=ETAL(I)
      END DO
C-----IF THIS IS SUBENTRY 1 SAVE COMMON AUTHOR.
   60 IF(ISAN.NE.1) GO TO 80
      IAUTH=NAUTH
      IF(IAUTH.LE.0) GO TO 80
      DO I=1,IAUTH
        AUTH1(I)=AUTHN(I)
      END DO
   80 RETURN
      END
      SUBROUTINE COMIN
      INTEGER OUTP,OTAPE
      CHARACTER*11 CARD1,TITLE,UNIT,DATUM
      CHARACTER*4  TITLE4
      CHARACTER*1 CARD2,ENT,SUBENT,FLAGI
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDS/CARD1(6),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADC2/FLAGI(50)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
C-----SAVE TITLES, UNITS AND DATA.
      I1=ICOM1+1
      I2=ICOM1+N1
      READ(ITAPE,1010,END=10,ERR=10) (TITLE(I),FLAGI(I),I=I1,I2)
      READ(ITAPE,1020,END=10,ERR=10) ( UNIT(I),I=I1,I2)
      READ(ITAPE,1020,END=10,ERR=10) (DATUM(I),I=I1,I2)
C-----DEFINE COLUMN COUNTS.
      ICOMN=I2
      IF(ISAN.EQ.1) ICOM1=I2
      RETURN
C-----ERROR READING EXFOR DATA.
   10 WRITE(OUTP,6000)
      CALL EXIT
 1000 FORMAT(6(2A4,A3),14A1)
 1010 FORMAT(6(A10,A1))
 1020 FORMAT(6A11)
 6000 FORMAT(10X,'ERROR READING EXFOR DATA...EXECUTION TERMINATED')
      END
      SUBROUTINE DATIN
C
C     READ DATA POINTS, TRANSLATE AND OUTPUT IN COMPUTATION FORMAT.
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 CARD1,TITLE,UNIT,DATUM,BLANK11
      CHARACTER*9  OUTLIN,BLANK9
      CHARACTER*4  TITLE4,IM78,BLANK4
      CHARACTER*1  CARD2,ENT,SUBENT,FLAGI,FLAGR,ZAN,AUTH1,AUTHN,AUTHK,
     1 REFER1,REFERN,LABCM,STAT1,STATN,BLANK,ZANRES,ZANRAT,DIGITS,ZANOK
     1,ZAPO(6,8)
      CHARACTER*1  iResPointer
      COMMON/iResCommon/iResFlag,iResPointer
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDS/CARD1(6),CARD2(14)
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADC2/FLAGI(50)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/RNOW/ISANR
      COMMON/ZATNC1/FLAGR(30),ZAN(7,30),ZANRES(7,30),ZANRAT(14,30),
     1 LABCM(30)
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      COMMON/AUTHI/IAUTH,NAUTH
      COMMON/AUTHC/AUTH1(25),AUTHN(25)
      COMMON/REFERI/IREF,NREF
      COMMON/REFERC/REFER1(4),REFERN(4)
      COMMON/POINTR/MPOINT(9)
      COMMON/STATUC/STAT1,STATN
      DIMENSION AUTHK(25),OUTLIN(8),DIGITS(10),ZANOK(7)
      DATA BLANK/' '/
      DATA BLANK4/'    '/
      DATA BLANK9/'         '/
      DATA BLANK11/'           '/
      DATA DIGITS/'0','1','2','3','4','5','6','7','8','9'/
      DATA ZAPO /' ',' ',' ',' ',' ','0',
     2           ' ',' ',' ',' ',' ','1',
     3           ' ',' ','1','0','0','1',
     4           ' ',' ','1','0','0','2',
     5           ' ',' ','1','0','0','3',
     6           ' ',' ','2','0','0','3',
     7           ' ',' ','2','0','0','4',
     8           ' ','9','9','9','9','9'/
c-----------------------------------------------------------------------
c
c     2025/10/7 - Added for PLOTTAB.PNT output
c
c-----------------------------------------------------------------------
      CHARACTER*25 AUTHNOW,AUTH25
      CHARACTER*5  ENTNOW,ENT5
      EQUIVALENCE (AUTH25,AUTHK(1)),(ENT5,ENT(1))
      data AUTHNOW/
     1 '                         '/
      data ENTNOW/'    '/
      datA ISANNOW/0/
      data ISANRNOW/0/
c-----initialize PLOTTAB.PNT on first call
      data IPASS/0/
      if(IPASS.eq.0) then
      open(16,file='PLOTTAB.PNT')
      IPASS = 1
      endif
c-----------------------------------------------------------------------
C
C     DEFINE STATUS, AUTHOR AND YEAR FROM CURRENT SUBENTRY OR COMMON
C     SUBENTRY.
C
c-----------------------------------------------------------------------
      MPOINT(1)=MPOINT(1)+1
      IF(STATN.EQ.BLANK) STATN=STAT1
      IF(NAUTH.GT.0.OR.IAUTH.LE.0) GO TO 20
      NAUTH=IAUTH
      DO I=1,NAUTH
        AUTHN(I)=AUTH1(I)
      END DO
   20 IF(NREF.GT.0.OR.IREF.LE.0) GO TO 40
      NREF=IREF
      DO I=1,NREF
        REFERN(I)=REFER1(I)
      END DO
C-----COPY AUTHOR TO OUTPUT ARRAY.
   40 KAUTH=NAUTH
      DO I=1,25
        AUTHK(I)=AUTHN(I)
      END DO
C-----ADD YEAR TO END OF AUTHOR.
      IF(NREF.LE.0) GO TO 70
      KAUTH=KAUTH+1
      DO I=1,4
        KAUTH=KAUTH+1
        AUTHK(KAUTH)=REFERN(I)
      END DO
C
C     SAVE TITLES AND UNITS AND DEFINE INITIAL NUMBER OF COLUMNS.
C
   70 I1=ICOMN+1
      I2=ICOMN+N1
      IDATN=I2
      READ(ITAPE,1010,END=500,ERR=500) (TITLE(I),FLAGI(I),I=I1,I2)
      READ(ITAPE,1020,END=500,ERR=500) (UNIT(I),I=I1,I2)
c---zvv+++2009.09.09
c     write (*,*) '---zvv-',i1,i2,('[',TITLE(I),']',FLAGI(I),I=I1,I2)
c     write (*,*) '---zvv-','iResFlag=',iResFlag,'[',iResPointer,']'
c     iResFlag=0
      if (iResFlag.ne.0) then
        do i=i1,i2
c         write (*,*) '---zvv-',i,'[',TITLE(I),']',FLAGI(I)
          if (FLAGI(I).eq.iResPointer) then
c           write (*,*) '---zvv=',i,iResFlag,'[',TITLE(I),']',FLAGI(I)
            if (TITLE(I).eq.'DATA') then
              TITLE(I)='EN-RES'
              FLAGI(I)=' '
            endif
            if (TITLE(I).eq.'DATA-ERR') then
              TITLE(I)='EN-RES-ERR'
              FLAGI(I)=' '
            endif
c           write (*,*) '---zvv=',i,iResFlag,'[',TITLE(I),']',FLAGI(I)
          endif
        enddo
c??     I2=ICOMN+N1
c??     IDATN=I2
      endif
c     write (*,*) '---zvv-',i1,i2,('[',TITLE(I),']',FLAGI(I),I=I1,I2)
c---zvv---2009.09.09
C-----INITIALIZE FIELD 7-8 DEFINITION TO BLANK.
      DO I=1,I2
        TITLE4(I)=BLANK4
      END DO
C-----INITIALIZE FLAGS TO INDICATE ALL INPUT FIELDS NOT YET REQUIRED OR
C-----TRANSLATED.
      DO I=1,IDATN
        IMUSED(I)=0
      END DO
C
C     DETERMINE THIS IS A MULTI-DIMENSIONAL TABLE = ONE REACTION BUT
C     MULTIPLE FLAGS IN COMMON SECTION. FOR THIS CASE DEFINE MULTIPLE
C     REACTIONS ALL OF WHICH ARE IDENTICAL AND DIFFER ONLY BY FLAG.
C
      IF(KSANR.GT.1.OR.ICOMN.LE.0) GO TO 140
      KSANR=0
      DO 130 I=1,ICOMN
C-----CHECK FOR NEW NON-BLANK FLAG IN COMMON.
      IF(FLAGI(I).EQ.BLANK) GO TO 130
      IF(KSANR.EQ.0) GO TO 110
      DO 100 J=1,KSANR
      IF(FLAGI(I).EQ.FLAGR(J)) GO TO 130
  100 CONTINUE
C-----NEW FLAG. CREATE SAME REACTION WITH NEW FLAG BY INCREASING
C-----REACTION COUNT AND DEFINING FLAG, ZA, MF, MT, REACTION OPERATION.
  110 KSANR=KSANR+1
      FLAGR(KSANR)=FLAGI(I)
      KZANRS(KSANR)=KZANRS(1)
      DO K=1,7
        ZAN(K,KSANR)=ZAN(K,1)
        ZANRES(K,KSANR)=ZANRES(K,1)
      END DO
      INPART(KSANR)=INPART(1)
      MFR(KSANR)=MFR(1)
      MTR(KSANR)=MTR(1)
      IRFLAG(KSANR)=IRFLAG(1)
  130 CONTINUE
      IF(KSANR.EQ.0) KSANR=1
C-----PRINT WARNING FOR MULTI-DIMENSIONAL TABLES.
  140 IF(KSANR.GT.1) WRITE(OUTP,6010)
C
C     CHECK FOR LEGAL TARGET ZA (ALL CHARACTERS BLANK OR DIGIT).
C     IF ILLEGAL  CHARACTERS FOUND PRINT WARNING BUT DO NOT CHANGE.
C
      DO 170 ISANR=1,KSANR
      IBADZA=0
      DO 160 M=1,6
      ZANOK(M)=ZAN(M,ISANR)
      IF(ZAN(M,ISANR).EQ.BLANK) GO TO 160
      DO 150 K=1,10
      IF(ZAN(M,ISANR).EQ.DIGITS(K)) GO TO 160
  150 CONTINUE
      IBADZA=1
      ZAN(M,ISANR)=DIGITS(1)
  160 CONTINUE
      ZANOK(7)=ZAN(7,ISANR)
      IF(IBADZA.NE.0) WRITE(OUTP,6055) ZANOK,(ZAN(M,ISANR),M=1,7)
  170 CONTINUE
C
C     PERFORM ALL OPERATIONS THAT APPLY TO ENTIRE DATA TABLE.
C
C-----DEFINE VECTORS TO PERMUTE DATA COLUMNS INTO OUTPUT ORDER FOR ALL
C-----REACTIONS.
      CALL TITLEX
C-----PERFORM TITLE OPERATIONS THAT APPLY TO ALL POINTS IN TABLE.
      CALL TOPS1
C-----DEFINE UNIT CONVERSION FACTORS AND OPERATIONS.
      CALL UNIT1
C-----SAVE NUMBER OF DATA COLUMNS (MAY BE MORE THAN THE NUMBER OF
C-----COLUMN READ DUE TO CREATION OF COLUMNS).
      IDAT1=IDATN
C-----INCREMENT COUNT OF POINTS READ.
      MPOINT(3)=MPOINT(3)+N2*KSANR
C-----INITIALIZE BLANK DATA FIELD COUNT.
      NODATA=0
C-----INITIALIZE BLANK INCIDENT ENERGY FIELD COUNT.
      NOEIN=0
C-----INITIALIZE BLANK COSINE FIELD COUNT.
      NOMU=0
C-----INITIALIZE BLANK SECONDARY ENERGY FIELD COUNT.
      NOE2=0
C-----INITIALIZE L =0 LEGENDRE COEFFICIENT COUNT.
      LEGS=0
C-----SET UP LOOP TO READ DATA POINTS.
      DO 460 NPT=1,N2
      READ(ITAPE,1020,END=500,ERR=500) (DATUM(I),I=I1,I2)
C-----RESET FLAGS TO INDICATE THAT DATA JUST READ HAS NOT YET BEEN
C-----TRANSLATED.
      DO I=I1,I2
        IF(IMUSED(I).EQ.2) IMUSED(I)=1
      END DO
C
C     SET UP LOOP OVER REACTIONS.
C
      DO 450 ISANR=1,KSANR
C-----RE-DEFINE NUMBER OF DATA COLUMNS
      IDATN=IDAT1
C
C     PERFORM ALL OPERATIONS THAT MAY BE DIFFERENT FOR EACH DATA POINT.
C
C-----CONVERT FIELDS REQUIRED FOR OUTPUT FROM HOLLERITH TO FLOATING
C-----POINT AND FROM INPUT UNITS TO STANDARD UNITS.
      CALL UNIT2
C-----PERFORM UNIT OPERATIONS.
      CALL UNOPS
C-----PERFORM TITLE OPERATIONS.
      CALL TOPS2
C-----PERFORM REACTION OPERATIONS.
      CALL REOPS
C
C     CHECK DATA FIELD. IF NOT DEFINED NO OUTPUT. PRINT WARNING IF FIELD
C     IS NOT DEFINED OR BLANK.
C
      II=KMOUT(3,ISANR)
C-----PRINT WARNING IF DATA FIELD IS NOT DEFINED.
      IF(II.GT.0) GO TO 190
      IF(NPT.EQ.1) WRITE(OUTP,6020)
      MPOINT(5)=MPOINT(5)+1
      GO TO 450
C-----DATA FIELD IS DEFINED. SEE IF DATA FIELD IS BLANK (SKIP TEST IF
C-----DATA FIELD WAS CREATED).
  190 IF(II.GT.IDAT1) GO TO 210
      IF(DATUM(II).NE.BLANK11) GO TO 210
C-----PRINT WARNING WHEN FIRST BLANK DATA FIELD IS FOUND.
      IF(NODATA.EQ.0) WRITE(OUTP,6025)
      NODATA=1
      MPOINT(6)=MPOINT(6)+1
      GO TO 450
C
C     CHECK INCIDENT ENERGY FIELD. PRINT WARNING IF FIELD IS NOT DEFINED
C     OR BLANK.
C
  210 IEIN=KMOUT(1,ISANR)
C-----PRINT WARNING IF INCIDENT ENERGY FIELD IS NOT DEFINED.
      IF(IEIN.GT.0) GO TO 220
      IF(NPT.EQ.1) WRITE(OUTP,6140)
      GO TO 240
C-----INCIDENT ENERGY FIELD IS DEFINED. SEE IF FIELD IS BLANK (SKIP
C-----TEST IF FIELD WAS CREATED).
  220 IF(IEIN.GT.IDAT1) GO TO 240
      IF(NOEIN.GT.0) GO TO 240
      IF(DATUM(IEIN).NE.BLANK11) GO TO 240
C-----PRINT WARNING WHEN FIRST BLANK INCIDENT ENERGY FIELD IS FOUND.
      WRITE(OUTP,6150)
      NOEIN=1
C
C     FOR ANGULAR AND DOUBLE DIFFERENTIAL DISTRIBUTION CHECK COSINE
C     FIELD, FOR LEGENDRE COEFFICIENTS CHECK LEGENDRE ORDER FIELD.
C     PRINT WARNING IF FIELD IS NOT DEFINED OR BLANK.
C
  240 IF(MFR(ISANR).NE.4.AND.MFR(ISANR).NE.6.AND.MFR(ISANR).NE.154)
     1 GO TO 270
      IMU=KMOUT(5,ISANR)
C-----PRINT WARNING IF FIELD IS NOT DEFINED.
      IF(IMU.GT.0) GO TO 250
      IF(NPT.EQ.1) WRITE(OUTP,6160)
      GO TO 270
C-----FIELD IS DEFINED. SEE IF FIELD IS BLANK (SKIP TEST IF FIELD WAS
C-----CREATED).
  250 IF(IMU.GT.IDAT1) GO TO 270
      IF(NOMU.GT.0) GO TO 270
      IF(DATUM(IMU).NE.BLANK11) GO TO 270
C-----PRINT WARNING WHEN FIRST BLANK FIELD IS FOUND.
      WRITE(OUTP,6170)
      NOMU=1
C
C     FOR ENERGY AND DOUBLE DIFFERENTIAL DISTRIBUTION CHECK SECONDARY
C     ENERGY FIELD. PRINT WARNING IF FIELD IS NOT DEFINED OR BLANK.
C
  270 IF(MFR(ISANR).NE.5.AND.MFR(ISANR).NE.6) GO TO 300
      IE2=KMOUT(7,ISANR)
C-----PRINT WARNING IF FIELD IS NOT DEFINED.
      IF(IE2.GT.0) GO TO 280
      IF(NPT.EQ.1) WRITE(OUTP,6180)
      GO TO 300
C-----FIELD IS DEFINED. SEE IF FIELD IS BLANK (SKIP TEST IF FIELD WAS
C-----CREATED).
  280 IF(IE2.GT.IDAT1) GO TO 300
      IF(NOE2.GT.0) GO TO 300
      IF(DATUM(IE2).NE.BLANK11) GO TO 300
C-----PRINT WARNING WHEN FIRST BLANK FIELD IS FOUND.
      WRITE(OUTP,6190)
      NOE2=1
C
C     INITIALIZE OUTPUT FIELDS AND THEN FILL IN ALL REQUIRED OUTPUT.
C
  300 DO J=1,8
        OUTLIN(J)=BLANK9
      END DO
C-----INITIALIZE DEFINITION OF FIELD 7-8.
      IM78=BLANK4
      DO 340 I=1,8
      II=KMOUT(I,ISANR)
C-----SKIP UNUSED FIELDS AND ZERO ERROR FIELDS.
      IF(II.LE.0) GO TO 340
      OVALUE=VALUES(II)
C---zvv+++2009.09.09
      if (ovalue.gt.1.e37) then
        print *,'WARNING ovalue overflow',ovalue
        ovalue=1.e37
      end if
C---zvv---2009.09.09
C-----ON FIRST POINT PRINT WARNING MESSAGE IF L = 0 LEGENDRE COEFFICIENT
C-----IS NOT NORMALIZED TO UNITY.
      IF(MFR(ISANR).NE.154.OR.LEGS.GT.0.OR.I.NE.5) GO TO 320
      IF(ABS(OVALUE).GT.0.001) GO TO 320
      LEGS=1
      LEG1=KMOUT(3,ISANR)
      IF(ABS(VALUES(LEG1)-1.0).GT.0.001) WRITE(OUTP,6120)
  320 IF(I.NE.2.AND.I.NE.4.AND.I.NE.6.AND.I.NE.8) GO TO 330
C-----INSURE THAT ALL ERRORS ARE NON-NEGATIVE.
      OVALUE=ABS(OVALUE)
      IF(OVALUE.LE.0.0) GO TO 340
C-----FORMAT DATA FOR OUTPUT.
  330 CALL NORMF(OVALUE,OUTLIN(I))
C-----IF REQUIRED SET DEFINITION OF FIELDS 7-8.
      IF(I.NE.7) GO TO 340
      IF(TITLE4(II).EQ.BLANK4) GO TO 340
      IF(IM78.EQ.TITLE4(II)) GO TO 340
      IF(NPT.EQ.1.AND.IM78.NE.BLANK4) WRITE(OUTP,6040)
      IM78=TITLE4(II)
      IF(NPT.EQ.1) WRITE(OUTP,6030) IM78
  340 CONTINUE
C
C     IF REQUIRED INSERT RESIDUAL NUCLEUS ZA (PRODUCTION) OR RATIO
C     DENOMINATOR MT AND MT. CHECK FOR ILLEGAL VALUES AND CONFLICTS.
C
C     PRODUCTION
C
      IF(KZANRS(ISANR).LE.0) GO TO 380
C-----ONLY PERFORM CHECKS AND PRINT MESSAGES FOR FIRST POINT.
      IF(NPT.GT.1) GO TO 370
C-----CHECK FOR LEGAL PRODUCT ZA (ALL CHARACTERS BLANK OR DIGIT).
      IBADZA=0
      DO 360 M=1,6
      ZANOK(M)=ZANRES(M,ISANR)
      IF(ZANRES(M,ISANR).EQ.BLANK) GO TO 360
      DO 350 K=1,10
      IF(ZANRES(M,ISANR).EQ.DIGITS(K)) GO TO 360
  350 CONTINUE
      IBADZA=1
      ZANRES(M,ISANR)=DIGITS(1)
  360 CONTINUE
      ZANOK(7)=ZANRES(7,ISANR)
      IF(IBADZA.NE.0) WRITE(OUTP,6060) ZANOK,(ZANRAT(M,ISANR),M=1,7)
C-----CHECK FOR PRODUCTION REACTIONS (MT = 9000 - 9999).
      IF(MTR(ISANR).LT.9000) WRITE(OUTP,6080) (ZANRES(M,ISANR),M=1,7)
C-----INSERT RESIDUAL NUCLEUS IN THE SIXTH OUTPUT FIELD (NORMALLY USED
C-----FOR COSINE ERROR).
  370 CALL RESZA(OUTLIN(6),ZANRES(1,ISANR))
      GO TO 390
C-----NO PRODUCT ZA. PRINT WARNING IF MT = 9000 - 9999.
C 380 IF(NPT.EQ.1.AND.MTR(ISANR).GE.9000) WRITE(OUTP,6090)
  380 IF(MTR(ISANR).LT.9000) GO TO 390
      IF(NPT.GT.1) GO TO 382
      IPO=MTR(ISANR)
      IPO=IPO-1000*(IPO/1000)
      MTR(ISANR)=MTR(ISANR)-IPO
      IPO=IPO+1
      IF(IPO.GT.8) IPO=8
      WRITE(OUTP,6090) (ZAPO(J,IPO),J=1,6)
  382 CALL RESZA(OUTLIN(6),ZAPO(1,IPO))
C
C     RATIO
C
  390 IF(MTRAT(ISANR).LE.0) GO TO 430
C-----ONLY PERFORM CHECKS AND PRINT MESSAGES FOR FIRST POINT.
      IF(NPT.GT.1) GO TO 420
C-----CHECK FOR LEGAL RATIO ZA (ALL CHARACTERS BLANK OR DIGIT).
      IBADZA=0
      DO 410 M=1,6
      ZANOK(M)=ZANRAT(M,ISANR)
      IF(ZANRAT(M,ISANR).EQ.BLANK) GO TO 410
      DO 400 K=1,10
      IF(ZANRAT(M,ISANR).EQ.DIGITS(K)) GO TO 410
  400 CONTINUE
      IBADZA=1
      ZANRAT(M,ISANR)=DIGITS(1)
  410 CONTINUE
      ZANOK(7)=ZANRAT(7,ISANR)
      IF(IBADZA.NE.0) WRITE(OUTP,6110) ZANOK,(ZANRAT(M,ISANR),M=1,7)
C-----CHECK FOR RATIO (MF = 203).
      IF(MFR(ISANR).NE.203) WRITE(OUTP,6050) (ZANRAT(M,ISANR),M=1,7),
     1 MTRAT(ISANR)
C-----CHECK FOR CONFLICT (RATIO OF PRODUCTIONS).
      IF(MTR(ISANR).GE.9000.OR.MTRAT(ISANR).GE.9000) WRITE(OUTP,6070)
C-----INSERT RATIO MT IN FIFTH FIELD AND ZA IN SIXTH OUTPUT FIELD
C-----(NORMALLY USED FOR COSINE AND COSINE ERROR).
  420 CALL RATZA(OUTLIN(5),OUTLIN(6),MTRAT(ISANR),ZANRAT(1,ISANR))
      GO TO 440
C-----NO RATIO ZA/MT. PRINT WARNING IF MF = 203.
  430 IF(NPT.EQ.1.AND.MFR(ISANR).EQ.203) WRITE(OUTP,6100)
C-----IF LEVEL ENERGY UNDEFINED FOR MT 51 CHANGE TO MT 4
  440 IF(MTR(ISANR).EQ.51 .AND. OUTLIN(7).EQ.BLANK9) MTR(ISANR)=4
c-----------------------------------------------------------------------
c
c     PRINT C4.DAT DATA POINT
c
c-----------------------------------------------------------------------
      WRITE(OTAPE,1100) INPART(ISANR),(ZAN(I,ISANR),I=1,7),MFR(ISANR),
     1 MTR(ISANR),ZANRES(7,ISANR),STATN,LABCM(ISANR),OUTLIN,IM78,
     1 AUTHK,ENT,ISAN,FLAGR(ISANR)
 1100 FORMAT(I5,7A1,I3,I4,3A1,8A9,A3,25A1,5A1,I3,A1)
c-----------------------------------------------------------------------
c
c     PLOTTAB.PNT ouput
c
c-----------------------------------------------------------------------
c-----only output MF=3 cross sections
      if(MFR(ISANR).ne.3) go to 449
      if(ISANR.eq.ISANRNOW.and.    ! same AM/SAN/Author
     1   ENT5 .eq.ENTNOW  .and.
     1 AUTH25 .eq.AUTHNOW) go to 446
c-----New Table
      if(AUTHNOW.ne.'    ') write(16,1620)  ! END preceding
 1620 format(66x,' (blank line)')
c-----Title to PLOTTAB.PNT
      write(16,1600) AUTH25,ENT,ISAN
c-----Title on-line
      write(* ,1600) AUTH25,ENT,ISAN
 1600 format(A25,5A1,i3)
      ISANRNOW= ISANR
      ENTNOW  = ENT5
      AUTHNOW = AUTH25
c-----Next point
  446 write(16,1610) OUTLIN(1),OUTLIN(2),OUTLIN(2),
     1               OUTLIN(3),OUTLIN(4),OUTLIN(4)
 1610 format(6(2x,a9))
  449 continue              ! skip PLOTTAB.PNT output
      MPOINT(4)=MPOINT(4)+1
  450 CONTINUE
  460 CONTINUE
C-----PRINT WARNING IF ANY LEGENDRE COEFFICIENTS AND L =0 COEFFICIENTS
C-----ARE NOT GIVEN.
      IF(LEGS.GT.0) GO TO 490
      DO 470 I=1,KSANR
      IF(MFR(I).EQ.154) GO TO 480
  470 CONTINUE
      GO TO 490
  480 WRITE(OUTP,6130)
C
C     TABLE COMPLETED. NORMAL RETURN.
C
  490 RETURN
C
C     ERROR READING EXFOR DATA. PRINT ERROR MESSAGE AND TERMINATE.
C
  500 WRITE(OUTP,6000)
      CALL EXIT
 1000 FORMAT(6(2A4,A3),14A1)
 1010 FORMAT(6(A10,A1))
 1020 FORMAT(6A11)
 6000 FORMAT(10X,'ERROR READING EXFOR DATA...EXECUTION TERMINATED')
 6010 FORMAT(10X,'WARNING.....MULTI-DIMENSIONAL DATA TABLE')
 6020 FORMAT(10X,'WARNING.....DATA IS NOT DEFINED. DATA POINT IGNORED')
 6025 FORMAT(10X,'WARNING.....DATA FIELD IS BLANK. DATA POINT IGNORED')
 6030 FORMAT(10X,'OPERATION...SET FIELD 7-8 DEFINITION=',A3)
 6040 FORMAT(10X,'WARNING.....CONFLICTING DEFINITIONS OF FIELDS 7-8')
 6050 FORMAT(10X,'WARNING.....RATIO DENOMINATOR ZA/MT=',7A1,'/',I5/
     1       10X,'            (EXPECT MF = 203)')
 6055 FORMAT(10X,'WARNING.....NON-NUMERIC TARGET  ZA =',7A1/
     1       10X,'                   CONVERTED TO ZA =',7A1/
     2       10X,'            YOU MUST CORRECT TRANSLATED DATA TO',
     3 ' DEFINE SPECIAL ZA.'/
     4       10X,'            SEE ENDF/B SPECIAL ZA DICTIONARY')
 6060 FORMAT(10X,'WARNING.....NON-NUMERIC PRODUCT ZA =',7A1/
     1       10X,'                   CONVERTED TO ZA =',7A1/
     2       10X,'IMPORTANT...YOU MUST CORRECT TRANSLATED DATA TO',
     3 ' DEFINE SPECIAL ZA.'/
     4       10X,'            SEE ENDF/B SPECIAL ZA DICTIONARY')
 6070 FORMAT(10X,'WARNING.....RATIO OF PRODUCTION DATA. WILL DEFINE'/
     1       10X,'            MT AND ZA OF DENOMINATOR IN FIELD 5 AND'/
     2       10X,'            6. CANNOT DEFINE ZA OF PRODUCTS.'/
     3       10X,'            CHECK AND CORRECT OUTPUT.')
 6080 FORMAT(10X,'WARNING.....PRODUCT ZA =',7A1,
     1 ' (EXPECT MT = 9000 - 9999)')
C6090 FORMAT(10X,'WARNING.....EXPECT PRODUCT ZA FOR MT=9000-9999')
 6090 FORMAT(10X,'WARNING.....EXPECT PRODUCT ZA FOR MT=9000-9999'/
     1       10X,'            SET DEFAULT ',6A1,'.9')
 6100 FORMAT(10X,'WARNING.....EXPECT RATIO ZA/MT FOR MF = 203')
 6110 FORMAT(10X,'WARNING.....RATIO ZA =',7A1,' CONVERTED TO'/
     1       10X,'                  ZA =',7A1)
 6120 FORMAT(10X,'WARNING.....L = 0 LEGENDRE COEFFICIENTS ARE NOT',
     1 ' NORMALIZED')
 6130 FORMAT(10X,'WARNING.....L = 0 LEGENDRE COEFFICIENTS ARE NOT',
     1 ' PRESENT')
 6140 FORMAT(10X,'WARNING.....INCIDENT ENERGY IS NOT DEFINED')
 6150 FORMAT(10X,'WARNING.....INCIDENT ENERGY FIELD IS BLANK')
 6160 FORMAT(10X,'WARNING.....COSINE OR LEGENDRE ORDER IS NOT DEFINED')
 6170 FORMAT(10X,'WARNING.....COSINE OR LEGENDRE ORDER FIELD IS BLANK')
 6180 FORMAT(10X,'WARNING.....SECONDARY ENERGY IS NOT DEFINED')
 6190 FORMAT(10X,'WARNING.....SECONDARY ENERGY FIELD IS BLANK')
      END
      SUBROUTINE RESZA(OUT1,ZANRES)
C
C     DEFINE RESIDUAL NUCLEUS IN OUTPUT FIELD.
C
      CHARACTER*1 OUT1,ZANRES,BLANK,DOT
      DIMENSION OUT1(9),ZANRES(7),METAB1(10),METAB2(10)
      DATA BLANK/' '/
      DATA DOT/'.'/
      OUT1(1)=BLANK
      DO I=1,6
        OUT1(I+1)=ZANRES(I)
      END DO
      OUT1(8)=DOT
C-----DEFINE PRODUCT METASTABLE STATE FLAG EQUIVALENT AND OUTPUT IN
C-----COLUMN 9.
      CALL META10(OUT1(9),ZANRES(7))
      RETURN
      END
      SUBROUTINE RATZA(OUT1,OUT2,MTIN,ZANRAT)
C
C     DEFINE RATIO MT IN FIELD 7 AND RATIO ZA IN FIELD 8.
C
      CHARACTER*1 OUT1,OUT2,ZANRAT,BLANK,DOT,DIGITS
      DIMENSION OUT1(9),OUT2(9),ZANRAT(14),MULT(4),DIGITS(10)
      DATA BLANK/' '/
      DATA DOT/'.'/
      DATA MULT/1,10,100,1000/
      DATA DIGITS/'0','1','2','3','4','5','6','7','8','9'/
      MT=MTIN
C-----INITIALIZE FIRST WORD TO BLANK FOLLOWED BY DECIMAL POINT.
      DO I=1,7
        OUT1(I)=BLANK
      END DO
      OUT1(8)=DOT
C-----OUTPUT MT IN FIRST WORD (CHARACTERS 4 THROUGH 7).
      J=4
      IF(MT.LT.1000) J=3
      IF(MT.LT.100) J=2
      IF(MT.LT.10) J=1
      MULTMT=MULT(J)
      II=8-J
      DO I=1,J
        IDIG=MT/MULTMT
        OUT1(II)=DIGITS(IDIG+1)
        MT=MT-IDIG*MULTMT
        MULTMT=MULTMT/10
        II=II+1
      END DO
C-----DEFINE PRODUCT METASTABLE STATE FLAG EQUIVALENT AND OUTPUT IN
C-----COLUMN 9.
      CALL META10(OUT1(9),ZANRAT(14))
C-----OUTPUT ZA IN SECOND WORD.
      OUT2(1)=BLANK
      DO I=1,6
        OUT2(I+1)=ZANRAT(I)
      END DO
      OUT2(8)=DOT
C-----DEFINE ZA METASTABLE STATE FLAG EQUIVALENT AND OUTPUT IN
C-----COLUMN 9.
      CALL META10(OUT2(9),ZANRAT(7))
      RETURN
      END
      SUBROUTINE META10(OUT,MSTATE)
C
C     DEFINE NUMERICAL EQUIVALENT OF METASTABLE STATE FLAG FOR OUTPUT
C     WITH ZA OR MT.
C
      CHARACTER*1 OUT,MSTATE,MTAB1,MTAB2
      DIMENSION MTAB1(11),MTAB2(11)
      DATA MTAB1/
     1 'G','1','2','3','4','5','?','M','+','T',' '/
      DATA MTAB2/
     1 '0','1','2','3','4','5','6','7','8','9','9'/
C-----LOOK UP METASTABLE STATE CHARACTER.
      DO I=1,11
        IF(MSTATE.EQ.MTAB1(I)) GO TO 20
      END DO
C-----SET INDEX TO UNKNOWN.
      I=7
   20 OUT=MTAB2(I)
      RETURN
      END
      SUBROUTINE NORMF(X,FIELD)
C
C     CONVERT FLOATING POINT NUMBER TO A STRING OF 9 CHARACTERS FOR
C     OUTPUT. NUMBERS BETWEEN 0.01 AND 9999999. WILL BE FORMATTED IN
C     F FORMAT. ALL OTHER NUMBERS WILL BE FORMATTED IN E FORMAT.
C
      CHARACTER*1 MINUS,FIELD,DIGITS,BLANK,ZERO,DOT
      DOUBLE PRECISION ZMULT,QMULT,XNORM,XIN,XABS,XZERO
      DIMENSION FIELD(9),DIGITS(10),ZERO(9),ZMULT(11),QMULT(11),IMULT(6)
      DATA DIGITS/'0','1','2','3','4','5','6','7','8','9'/
      DATA ZERO/' ','0','.','0','0','0','0','0','0'/
      DATA MINUS/'-'/
      DATA BLANK/' '/
      DATA DOT/'.'/
      DATA IMULT/100,1000,10000,100000,1000000,10000000/
      DATA ZMULT/1.0D-3,1.0D-2,1.0D-1,1.0D+0,1.0D+1,1.0D+2,1.0D+3,
     1 1.0D+4,1.0D+5,1.0D+6,1.0D+7/
      DATA QMULT/1.0D-8,1.0D-7,1.0D-6,1.0D-5,1.0D-4,1.0D-3,1.0D-2,
     1 1.0D-1,1.0D+0,1.0D+1,1.0D+2/
      DATA XZERO/0.0D+0/
C-----IF NUMBER IS ZERO RETURN STANDARD FORM.
      XIN=X
      XABS=DABS(XIN)
      IF(XABS.GT.XZERO) GO TO 20
      DO I=1,9
        FIELD(I)=ZERO(I)
      END DO
      RETURN
C-----IF NUMBER OUT OF RANGE USE E FORMAT.
   20 IF(XABS.LT.ZMULT(2).OR.XABS.GE.ZMULT(11)) GO TO 110
C-----DEFINE EXPONENT TO NORMALIZE MANTISSA.
      DO 30 IEXP=1,11
C-----IF CLOSE TO ONE DECADE SET EQUAL TO ONE DECADE.
      IF(DABS(XABS-ZMULT(IEXP)).LE.QMULT(IEXP)) XABS=ZMULT(IEXP)
      IF(XABS.LT.ZMULT(IEXP)) GO TO 40
   30 CONTINUE
      GO TO 110
C-----PRECEDING VALUE WILL NORMALIZE NUMBER.
   40 IEXP=IEXP-1
C-----DEFINE EXPONENT TO PUT NUMBER IN NORMAL FORM N.NNNN...
      KEXP=IEXP-4
C-----INITIALIZE OUTPUT FIELD.
      DO I=1,9
        FIELD(I)=BLANK
      END DO
C-----IF NUMBER IS NEGATIVE SET SIGN.
      IF(X.LT.0.0) FIELD(1)=MINUS
C-----DEFINE NORMALIZED INTEGER.
      KEXPAB=IABS(KEXP)
      IF(KEXPAB.LE.0) KEXP=0
      KMULT=5
      IF(KEXP.LT.0) KMULT=5+KEXP
      XNORM=ZMULT(KMULT+6)*XABS/ZMULT(IEXP)
      INORM=XNORM
      INORM=(INORM+5)/10
      KNORM=1000000
C-----TRY TO AVOID LAST DIGIT ROUND-OFF.
      IF(INORM.LT.KNORM) GO TO 70
      LNORM=INORM-1000*(INORM/1000)
C-----IF LAST 3 DIGITS ARE LESS THAN 005 ROUND DOWN.
      IF(LNORM.GT.5) GO TO 60
      INORM=10*(INORM/10)
      GO TO 70
C-----IF LAST 3 DIGITS ARE GREATER THAN 995 ROUND UP.
   60 IF(LNORM.LT.995) GO TO 70
      INORM=1000*(INORM/1000)+1000
C-----INSURE NUMBER IS IN NORMALIZED FORM (I.E., ALLOW FOR ROUND-OFF).
   70 IF(INORM.GE.IMULT(KMULT)) GO TO 80
      INORM=IMULT(KMULT)
      GO TO 90
   80 IF(INORM.LT.IMULT(KMULT+1)) GO TO 90
      INORM=IMULT(KMULT+1)
      KEXP=KEXP+1
C-----DEFINE POSITION OF DECIMAL POINT AND INSERT IT.
   90 IPOINT=3
      IF(KEXP.GT.0) IPOINT=KEXP+3
      IF(IPOINT.GT.9) GO TO 110
      FIELD(IPOINT)=DOT
C-----CONVERT TO CHARACTERS AND INSERT INTO OUTPUT FIELD
      DO 100 I=2,9
C-----SKIP DECIMAL POINT LOCATION.
      IF(I.EQ.IPOINT) GO TO 100
      IDIG=INORM/KNORM
      FIELD(I)=DIGITS(IDIG+1)
      INORM=INORM-IDIG*KNORM
      KNORM=KNORM/10
  100 CONTINUE
      RETURN
C-----NUMBER IS OUT OF RANGE. USE E FORMATTED OUTPUT.
  110 CALL NORME(X,FIELD)
      RETURN
      END
      SUBROUTINE NORME(X,FIELD)
C
C     CONVERT FLOATING POINT NUMBER TO CHARACTER STRING FOR E9.3
C     OUTPUT. OUTPUT WILL BE IN THE FORM X.XXX+/-NN OR X.XXXX+/-N
C     (IF EXPONENT IS LESS THAN 10) WHICH GIVES 1 OR 2 MORE DIGITS
C     OF ACCURACY COMPARED TO NORMAL FORTRAN OUTPUT.
C
      CHARACTER*1 PLUS,MINUS,FIELD,DIGITS,BLANK,ZERO,DOT
      DIMENSION FIELD(9),DIGITS(10),ZERO(9)
      DATA DIGITS/'0','1','2','3','4','5','6','7','8','9'/
      DATA ZERO/' ','0','.','0','0','0','0','+','0'/
      DATA PLUS/'+'/
      DATA MINUS/'-'/
      DATA BLANK/' '/
      DATA DOT/'.'/
C-----IF NUMBER IS ZERO RETURN STANDARD FORM.
      XABS=ABS(X)
      IF(XABS.GT.0.0) GO TO 20
      DO I=1,9
        FIELD(I)=ZERO(I)
      END DO
      RETURN
C-----INITIALIZE OUTPUT FIELD.
   20 DO I=1,9
        FIELD(I)=BLANK
      END DO
C-----IF NUMBER IS NEGATIVE INSERT LEADING MINUS SIGN.
      IF(X.LT.0.0) FIELD(1)=MINUS
C-----INSERT DECIMAL POINT.
      FIELD(3)=DOT
C-----DEFINE EXPONENT TO NORMALIZE MANTISSA.
      KEXP=ALOG10(XABS)
      SHIFT=10.0**KEXP
      XNORM=XABS/SHIFT+0.000051
C-----DEFINE NORMALIZAED MANTISSA.
      IF(XNORM.GE.1.0) GO TO 40
      KEXP=KEXP-1
      SHIFT=SHIFT/10.0
      XNORM=XABS/SHIFT+0.000051
      GO TO 50
   40 IF(XNORM.LT.10.0) GO TO 50
      KEXP=KEXP+1
      SHIFT=10.0*SHIFT
      XNORM=XABS/SHIFT+0.000051
C-----SELECT X.XXX+/-NN OR X.XXXX+/-N FORMAT (DEPENDING ON SIZE OF
C-----EXPONENT).
   50 KEXPAB=IABS(KEXP)
      IF(KEXPAB.LE.0) KEXP=0
      IF(KEXPAB.LT.10) GO TO 60
C-----X.XXX+/-NN FORMAT.
      ITOP=6
      INORM=1000.0*XNORM
      KNORM=1000
      IDIG=KEXPAB/10
      FIELD(8)=DIGITS(IDIG+1)
      KEXPAB=KEXPAB-IDIG*10
      GO TO 70
C-----X.XXXX+/-N FORMAT.
   60 ITOP=7
      INORM=10000.0*XNORM
      KNORM=10000
   70 FIELD(9)=DIGITS(KEXPAB+1)
C-----DEFINE SIGN OF EXPONENT.
      IF(KEXP.LT.0) FIELD(ITOP+1)=MINUS
      IF(KEXP.GE.0) FIELD(ITOP+1)=PLUS
C-----CONVERT TO CHARACTERS AND INSERT INTO OUTPUT FIELD
      DO 80 I=2,ITOP
C-----SKIP DECIMAL POINT LOCATION.
      IF(I.EQ.3) GO TO 80
      IDIG=INORM/KNORM
      FIELD(I)=DIGITS(IDIG+1)
      INORM=INORM-IDIG*KNORM
      KNORM=KNORM/10
   80 CONTINUE
      RETURN
      END
      SUBROUTINE MFMTIN(NTAPE1)
C
C     READ EQUIVALENCE TABLE FOR REACTION VS. MF/MT
C
C     COLUMNS
C     -------
C      1- 48    REACTION
C     49- 53    INCIDENT PARTICLE ZA
C     54- 56    MF
C     57- 60    MT
C
      INTEGER OUTP,OTAPE
      CHARACTER*4 R2MFMT,DUMMY,DUMMY2
      CHARACTER*1 FLAG,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/MFMTI1/IMFMT
      COMMON/MFMTI2/MFMTAB(7,11111)
      COMMON/MFMTC/R2MFMT(12,11111)
      DIMENSION DUMMY(8)
      DATA MAXIE/11111/
      DATA BLANK/' '/
C-----READ ENTIRE FILE. SKIP CARDS WITH NON-BLANK COLUMN 80.
      DO 20 IMFMT=1,MAXIE
   10 READ(NTAPE1,1000,END=60,ERR=50) (R2MFMT(J,IMFMT),J=1,12),
     1 DUMMY,FLAG
      IF(FLAG.NE.BLANK) GO TO 10
      CALL INTGER(DUMMY(1),MFMTAB(1,IMFMT),5)
      CALL INTGER(DUMMY(3),MFMTAB(2,IMFMT),3)
      CALL INTGER(DUMMY(4),MFMTAB(3,IMFMT),4)
      CALL INTGER(DUMMY(5),MFMTAB(4,IMFMT),3)
      CALL INTGER(DUMMY(6),MFMTAB(5,IMFMT),3)
      CALL INTGER(DUMMY(7),MFMTAB(6,IMFMT),3)
      CALL INTGER(DUMMY(8),MFMTAB(7,IMFMT),3)
   20 CONTINUE
      IMFMT=MAXIE
   30 IMFMT=IMFMT+1
   40 READ(NTAPE1,1000,END=60,ERR=50) (DUMMY2,J=1,12),
     1 DUMMY,FLAG
      IF(FLAG.NE.BLANK) GO TO 40
      GO TO 30
   50 WRITE(OUTP,6000)
      CALL EXIT
   60 IMFMT=IMFMT-1
      WRITE(OUTP,6010) IMFMT,MAXIE
      IF(IMFMT.LE.MAXIE) RETURN
      WRITE(OUTP,6020)
      IMFMT=MAXIE
      RETURN
 1000 FORMAT(12A4,A4,A1,A3,A4,4A3,7X,A1)
 6000 FORMAT(' ERROR READING REACTION TABLE...EXECUTION TERMINATED')
 6010 FORMAT(' REACTIONS------------',I5,' (',I5,' ALLOWED)')
 6020 FORMAT(' WARNING...ONLY FIRST ',I5,' REACTIONS USED')
      END
      SUBROUTINE TITLEI(NTAPE2)
C
C     READ COLUMN HEADING VS. MF/FIELDS.
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 TITTAB
      CHARACTER*4  TITTAB4,DUMMY,DUMMY2
      CHARACTER*1 FLAG,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/TITTBI/ITITLE,MFTITL(11111),MFTITH(11111),IFIELD(11111),
     1 ITFLAG(11111)
      COMMON/TITTBC/TITTAB(11111),TITTAB4(11111)
      DIMENSION DUMMY(7)
      DATA BLANK/' '/
      DATA MAXIE/11111/
C-----READ ENTIRE FILE. SKIP CARDS WITH NON-BLANK COLUMN 80.
      DO 20 ITITLE=1,MAXIE
   10 READ(NTAPE2,1000,END=60,ERR=50) TITTAB(ITITLE),
     1 DUMMY,TITTAB4(ITITLE),FLAG
      IF(FLAG.NE.BLANK) GO TO 10
      CALL INTGER(DUMMY(1),MFTITL(ITITLE),4)
      CALL INTGER(DUMMY(2),MFTITH(ITITLE),5)
      CALL INTGER(DUMMY(4),IFIELD(ITITLE),5)
      IF(IFIELD(ITITLE).LT.0.OR.IFIELD(ITITLE).GT.8) IFIELD(ITITLE)=0
      CALL INTGER(DUMMY(6),ITFLAG(ITITLE),5)
   20 CONTINUE
      ITITLE=MAXIE
   30 ITITLE=ITITLE+1
   40 READ(NTAPE2,1000,END=60,ERR=50) (DUMMY2,J=1,3),
     1 DUMMY,DUMMY2,FLAG
      IF(FLAG.NE.BLANK) GO TO 40
      GO TO 30
   50 WRITE(OUTP,6000)
      CALL EXIT
   60 ITITLE=ITITLE-1
      WRITE(OUTP,6010) ITITLE,MAXIE
      IF(ITITLE.LE.MAXIE) RETURN
      WRITE(OUTP,6020) MAXIE
      ITITLE=MAXIE
      RETURN
 1000 FORMAT(A11,A4,A4,A1,A4,A1,A4,A1,2X,A3,44X,A1)
 6000 FORMAT(' ERROR READING TITLE TABLE...EXECUTION TERMINATED')
 6010 FORMAT(' TITLES---------------',I5,' (',I5,' ALLOWED)')
 6020 FORMAT(' WARNING...ONLY FIRST ',I5,' TITLES USED')
      END
      SUBROUTINE UNITI(NTAPE3)
C
C     READ COLUMN UNITS, STANDARD UNITS AND CONVERSION FACTORS
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 UNITAB,DUMMY,DUMMY2
      CHARACTER*1 FLAG,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/UNITBI/IUNIT,TIMES(11111),ADD(11111),IUFLAG(11111)
      COMMON/UNITBC/UNITAB(2,11111)
      DIMENSION DUMMY(3)
      DATA BLANK/' '/
      DATA MAXIE/11111/
C-----READ ENTIRE FILE. SKIP CARDS WITH NON-BLANK COLUMN 80.
      DO 20 IUNIT=1,MAXIE
   10 READ(NTAPE3,1000,END=60,ERR=50) (UNITAB(J,IUNIT),J=1,2),
     1 DUMMY,FLAG
      IF(FLAG.NE.BLANK) GO TO 10
      CALL FLOATF(DUMMY(1),TIMES(IUNIT))
      CALL FLOATF(DUMMY(2),ADD(IUNIT))
      CALL INTGER(DUMMY(3),IUFLAG(IUNIT),11)
   20 CONTINUE
      IUNIT=MAXIE
   30 IUNIT=IUNIT+1
   40 READ(NTAPE3,1000,END=60,ERR=50) (DUMMY2,J=1,2),
     1 DUMMY,FLAG
      IF(FLAG.NE.BLANK) GO TO 40
      GO TO 30
   50 WRITE(OUTP,6000)
      CALL EXIT
   60 IUNIT=IUNIT-1
      WRITE(OUTP,6010) IUNIT,MAXIE
      IF(IUNIT.LE.MAXIE) RETURN
      WRITE(OUTP,6020) MAXIE
      IUNIT=MAXIE
      RETURN
 1000 FORMAT(5(A11),24X,A1)
 6000 FORMAT(' ERROR READING UNITS TABLE...EXECUTION TERMINATED')
 6010 FORMAT(' UNITS----------------',I5,' (',I5,' ALLOWED)')
 6020 FORMAT(' WARNING...ONLY FIRST ',I5,' UNITS USED')
      END
      SUBROUTINE MFMTX(REACT,INPART,MF,MT,IRFLAG,KNOWN)
C
C     DEFINE MF/MT EQUIVALENT OF SIMPLE REACTION.
C
      INTEGER OUTP,OTAPE
      CHARACTER*4 R2MFMT,REACT
      CHARACTER*1 FLAG,BLANK,ENT,SUBENT
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/RESIDI/KZARES
      COMMON/MFMTI1/IMFMT
      COMMON/MFMTI2/MFMTAB(7,11111)
      COMMON/MFMTC/R2MFMT(12,11111)
      COMMON/POINTR/MPOINT(9)
      DIMENSION REACT(15)
      DO 20 I=1,IMFMT
      DO 10 J=1,12
      IF(REACT(J).NE.R2MFMT(J,I)) GO TO 20
   10 CONTINUE
      GO TO 30
   20 CONTINUE
C
C     REACTION IS NOT DEFINED. WRITE REACTION TO NEWX4 FILE.
C
      INPART=0
      MF=0
      MT=0
      IRFLAG=0
      KZARES=0
      KNOWN=0
      WRITE(NEWX4,4000) ENT,ISAN,REACT
      MPOINT(7)=MPOINT(7)+1
      RETURN
C
C     REACTION IS DEFINED.
C
   30 INPART=MFMTAB(1,I)
      MF=MFMTAB(2,I)
      MT=MFMTAB(3,I)
      IRFLAG=MFMTAB(4,I)
      KNOWN=1
C-----ONLY CONSIDER RESIDUAL NUCLEUS FOR PRODUCTION CROSS SECTIONS AND
C-----ANGULAR DISTRIBUTIONS (MF=3 OR MF=4) AND MT=9000-9999.
      IF(MF.NE.3.AND.MF.NE.4) KZARES=0
      IF(MT.LT.9000) KZARES=0
      RETURN
 4000 FORMAT(1X,5A1,I3,1X,15A4)
      END
      SUBROUTINE TITLEX
C
C     USE REACTION DEFINED MF TO PERMUTE DATA COLUMNS INTO OUTPUT ORDER
C     FOR ALL REACTIONS.
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 TITLE,UNIT,DATUM,TITTAB
      CHARACTER*4  TITLE4,TITTAB4
      CHARACTER*1 FLAGI,FLAGR,ZAN,BLANK ,ENT,SUBENT,LABCM,ZANRES,ZANRAT
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/TITTBI/ITITLE,MFTITL(11111),MFTITH(11111),IFIELD(11111),
     1 ITFLAG(11111)
      COMMON/TITTBC/TITTAB(11111),TITTAB4(11111)
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADC2/FLAGI(50)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/ZATNC1/FLAGR(30),ZAN(7,30),ZANRES(7,30),ZANRAT(14,30),
     1 LABCM(30)
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      COMMON/POINTR/MPOINT(9)
      DATA BLANK/' '/
C-----SET UP LOOP OVER REACTIONS.
      IF(KSANR.LE.0) RETURN
      DO 100 ISANR=1,KSANR
C-----INITIALIZE OUTPUT FIELD VECTORS.
      DO K=1,10
        DO I=1,8
          IMOUT(I,ISANR,K)=0
        END DO
      END DO
C-----SELECT COLUMNS WITH COLUMN 11 BLANK OR SAME AS REACTION HAS IN
C-----COLUMN 11.
      DO 90 KIN=1,IDATN
      IF(FLAGI(KIN).EQ.BLANK) GO TO 30
      IF(FLAGI(KIN).NE.FLAGR(ISANR)) GO TO 90
C-----SELECT TITLES FROM TABLE FOR WHICH MF RANGE SPANS MF OF REACTION.
   30 DO 50 KTAB=1,ITITLE
      IF(MFR(ISANR).LT.MFTITL(KTAB).OR.
     1 MFR(ISANR).GT.MFTITH(KTAB)) GO TO 50
      IF(TITLE(KIN).NE.TITTAB(KTAB)) GO TO 50
      GO TO 60
   50 CONTINUE
C
C     TITLE IS NOT DEFINED. WRITE TITLE TO NEWX4 FILE.
C
      WRITE(NEWX4,4000) ENT,ISAN,TITLE(KIN)
      MPOINT(8)=MPOINT(8)+1
      GO TO 90
C
C     TITLE IS DEFINED. DEFINE POSITION OF OUTPUT FIELD (SKIP IF
C     NOT USED IN OUTPUT).
C
   60 KOUT=IFIELD(KTAB)
      IF(KOUT.LE.0) GO TO 90
C-----DEFINE FIELDS 7-8.
      TITLE4(KIN)=TITTAB4(KTAB)
C-----SAVE INPUT FIELD INDEX IN NEXT AVAILABLE OUTPUT FIELD LOCATION.
      DO 70 JMULT=1,10
      IF(IMOUT(KOUT,ISANR,JMULT).LE.0) GO TO 80
   70 CONTINUE
      JMULT=10
   80 IMOUT(KOUT,ISANR,JMULT)=KIN
C-----DEFINE TITLE OPERATION FLAG FOR INPUT COLUMN.
      KTFLGX(KIN)=ITFLAG(KTAB)
C-----INDICATE INPUT FIELD USED (TO FORCE HOLLERITH TO FLOATING POINT
C-----TRANSLATION).
      IMUSED(KIN)=1
   90 CONTINUE
  100 CONTINUE
      RETURN
 4000 FORMAT(1X,5A1,I3,1X,A10)
      END
      SUBROUTINE TOPS1
C
C     PERFORM TITLE OPERATIONS THAT APPLY TO ENTIRE TABLE,
C     (1) SET CENTER-OF-MASS FLAG.
C     (2) DEFINE -MIN OR -MAX TO CREATE A PAIR (CREATE -MIN= 0,
C         OR -MAX = 15 MEV).
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 TITLE,UNIT,DATUM,EV,LIMITS,TITLE2,TITLE3
      CHARACTER*4  TITLE4
      CHARACTER*1  FLAGI,FLAGR,ZAN,ENT,SUBENT,LABCM,CENTER
     &            ,ZANRES,ZANRAT,BLANK
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/TITTBI/ITITLE,MFTITL(11111),MFTITH(11111),IFIELD(11111),
     1 ITFLAG(11111)
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADC2/FLAGI(50)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/ZATNC1/FLAGR(30),ZAN(7,30),ZANRES(7,30),ZANRAT(14,30),
     1 LABCM(30)
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      COMMON/POINTR/MPOINT(9)
      DIMENSION LIMITS(2)
      DATA CENTER/'C'/
      DATA BLANK/' '/
      DATA EV/'EV         '/
      DATA LIMITS/
     1 ' 0.0       ',' 1.50000+ 7'/
      KDATN=IDATN
      DO 110 ISANR=1,KSANR
C-----INITIALIZE SYSTEM FLAG TO BLANK.
      LABCM(ISANR)=BLANK
      DO 100 KFIELD=1,8
      DO 90 KMULT=1,10
      KIN=IMOUT(KFIELD,ISANR,KMULT)
      IF(KIN.LE.0) GO TO 100
C-----ONLY CONSIDER FIELDS THAT ARE REQUIRED FOR OUTPUT.
      IF(IMUSED(KIN).LE.0) GO TO 90
C-----IF REQUESTED SET CENTER-OF-MASS SYSTEM FLAG.
      IF(KTFLGX(KIN).NE.6) GO TO 10
      LABCM(ISANR)=CENTER
      WRITE(OUTP,6030)
      GO TO 90
C-----SEE IF -MIN AND -MAX MUST APPEAR IN PAIR.
   10 IF(KTFLGX(KIN).NE.9) GO TO 90
C-----DECODE TITLE TO DEFINE COMPLEMENTARY TITLE AND WHETHER TITLE
C-----ENDS IN -MIN, -MAX OR OTHER (ERROR).
      CALL IPAIR(TITLE(KIN),TITLE2,IWAY)
      IF(IWAY.GT.0) GO TO 20
C-----ERROR. TITLE DOES NOT END IN -MIN OR -MAX.
      WRITE(OUTP,6000) TITLE(KIN),FLAGI(KIN)
      GO TO 90
C-----TITLE ENDS IN -MIN OR -MAX. SCAN REMAINING TITLES FOR OTHER
C-----LIMIT AND SAME TITLE FLAG.
   20 JIN=KIN+1
      IF(JIN.GT.KDATN) GO TO 70
      DO 60 K=JIN,KDATN
      IF(IMUSED(K).LE.0.OR.KTFLGX(K).NE.9) GO TO 60
      IF(FLAGI(K).NE.FLAGI(KIN)) GO TO 60
      CALL IPAIR(TITLE(K),TITLE3,KWAY)
      IF(KWAY.EQ.0) GO TO 60
      IF(IWAY.NE.KWAY) GO TO 40
C-----POSSIBLE MULTIPLE SAME LIMIT. CHECK FOR SAME TITLE.
      IF(TITLE(KIN).NE.TITLE3) GO TO 90
      WRITE(OUTP,6010) TITLE(KIN),FLAGI(KIN)
      GO TO 90
C-----SEE IF RECONSTRUCTED TITLE TITLE IS SAME AS ORIGINAL
C-----(E.G., AVOID ASUMMING EN-MIN AND E-MAX ARE A PAIR).
   40 IF(TITLE(KIN).NE.TITLE3) GO TO 60
C-----LIMITS ARE PAIRED.
      GO TO 90
   60 CONTINUE
C-----LIMITS ARE NOT PAIRED. CREATE DATA POINT.
   70 IDATN=IDATN+1
      KWAY=3-IWAY
      TITLE(IDATN)=TITLE2
      DATUM(IDATN)=LIMITS(KWAY)
      UNIT(IDATN)=EV
      FLAGI(IDATN)=FLAGI(KIN)
      IMUSED(IDATN)=1
      WRITE(OUTP,6020) TITLE(IDATN),FLAGI(IDATN),
     1 DATUM(IDATN),UNIT(IDATN)
C-----SET INDEX TO OUTPUT CREATED LIMIT NEXT TO EXISTING LIMIT.
      IF(IWAY.EQ.1) IMOUT(KFIELD+1,ISANR,KMULT)=IDATN
      IF(IWAY.EQ.2) IMOUT(KFIELD-1,ISANR,KMULT)=IDATN
   90 CONTINUE
  100 CONTINUE
  110 CONTINUE
      RETURN
 6000 FORMAT(10X,'WARNING.....CHECK -MIN/-MAX FLAG FOR ',A10,A1)
 6010 FORMAT(10X,'WARNING.....MULTIPLE -MIN/-MAX FIELDS ',A10,A1)
 6020 FORMAT(10X,'OPERATION...CREATED ',A10,A1,1X,A11,1X,A11)
 6030 FORMAT(10X,'OPERATION...CENTER-OF-MASS SYSTEM FLAG SET')
      END
      SUBROUTINE IPAIR(TITLE1,TITLE2,IWAY)
C
C     SEARCH TITLE1 FOR ENDING OF -MIN OR -MAX.
C     IF FOUND, CREATE TITLE2 TO BE OTHER LIMIT.
C
      CHARACTER*1 TITLE1,TITLE2,MINMAX,BLANK
      DIMENSION TITLE1(10),TITLE2(10),MINMAX(4,2)
      DATA MINMAX/
     1 '-','M','I','N',
     2 '-','M','A','X'/
      DATA BLANK/' '/
C-----FIND LAST NON-BLANK CHARACTER.
      II=11
      DO I=1,10
        II=II-1
        IF(TITLE1(II).NE.BLANK) GO TO 20
      END DO
      GO TO 50
C-----SEARCH FOR -MIN OR -MAX.
   20 DO 40 IWAY=1,2
      JJ=4
      KK=II
      DO 30 J=1,4
      IF(TITLE1(KK).NE.MINMAX(JJ,IWAY)) GO TO 40
      JJ=JJ-1
   30 KK=KK-1
      GO TO 60
   40 CONTINUE
C----- -MIN/-MAX NOT FOUND.
   50 IWAY=0
      RETURN
C----- -MIN/-MAX FOUND. DEFINE COMPLEMENTARY TITLE.
   60 II=II-4
      KWAY=3-IWAY
      DO I=1,II
        TITLE2(I)=TITLE1(I)
      END DO
      DO I=1,4
        II=II+1
        TITLE2(II)=MINMAX(I,KWAY)
      END DO
      IF(II.GE.11) GO TO 100
      II=II+1
      DO I=II,11
        TITLE2(I)=BLANK
      END DO
  100 RETURN
      END
      SUBROUTINE UNIT1
C
C     DEFINE UNIT CONVERSION FACTORS AND OPERATIONS.
C
      INTEGER      OUTP,OTAPE
      CHARACTER*11 UNITAB,TITLE,UNIT,DATUM
      CHARACTER*4  TITLE4
      CHARACTER*1  ENT,SUBENT,STAT1,STATN,UNNORM
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/UNITBI/IUNIT,TIMES(11111),ADD(11111),IUFLAG(11111)
      COMMON/UNITBC/UNITAB(2,11111)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      COMMON/STATUC/STAT1,STATN
      COMMON/POINTR/MPOINT(9)
      DATA UNNORM/'U'/
C
C     ONLY CONSIDER FIELDS THAT ARE REQUIRED FOR OUTPUT.
C
      DO 30 I=1,IDATN
      IF(IMUSED(I).LE.0) GO TO 30
C-----DETERMINE CONVERSION FACTOR FOR UNITS.
      DO 20 J=1,IUNIT
      IF(UNIT(I).NE.UNITAB(1,J)) GO TO 20
C-----TITLE IS DEFINED. DEFINE MULTIPLIER, ADDER AND UNIT OPERATION.
      TIMEX(I)=TIMES(J)
      ADDX(I)=ADD(J)
      KUFLGX(I)=IUFLAG(J)
C-----IF REQUESTED PRINT WARNING MESSAGE.
      IF(IUFLAG(J).EQ.7) WRITE(OUTP,6000) UNIT(I)
      IF(IUFLAG(J).NE.8) GO TO 30
      WRITE(OUTP,6010) UNIT(I)
      STATN=UNNORM
      GO TO 30
   20 CONTINUE
C
C     UNITS IS NOT DEFINED. WRITE TITLE TO NEWX4 FILE.
C
      TIMEX(I)=0.0
      ADDX(I)=0.0
      KUFLGX(I)=0
      WRITE(NEWX4,4000) ENT,ISAN,UNIT(I)
      MPOINT(9)=MPOINT(9)+1
   30 CONTINUE
      RETURN
 4000 FORMAT(1X,5A1,I3,1X,A10)
 6000 FORMAT(10X,'WARNING.....UNITS=',A11)
 6010 FORMAT(10X,'WARNING.....UNITS=',A11,' STATUS CHANGED TO',
     1 ' UNNORMALIZED (U)')
      END
      SUBROUTINE UNIT2
C
C     TRANSLATE FIELDS TO STANDARD UNITS.
C
      CHARACTER*11 TITLE,UNITAB,UNIT,DATUM
      CHARACTER*4  TITLE4
      CHARACTER*1  ENT,SUBENT
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/WHERE/ENT(5),SUBENT(3)
      COMMON/UNITBI/IUNIT,TIMES(11111),ADD(11111),IUFLAG(11111)
      COMMON/UNITBC/UNITAB(2,11111)
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/RNOW/ISANR
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      COMMON/INVAL/VALUEI(50)
C
C     ONLY TRANSLATE FIELDS THAT ARE REQUIRED FOR OUTPUT.
C
      DO 40 KFIELD=1,8
      DO 30 KMULT=1,10
      II=IMOUT(KFIELD,ISANR,KMULT)
      IF(II.EQ.0) GO TO 40
      IF(IMUSED(II)-1) 40,10,20
C-----CONVERT DATA FROM HOLLERITH TO FLOATING POINT.
   10 CALL FLOATF(DATUM(II),VALUEI(II))
      IMUSED(II)=2
C-----APPLY CONVERSION FACTORS.
   20 VALUES(II)=TIMEX(II)*VALUEI(II)+ADDX(II)
   30 CONTINUE
   40 CONTINUE
      RETURN
      END
      SUBROUTINE UNOPS
C
C     APPLY UNIT CONVERSION OPTIONS,
C
C     (1) PER-CENT TO ABSOLUTE
C     (2) ANGLE TO COSINE (ANGLE OR ANGULAR ERROR)
C     (3) RESOLUTION (E.G. NSEC/M) TO ENERGY ERROR (EV).
C     (4) ANGSTROM TO EV.
C     (5) LENGTH (CM OR FERMI) TO AREA (BARNS)
C     (6) BARNS*SQRT(E) TO BARNS
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 UNITAB,TITLE,UNIT,DATUM
      CHARACTER*4  TITLE4
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/UNITBI/IUNIT,TIMES(11111),ADD(11111),IUFLAG(11111)
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/RNOW/ISANR
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/UNITBC/UNITAB(2,11111)
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      DIMENSION KUFLG1(50)
      DATA PI/3.141597/
      DATA RES2EV/2.77E-5/
C-----DEFINE UNIT OPERATIONS FOR INTERNAL USE.
      DO I=1,IDATN
        KUFLG1(I)=KUFLGX(I)
      END DO
C-----SET UP LOOP OVER OUTPUT FIELDS.
      DO 140 KFIELD=1,8
C-----SET UP LOOP OVER EXFOR FIELDS MAPPED INTO OUTPUT FIELD.
      DO 130 JMULT=1,10
C-----DETERMINE IF OUTPUT FIELD IS USED, AND IF SO WHEATHER OR NOT
C-----TO PERFORM AN OPERATION ON IT.
      II=IMOUT(KFIELD,ISANR,JMULT)
      IF(II.LE.0) GO TO 140
      IF(KUFLG1(II).LE.0) GO TO 140
C
C     PERFORM PER-CENT TO ABSOLUTE CONVERSION.
C
C     TO CONVERT FROM PER-CENT TO ABSOLUTE MULTIPLY THE OUTPUT FIELD
C     BY 0.01 TIMES THE PRECEDING OUTPUT FIELD (THIS WILL WORK FOR
C     ENERGY FOLLOWED BY ENERGY ERROR, DATA FOLLOWED BY DATA ERROR,ETC.)
C
      IF(KUFLG1(II).NE.1) GO TO 30
      JJ=IMOUT(KFIELD-1,ISANR,1)
      IF(JJ.GT.0) GO TO 20
      IF(NPT.EQ.1) WRITE(OUTP,6000)
      VALUES(II)=0.0
      GO TO 120
   20 VALUES(II)=ABS(0.01*VALUES(II)*VALUES(JJ))
      IF(NPT.EQ.1) WRITE(OUTP,6040)
      GO TO 120
C
C     PERFORM ANGLE TO COSINE CONVERSION.
C
   30 IF(KUFLG1(II).NE.2) GO TO 60
      IF(KFIELD.EQ.5) GO TO 50
C
C     CONVERT ANGULAR RESOLUTION TO COSINE RESOLUTION.
C
C     DEFINE COSINE RESOLUTION TO BE,
C
C     DMU = ABS(COS(ANGLE+DANGLE)-COS(ANGLE))+
C           ABS(COS(ANGLE-DANGLE)-COS(ANGLE)))/2.0
C
      JJ=IMOUT(KFIELD-1,ISANR,1)
      IF(JJ.GT.0) GO TO 40
      IF(NPT.EQ.1) WRITE(OUTP,6010)
      VALUES(II)=0.0
      GO TO 120
   40 XMU=VALUES(JJ)
      IF(ABS(XMU).GT.1) THEN
        ANG=XMU*PI/180
        WRITE(OUTP,6051)
      ELSE
        ANG=ACOS(XMU)
      END IF
      DANG=PI*VALUES(II)/180.0
      DMUP=COS(ANG+DANG)
      DMUM=COS(ANG-DANG)
      VALUES(II)=0.5*(ABS(DMUP-XMU)+ABS(DMUM-XMU))
      IF(NPT.EQ.1) WRITE(OUTP,6055)
      GO TO 120
C-----CONVERT ANGLE TO COSINE.
   50 VALUES(II)=COS(PI*VALUES(II)/180.0)
C-----ADJUST FOR EXACTLY 90 DEGREES (COSINE MAY DIFFER SLIGHTLY FROM
C-----ZERO DUE TO APPROXIMATION OF PI TO ACCURACY OF COMPUTER).
      IF(ABS(VALUES(II)).LT.0.00005) VALUES(II)=0.0
      IF(NPT.EQ.1) WRITE(OUTP,6050)
      GO TO 120
C
C     PERFORM RESOLUTION (E.G. NSEC/M) TO ENERGY ERROR (EV).
C
   60 IF(KUFLG1(II).NE.3) GO TO 80
      JJ=IMOUT(1,ISANR,1)
      IF(JJ.GT.0) GO TO 70
      IF(NPT.EQ.1) WRITE(OUTP,6020)
      VALUES(II)=0.0
      GO TO 120
   70 XE=VALUES(JJ)
      VALUES(II)=RES2EV*VALUES(II)*XE*SQRT(XE)
      IF(NPT.EQ.1) WRITE(OUTP,6060)
      GO TO 120
C
C     PERFORM ANGSTROM TO EV CONVERSION.
C
   80 IF(KUFLG1(II).NE.4) GO TO 90
      XE=VALUES(II)
      IF(XE.LE.0.0) GO TO 130
      VALUES(II)=(0.08180)/(XE*XE)
      IF(NPT.EQ.1) WRITE(OUTP,6070)
      GO TO 120
C
C     PERFORM LENGTH (CM OR FERMI) TO AREA (BARNS) CONVERSION.
C
   90 IF(KUFLG1(II).NE.5) GO TO 100
      VALUES(II)=4.0*PI*VALUES(II)*VALUES(II)
      IF(NPT.EQ.1) WRITE(OUTP,6080)
      GO TO 120
C
C     PERFORM BARNS*SQRT(E) TO BARNS CONVERSION.
C
  100 IF(KUFLG1(II).NE.6) GO TO 112
      JJ=IMOUT(1,ISANR,1)
      IF(JJ.GT.0) GO TO 110
      IF(NPT.EQ.1) WRITE(OUTP,6030)
      VALUES(II)=0.0
      GO TO 120
  110 XE=VALUES(JJ)
      IF(XE.LE.0.0) GO TO 130
      VALUES(II)=VALUES(II)/SQRT(XE)
      IF(NPT.EQ.1) WRITE(OUTP,6090)
      GO TO 120
C
C
C     PERFORM ENERGY/ATOMIC-MASS TO ENERGY CONVERSION.
C
  112 IF(KUFLG1(II).NE.9) GO TO 130
      IF(NPT.EQ.1) WRITE(OUTP,6095)
      VALUES(II)=VALUES(II)*MOD(INPART(ISANR),1000)
      GO TO 120
C
C     TURN OFF FLAG TO INSURE OPERATION IS ONLY PERFORMED ONCE ON EACH
C     INPUT VALUE.
C
  120 KUFLG1(II)=0
  130 CONTINUE
  140 CONTINUE
      CONTINUE
      RETURN
 6000 FORMAT(10X,'WARNING.....CANNOT CONVERT PER-CENT TO ABSOLUTE'/
     1 10X,'REQUIRED PRECEDING DATA FIELD NOT DEFINED')
 6010 FORMAT(10X,'WARNING.....CANNOT CONVERT ANGLE TO COSINE ERROR'/
     1 10X,'REQUIRED COSINE FIELD NOT DEFINED')
 6020 FORMAT(10X,'WARNING.....CANNOT CONVERT RESOLUTION TO ERROR'/
     1 10X,'REQUIRED ENERGY FIELD NOT DEFINED')
 6030 FORMAT(10X,'WARNING.....CANNOT CONVERT BARNS*SQRT(E) TO BARNS'/
     1 10X,'REQUIRED ENERGY FIELD NOT DEFINED')
 6040 FORMAT(10X,'OPERATION...CONVERTED PER-CENT TO ABSOLUTE')
 6050 FORMAT(10X,'OPERATION...CONVERTED ANGLES TO COSINES')
 6051 FORMAT(10X,'WARNING...CANNOT CONVERT COSINE TO ANGLE'/
     1 10X,'|COSINE| > 1; ASSUMED ANGLE IS GIVEN')
 6055 FORMAT(10X,'OPERATION...CONVERTED ANGULAR ERROR TO COSINE ERROR')
 6060 FORMAT(10X,'OPERATION...CONVERTED RESOLUTION TO ERROR')
 6070 FORMAT(10X,'OPERATION...CONVERTED ANGSTROM TO ENERGY')
 6080 FORMAT(10X,'OPERATION...CONVERTED LENGTH TO BARNS')
 6090 FORMAT(10X,'OPERATION...CONVERTED BARNS*SQRT(E) TO BARNS')
 6095 FORMAT(10X,'OPERATION...CONVERT ENERGY/ATOMIC-MASS TO ENERGY')
      END
      SUBROUTINE TOPS2
C
C     RESOLVE MULTIPLE INPUT FIELDS MAPPED INTO A SINGLE OUTPUT FIELD.
C
      INTEGER OUTP,OTAPE
      CHARACTER*11 TITLE,UNIT,DATUM
      CHARACTER*4  TITLE4
      CHARACTER*1  FLAGI
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/RNOW/ISANR
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADC2/FLAGI(50)
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      DIMENSION KUFLG1(50)
      DATA PI/3.141597/
C-----INITIALIZE FIELD SKIP FLAG.
      ISKIP=0
C-----SET UP LOOP OVER OUTPUT FIELDS.
      DO 310 KFIELD=1,8
C-----CHECK FOR CURRENT FIELD DEFINED BY PRECEDING FIELD.
      IF(ISKIP.LE.0) GO TO 10
      ISKIP=0
      GO TO 310
C-----COUNT THE NUMBER OF INPUT FIELDS MAPPED INTO 1 OUTPUT FIELD.
   10 DO JMULT=1,10
        II=IMOUT(KFIELD,ISANR,JMULT)
        IF(II.LE.0) GO TO 30
C-----  OPERATION ABSOLUTE ON THE VALUES (IF REQUESTED)
        IF(KTFLGX(II).EQ.11) THEN
          VALUES(II)=ABS(VALUES(II))
          IF(NPT.EQ.1) WRITE(OUTP,6150) TITLE(II)
        END IF
C-----  OPERATION HALVE ON THE VALUES (IF REQUESTED)
        IF(KTFLGX(II).EQ.12) THEN
          VALUES(II)=VALUES(II)/2
          IF(NPT.EQ.1) WRITE(OUTP,6160) TITLE(II)
        END IF
      END DO
      JMULT=10
C
C     ATTEMPT TO RESOLVE MULTIPLE FIELD DEFINITION (IF ANY).
C
   30 IF(JMULT.LE.2) GO TO 290
      JMULT=JMULT-1
C-----ONLY PRINT MULTIPLE FIELD WARNING MESSAGE FOR FIRST POINT.
      IF(NPT.GT.1) GO TO 50
      WRITE(OUTP,6000)
      DO KMULT=1,JMULT
        JJ=IMOUT(KFIELD,ISANR,KMULT)
        WRITE(OUTP,6020) TITLE(JJ),FLAGI(JJ)
      END DO
C-----USE TITLE FLAG TO (1) ALWAYS CHOOSE.
   50 DO KMULT=1,JMULT
        JJ=IMOUT(KFIELD,ISANR,KMULT)
        IF(KTFLGX(JJ).EQ.1) GO TO 90
      END DO
C-----USE TITLE FLAG TO (2) CHOOSE FIRST (3) NEVER CHOOSE.
      KK=0
      DO 70 KMULT=1,JMULT
        JJ=IMOUT(KFIELD,ISANR,KMULT)
        IF(KTFLGX(JJ).EQ.2) GO TO 90
        IF(KTFLGX(JJ).EQ.3) GO TO 70
        KK=KK+1
        IMOUT(KFIELD,ISANR,KK)=IMOUT(KFIELD,ISANR,KMULT)
   70 CONTINUE
      JMULT=KK
C-----SET NEXT FIELD TO ZERO TO ELIMINATE ALL (3) NEVER CHOOSE FIELDS
C-----FOR ALL POINTS IN TABLE.
      IF(JMULT.LT.10) IMOUT(KFIELD,ISANR,JMULT+1)=0
      IF(JMULT-1) 80,90,100
C-----NO FIELDS LEFT. SET INDEX FOR NO OUTPUT.
   80 JJ=0
      IF(NPT.EQ.1) WRITE(OUTP,6090)
      GO TO 300
C-----IF (1) ALWAYS CHOOSE OR (2) CHOOSE FIRST FIELD OR ONLY ONE
C-----FIELD LEFT NO MORE CONFLICT FOR ALL POINTS IN TABLE.
   90 IMOUT(KFIELD,ISANR,1)=JJ
      IMOUT(KFIELD,ISANR,2)=0
      IF(NPT.EQ.1) WRITE(OUTP,6080) TITLE(JJ),FLAGI(JJ)
      GO TO 300
C-----SEE IF ALL REMAINING FIELDS HAVE THE SAME TITLE FLAG.
  100 JOPS=0
      DO 110 KMULT=1,JMULT
      JJ=IMOUT(KFIELD,ISANR,KMULT)
C-----ERROR IF USER DOES NOT SPECIFY HOW TO RESOLVE.
      IF(KTFLGX(JJ).LE.0) GO TO 260
      IF(JOPS.LE.0) JOPS=KTFLGX(JJ)
      IF(KTFLGX(JJ).NE.JOPS) GO TO 260
  110 CONTINUE
C-----SEE IF ALL REMAINING FIELDS SHOULD BE (4) USED TO SELECT LARGEST
C-----(5) COMBINE QUADRATICALLY.
      IF(JOPS.GT.5) GO TO 140
      IF(NPT.EQ.1.AND.JOPS.EQ.4) WRITE(OUTP,6100)
      IF(NPT.EQ.1.AND.JOPS.EQ.5) WRITE(OUTP,6110)
C-----CHOOSE LARGEST OR COMBINE QUADRATICALLY.
      DXDX=0.0
      DO 130 KMULT=1,JMULT
      II=IMOUT(KFIELD,ISANR,KMULT)
      DX=ABS(VALUES(II))
      DXDX=DXDX+DX*DX
      IF(KMULT.EQ.1) GO TO 120
      IF(DX.LE.DXMAX) GO TO 130
  120 JJ=II
      DXMAX=DX
  130 CONTINUE
C-----SELECT LARGEST OR QUADRATIC COMBINATION.
      IF(JOPS.EQ.4) GO TO 300
      DX=SQRT(DXDX)
      IDATN=IDATN+1
      VALUES(IDATN)=DX
      JJ=IDATN
C-----SAVE DEFINITION OF FIELDS 7-8.
      IF(KFIELD.NE.7) GO TO 300
      II=IMOUT(KFIELD,ISANR,1)
      TITLE4(IDATN)=TITLE4(II)
      GO TO 300
C-----SEE IF DATA ARE TO BE COMBINED TO DEFINE AVERAGE AND SPREAD.
  140 IF(JOPS.EQ.7) GO TO 150
      IF(JOPS.GT.8) GO TO 190
C-----CANNOT COMBINE FIELDS TO DEFINE AVERAGE AND ERROR IF CURRENT
C-----OUTPUT FIELD IS 8 (I.E. NO OUTPUT FIELD 9) OR IF THE NEXT FIELD
C-----IS ALREADY USED.
      KFP1=KFIELD+1
C-----EXCEPTION FOR INCIDENT ENERGY - OVERWRITE UNCERTAINTY FIELD
      IF(KFIELD.GT.1. OR.IMOUT(KFP1,ISANR,1).LE.0) GO TO 142
      IF(IMOUT(KFP1,ISANR,1).GT.0) WRITE(OUTP,6042) KFP1
      IMOUT(KFP1,ISANR,1)=0
  142 IF(KFIELD.LT.8.AND.IMOUT(KFP1,ISANR,1).LE.0) GO TO 150
      IF(NPT.GT.1) GO TO 290
      IF(KFIELD.EQ.8) WRITE(OUTP,6030) KFIELD
      IF(IMOUT(KFP1,ISANR,1).GT.0) WRITE(OUTP,6040) KFIELD,KFP1
      GO TO 270
C-----COMBINE FIELDS TO DEFINE AVERAGE.
  150 IF(NPT.EQ.1.AND.JOPS.EQ.7) WRITE(OUTP,6120)
      IF(NPT.EQ.1.AND.JOPS.EQ.8) WRITE(OUTP,6130)
      ZJMULT=JMULT
      AVER=0.0
      DO 160 KMULT=1,JMULT
      II=IMOUT(KFIELD,ISANR,KMULT)
  160 AVER=AVER+VALUES(II)
      AVER=AVER/ZJMULT
      IDATN=IDATN+1
      VALUES(IDATN)=AVER
      KMOUT(KFIELD,ISANR)=IDATN
C-----SAVE DEFINITION OF FIELDS 7-8.
      IF(KFIELD.NE.7) GO TO 170
      II=IMOUT(KFIELD,ISANR,1)
      TITLE4(IDATN)=TITLE4(II)
  170 IF(JOPS.EQ.7) GO TO 310
C-----DEFINE COMBINED ERROR.
      ERRAV=0.0
      DO 180 KMULT=1,JMULT
      II=IMOUT(KFIELD,ISANR,KMULT)
  180 ERRAV=ERRAV+ABS(VALUES(II)-AVER)
      ERRAV=ERRAV/ZJMULT
      IDATN=IDATN+1
      VALUES(IDATN)=ERRAV
      KMOUT(KFIELD+1,ISANR)=IDATN
C-----SET FLAG TO SKIP NEXT FIELD (ERROR FIELD ALREADY DEFINED).
      ISKIP=1
      GO TO 310
C-----SELECT SMALLEST AND LARGEST IN 2 SUCCESSIVE FIELDS.
  190 IF(JOPS.NE.10) GO TO 260
C-----CANNOT SELECT SMALLEST AND LARGEST IF CURRENT OUTPUT FIELD IS
C-----8 (I.E. NO OUTPUT FIELD 9) OR IF THE NEXT FIELD IS ALREADY USED.
      IF(KFIELD.LT.8.AND.IMOUT(KFIELD+1,ISANR,1).LE.0) GO TO 200
      IF(NPT.GT.1) GO TO 290
      KFP1=KFIELD+1
      IF(KFIELD.EQ.8) WRITE(OUTP,6060) KFIELD
      IF(IMOUT(KFP1,ISANR,1).GT.1) WRITE(OUTP,6070) KFIELD,KFP1
      GO TO 270
C-----SELECT SMALLEST AND LARGEST IN 2 SUCCESSIVE FIELDS.
  200 IF(NPT.EQ.1) WRITE(OUTP,6140)
      JL=IMOUT(KFIELD,ISANR,1)
      JH=JL
      DO 250 KMULT=1,JMULT
      II=IMOUT(KFIELD,ISANR,KMULT)
      DX=ABS(VALUES(II))
C-----SKIP ZERO ENTRIES
      IF(DX.EQ.0) GO TO 250
      IF(KMULT.EQ.1) GO TO 210
      IF(DX-DXMIN) 220,230,230
  210 JH=II
      DXMAX=DX
  220 JL=II
      DXMIN=DX
  230 IF(DX-DXMAX) 250,250,240
  240 JH=II
      DXMAX=DX
  250 CONTINUE
C-----DEFINE INDICES TO SMALLEST AND LARGEST VALUES.
      KMOUT(KFIELD,ISANR)=JL
      KMOUT(KFIELD+1,ISANR)=JH
C-----SET FLAG TO SKIP NEXT FIELD (ERROR FIELD ALREADY DEFINED).
      ISKIP=1
      GO TO 310
C
C     CANNOT RESOLVE MULTIPLE FIELD DEFINITION. PRINT ERROR MESSAGE
C     WHEN PROCESSING FIRST POINT OF TABLE.
C
  260 IF(NPT.GT.1) GO TO 290
      WRITE(OUTP,6010) KFIELD
  270 WRITE(OUTP,6050)
      DO KMULT=1,JMULT
        JJ=IMOUT(KFIELD,ISANR,KMULT)
        WRITE(OUTP,6020) TITLE(JJ),FLAGI(JJ)
      END DO
C-----USE FIRST INPUT FIELD FOR OUTPUT.
  290 JJ=IMOUT(KFIELD,ISANR,1)
C-----DEFINE UNIQUE INPUT FIELD INDEX TO MAP INTO OUTPUT FIELD.
  300 KMOUT(KFIELD,ISANR)=JJ
  310 CONTINUE
      RETURN
 6000 FORMAT(10X,'WARNING.....CHECK MULTIPLE FIELD DEFINITION')
 6010 FORMAT(10X,'WARNING.....FIELD=',I2,' UNRESOLVED MULTIPLE FIELDS')
 6020 FORMAT(10X,A10,A1)
 6030 FORMAT(10X,'WARNING.....FIELD=',I2,' CANNOT COMBINE FIELDS TO',
     1       10X,'DEFINE AVERAGE FOLLOWED BY ERROR (NO FIELD 9)')
 6040 FORMAT(10X,'WARNING.....FIELD=',I2,' CANNOT COMBINE FIELDS TO',
     1       10X,'DEFINE AVERAGE FOLLOWED BY ERROR (FIELD=',I2,' USED)')
 6042 FORMAT(10X,'WARNING.....FIELD=',I2,' ALREADY USED - OVERWRITE')
 6050 FORMAT(10X,'WILL USE THE FIRST OF THE FOLLOWING COLUMN TITLES')
 6060 FORMAT(10X,'WARNING.....FIELD=',I2,' CANNOT SELECT LARGEST AND'/
     1 10X,'SMALLEST VALUES (NO FIELD 9)')
 6070 FORMAT(10X,'WARNING.....FIELD=',I2,' CANNOT SELECT LARGEST AND'/
     1 10X,'SMALLEST VALUES (FIELD=',I2,' USED)')
 6080 FORMAT(10X,'OPERATION...SELECTED ',A10,A1)
 6090 FORMAT(10X,'OPERATION...NO FIELD SELECTED (ALL NEVER OUTPUT)')
 6100 FORMAT(10X,'OPERATION...SELECTED LARGEST')
 6110 FORMAT(10X,'OPERATION...COMBINED FIELDS QUADRATICALLY')
 6120 FORMAT(10X,'OPERATION...DEFINED AVERAGE VALUE')
 6130 FORMAT(10X,'OPERATION...DEFINED AVERAGE VALUE AND ERROR')
 6140 FORMAT(10X,'OPERATION...SELECTED SMALLEST AND LARGEST VALUES')
 6150 FORMAT(10X,'OPERATION...ABSOLUTE',A11)
 6160 FORMAT(10X,'OPERATION...HALVE',A11)
      END
      SUBROUTINE REOPS
C
C     PERFORM REACTION DEFINED OPERATIONS.
C     (1) IF EN IS NOT DEFINED, DEFINE EN = 0.0253 EV
C     (2) IF EN IS NOT DEFINED, DEFINE EN = 2.0 MEV
C     (3) DATA = DATA/2 (DATA AND DATA ERROR)
C     (4) DATA = DATA/(2*L+1) (DATA AND DATA ERROR)
C     (5) DATA = DATA/F(0) (F(0)=ZEROTH ORDER LEGENDRE COEFFICIENT,
C                           DATA AND DATA ERROR).
C     (6) DATA = DATA/(F(0)*(2*L+1)) (DATA AND DATA ERROR)
C     (8) DATA =-LOG(DATA)/THICKNESS (CONVERT TRANSMISSION TO BARNS)
C     (9) DATA = DATA*RUTHERFORD (COULOMB) CROSS SECTION
C
      INTEGER      OUTP,OTAPE
      CHARACTER*11 TITLE,UNIT,DATUM
      CHARACTER*7  ZACH7
      CHARACTER*4  TITLE4
      CHARACTER*1  FLAGI,FLAGR,ZAN,LABCM,BLANK,ZANRES,ZANRAT
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      COMMON/ZATNI/KSAN1,KSANR,KZAN(30),INPART(30),MFR(30),MTR(30),
     1 IRFLAG(30),KZANRS(30),MTRAT(30)
      COMMON/RNOW/ISANR
      COMMON/HEADI/ICOM1,ICOMN,IDATN
      COMMON/CARDI/INKEY,N1,N2,ISAN,NPT
      COMMON/HEADC1/TITLE(50),TITLE4(50),UNIT(50),DATUM(50)
      COMMON/HEADC2/FLAGI(50)
      COMMON/OUTVEC/IMOUT(8,30,10),KMOUT(8,30)
      COMMON/ZATNC1/FLAGR(30),ZAN(7,30),ZANRES(7,30),ZANRAT(14,30),
     1 LABCM(30)
      COMMON/OUTVAL/IMUSED(50),VALUES(100),TIMEX(50),ADDX(50),
     1 KTFLGX(50),KUFLGX(50)
      DIMENSION EF(500),F(500)
      DATA BLANK/' '/
      DATA ETHERM/2.53E-02/
      DATA EFISS/2.0E+06/
C-----NOTHING TO DO IF NO OPERATION DEFINED.
      IF(IRFLAG(ISANR).LE.0) GO TO 110
C-----RESET ENERGY COUNT ON FIRST POINT.
      IF(ISANR.EQ.1.AND.NPT.EQ.1) IEF=0
C
C     CHECK FOR CREATION OF AVERAGE ENERGY (THERMAL OR FISSION).
C
      IF(IRFLAG(ISANR).GT.2) GO TO 10
C-----DEFINE LOCATION OF ENERGY FIELD. NOTHING TO DO IF ENERGY IS
C-----DEFINED.
      II=KMOUT(1,ISANR)
      IF(II.GT.0) GO TO 110
C-----CREATE AVERAGE ENERGY (THERMAL OR FISSION).
      IF(IRFLAG(ISANR).EQ.1) EX=ETHERM
      IF(IRFLAG(ISANR).EQ.2) EX=EFISS
      IDATN=IDATN+1
      KMOUT(1,ISANR)=IDATN
      VALUES(IDATN)=EX
      IF(NPT.EQ.1) WRITE(OUTP,6000) EX
      GO TO 110
C
C     CHECK FOR RENORMALIZATION OF DATA AND DATA ERROR.
C
C-----DEFINE LOCATION OF DATA FIELD. NOTHING TO DO IF DATA FIELD IS
C-----NOT DEFINED.
   10 II=KMOUT(3,ISANR)
      IF(II.LE.0) GO TO 110
      IF(IRFLAG(ISANR).NE.3) GO TO 20
C-----DEFINE DATA = DATA/2
      IF(NPT.EQ.1) WRITE(OUTP,6020)
      VALUES(II)=VALUES(II)/2.0
      II=KMOUT(4,ISANR)
      IF(II.LE.0) GO TO 110
      VALUES(II)=VALUES(II)/2.0
      GO TO 110
C***** CULLEN
C  20 IF(IRFLAG(ISANR).GT.6) GO TO 110
C***** CULLEN
C***** TRKOV
   20 IF(IRFLAG(ISANR).GT.6) GO TO 120
C***** TRKOV
C
C     RENORMALIZE LEGENDRE COEFFICIENTS.
C
C-----DEFINE INDEX TO LEGENDRE ORDER. IF NOT DEFINED TURN OFF FLAG.
      JJ=KMOUT(5,ISANR)
      IF(JJ.GT.0) GO TO 30
      IRFLAG(ISANR)=0
      WRITE(OUTP,6010)
      GO TO 110
C-----DEFINE LEGENDRE ORDER.
   30 ORDERL=VALUES(JJ)
C-----IF NOT NORMALIZED TO F(0) PERFORM NORMALIZATION.
      IF(IRFLAG(ISANR).EQ.4) GO TO 90
C-----SAVE F(0) AT ALL INCIDENT ENERGIES.
C-----DEFINE INDEX TO ENERGY. IF NOT DEFINED TURN OFF FLAG.
      KK=KMOUT(1,ISANR)
      IF(KK.GT.0) GO TO 40
      IRFLAG(ISANR)=0
      WRITE(OUTP,6060)
      GO TO 110
C-----SAVE ZEROTH ORDER ENERGY AND COEFFICIENT.
   40 ENOW=VALUES(KK)
      LORDER=ORDERL
      IF(LORDER.NE.0) GO TO 50
      IF(IEF.LT.500) IEF=IEF+1
      EF(IEF)=ENOW
      F(IEF)=VALUES(II)
C-----LOOK UP ZEROTH ORDER COEFFICIENT IN ENERGY TABLE.
   50 IF(IEF.LE.0) GO TO 70
      DO 60 M=1,IEF
      IF(ABS(ENOW-EF(IEF)).LE.0.00001*EF(IEF)) GO TO 80
   60 CONTINUE
   70 WRITE(OUTP,6070) ENOW
      GO TO 110
C-----DEFINE NORMALIZATION.
   80 IF(IRFLAG(ISANR).EQ.5) ZNORM=F(M)
      IF(IRFLAG(ISANR).EQ.6) ZNORM=F(M)*(2.0*ORDERL+1.0)
      IF(NPT.EQ.1.AND.IRFLAG(ISANR).EQ.5) WRITE(OUTP,6040)
      IF(NPT.EQ.1.AND.IRFLAG(ISANR).EQ.6) WRITE(OUTP,6050)
      GO TO 100
C-----DEFINE NORMALIZATION.
   90 ZNORM=2.0*ORDERL+1.0
      IF(NPT.EQ.1) WRITE(OUTP,6030)
C-----RE-NORMALIZE DATA.
  100 VALUES(II)=VALUES(II)/ZNORM
      II=KMOUT(4,ISANR)
      IF(II.LE.0) GO TO 110
      VALUES(II)=VALUES(II)/ZNORM
  110 GO TO 800
  120 IF(IRFLAG(ISANR).GT.8) GO TO 130
C-----CONVERT TRANSMISSION DATA TO CROSS SECTION (USING SAMPLE THICKNESS
      IF(ICOMN .LT. 1) GO TO 126
      IF(IMUSED(ICOMN).NE.0) GO TO 124
        IMUSED(ICOMN)=1
        VALUES(ICOMN)=1
        IF(UNIT(ICOMN).NE.'ATOMS/B   ') GO TO 126
        IF(NPT.EQ.1.AND.IRFLAG(ISANR).EQ.9) WRITE(OUTP,6081)
          CALL FLOATF(DATUM(ICOMN),VALUES(ICOMN))
          GO TO 124
  123   WRITE(OUTP,6080) DATUM(ICOMN)
  124 CONTINUE
      VALUES(II)=-LOG(VALUES(II))/VALUES(ICOMN)
      GO TO 800
  126 WRITE(OUTP,6082)
      IRFLAG(ISANR)=0
C-----CONVERT RATIO-TO-RUTHERFORD INTO CROSS SECTIONS
  130 IF(IRFLAG(ISANR).GT.9) GO TO 800
C*    -- define constants (Table 1, Appendix H, ENDF-102 manual)
      IF(NPT.EQ.1.AND.IRFLAG(ISANR).EQ.9) WRITE(OUTP,6090)
      PCP=6.58211889E-16
      RAL=137.03599976
      AMUEV=9.31494013E8
      CC=299792458
C*    -- Energy and angle
      IE=KMOUT(1,ISANR)
      IA=KMOUT(5,ISANR)
      EE=VALUES(IE)
      AIN=VALUES(IA)
C*    -- Target and projectile ZA
      DO K=1,7
        ZACH7(K:K)=ZAN(K,ISANR)
      END DO
      READ (ZACH7,'(I6)') IZA
      IZAP=INPART(ISANR)
C*    -- Target and projectile mass (equal to ejectile)
      CALL ZAMASS(NMASS,IZA, AWT)
      CALL ZAMASS(NMASS,IZAP,AM1)
      AWP=AM1
C*    -- Target and projectile charge
      ZZT=IZA /1000
      ZZI=IZAP/1000
C*    -- Target spin (only relevant when equal to projectile)
      SPI=0
C*    - Calculate Rutherford (Coulomb) scattering term
      AA =AWT/AWP
      AK =2*AMUEV/(PCP*CC*1E14)**2
      AE =AMUEV/(2*RAL*RAL)
      AKA=SQRT(AK*AM1*EE)*AA/(AA+1)
      AET=ZZT*ZZI*SQRT(AE*AM1/EE)
        IF(IZAP.NE.IZA) THEN
          SIGC=AET*AET/(AKA*AKA*(1-AIN)**2)
        ELSE
          A0 =LOG((1+AIN)/(1-AIN))
          A1 =COS(AET*A0)
          A2 =A1* (-1)**NINT(2*SPI) /(2*SPI+1)
          A3 =A2+ (1+AIN*AIN)/(1-AIN*AIN)
          SIGC=A3* 2 * (AET*AET/(AKA*AKA*(1-AIN*AIN)))
        END IF
      VALUES(II)=VALUES(II)*SIGC
C*    - Apply the same correction to the uncertainty
      II=KMOUT(4,ISANR)
      VALUES(II)=VALUES(II)*SIGC
C-----
  800 RETURN
 6000 FORMAT(10X,'OPERATION...CREATED EN          ',1PE11.4,' EV')
 6010 FORMAT(10X,'WARNING...LEGENDRE ORDER (COLUMN 5) NOT DEFINED'/
     1 10X,'LEGENDRE COEFFICIENTS CANNOT BE RENORMALIZED')
 6020 FORMAT(10X,'OPERATION...DEFINED DATA = DATA/2')
 6030 FORMAT(10X,'OPERATION...DEFINED DATA = DATA/(2*L+1)')
 6040 FORMAT(10X,'OPERATION...DEFINED DATA = DATA/F(0)')
 6050 FORMAT(10X,'OPERATION...DEFINED DATA = DATA/(F(0)*(2*L+1))')
 6060 FORMAT(10X,'WARNING...ENERGY (COLUMN 1) NOT DEFINED'/
     1 10X,'LEGENDRE COEFFICIENTS CANNOT BE RENORMALIZED')
 6070 FORMAT(10X,'WARNING...NO F(0) AT ENERGY = ',1PE11.4,' EV'/
     1 10X,'LEGENDRE COEFFICIENTS CANNOT BE RENORMALIZED')
 6080 FORMAT(10X,'WARNING...UNITS IN COMMON FIELD ',A11,/
     1      ,10X,'                     EXPECTED ATOMS/B')
 6081 FORMAT(10X,'OPERATION...CONVERTED TRANSMISSION TO X.S.')
 6082 FORMAT(10X,'WARNING...SAMPLE THICKNESS FOR TRANSMISSION DATA'
     1      ,' NOT SPECIFIED')
 6090 FORMAT(10X,'OPERATION...CONVERTED RUTHERFORD RATIO TO X.S.')
      END
      SUBROUTINE INTGER(CARD,N,I)
C
C     TRANSLATE FROM CHARACTERS TO INTEGER
C
      INTEGER OUTP,OTAPE
      CHARACTER*1 CARD,DIGITS,PLUS,MINUS,BLANK,STAR,STARS
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      DIMENSION CARD(I),DIGITS(10),STARS(11)
      DATA DIGITS/'0','1','2','3','4','5','6','7','8','9'/
      DATA STARS/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA PLUS/'+'/
      DATA MINUS/'-'/
      DATA BLANK/' '/
      DATA STAR/'*'/
C-----INITIALIZE NUMBER AND SKIP LEADING BLANKS.
      N=0
      NS=1
      DO 10 K=1,I
      IF(CARD(K).NE.BLANK) GO TO 20
   10 CONTINUE
C-----FIELD IS BLANK. RETURN ZERO.
      RETURN
C-----ALLOW LEADING + OR -.
   20 IF(CARD(K).EQ.PLUS) GO TO 30
      IF(CARD(K).NE.MINUS) GO TO 40
      NS=-1
   30 K=K+1
C-----ERROR IF NUMBER ENDS WITH + OR -
      IF(K.LE.I) GO TO 40
      J=I
      GO TO 80
C-----TRANSLATE DIGITS.
   40 IPASS=0
      DO 70 J=K,I
      DO 50 M=1,10
      IF(CARD(J).EQ.DIGITS(M)) GO TO 60
   50 CONTINUE
C-----ERROR. CANNOT TRANSLATE CHARACTER.
      GO TO 80
   60 N=10*N+(M-1)
   70 CONTINUE
C-----ALL CHARACTERS TRANSLATED. DEFINE SIGNED NUMBER
      N=NS*N
      RETURN
   80 STARS(J)=STAR
      WRITE(OUTP,6000) CARD
      WRITE(OUTP,6010) STARS
      N=0
      STARS(J)=BLANK
      RETURN
 6000 FORMAT(' SUBROUTINE INTGER....CANNOT TRANSLATE BELOW FIELD'/
     1 1X,11A1)
 6010 FORMAT(1X,11A1)
      END
      SUBROUTINE FLOATF(FIELD,X)
C
C     CONVERT FROM HOLLERITH TO FLOATING POINT.
C     MUST BE BETWEEN 1.0E-40 AND 1.0E+40.
C
      INTEGER OUTP,OTAPE
      CHARACTER*1 BLANK,DOT,EXPD,EXPE,PLUS,MINUS,STAR,MESS,DIGIT,FIELD,
     1 IFIELD,EXPDL,EXPEL
      COMMON/UNITS/INP,OUTP,ITAPE,OTAPE,NEWX4,NMASS
      DIMENSION FIELD(11),TEN(35),DIGIT(10),MESS(11)
      DATA BLANK/' '/
      DATA DOT/'.'/
      DATA EXPD/'D'/
      DATA EXPE/'E'/
      DATA EXPDL/'d'/
      DATA EXPEL/'e'/
      DATA PLUS/'+'/
      DATA MINUS/'-'/
      DATA STAR/'*'/
      DATA MESS/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/
      DATA DIGIT/'0','1','2','3','4','5','6','7','8','9'/
      DATA ZERO/0.0E+00/
      DATA TEN/
     1 1.0E+01,1.0E+02,1.0E+03,1.0E+04,1.0E+05,
     2 1.0E+06,1.0E+07,1.0E+08,1.0E+09,1.0E+10,
     3 1.0E+11,1.0E+12,1.0E+13,1.0E+14,1.0E+15,
     4 1.0E+16,1.0E+17,1.0E+18,1.0E+19,1.0E+20,
     5 1.0E+21,1.0E+22,1.0E+23,1.0E+24,1.0E+25,
     6 1.0E+26,1.0E+27,1.0E+28,1.0E+29,1.0E+30,
     7 1.0E+31,1.0E+32,1.0E+33,1.0E+34,1.0E+35/
C
C     TRANSLATE MANTISSA.
C
C-----SKIP LEADING BLANK CHARACTERS.
      DO 10 I=1,11
      IF(FIELD(I).NE.BLANK) GO TO 20
   10 CONTINUE
C-----FIELD IS COMPLETELY BLANK. RETURN ZERO.
      X=ZERO
      GO TO 240
C-----INITIALIZE FIXED POINT INPUT FIELD AND POSITION OF DECIMAL POINT.
   20 IN=0
      IPT=-20
C-----ALLOW LEADING SIGN.
      IF(FIELD(I).EQ.MINUS) GO TO 40
      IF(FIELD(I).NE.PLUS) GO TO 30
      I=I+1
   30 XSIGN=1.0
      GO TO 50
   40 I=I+1
      XSIGN=-1.0
C-----SCAN REMAINDER OF MANTISSA.
   50 DO 90 J=I,11
      IFIELD=FIELD(J)
C-----SCAN FOR DIGIT OR DECIMAL POINT (WHICH ARE PART OF MANTISSA).
      DO 60 K=1,10
      IF(IFIELD.EQ.DIGIT(K)) GO TO 80
   60 CONTINUE
      IF(IFIELD.NE.DOT) GO TO 70
      IPT=0
      GO TO 90
C-----SCAN FOR BLANK (WHICH ENDS MANTISSA).
   70 IF(IFIELD.EQ.BLANK) GO TO 100
C-----SCAN FOR E,D,- OR + (WHICH BEGINS EXPONENT).
      IF(IFIELD.EQ.EXPE .OR.IFIELD.EQ.EXPD .OR.
     &   IFIELD.EQ.EXPEL.OR.IFIELD.EQ.EXPDL) GO TO 130
      IF(IFIELD.EQ.MINUS) GO TO 160
      IF(IFIELD.EQ.PLUS) GO TO 140
C-----ERROR. CANNOT IDENTIFY CHARACTER.
      GO TO 250
C-----DIGIT FOUND. INCREMENT FIXED POINT EQUIVALENT AND DECIMAL POINT
C-----OFFSET.
   80 IN=10*IN+(K-1)
      IPT=IPT+1
   90 CONTINUE
C-----ENTIRE FIELD TRANSLATED (NO EXPONENT). CONVERT TO FLOATING POINT.
      GO TO 120
C-----BLANK FOUND (END OF MANTISSA). SCAN REMAINDER OF FIELD FOR
C-----EXPONENT.
  100 I=J+1
      IF(I.GT.11) GO TO 120
      DO 110 J=I,11
      IFIELD=FIELD(J)
      IF(IFIELD.EQ.BLANK) GO TO 110
      IF(IFIELD.EQ.EXPE.OR.IFIELD.EQ.EXPD) GO TO 130
      IF(IFIELD.EQ.MINUS) GO TO 160
      IF(IFIELD.EQ.PLUS) GO TO 140
C-----ERROR. CANNOT IDENTIFY CHARACTER.
      GO TO 250
  110 CONTINUE
C-----ENTIRE FIELD TRANSLATED (NO EXPONENT). CONVERT TO FLOATING POINT.
  120 X=IN
      IF(IPT.GT.0) X=X/TEN(IPT)
      GO TO 230
C
C     TRANSLATE EXPONENT.
C
C-----BEGINNING OF EXPONENT FOUND (X OR D). CHECK FOR FOLLOWING - OR +.
  130 J=J+1
      IFIELD=FIELD(J)
      IF(IFIELD.EQ.MINUS) GO TO 160
      IF(IFIELD.NE.PLUS) GO TO 150
C----- + FOUND. INITIALIZE EXPONENT SIGN.
  140 J=J+1
  150 KSIGN=1
      GO TO 170
C----- - FOUND. INITIALIZE EXPONENT SIGN.
  160 J=J+1
      KSIGN=-1
C-----INITIALIZE EXPONENT AND SCAN REMAINING CHARACTERS FOR EXPONENT.
  170 KEXP=0
      DO 200 I=J,11
      IFIELD=FIELD(I)
      IF(IFIELD.EQ.BLANK) GO TO 200
      DO 180 K=1,10
      IF(IFIELD.EQ.DIGIT(K)) GO TO 190
  180 CONTINUE
C-----ERROR. CANNOT IDENTIFY CHARACTER.
      GO TO 250
C-----DIGIT FOUND. INCREMENT EXPONENT.
C-----OFFSET.
  190 KEXP=10*KEXP+(K-1)
  200 CONTINUE
C-----ENTIRE FIELD TRANSLATED (WITH EXPONENT). CONVERT TO FLOATING
C-----POINT.
      X=IN
      KEXP=KSIGN*KEXP
      IF(IPT.GT.0) KEXP=KEXP-IPT
      IF(KEXP) 210,230,220
  210 KEXP=-KEXP
      X=X/TEN(KEXP)
      GO TO 230
  220 X=X*TEN(KEXP)
  230 X=XSIGN*X
  240 RETURN
  250 MESS(J)=STAR
      WRITE(OUTP,6000) FIELD,MESS
      X=ZERO
      MESS(J)=BLANK
      RETURN
 6000 FORMAT(1X,11A1/1X,11A1/
     1 ' SUBROUTINE FLOATF...ERROR IN INPUT DATA...TRANSLATED AS 0')
      END
      SUBROUTINE ZAMASS(NMASS,IZA,AWT)
C-Title  : Subroutine ZAMASS
C-Purpose: Read Audi-Wapstra tables for atomic weight of nuclide IZA
C-
      CHARACTER*132 REC
      IF(NMASS.LE.0) GO TO 80
C* Try reading Audi-Wapstra file
      REWIND NMASS
C* Skip header records
   20 READ (NMASS,90) REC
      IF(REC(1:4).NE.'1N-Z') GO TO 20
      READ (NMASS,90) REC
C* Search the file for matching ZA
   40 READ (NMASS,90,END=80) REC
      READ (REC,91,ERR=40) IZ,IA,AM1,AM2
      JZA=IZ*1000+IA
      IF(JZA.NE.IZA) GO TO 40
C* Matching nuclide found
      AWT=AM1+AM2/1000000
      RETURN
C...
C... CRUDE APPROXIMATION FOR NUCLIDES NOT LISTED
C...
   80 CONTINUE
      PRINT *,'ZAMASS WARNING - Mass approximated by A for ZA',IZA
C...
      IZ=IZA/1000
      IA=IZA-1000*IZ
      IF(IA.EQ.0) IA=2*IZ
      AWT=IA
      RETURN
   90 FORMAT(A132)
   91 FORMAT(9X,I5,I5,77X,F3.0,F13.0)
      END
