      subroutine starplot
c***********************************************************************
c
c       written by
c       ==========
c       Jay McGowan and Red Cullen
c       LLNL
c       L-298
c       P.O. Box 808
c       Livermore, Ca 94550
c
c       Please report all comments or errors to the authors.
c
c       purpose
c       =======
c       1) calcomp like graphics interface for SUN workstations
c       2) interactive graphics using mouse for SUN workstation
c
c       this routine can be used,
c       1) black and white - not pd7 sparc workstation
c          color           - if pd7 workstation
c       2) inside windows
c          not in windows
c
c       the workstation and whether or not in windows is
c       automatically determined by this routine - so this
c       routine can be used without any modifications for
c       any of the above combinations
c
c       use
c       ===
c       for calcomp like output and no mouse interaction only
c       use plots, plot and pen.
c
c       in either case to create a plot on the screen,
c       1) initialize the screen by calling plots
c       2) define the color of vectors calling pen (black/white - ignore
c       3) draw vectors on screen calling plot
c       4) end plot by calling plot - see plot arguments below
c       5) after all plots are completed terminate plotting by
c          calling plot - see plot arguments below
c
c       screen area
c       ===========
c       the screen is defined to extend from,
c       x   = -1.0 to 14.0
c       y   = -1.0 to 11.0
c       you should scale all x,y arguments to call plot to this range.
c       alternatively you may change the limits in SetWindow below
c       which presently says,
c
c       call SetWindow(-1.0, 14.0, -1.0, 11.0)
c
c       calcomp like graphics interface
c       ===============================
c       entry points
c       ============
c       starplot       = initialize plotting
c       nextplot       = pause at end of plot - then clear screen
c       endplots       = terminate plotting
c
c       plot(x,y,ipen) = draw, move, end plot, end plotting
c            x,y       = absolute coordinates for draw or move
c                ipen  =   2 - draw
c                      =   3 - move
c
c       pen(icolor)    = select color inverting 256 color table
c           icolor     = index to color (0 to any number)
c
c       pen1(icolor)   = select color directly in icolor order
c           icolor     = index to color (0 to any number)
c
c       backgd(icolor) = define background color
c
c       interactive graphics using mouse
c       ================================
c       entry points
c       ============
c       mousey(iway,x,y,iway1,iway2) = turn on mouse
c                                      test for mouse or keyboard input
c                                      turn off mouse
c                                iway  = 0 - none
c                                      = 1 - left mouse key
c                                      = 2 - center mouse key
c                                      = 3 - right mouse key
c                                      = 4 - keyboard
c                                   x  =     x coordinate if mouse key
c                                      =     0.0 otherwise
c                                   y  =     y coordinate if mouse key
c                                      =     0.0 otherwise
c                                iway1 = lowest allowable value of iway
c                                iway2 = highest allowable value of iway
c
c       sleepy(isleep) = delay for (isleep) seconds
c
c      call xinitialize
c
      SAVE
      integer itemp,job,mymouse,penmap,mycolor,lcolor
      integer i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12
C***** DEBUG ****
c     character*40 file1,file2,filex
C***** DEBUG ****
      CHARACTER*44 MYFONT
      CHARACTER*1 MYFONT1
      character*1 keyhit
C***** DEBUG ****
      common/backmy/myback
c     dimension penmap(0:255),ired(256),igreen(256),iblue(256),
c    1 file1(2),file2(2),xc(2),yc(2),
c    2 MYFONT1(44),XSIZE(2),YSIZE(2)
      dimension penmap(0:255),ired(256),igreen(256),iblue(256),
     1                   xc(2),yc(2),
     2 MYFONT1(44),XSIZE(2),YSIZE(2)
C***** DEBUG ****
      EQUIVALENCE (MYFONT,MYFONT1(1))
C***** DEBUG ****
c     data file1/
c    1 'RGB.DAT                                 ',
c    2 'RGB.DAT.RAINBOW                         '/
c     data file2/
c    1 'PALLETTE.DAT                            ',
c    2 'PALLETTE.DAT.RAINBOW                    '/
C***** DEBUG ****
      data mymouse/0/
      data lcolor/-9999/
      DATA MYFONT/
     1 '-adobe-courier-bold-r-*-*-25-*-*-*-*-*-*-*  '/
c-----indicate plotter has not been initialized.
      data imon/0/
c-----define plotting surface
      data xmin/0.0/
      data xmax/12.5/
      data ymin/0.0/
      data ymax/10.0/
c-----maintain perspective
      data myview/1/
c-----initialize background color to IBM blue
      myback = 183
c***********************************************************************
c
c     initialize window
c
c***********************************************************************
c
c     initialize window
c
      imon=1
      call xpinit(xmin,xmax,ymin,ymax,myview)
      lastpen=0
      resolve=0.01
c
c     define type of screen - black/white = 1, otherwise color
c
      call myscreen(mycolor)
C***** DEBUG
C-----ACTIVATE TO SIMULATE BLACK/WHITE.
C     mycolor=1
C***** DEBUG
c
c     if black and white set all colors 0, except 0 = 1.
c
      if(mycolor.ne.1) go to 20
      penmap(0)=1
      myback=penmap(0)
      do 10 i=1,255
   10 penmap(i)=0
      return
   20 call paltab(penmap,ired,igreen,iblue,1)
c-----set new rgb data
      call pallette(ired,igreen,iblue)
c-----clear screen
      call xpclr()
      call boxfill(0.0,12.5,0.0,10.0,myback,-1)
C
C     LOAD FONT
C
      MYFONT1(43)=CHAR(0)
      CALL SETFONT(MYFONT)
      return
c
      ENTRY INTERACT(MYACTION)
C=======================================================================
C
C     INDICATE PROGRAM IS IN INTERACTIVE MODE
C
C=======================================================================
      MYACTION=1
      RETURN
      ENTRY MYSIZE(XSIZE,YSIZE)
C=======================================================================
C
C     DEFINE X AND Y SIZE OF SCREEN.
C
C=======================================================================
      XSIZE(1)=XMIN
      XSIZE(2)=XMAX
      YSIZE(1)=0.01
      YSIZE(2)=YMAX
      RETURN
      entry newpal(index)
c======================================================================
c
c     new rgb data and pen map
c
c     index = 1 - standard
c           = 2 - rainbow
c
C***** DEBUG
c     file1 = new rgb data
c     file2 = new pen map
c
C***** DEBUG
c======================================================================
c-----ignore if black/write.
      if(mycolor.eq.1) return
c-----nothing to do if requested pallette is already loaded.
      if(index.eq.lastdex) return
      lastdex=index
      call paltab(penmap,ired,igreen,iblue,index)
c-----set new rgb data
      call pallette(ired,igreen,iblue)
c-----clear screen
      call xpclr()
      call boxfill(0.0,12.5,0.0,10.0,myback,-1)
      return
c***********************************************************************
c
c     draw or move
c
c***********************************************************************
      entry plot(xin, yin, ipen)
c-----always output if different type of output from last time
      if(ipen.ne.lastpen) go to 60
c-----otherwise, filter to resolution of screen
      if(abs(xin-xlast).ge.resolve.or.
     1   abs(yin-ylast).ge.resolve) go to 70
      return
c-----save parameters for filtering
   60 lastpen=ipen
   70 xlast=xin
      ylast=yin
c-----draw
      if(ipen.ne.2) go to 80
      call xpdraw(xin,yin)
      return
c-----move
   80 if(ipen.ne.3) return
      call xpmove(xin,yin)
      return
c***********************************************************************
c
c     end of a plot - delay and then clear screen.
c
c***********************************************************************
      entry nextplot
c-----nothing to do if plotter not initialized.
      if(imon.le.0) return
c-----if mouse is not being used, delay at end of plot.
      if(mymouse.le.0) call xmouse(kway,xd,yd,4,4)
c-----clear screen.
      call xpclr()
      call boxfill(0.0,12.5,0.0,10.0,myback,-1)
      lastpen=0
      return
c***********************************************************************
c
c     clear the screen - no delay.
c
c***********************************************************************
      entry newplot
c-----nothing to do if plotter not initialized.
      if(imon.le.0) return
      call xpclr()
      call boxfill(0.0,12.5,0.0,10.0,myback,-1)
      return
c***********************************************************************
c
c     end of plotting.
c
c***********************************************************************
      entry endplots
c-----nothing to do if plotter not initialized.
      if(imon.le.0) return
      call xpdone(itemp,job)
      return
c***********************************************************************
c
c     select pen directly
c
c***********************************************************************
      entry pen1(icolor)
c-----ignore if same as current color.
      if(icolor.eq.lcolor) return
      lcolor=icolor
      call xpen(icolor)
      return
c***********************************************************************
c
c     select pen using pen map to insert order.
c
c***********************************************************************
      entry pen(icolor)
      if(mycolor.ne.1) go to 90
c-----black/white.
      kcolor=1
      if(icolor.eq.0) kcolor=0
      go to 100
   90 kcolor=mod(icolor,256)
  100 kcolor=penmap(kcolor)
c-----ignore if same as current color.
      if(kcolor.eq.lcolor) return
      lcolor=kcolor
      call xpen(kcolor)
      return
c***********************************************************************
c
c     select background color
c
c***********************************************************************
      entry backgd(icolor)
c
c     nothing to do if this is already the background color
c
      ii=penmap(0)
      if(icolor.eq.ii) return
c
c     if black and white reverse entire map
c
      if(mycolor.ne.1) go to 120
      do 110 i=1,255
  110 penmap(i)=ii
      penmap(0)=1-ii
      myback=penmap(0)
      call backcolor(penmap(0))
      return
c
c     for color switch the background and selected color
c
  120 kcolor=mod(icolor,256)
      penmap(0)=penmap(kcolor)
      penmap(kcolor)=ii
      call backcolor(penmap(0))
      return
c***********************************************************************
c
c     switch background between black/white
c
c***********************************************************************
      entry newback
      ii=penmap(0)
c
c     if black and white reverse entire map
c
      if(mycolor.ne.1) go to 140
      do 130 i=1,255
  130 penmap(i)=ii
      penmap(0)=1-ii
      myback=penmap(0)
      call backcolor(penmap(0))
      return
c
c     for color only switch the background and foreground (assumed
c     to be colors 0 and 1)
c
  140 if(myback.eq.183) then
      myback = penmap(1)
      i2     = penmap(2)
      i3     = penmap(3)
      i4     = penmap(4)
      i5     = penmap(5)
      i6     = penmap(6)
      i7     = penmap(7)
      i8     = penmap(8)
      i9     = penmap(9)
      i10    = penmap(10)
      i11    = penmap(11)
      i12    = penmap(12)
      penmap(2)  = 1
      penmap(3)  = 1
      penmap(4)  = i3
      penmap(5)  = i10
      penmap(6)  = i12
      penmap(10) = i5
      penmap(12) = i6
      else
      myback = 183
      penmap(2)  = i2
      penmap(3)  = i3
      penmap(4)  = i4
      penmap(5)  = i5
      penmap(6)  = i6
      penmap(7)  = i7
      penmap(8)  = i8
      penmap(9)  = i9
      penmap(10) = i10
      penmap(11) = i11
      penmap(12) = i12
      endif
      ii        = penmap(0)
      penmap(0) = penmap(1)
      penmap(1) = ii
      return
c***********************************************************************
c
c     service mouse
c
c***********************************************************************
      entry mousey(iway,x,y,iway1,iway2)
c-----indicate mousey has been called - no delay between frames
      mymouse=1
      x=0.0
      y=0.0
c-----test mouse or keyboard input.
  150 call xmouse(iway,x,y,iway1,iway2)
      if(iway.gt.0) go to 160
c-----no input - keep testing if iway1 > 0
      if(iway1.gt.0) go to 150
      return
  160 if(iway.lt.4) go to 170
c-----input - unless requested ignore keyboard input.
      if(iway2.lt.4) go to 150
c-----otherwise use input.
      return
c-----ignore mouse outside scrreen area.
  170 if(x.lt.xmin.or.x.gt.xmax) go to 150
      if(y.lt.ymin.or.y.gt.ymax) go to 150
c-----otherwise use input.
      return
c***********************************************************************
c
c     draw and fill a rectangular box
c
c***********************************************************************
      entry boxcolor(xc,yc,mfill,mborder)
c-----ignore for black/white screens.
C     if(mycolor.eq.1) return
      ifill=-1
      ibord=-1
      if(mfill.lt.0) go to 180
      lfill=mod(mfill,256)
      if(mfill.ge.256.and.lfill.le.0) lfill=1
      ifill=penmap(lfill)
C***** DEBUG
C-----SPECIAL TREATMENT FOR IBM BLUE
      if(mfill.eq.183) ifill=myback
C***** DEBUG
  180 if(mborder.lt.0) go to 190
      lfill=mod(mborder,256)
      if(mborder.ge.256.and.lfill.le.0) lfill=1
      ibord=penmap(lfill)
  190 call boxfill(xc(1),xc(2),yc(1),yc(2),ifill,ibord)
      return
c***********************************************************************
c
c     draw a box - either filled or not
c
c***********************************************************************
      entry boxdraw(x1,x2,y1,y2,kfill,kborder)
      ifill=-1
      ibord=-1
      if(kfill.lt.0) go to 200
      lfill=mod(kfill,256)
      if(kfill.ge.256.and.lfill.le.0) lfill=1
      ifill=penmap(lfill)
C***** DEBUG
C-----SPECIAL TREATMENT FOR IBM BLUE
      if(kfill.eq.183) ifill=myback
C***** DEBUG
  200 if(kborder.lt.0) go to 210
      lfill=mod(kborder,256)
      if(kborder.ge.256.and.lfill.le.0) lfill=1
      ibord=penmap(lfill)
  210 call boxfill(x1,x2,y1,y2,ifill,ibord)
      return
c***********************************************************************
c
c     draw a polygon - either filled or not
c
c***********************************************************************
      entry polydraw(xtab,ytab,ntab,kfill,kborder)
      ifill=-1
      ibord=-1
      if(kfill.lt.0) go to 220
      lfill=mod(kfill,256)
      if(kfill.ge.256.and.lfill.le.0) lfill=1
      ifill=penmap(lfill)
C***** DEBUG
C-----SPECIAL TREATMENT FOR IBM BLUE
      if(kfill.eq.183) ifill=myback
C***** DEBUG
  220 if(kborder.lt.0) go to 230
      lfill=mod(kborder,256)
      if(kborder.ge.256.and.lfill.le.0) lfill=1
      ibord=penmap(lfill)
  230 call polyfill(xtab,ytab,ntab,ifill,ibord)
      return
c***********************************************************************
c
c      read character from keyboard
c
c***********************************************************************
      entry key1(keyhit,iend)
      call pxkbd(keyhit,iend)
      return
c***********************************************************************
c
c      read character code (integer) from keyboard
c
c***********************************************************************
      entry key2(keyint)
      call pxkbd2(keyint)
      return
c***********************************************************************
c
c     empty display buffer and then delay for (isleep) seconds
c
c***********************************************************************
      entry sleepy(isleep)
      call flushit
      call sleep(isleep)
      return
      end
      FUNCTION KEYCODE()
C=======================================================================
C
C     READ 1 CHARACTER CODE FROM KEYBOARD
C
C     FOR SPECIAL CHARACTERS DEFINE IBM EQUIVALENT.
C     IGNORE CHARACTERS THAT ARE NOT USED.
C
C=======================================================================
C-----READ CHARACTER.
   10 CALL PXKBD2(KEY)
C-----USE NORMAL CODES
      IF(KEY.LE.255) GO TO 20
C-----IGNORE FUNCTION KEYS 3-12
      IF(KEY.GE.65472.AND.KEY.LE.65481) GO TO 10
      IF(KEY.EQ.65470) KEY=1059       ! F1       = REPEAT FIND
      IF(KEY.EQ.65471) KEY=1060       ! F2       = REPEAT CHANGE
      IF(KEY.EQ.65425) KEY=1073       ! PF1      = PAGE UP
      IF(KEY.EQ.65426) KEY=1081       ! PF2      = PAGE DOWN
      IF(KEY.EQ.65290) KEY=1071       ! LINEFEED = HOME
      IF(KEY.EQ.65387) KEY=1079       ! BREAK    = END
      IF(KEY.EQ.65507) KEY=1082       ! OPTION   = INSERT
      IF(KEY.EQ.65535) KEY=1083       ! DELETE
      IF(KEY.EQ.65293) KEY=13         ! RETURN
      IF(KEY.EQ.65307) KEY=27         ! ESCAPE
      IF(KEY.EQ.65362) KEY=1072       ! UP ARROW
      IF(KEY.EQ.65364) KEY=1080       ! DOWN ARROW
      IF(KEY.EQ.65361) KEY=1075       ! LEFT ARROW
      IF(KEY.EQ.65363) KEY=1077       ! RIGHT ARROW
      IF(KEY.EQ.65289) KEY=9          ! TAB
C-----NEWER KEYBOARD
      IF(KEY.EQ.65379) KEY=1082       ! INSERT
      IF(KEY.EQ.65360) KEY=1071       ! HOME
      IF(KEY.EQ.65365) KEY=1073       ! PAGE UP
      IF(KEY.EQ.65366) KEY=1081       ! PAGE DOWN
      IF(KEY.EQ.65367) KEY=1079       ! END
C-----IGNORE REMAINING SPECIAL CHARACTERS.
      IF(KEY.GE.10000) GO TO 10
C-----RETURN CHARACTER CODE
      KEYCODE=KEY
      RETURN
   20 IF(KEY.EQ.0) KEY=32             ! NULL = BLANK (SHIFT+SPACE BAR)
C-----RETURN CHARACTER CODE
      KEYCODE=KEY
      RETURN
      END
      SUBROUTINE SHOWTEXT(NX,NY,MESS,NMESS)
C=======================================================================
C
C     DISPLAY TEXT
C
C=======================================================================
C***** SAVE *****
      SAVE
C***** SAVE *****
      CHARACTER*1 MESS,CURSOR,IBLANK
      common/backmy/myback
      DIMENSION MESS(80),XSPOT(0:81),YSPOT(0:30),XBSPOT(2,0:81),
     1 YBSPOT(2,0:30)
C-----ON FIRST PASS DEFINE POSITION OF CHARACTERS
      DATA IPASS/0/
C-----COLORS FOR CURSOR ON COLOR SCREEN.
      DATA ICC1/4/
      DATA ICC2/0/
C
C     INITIALIZATION - PREFORMED THE FIRST TIME THIS ROUTINE IS CALLED
C
      IF(IPASS.NE.0) GO TO 50
      IPASS=1
      HTX=12.5/80.0
      HTY=9.9/30.0
      XSPOT(0)=0.0
      XSPOT(1)=0.5*HTX
      DO 10 I=2,81
   10 XSPOT(I)=XSPOT(I-1)+HTX
      YSPOT(0)=10.0-0.8*HTY
      DO 20 I=1,30
   20 YSPOT(I)=YSPOT(I-1)-HTY
      TAD=0.1*HTX
      DO 30 I=0,81
      XBSPOT(1,I)=XSPOT(I)-TAD
   30 XBSPOT(2,I)=XBSPOT(1,I)+HTX+TAD
      DO 40 I=1,30
      YBSPOT(1,I)=YSPOT(I)-TAD
   40 YBSPOT(2,I)=YSPOT(I)+HTX+TAD
C-----CURSOR OVER BLANK
      IBLANK=CHAR(2)
C-----DEFINE WHETHER COLOR OR BLACK AND WHITE
      CALL MYSCREEN(MYCOLOR)
      IF(MYCOLOR.le.1) then
C-----COLORS FOR CURSOR ON BLACK/WHITE SCREEN
      ICC1=1
      ICC2=0
      else
      if(myback.eq.183) then
      ICC1 = 4
      ICC2 = 0
      else
      ICC1 = 0
      ICC1 = 1
      endif
      endif
C
C     LOOP OVER CHARACTERS.
C
   50 IX=NX
      DO 60 I=1,NMESS
      CALL RTEXTX(0,XSPOT(IX),YSPOT(NY),MESS(I),1)
   60 IX=IX+1
      CALL FLUSHIT
      RETURN
C=======================================================================
C
C     DISPLAY CURSOR
C
C=======================================================================
      ENTRY CURSEON(NXC,NYC,CURSOR)
C-----BOX AROUND CURSOR.
      CALL BOXCOLOR(XBSPOT(1,NXC),YBSPOT(1,NYC),ICC1,-1)
C-----NOTHING ELSE TO DO IF CHARACTER IS BLANK.
      IF(CURSOR.EQ.IBLANK) RETURN
C-----OTHERWISE CHARACTER WITHIN BOX.
      CALL PEN(ICC2)
      CALL RTEXTX(1,XSPOT(NXC),YSPOT(NYC),CURSOR,1)
      RETURN
C=======================================================================
C
C     REMOVE CURSOR
C
C=======================================================================
      ENTRY CURSEOFF(NXC,NYC,CURSOR)
C-----BLANK BOX AROUND CURSOR.
      CALL BOXCOLOR(XBSPOT(1,NXC),YBSPOT(1,NYC),0,-1)
C-----NOTHING ELSE TO DO IF CHARACTER IS BLANK.
      IF(CURSOR.EQ.IBLANK) RETURN
C-----OTHERWISE DISPLAY CHARACTER.
      CALL RTEXTX(0,XSPOT(NXC),YSPOT(NYC),CURSOR,1)
      RETURN
      END
      SUBROUTINE PIXSET(XP,YP,IPEN)
C=======================================================================
C
C     SET PIXEL COLOR
C
C=======================================================================
C***** SAVE *****
      SAVE
C***** SAVE *****
      CALL PEN(IPEN)
      CALL XYPIXEL(XP,YP)
      RETURN
      END
      SUBROUTINE PRINTIT
C***********************************************************************
C
C     PRINT SCREEN
C
C***********************************************************************
C***** SAVE *****
      SAVE
C***** SAVE *****
      CHARACTER*1  NEXT1
      CHARACTER*56 NEXTPAGE
      DIMENSION NEXT1(56)
      EQUIVALENCE (NEXTPAGE,NEXT1(1))
      DATA SPAGE/0.0/
      DATA NEXTPAGE/
     1 'import -rotate 90                         SCREEN.       '/
c    1 'XtoPS -rotate 90                          SCREEN.       '/
C    1 'XtoPS -rotate 90 -geometry 612x792+67+92  SCREEN.       '/
C***** DEBUG - THIS IS THE STANDARD ORIGINAL GEOMETRY
C     THE OFFSETS IN X AND Y ARE ADDED TO THE SIZE TO DEFINE THE
C     BOX 67 92 544 700 (X = 67-544, Y = 92-700)
C    1 'XtoPS -rotate 90 -geometry 477x608+67+92  SCREEN.       '/
C       12345678901234567890123456789012345678901234567890123456
C                1         2         3         4         5
C***** DEBUG - THIS IS THE STANDARD ORIGINAL GEOMETRY
C-----INCREMENT NAME OF OUTPUT FILE.
      SPAGE=SPAGE+1.0
      CALL NUMBR2(SPAGE,-1,NEXT1(50),NN)
C-----INSURE EVERYTHING IS DISPLAYED
      CALL FLUSHIT
C-----PRINT SCREEN INTO OUTPUT FILE.
      CALL SYSTEM(NEXTPAGE)
      RETURN
      END
      SUBROUTINE SHOWSCRN(NX,NY,MESS,NMESS)
C=======================================================================
C
C     DISPLAY TEXT ONLY ON SCREEN - NOT HARD COPY.
C     OTHERWISE JUST A COPY OF SHOWTEXT
C
C=======================================================================
C***** SAVE *****
      SAVE
C***** SAVE *****
      CHARACTER*1 MESS,IBLANK
      common/backmy/myback
      DIMENSION MESS(80),XSPOT(0:81),YSPOT(0:30),XBSPOT(2,0:81),
     1 YBSPOT(2,0:30)
C-----ON FIRST PASS DEFINE POSITION OF CHARACTERS
      DATA IPASS/0/
C-----COLORS FOR CURSOR ON COLOR SCREEN.
      DATA ICC1/4/
      DATA ICC2/0/
C
C     INITIALIZATION - PREFORMED THE FIRST TIME THIS ROUTINE IS CALLED
C
      IF(IPASS.NE.0) GO TO 50
      IPASS=1
      HTX=12.5/80.0
      HTY=9.9/30.0
      XSPOT(0)=0.0
      XSPOT(1)=0.5*HTX
      DO 10 I=2,81
   10 XSPOT(I)=XSPOT(I-1)+HTX
      YSPOT(0)=10.0-0.8*HTY
      DO 20 I=1,30
   20 YSPOT(I)=YSPOT(I-1)-HTY
      TAD=0.1*HTX
      DO 30 I=0,81
      XBSPOT(1,I)=XSPOT(I)-TAD
   30 XBSPOT(2,I)=XBSPOT(1,I)+HTX+TAD
      DO 40 I=1,30
      YBSPOT(1,I)=YSPOT(I)-TAD
   40 YBSPOT(2,I)=YSPOT(I)+HTX+TAD
C-----CURSOR OVER BLANK
      IBLANK=CHAR(2)
C-----DEFINE WHETHER COLOR OR BLACK AND WHITE
      CALL MYSCREEN(MYCOLOR)
      IF(MYCOLOR.le.1) then
C-----COLORS FOR CURSOR ON BLACK/WHITE SCREEN
      ICC1=1
      ICC2=0
      else
      if(myback.eq.183) then
      ICC1 = 4
      ICC2 = 0
      else
      ICC1 = 0
      ICC1 = 1
      endif
      endif
C
C     LOOP OVER CHARACTERS.
C
   50 IX=NX
      DO 60 I=1,NMESS
      CALL RTEXTX(0,XSPOT(IX),YSPOT(NY),MESS(I),1)
   60 IX=IX+1
      CALL FLUSHIT
      RETURN
      END
      SUBROUTINE NUMBR2(Z,IZ,FIELD,IFIELD)
C=================================================================
C
C     CONVERT FLOATING POINT NUMBER OF CHARACTER STRING AND RETURN IT.
C
C=================================================================
      INCLUDE 'implicit.h'
      CHARACTER*1 DIGIT,MINUS,DOT,FIELD
      DIMENSION DIGIT(10),FIELD(16)
      DATA DIGIT/'1','2','3','4','5','6','7','8','9','0'/
      DATA MINUS/'-'/
      DATA DOT/'.'/
C
C     ROUND-OFF NUMBER TO REQUIRED DIGITS, E.G. IF WRITING 54.321 WITH
C     2 DIGITS AFTER DECIMAL POINT DEFINE MR=5432 (ENTIRE STRING) AND
C     MR1=54 (DIGITS PRECEDING DECIMAL POINT).
C
      AZ=DABS(Z)
      IIZ=IZ
      IF(IIZ.LE.0) IIZ=0
      Z10=10.0**IIZ
      MR=AZ*Z10+0.5
      IZ10=Z10
      MR1=MR/IZ10
C
C     DETERMINE NUMBER OF DIGITS PRECEDING DECIMAL POINT.
C
      M10=1
      DO 10 IDIG=1,12
      NR=MR1/M10
      IF(NR.LE.0) GO TO 20
   10 M10=10*M10
C
C     NUMBER IS TOO BIG...NO PLOTTING.
C
      RETURN
   20 IF(IDIG.EQ.1) GO TO 30
      IDIG=IDIG-1
      M10=M10/10
C
C     ADD DIGITS AFTER DECIMAL POINT.
C
   30 IDIG=IDIG+IIZ
      M10=M10*IZ10
C
C     IF NUMBER IS ZERO, PLOT ZERO AND RETURN.
C
      IF(IDIG.GT.0) GO TO 40
      IFIELD=1
      FIELD(1)=DIGIT(10)
      GO TO 80
C
C     INITIALIZE CHARACTER COUNT.
C
   40 IFIELD=0
C
C     IF NUMBER IS NEGATIVE INSERT MINUS SIGN.
C
      IF(Z.GE.0.0) GO TO 50
      FIELD(1)=MINUS
      IFIELD=1
C
C     DEFINE POSITION OF DECIMAL POINT (IF ANY).
C
   50 IDOT=IDIG-IZ
      IF(IZ.LT.0) IDOT=IDIG+2
C
C     INSERT DIGITS AND DECIMAL POINT (IF ANY) IN STRING.
C
      DO 70 I=1,IDIG
      NDIG=MR/M10
      KDIG=NDIG
      IF(KDIG.EQ.0) KDIG=10
      IFIELD=IFIELD+1
      FIELD(IFIELD)=DIGIT(KDIG)
C
C     INSERT DECIMAL POINT AT APPROPRIATE POSITION.
C
      IF(I.NE.IDOT) GO TO 60
      IFIELD=IFIELD+1
      FIELD(IFIELD)=DOT
   60 MR=MR-M10*NDIG
   70 M10=M10/10
C
C     ENTIRE FIELD FORMATTED. RETURN IT.
C
   80 RETURN
      END
