c=======================================================================
c
c      ENDF2PLOT (2025-1)
c      ==================
c             by
c      Dermott E. Cullen
c      1466 Hudson Way
c      Livermore, CA 94550
c      Email: redcullen1@comcast.net
c
c      Purpose
c      =======
c      Simple code to translate 1 ENDF MF=3/MT to PLOTTAB.CUR format -
c      PLOTTAB can then be used to plot the data.
c      1)ENDF read is kept as simple and exactly the same as input -
c        reading data points in chracter A11 format instead of D11.4.
c      2)there is no limit on the number of data poiints - they are
c        read only 1 ENDF line at a time (up to 3 points) and output
c        up to 3 points at a time.
c
c      Input/Output Filenames are constant
c      =======================================
c      Input parameterss = ENDF2PLOT.INP     2
c      ENDF data         = ENDFB.IN         10
c      PLOTTAB dat       = PLOTTAB.CUR      11
c
c      Input: read from ENDF2PLOT.INP
c      ==============================
c      line columns Definition
c      ======================
c      1    1-5     MT  - any ENDF MT # in MT=3 Cross Sectiond
c           7-26    Title - Title beginning PLOTTAB.CUR
c      You can repeat the MT/Title request any number of times, e.g.,
c          1 Totsl
c          2 Elastic
c        102 Capture
c         18 Fission
c
c      Any MT that is not found will ne skipped - do not worry
c      about requesting MT=18 Fission for non-fissile material
c
c=======================================================================
      implicit real*8 (a-h,o-z)
      character*11 X(3),Y(3),DUMMY6(6)
      character*20 TITLE
      character*66 LABELS
      data ipass/0/
c-----------------------------------------------------------------------
c     define ENDF2PLOT input and PLOYTAB.CUR output files only once
c-----------------------------------------------------------------------
      open( 2,file='ENDF2PLOT.INP')
      open(11,file='PLOTTAB.CUR')
      write(*,3000)
 3000 format(//1x,66('=')/
     1 ' ENDF2PLOT (2025-1): Create PLOTTAB.CUR'/1x,66('='))
c-----------------------------------------------------------------------
c     Read next MT and Title = STOP on END or ERR
c-----------------------------------------------------------------------
   10 read(2,2000,END=700,ERR=700) MTGET,TITLE
 2000 format(i5,1x,a20)
c-----------------------------------------------------------------------
c     define ENDF data file for each MT request
c-----------------------------------------------------------------------
      open(10,file='ENDFB.IN')
      n2 = 0                    ! Initialze point count
c=======================================================================
c
c     read ENDF
c
c=======================================================================
c     read and print LABEL once
c-----------------------------------------------------------------------
      read(10,1070) LABELS
 1070 format(a66)
c-----------------------------------------------------------------------
c     Print ENDF title once
c-----------------------------------------------------------------------
      if(ipass.le.0) then
      write(*,1080) LABELS
 1080 format(' ENDF Label'/1x,66('-')/1x,a66/1x,66('-')/
     1 '   MT Title                 Points' /1x,66('-'))
      ipass = 1
      endif
c-----------------------------------------------------------------------
c     find MF=3/MT
c-----------------------------------------------------------------------
   20 read(10,1000,end=600) DUMMY6,MAT,MF,MT
 1000 format(6a11,i4,i2,i3)
      if(MF-    3) 20,30,600          !skip below MF=3 -stop above MF=3
   30 if(MT-MTGET) 20,40,600          !skip below MTGET-stop above MTGET
c-----------------------------------------------------------------------
c     at MF/MT - second line defines N1 and N2
c-----------------------------------------------------------------------
c-----output PLOTTAB.CUR title to start table
   40 write(11,1150) TITLE
 1150 format(a20)
      read(10,1010) c1,c2,l1,l2,n1,n2
 1010 format(2d11.4,4i11)
c-----skip interpolatiom law
      read(10,1020) (int,nbt,i=1,n1)
 1020 format(6i11)
c-----read points up to 3 at a time (1 ENDF line)
      do 100 i1=1,n2,3     ! read 1 ENDF line at a rime (up to 3 points)
      i2 = i1 + 2
      if(i2.gt.n2) i2 =n2
      k2 = (i2-i1)+1
      read(10,1000)  (X(k),Y(k),k=1,k2)  ! ENDF in
      write(11,1120) (X(k),Y(k),K=1,k2)  ! PLOTTAB OUT
 1120 format(2A11)
  100 continue
c-----------------------------------------------------------------------
c     end of MT request
c-----------------------------------------------------------------------
  600 if(n2.gt.0) then                ! Was MT found?
c-----Identify reqest MT, title & pointd
      write(*,3010) MTGET,TITLE,n2
 3010 format(i5,1x,A20,i8)
      write(11,1190)                  ! end of CUR table
 1190 format(30x,'(BLANK LINE)')
      else
      write(*,3040) MTGET,TITLE,n2
 3040 format(i5,1x,A20,i8,' NOT found - Skipped')
      endif
c-----------------------------------------------------------------------
c     set up for next request
c-----------------------------------------------------------------------
      close(10)
      go to 10
c-----------------------------------------------------------------------
c     end of run
c-----------------------------------------------------------------------
  700 write(*,3070)
 3070 format(1x,66('=')/' End of Run'/1x,66('='))
      CALL EXIT
      end
